/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/11/21 16:21:42
!  AUTHOR(S): KOGA, Junichiro
!  File : SimpleChart.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.graph;

import java.awt.Dimension;
import java.util.HashMap;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.ChartProgressListener;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.data.xy.XYSeriesCollection;

import ciss.phase_viewer.mainpanel.DefaultInternalFrameChase;
import ciss.phase_viewer.mainpanel.InternalFrameChase;

/**
 * Vvȃ`[g, łƂ.
 * 
 * @author KOGA, Junichiro
 * 
 */
public class SimpleChart {
    private Logger logger = Logger.getLogger(SimpleChart.class.getName());

    private Vector yAxis = new Vector();

    private Vector xAxis = new Vector();

    private Vector xyCollections = new Vector();

    private Dimension size = new Dimension(512, 512);

    private XYPlot plot;

    private String title = "";

    private String chartTitle = null;
    private CombinedDomainXYPlot combinedPlot;

    public SimpleChart(XYData[] xyData) {
        plot = new XYPlot();
        HashMap collections = new HashMap();
        ValueAxis domainAxis = null;
        for (int i = 0; i < xyData.length; i++) {
            int colind = xyData[i].collectionIndex;
            XYSeriesCollection col = (XYSeriesCollection) collections
                    .get(new Integer(colind));
            if (col == null) {
                col = new XYSeriesCollection();
                collections.put(new Integer(colind), col);
            }
            col.addSeries(xyData[i].getXYSeries());

            ValueAxis xva = null;
            ValueAxis yva = null;
            if (xyData[i].xisLog) {
                xva = new LogarithmicAxis(xyData[i].xAxisName);
                ((LogarithmicAxis) xva).setLog10TickLabelsFlag(true);
                ((LogarithmicAxis) xva).setAutoRangeIncludesZero(false);
            } else {
                xva = new NumberAxis(xyData[i].xAxisName);
                ((NumberAxis) xva).setAutoRangeIncludesZero(false);
            }
            if (xyData[i].yisLog) {
                yva = new LogarithmicAxis(xyData[i].yAxisName);
                ((LogarithmicAxis) yva).setLog10TickLabelsFlag(true);
                ((LogarithmicAxis) yva).setAutoRangeIncludesZero(false);
            } else {
                yva = new NumberAxis(xyData[i].yAxisName);
                ((NumberAxis) yva).setAutoRangeIncludesZero(false);
            }

            if (xyData[i].xValType == XYData.INTEGER)
                xva.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            if (xyData[i].yValType == XYData.INTEGER)
                yva.setStandardTickUnits(NumberAxis.createIntegerTickUnits());

            if (plot.getDomainAxis(0) == null)
                plot.setDomainAxis(0, xva);
            if (plot.getRangeAxis(xyData[i].collectionIndex) == null) {
                plot.setRangeAxis(xyData[i].collectionIndex, yva);
                plot.setRangeAxisLocation(xyData[i].collectionIndex,
                        xyData[i].yAxisLocation);
                plot.mapDatasetToRangeAxis(xyData[i].collectionIndex,
                        xyData[i].collectionIndex);
            }
            plot.setDataset(xyData[i].collectionIndex, col);

            StandardXYItemRenderer renderer = (StandardXYItemRenderer) plot
                    .getRenderer(xyData[i].collectionIndex);
            if (renderer == null) {
                renderer = new StandardXYItemRenderer();
                plot.setRenderer(xyData[i].collectionIndex, renderer);
            }

            if (xyData[i].seriesColor != null && xyData[i].seriesIndex >= 0) {
                renderer.setSeriesPaint(xyData[i].seriesIndex,
                        xyData[i].seriesColor);
            }

            domainAxis = xva;
        }
        //
        // combinedPlot = new CombinedDomainXYPlot(domainAxis);
        // combinedPlot.add(plot);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setChartTitle(String chartTitle) {
        this.chartTitle = chartTitle;
    }

    public void setSize(Dimension size) {
        this.size = size;
    }

    public XYPlot getPlot() {
        return this.plot;
    }

    private boolean createLegend = true;

    public void createLegend(boolean createLegend) {
        this.createLegend = createLegend;
    }

    private InternalFrameChase graph;

    private ChartProgressListener chartProgressListener;

    public void setChartProgressListener(
            ChartProgressListener chartProgressListener) {
        this.chartProgressListener = chartProgressListener;
    }

    private JFreeChart chart;

    public JFreeChart getChart() {
        if (chart == null) {
            // chart = new JFreeChart(combinedPlot);
            chart = new JFreeChart(plot);
            if (chartTitle != null)
                chart.setTitle(chartTitle);
            if (!createLegend)
                chart.removeLegend();
            if (chartProgressListener != null)
                chart.addProgressListener(chartProgressListener);
        }

        return chart;
    }

    public Dimension getSize() {
        return this.size;
    }

    public String getFrameTitle() {
        return this.title;
    }

    public String getChartTitle() {
        return this.chartTitle;
    }

    public void createChart() {
        chart = getChart();
        graph = new DefaultInternalFrameChase(title, size);
        graph.setSize(size);
        ChartPanel chartPanel = new ChartPanel(chart, true, true, true, true,
                true);

        graph.getContentPane().add(chartPanel);
    }

    public InternalFrameChase getGraph() {
        return this.graph;
    }

}
