/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/06/09, 18:22
!  AUTHOR(S): KOGA, Junichiro
!  File : ChaseFileInfoSpec.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.file;

import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Element;

/**
 * fileinfoɓZ`Ȃ.
 * 
 * @author
 */
public class ChaseFileInfoSpec {
    private Logger logger = Logger.getLogger(ChaseFileInfoSpec.class.getName());
    private Element chaseFileInfo;

    public static String TYPE = "type";
    public static String TYPE_CHOOSABLE = "choosable";
    public static String TYPE_STR = "string";
    public static String TYPE_PATH_STR = "path_string";
    public static String TYPE_REG_STR = "regexped_string";

    public static String EDITOR = "editor";
    public static String EDITOR_COMBO = "combobox";
    public static String EDITOR_TEXTFIELD = "textfield";
    public static String EDITOR_CHECKBOX = "checkbox";

    public static String REG_HAS_REG = "hasregexp";
    public static String REG_REP_STR = "replace_string";

    public static String DEFAULT = "default";

    public static String SAVE_TO_DISK = "save_to_disk";

    private String name = "";
    private boolean save_to_disk = false;
    private String[] choices;
    private String type = TYPE_STR;
    private String editor = EDITOR_TEXTFIELD;
    private boolean editable = false;
    private String defaultValue = "";

    public static String TRUE = "true";
    public static String FALSE = "false";

    public static String NEVER = "never";
    public static String ALWAYS = "always";

    public String getName() {
        return this.name;
    }

    public boolean saveToDisk() {
        return this.save_to_disk;
    }

    public String[] getChoices() {
        return this.choices;
    }

    public String getType() {
        return this.type;
    }

    public String getEditor() {
        return this.editor;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    /**
     * Creates a new instance of ChaseFileInfoSpec
     */
    public ChaseFileInfoSpec(Element chaseFileInfo) {
        this.chaseFileInfo = chaseFileInfo;
        name = chaseFileInfo.getName();
        Attribute attrsave = chaseFileInfo.getAttribute("save_to_disk");
        if (attrsave != null && attrsave.getValue().equals(TRUE)) {
            save_to_disk = true;
        }

        Element elemType = chaseFileInfo.getChild(TYPE);
        if (elemType != null) {
            type = elemType.getTextTrim();
            Attribute attrchoi = elemType.getAttribute("choices");
            if (attrchoi != null) {
                String ch = attrchoi.getValue();
                choices = ch.split(",");
            }
        }

        Element elemEditor = chaseFileInfo.getChild(EDITOR);
        if (elemEditor != null) {
            editor = elemEditor.getTextTrim();
            Attribute attredi = elemEditor.getAttribute("editable");
            if (attredi != null && attredi.getValue().equals(TRUE)) {
                editable = true;
            }
        }

        Element elemDefault = chaseFileInfo.getChild(DEFAULT);
        if (elemDefault != null) {
            defaultValue = elemDefault.getTextTrim();
        }
    }

}
