/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.pdf;

import hep.aida.ref.pdf.Function;
import hep.aida.ref.pdf.Variable;

public abstract class FunctionDerivative {
    public static double derivative(Function f, Variable x, double h) {
        double BIG = Double.MAX_VALUE;
        double CON = 1.4;
        double CON2 = 1.9599999999999997;
        double SAFE = 2.0;
        int NTAB = 10;
        double[][] a = new double[10][10];
        double res = Double.NaN;
        double err = Double.MAX_VALUE;
        a[0][0] = FunctionDerivative.evaluateMatrixElement(f, x, h);
        for (int i = 1; i < 10; ++i) {
            a[0][i] = FunctionDerivative.evaluateMatrixElement(f, x, h /= 1.4);
            double fac = 1.9599999999999997;
            for (int j = 1; j <= i; ++j) {
                a[j][i] = (a[j - 1][i] * fac - a[j - 1][i - 1]) / (fac - 1.0);
                fac *= 1.9599999999999997;
                double errt = Math.max(Math.abs(a[j][i] - a[j - 1][i]), Math.abs(a[j][i] - a[j - 1][i - 1]));
                if (!(errt <= err)) continue;
                err = errt;
                res = a[j][i];
            }
            if (!(Math.abs(a[i][i] - a[i - 1][i - 1]) >= 2.0 * err)) continue;
            return res;
        }
        return res;
    }

    private static double evaluateMatrixElement(Function f, Variable x, double increment) {
        double xVal = x.value();
        double result = 0.0;
        double xPlus = xVal + increment;
        double xMinus = xVal - increment;
        x.setValue(xPlus);
        result += f.value();
        x.setValue(xMinus);
        result -= f.value();
        x.setValue(xVal);
        return result /= 2.0 * increment;
    }
}

