/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram.binner;

import hep.aida.ref.histogram.binner.Binner1D;
import hep.aida.ref.histogram.binner.EfficiencyBinnerUtils;

public class EfficiencyBinner1D
implements Binner1D {
    private int bins;
    private int[] entries;
    private double[] heights;
    private double[] means;
    private double[] rmss;

    public EfficiencyBinner1D(int bins) {
        if (bins < 0) {
            throw new IllegalArgumentException("Number of bins cannot be negative!!! " + bins);
        }
        this.setNumberOfBins(bins);
    }

    public void fill(int bin, double x, double weight) {
        if (weight < 0.0 || weight > 1.0) {
            throw new IllegalArgumentException("Wrong weight " + weight + " !! It has to be between 0 and 1");
        }
        int n = bin;
        this.entries[n] = this.entries[n] + 1;
        int n2 = bin;
        this.heights[n2] = this.heights[n2] + weight;
        int n3 = bin;
        this.means[n3] = this.means[n3] + x * weight;
        int n4 = bin;
        this.rmss[n4] = this.rmss[n4] + x * x * weight;
    }

    public void clear() {
        this.createArrays(this.bins);
    }

    private void setNumberOfBins(int bins) {
        this.bins = bins;
        this.createArrays(bins);
    }

    public int entries(int bin) {
        return this.entries[bin];
    }

    public double height(int bin) {
        if (this.entries(bin) > 0) {
            return this.heights[bin] / (double)this.entries(bin);
        }
        return 0.0;
    }

    public double plusError(int bin) {
        return EfficiencyBinnerUtils.H95CL(this.heights[bin], this.entries[bin], 1);
    }

    public double minusError(int bin) {
        return EfficiencyBinnerUtils.H95CL(this.heights[bin], this.entries[bin], 2);
    }

    public double mean(int bin) {
        double h = this.heights[bin];
        if (h != 0.0) {
            return this.means[bin] / h;
        }
        return Double.NaN;
    }

    public double rms(int bin) {
        double h = this.heights[bin];
        double m = this.mean(bin);
        if (h != 0.0) {
            return Math.sqrt(Math.abs(this.rmss[bin] / h - m * m));
        }
        return Double.NaN;
    }

    public void setBinContent(int bin, int entries, double height, double plusError, double minusError, double mean, double rms) {
        this.entries[bin] = entries;
        this.heights[bin] = !Double.isNaN(height) ? height * (double)entries : (double)(entries * entries);
        this.means[bin] = 0.0;
        this.rmss[bin] = 0.0;
        if (this.heights[bin] != 0.0) {
            this.means[bin] = mean * this.heights[bin];
            this.rmss[bin] = rms * rms * this.heights[bin] + mean * mean * this.heights[bin];
        }
    }

    public void scale(double scaleFactor) {
        int bin = 0;
        while (bin < this.bins) {
            int n = bin;
            this.heights[n] = this.heights[n] * scaleFactor;
            int n2 = bin;
            this.means[n2] = this.means[n2] * scaleFactor;
            int n3 = bin++;
            this.rmss[n3] = this.rmss[n3] * scaleFactor;
        }
    }

    private void createArrays(int n) {
        this.entries = new int[n];
        this.heights = new double[n];
        this.means = new double[n];
        this.rmss = new double[n];
    }
}

