/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.sets;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.__builtin__;
import org.python.modules.sets.PySet;
import org.python.modules.sets.PySetIterator;

public abstract class BaseSet
extends PyObject {
    protected HashSet _set = new HashSet();
    static /* synthetic */ Class class$java$util$Collection;

    public BaseSet() {
    }

    public BaseSet(PyObject data) {
        this._update(data);
    }

    public BaseSet(PyType type) {
        super(type);
    }

    protected void _update(PyObject data) throws PyIgnoreMethodTag {
        if (data instanceof BaseSet) {
            this._set.addAll(((BaseSet)data)._set);
            return;
        }
        PyObject value = null;
        if (data.__findattr__("__iter__") != null) {
            PyObject iter = data.__iter__();
            while ((value = iter.__iternext__()) != null) {
                try {
                    this._set.add(value);
                }
                catch (PyException e) {
                    PyObject immutable = this.asImmutable(e, value);
                    this._set.add(immutable);
                }
            }
        } else {
            int i = 0;
            while (true) {
                block12: {
                    try {
                        value = data.__finditem__(i++);
                        if (value != null) break block12;
                        break;
                    }
                    catch (PyException e) {
                        if (Py.matchException(e, Py.AttributeError)) {
                            throw Py.TypeError("object not iterable");
                        }
                        throw e;
                    }
                }
                try {
                    this._set.add(value);
                }
                catch (PyException e) {
                    PyObject immutable = this.asImmutable(e, value);
                    this._set.add(immutable);
                }
            }
        }
    }

    public PyObject __or__(PyObject other) {
        return this.baseset___or__(other);
    }

    final PyObject baseset___or__(PyObject other) {
        if (!(other instanceof BaseSet)) {
            throw Py.TypeError("Not Implemented");
        }
        return this.baseset_union(other);
    }

    public PyObject __and__(PyObject other) {
        return this.baseset___and__(other);
    }

    final PyObject baseset___and__(PyObject other) {
        if (!(other instanceof BaseSet)) {
            throw Py.TypeError("Not Implemented");
        }
        return this.baseset_intersection(other);
    }

    public PyObject __sub__(PyObject other) {
        return this.baseset___sub__(other);
    }

    final PyObject baseset___sub__(PyObject other) {
        if (!(other instanceof BaseSet)) {
            throw Py.TypeError("Not Implemented");
        }
        return this.difference(other);
    }

    public PyObject difference(PyObject other) {
        return this.baseset_difference(other);
    }

    final PyObject baseset_difference(PyObject other) {
        BaseSet iterable = other instanceof BaseSet ? (BaseSet)other : new PySet(other);
        HashSet set = iterable._set;
        BaseSet o = (BaseSet)this.getType().__call__();
        Iterator i = this._set.iterator();
        while (i.hasNext()) {
            Object p = i.next();
            if (set.contains(p)) continue;
            o._set.add(p);
        }
        return o;
    }

    public PyObject __xor__(PyObject other) {
        return this.baseset___xor__(other);
    }

    final PyObject baseset___xor__(PyObject other) {
        if (!(other instanceof BaseSet)) {
            throw Py.TypeError("Not Implemented");
        }
        return this.symmetric_difference(other);
    }

    public PyObject symmetric_difference(PyObject other) {
        return this.baseset_symmetric_difference(other);
    }

    public PyObject baseset_symmetric_difference(PyObject other) {
        Object p;
        BaseSet iterable = other instanceof BaseSet ? (BaseSet)other : new PySet(other);
        BaseSet o = (BaseSet)this.getType().__call__();
        Iterator i = this._set.iterator();
        while (i.hasNext()) {
            p = i.next();
            if (iterable._set.contains(p)) continue;
            o._set.add(p);
        }
        i = iterable._set.iterator();
        while (i.hasNext()) {
            p = i.next();
            if (this._set.contains(p)) continue;
            o._set.add(p);
        }
        return o;
    }

    public abstract int hashCode();

    public int __len__() {
        return this.baseset___len__();
    }

    final int baseset___len__() {
        return this._set.size();
    }

    public boolean __nonzero__() {
        return this.baseset___nonzero__();
    }

    final boolean baseset___nonzero__() {
        return !this._set.isEmpty();
    }

    public PyObject __iter__() {
        return new PySetIterator(this._set);
    }

    public boolean __contains__(PyObject other) {
        return this.baseset___contains__(other);
    }

    final boolean baseset___contains__(PyObject other) {
        return this._set.contains(other);
    }

    public PyObject __eq__(PyObject other) {
        return this.baseset___eq__(other);
    }

    final PyObject baseset___eq__(PyObject other) {
        if (other instanceof BaseSet) {
            BaseSet bs = this._binary_sanity_check(other);
            return Py.newBoolean(this._set.equals(bs._set));
        }
        return Py.Zero;
    }

    public PyObject __ne__(PyObject other) {
        return this.baseset___ne__(other);
    }

    final PyObject baseset___ne__(PyObject other) {
        if (other instanceof BaseSet) {
            BaseSet bs = this._binary_sanity_check(other);
            return Py.newBoolean(!this._set.equals(bs._set));
        }
        return Py.One;
    }

    public PyObject __le__(PyObject other) {
        return this.baseset___le__(other);
    }

    final PyObject baseset___le__(PyObject other) {
        return this.baseset_issubset(other);
    }

    public PyObject __ge__(PyObject other) {
        return this.baseset___ge__(other);
    }

    final PyObject baseset___ge__(PyObject other) {
        return this.baseset_issuperset(other);
    }

    public PyObject __lt__(PyObject other) {
        return this.baseset___lt__(other);
    }

    final PyObject baseset___lt__(PyObject other) {
        BaseSet bs = this._binary_sanity_check(other);
        return Py.newBoolean(this.__len__() < bs.__len__() && this.baseset_issubset(other).__nonzero__());
    }

    public PyObject __gt__(PyObject other) {
        return this.baseset___gt__(other);
    }

    public PyObject baseset___gt__(PyObject other) {
        BaseSet bs = this._binary_sanity_check(other);
        return Py.newBoolean(this.__len__() > bs.__len__() && this.baseset_issuperset(other).__nonzero__());
    }

    public PyObject __reduce__() {
        String name = this.getType().getFullName();
        PyObject factory = __builtin__.__import__("setsfactory");
        PyObject func = factory.__getattr__(name);
        return new PyTuple(new PyObject[]{func, new PyTuple(new PyObject[]{new PyList(this)})});
    }

    public PyObject __deepcopy__(PyObject memo) {
        return this.baseset___deepcopy__(memo);
    }

    final PyObject baseset___deepcopy__(PyObject memo) {
        PyObject copy = __builtin__.__import__("copy");
        PyObject deepcopy = copy.__getattr__("deepcopy");
        BaseSet result = (BaseSet)this.getType().__call__();
        memo.__setitem__(Py.newInteger(Py.id(this)), (PyObject)result);
        Iterator iterator = this._set.iterator();
        while (iterator.hasNext()) {
            result._set.add(deepcopy.__call__(Py.java2py(iterator.next()), memo));
        }
        return result;
    }

    public Object __tojava__(Class c) {
        if ((class$java$util$Collection == null ? (class$java$util$Collection = BaseSet.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(c)) {
            return Collections.unmodifiableSet(this._set);
        }
        return super.__tojava__(c);
    }

    public PyObject baseset_union(PyObject other) {
        BaseSet result = (BaseSet)this.getType().__call__(this);
        result._update(other);
        return result;
    }

    public PyObject baseset_intersection(PyObject other) {
        PyObject big;
        PyObject little;
        if (!(other instanceof BaseSet)) {
            other = new PySet(other);
        }
        if (this.__len__() <= __builtin__.len(other)) {
            little = this;
            big = other;
        } else {
            little = other;
            big = this;
        }
        PyObject common = __builtin__.filter(big.__getattr__("__contains__"), little);
        return other.getType().__call__(common);
    }

    public PyObject baseset_copy() {
        BaseSet copy = (BaseSet)this.getType().__call__();
        copy._set = (HashSet)this._set.clone();
        return copy;
    }

    public PyObject baseset_issubset(PyObject other) {
        BaseSet bs = this._binary_sanity_check(other);
        if (this.__len__() > bs.__len__()) {
            return Py.Zero;
        }
        Iterator iterator = this._set.iterator();
        while (iterator.hasNext()) {
            if (bs._set.contains(iterator.next())) continue;
            return Py.Zero;
        }
        return Py.One;
    }

    public PyObject baseset_issuperset(PyObject other) {
        BaseSet bs = this._binary_sanity_check(other);
        if (this.__len__() < bs.__len__()) {
            return Py.Zero;
        }
        Iterator iterator = bs._set.iterator();
        while (iterator.hasNext()) {
            if (this._set.contains(iterator.next())) continue;
            return Py.Zero;
        }
        return Py.One;
    }

    final String baseset_toString() {
        return this.toString();
    }

    public String toString() {
        String name = this.getType().getFullName();
        StringBuffer buf = new StringBuffer(name).append("([");
        Iterator i = this._set.iterator();
        while (i.hasNext()) {
            buf.append(((PyObject)i.next()).__repr__().toString());
            if (!i.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("])");
        return buf.toString();
    }

    protected final BaseSet _binary_sanity_check(PyObject other) throws PyIgnoreMethodTag {
        try {
            return (BaseSet)other;
        }
        catch (ClassCastException e) {
            throw Py.TypeError("Binary operation only permitted between sets");
        }
    }

    protected final PyObject asImmutable(PyException e, PyObject value) {
        PyObject transform;
        if (Py.matchException(e, Py.TypeError) && (transform = value.__findattr__("_as_immutable")) != null) {
            return transform.__call__();
        }
        throw e;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

