/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.regex;

final class CharStringPointer {
    static final char _END_OF_STRING = '\uffff';
    int _offset;
    char[] _array;

    CharStringPointer(char[] charArray, int offset) {
        this._array = charArray;
        this._offset = offset;
    }

    CharStringPointer(char[] charArray) {
        this(charArray, 0);
    }

    char _getValue() {
        return this._getValue(this._offset);
    }

    char _getValue(int offset) {
        if (offset < this._array.length && offset >= 0) {
            return this._array[offset];
        }
        return '\uffff';
    }

    char _getValueRelative(int offset) {
        return this._getValue(this._offset + offset);
    }

    int _getLength() {
        return this._array.length;
    }

    int _getOffset() {
        return this._offset;
    }

    void _setOffset(int offset) {
        this._offset = offset;
    }

    boolean _isAtEnd() {
        return this._offset >= this._array.length;
    }

    char _increment(int inc) {
        this._offset += inc;
        if (this._isAtEnd()) {
            this._offset = this._array.length;
            return '\uffff';
        }
        return this._array[this._offset];
    }

    char _increment() {
        return this._increment(1);
    }

    char _decrement(int inc) {
        this._offset -= inc;
        if (this._offset < 0) {
            this._offset = 0;
        }
        return this._array[this._offset];
    }

    char _decrement() {
        return this._decrement(1);
    }

    char _postIncrement() {
        char ret = this._getValue();
        this._increment();
        return ret;
    }

    char _postDecrement() {
        char ret = this._getValue();
        this._decrement();
        return ret;
    }

    String _toString(int offset) {
        return new String(this._array, offset, this._array.length - offset);
    }

    public String toString() {
        return this._toString(0);
    }
}

