/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.MFVec3f;
import org.cybergarage.x3d.field.SFVec3f;
import org.cybergarage.x3d.node.InterpolatorNode;
import org.cybergarage.x3d.node.Node;

public class NormalInterpolatorNode
extends InterpolatorNode {
    private String keyValueFieldName = "keyValue";
    private MFVec3f keyValueField;
    private SFVec3f valueField;

    public NormalInterpolatorNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.NORMALINTERP);
        this.keyValueField = new MFVec3f();
        this.addExposedField(this.keyValueFieldName, this.keyValueField);
        this.valueField = new SFVec3f(0.0f, 0.0f, 0.0f);
        this.addEventOut("value", this.valueField);
    }

    public NormalInterpolatorNode(NormalInterpolatorNode node) {
        this();
        this.setFieldValues(node);
    }

    public MFVec3f getKeyValueField() {
        if (!this.isInstanceNode()) {
            return this.keyValueField;
        }
        return (MFVec3f)this.getExposedField(this.keyValueFieldName);
    }

    public void addKeyValue(float[] vector) {
        this.getKeyValueField().addValue(vector);
    }

    public void addKeyValue(float x, float y, float z) {
        this.getKeyValueField().addValue(x, y, z);
    }

    public int getNKeyValues() {
        return this.getKeyValueField().getSize();
    }

    public void setKeyValue(int index, float[] vector) {
        this.getKeyValueField().set1Value(index, vector);
    }

    public void setKeyValue(int index, float x, float y, float z) {
        this.getKeyValueField().set1Value(index, x, y, z);
    }

    public void setKeyValues(String vector) {
        this.getKeyValueField().setValues(vector);
    }

    public void setKeyValues(String[] vector) {
        this.getKeyValueField().setValues(vector);
    }

    public void getKeyValue(int index, float[] vector) {
        this.getKeyValueField().get1Value(index, vector);
    }

    public float[] getKeyValue(int index) {
        float[] value = new float[3];
        this.getKeyValue(index, value);
        return value;
    }

    public void removeKeyValue(int index) {
        this.getKeyValueField().removeValue(index);
    }

    public SFVec3f getValueField() {
        if (!this.isInstanceNode()) {
            return this.valueField;
        }
        return (SFVec3f)this.getEventOut("value");
    }

    public void setValue(float[] vector) {
        this.getValueField().setValue(vector);
    }

    public void setValue(String vector) {
        this.getValueField().setValue(vector);
    }

    public void getValue(float[] vector) {
        this.getValueField().getValue(vector);
    }

    public boolean isChildNodeType(Node node) {
        return false;
    }

    public void initialize() {
        super.initialize();
    }

    public void uninitialize() {
    }

    public void update() {
        float fraction = this.getFraction();
        int index = -1;
        for (int n = 0; n < this.getNKeys() - 1; ++n) {
            if (!(this.getKey(n) <= fraction) || !(fraction <= this.getKey(n + 1))) continue;
            index = n;
            break;
        }
        if (index == -1) {
            return;
        }
        float scale = (fraction - this.getKey(index)) / (this.getKey(index + 1) - this.getKey(index));
        float[] vector1 = new float[3];
        float[] vector2 = new float[3];
        float[] vectorOut = new float[3];
        this.getKeyValue(index, vector1);
        this.getKeyValue(index + 1, vector2);
        for (int n = 0; n < 3; ++n) {
            vectorOut[n] = vector1[n] + (vector2[n] - vector1[n]) * scale;
        }
        this.setValue(vectorOut);
        this.sendEvent(this.getValueField());
    }

    public void outputContext(PrintWriter printStream, String indentString) {
        printStream.println(indentString + "\tkey [");
        for (int n = 0; n < this.getNKeys(); ++n) {
            if (n < this.getNKeys() - 1) {
                printStream.println(indentString + "\t\t" + this.getKey(n));
                continue;
            }
            printStream.println(indentString + "\t\t" + this.getKey(n));
        }
        printStream.println(indentString + "\t]");
        float[] vector = new float[3];
        printStream.println(indentString + "\tkeyValue [");
        for (int n = 0; n < this.getNKeyValues(); ++n) {
            this.getKeyValue(n, vector);
            if (n < this.getNKeyValues() - 1) {
                printStream.println(indentString + "\t\t" + vector[0] + " " + vector[1] + " " + vector[2] + ",");
                continue;
            }
            printStream.println(indentString + "\t\t" + vector[0] + " " + vector[1] + " " + vector[2]);
        }
        printStream.println(indentString + "\t]");
    }
}

