/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jcterm;

import com.jcraft.jcterm.Emulator;
import com.jcraft.jcterm.EmulatorVT100;
import com.jcraft.jcterm.Sftp;
import com.jcraft.jcterm.Splash;
import com.jcraft.jcterm.Term;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class JCTerm
extends JPanel
implements KeyListener,
ActionListener,
Runnable,
Term {
    static String COPYRIGHT = "JCTerm 0.0.8\nCopyright (C) 2002-2005 ymnk<ymnk@jcraft.com>, JCraft,Inc.\nOfficial Homepage: http://www.jcraft.com/jcterm/\nThis software is licensed under GNU LGPL.";
    private static final int SHELL = 0;
    private static final int SFTP = 1;
    private static final int EXEC = 2;
    private int mode = 0;
    private OutputStream out;
    private InputStream in;
    private BufferedImage img;
    private BufferedImage background;
    private Graphics2D cursor_graphics;
    private Graphics2D graphics;
    private Color bground = Color.white;
    private Color fground = Color.black;
    private Component term_area = null;
    private Font font;
    private int term_width = 80;
    private int term_height = 24;
    private int x = 0;
    private int y = 0;
    private int descent = 0;
    private int char_width;
    private int char_height;
    private String xhost = "127.0.0.1";
    private int xport = 0;
    private boolean xforwarding = false;
    private String user = System.getProperty("user.name");
    private String host = "127.0.0.1";
    private String proxy_http_host = null;
    private int proxy_http_port = 0;
    private String proxy_socks5_host = null;
    private int proxy_socks5_port = 0;
    private Session session = null;
    private Proxy proxy = null;
    private boolean antialiasing = true;
    private int line_space = -2;
    private int compression = 0;
    private Splash splash = null;
    private Thread thread = null;
    private Emulator emulator = null;
    byte[] obuffer = new byte[3];

    public JCTerm() {
        this.font = Font.decode("Monospaced-14");
        this.img = new BufferedImage(1, 1, 1);
        this.graphics = (Graphics2D)this.img.getGraphics();
        this.graphics.setFont(this.font);
        FontMetrics fo = this.graphics.getFontMetrics();
        this.descent = fo.getDescent();
        this.char_width = fo.charWidth('@');
        this.char_height = fo.getHeight() + this.line_space * 2;
        this.descent += this.line_space;
        this.img.flush();
        this.graphics.dispose();
        this.background = new BufferedImage(this.char_width, this.char_height, 1);
        Graphics2D foog = (Graphics2D)this.background.getGraphics();
        foog.setColor(this.bground);
        foog.fillRect(0, 0, this.char_width, this.char_height);
        foog.dispose();
        this.img = new BufferedImage(this.getTermWidth(), this.getTermHeight(), 1);
        this.graphics = (Graphics2D)this.img.getGraphics();
        this.graphics.setFont(this.font);
        if (this.splash != null) {
            this.splash.draw(this.img, this.getTermWidth(), this.getTermHeight());
        } else {
            this.clear();
        }
        this.cursor_graphics = (Graphics2D)this.img.getGraphics();
        this.cursor_graphics.setColor(this.fground);
        this.cursor_graphics.setXORMode(this.bground);
        this.setAntiAliasing(this.antialiasing);
        this.term_area = this;
        JCTerm panel = this;
        panel.setPreferredSize(new Dimension(this.getTermWidth(), this.getTermHeight()));
        panel.setSize(this.getTermWidth(), this.getTermHeight());
        panel.setFocusable(true);
        panel.enableInputMethods(true);
        panel.setFocusTraversalKeysEnabled(false);
    }

    public void setFrame(Component term_area) {
        this.term_area = term_area;
    }

    public void kick() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void run() {
        JSch jsch = new JSch();
        while (this.thread != null) {
            try {
                int port = 22;
                try {
                    String _host = JOptionPane.showInputDialog(this, "Enter username@hostname", this.user + "@" + this.host);
                    if (_host == null) break;
                    String _user = _host.substring(0, _host.indexOf(64));
                    if ((_host = _host.substring(_host.indexOf(64) + 1)) == null || _host.length() == 0) continue;
                    if (_host.indexOf(58) != -1) {
                        try {
                            port = Integer.parseInt(_host.substring(_host.indexOf(58) + 1));
                        }
                        catch (Exception eee) {
                            // empty catch block
                        }
                        _host = _host.substring(0, _host.indexOf(58));
                    }
                    this.user = _user;
                    this.host = _host;
                }
                catch (Exception ee) {
                    continue;
                }
                try {
                    this.session = jsch.getSession(this.user, this.host, port);
                    this.session.setProxy(this.proxy);
                    MyUserInfo ui = new MyUserInfo();
                    this.session.setUserInfo(ui);
                    Properties config = new Properties();
                    if (this.compression == 0) {
                        config.put("compression.s2c", "none");
                        config.put("compression.c2s", "none");
                    } else {
                        config.put("compression.s2c", "zlib,none");
                        config.put("compression.c2s", "zlib,none");
                    }
                    this.session.setConfig(config);
                    this.session.setTimeout(5000);
                    this.session.connect();
                    this.session.setTimeout(0);
                }
                catch (Exception e) {
                    break;
                }
                Channel channel = null;
                if (this.mode == 0) {
                    channel = this.session.openChannel("shell");
                    if (this.xforwarding) {
                        this.session.setX11Host(this.xhost);
                        this.session.setX11Port(this.xport + 6000);
                        channel.setXForwarding(true);
                    }
                    this.out = channel.getOutputStream();
                    this.in = channel.getInputStream();
                    channel.connect();
                } else if (this.mode == 1) {
                    this.out = new PipedOutputStream();
                    this.in = new PipedInputStream();
                    channel = this.session.openChannel("sftp");
                    channel.connect();
                    new Sftp((ChannelSftp)channel, new PipedInputStream((PipedOutputStream)this.out), new PipedOutputStream((PipedInputStream)this.in)).kick();
                }
                this.requestFocus();
                this.emulator = new EmulatorVT100(this, this.in);
                this.emulator.reset();
                this.emulator.start();
                break;
            }
            catch (Exception exception) {
                // empty catch block
                break;
            }
        }
        this.thread = null;
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
        if (this.splash != null) {
            this.splash.draw(this.img, this.getTermWidth(), this.getTermHeight());
        } else {
            this.clear();
        }
        this.redraw(0, 0, this.getTermWidth(), this.getTermHeight());
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.img != null) {
            g.drawImage(this.img, 0, 0, this.term_area);
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    public void processKeyEvent(KeyEvent e) {
        int id = e.getID();
        if (id == 401) {
            this.keyPressed(e);
        } else if (id != 402 && id == 400) {
            this.keyTyped(e);
        }
        e.consume();
    }

    public void keyPressed(KeyEvent e) {
        int keycode = e.getKeyCode();
        byte[] code = null;
        switch (keycode) {
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                return;
            }
            case 10: {
                code = this.emulator.getCodeENTER();
                break;
            }
            case 38: {
                code = this.emulator.getCodeUP();
                break;
            }
            case 40: {
                code = this.emulator.getCodeDOWN();
                break;
            }
            case 39: {
                code = this.emulator.getCodeRIGHT();
                break;
            }
            case 37: {
                code = this.emulator.getCodeLEFT();
                break;
            }
            case 112: {
                code = this.emulator.getCodeF1();
                break;
            }
            case 113: {
                code = this.emulator.getCodeF2();
                break;
            }
            case 114: {
                code = this.emulator.getCodeF3();
                break;
            }
            case 115: {
                code = this.emulator.getCodeF4();
                break;
            }
            case 116: {
                code = this.emulator.getCodeF5();
                break;
            }
            case 117: {
                code = this.emulator.getCodeF6();
                break;
            }
            case 118: {
                code = this.emulator.getCodeF7();
                break;
            }
            case 119: {
                code = this.emulator.getCodeF8();
                break;
            }
            case 120: {
                code = this.emulator.getCodeF9();
                break;
            }
            case 121: {
                code = this.emulator.getCodeF10();
            }
        }
        if (code != null) {
            try {
                this.out.write(code, 0, code.length);
                this.out.flush();
            }
            catch (Exception ee) {
                // empty catch block
            }
            return;
        }
        char keychar = e.getKeyChar();
        if ((keychar & 0xFF00) == 0) {
            this.obuffer[0] = (byte)e.getKeyChar();
            try {
                this.out.write(this.obuffer, 0, 1);
                this.out.flush();
            }
            catch (Exception ee) {
                // empty catch block
            }
        }
    }

    public void keyTyped(KeyEvent e) {
        char keychar = e.getKeyChar();
        if ((keychar & 0xFF00) != 0) {
            char[] foo = new char[]{keychar};
            try {
                byte[] goo = new String(foo).getBytes("EUC-JP");
                this.out.write(goo, 0, goo.length);
                this.out.flush();
            }
            catch (Exception eee) {
                // empty catch block
            }
        }
    }

    public int getTermWidth() {
        return this.char_width * this.term_width;
    }

    public int getTermHeight() {
        return this.char_height * this.term_height;
    }

    public int getCharWidth() {
        return this.char_width;
    }

    public int getCharHeight() {
        return this.char_height;
    }

    public int getColumnCount() {
        return this.term_width;
    }

    public int getRowCount() {
        return this.term_height;
    }

    public void clear() {
        this.graphics.setColor(this.bground);
        this.graphics.fillRect(0, 0, this.char_width * this.term_width, this.char_height * this.term_height);
        this.graphics.setColor(this.fground);
    }

    public void setCursor(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void draw_cursor() {
        this.cursor_graphics.fillRect(this.x, this.y - this.char_height, this.char_width, this.char_height);
        Graphics g = this.getGraphics();
        g.setClip(this.x, this.y - this.char_height, this.char_width, this.char_height);
        g.drawImage(this.img, 0, 0, this.term_area);
    }

    public void redraw(int x, int y, int width, int height) {
        Graphics g = this.getGraphics();
        g.setClip(x, y, width, height);
        g.drawImage(this.img, 0, 0, this.term_area);
    }

    public void clear_area(int x1, int y1, int x2, int y2) {
        this.graphics.setColor(this.bground);
        this.graphics.fillRect(x1, y1, x2 - x1, y2 - y1);
        this.graphics.setColor(this.fground);
    }

    public void scroll_area(int x, int y, int w, int h, int dx, int dy) {
        this.getGraphics().copyArea(x, y, w, h, dx, dy);
        this.graphics.copyArea(x, y, w, h, dx, dy);
    }

    public void drawBytes(byte[] buf, int s, int len, int x, int y) {
        this.graphics.drawBytes(buf, s, len, x, y - this.descent);
    }

    public void drawString(String str, int x, int y) {
        this.graphics.drawString(str, x, y - this.descent);
    }

    public void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public void keyReleased(KeyEvent event) {
    }

    public void setProxyHttp(String host, int port) {
        this.proxy_http_host = host;
        this.proxy_http_port = port;
        this.proxy = this.proxy_http_host != null && this.proxy_http_port != 0 ? new ProxyHTTP(this.proxy_http_host, this.proxy_http_port) : null;
    }

    public String getProxyHttpHost() {
        return this.proxy_http_host;
    }

    public int getProxyHttpPort() {
        return this.proxy_http_port;
    }

    public void setProxySOCKS5(String host, int port) {
        this.proxy_socks5_host = host;
        this.proxy_socks5_port = port;
        this.proxy = this.proxy_socks5_host != null && this.proxy_socks5_port != 0 ? new ProxySOCKS5(this.proxy_socks5_host, this.proxy_socks5_port) : null;
    }

    public String getProxySOCKS5Host() {
        return this.proxy_socks5_host;
    }

    public int getProxySOCKS5Port() {
        return this.proxy_socks5_port;
    }

    public void setSplash(Splash foo) {
        this.splash = foo;
    }

    public void setXHost(String xhost) {
        this.xhost = xhost;
    }

    public void setXPort(int xport) {
        this.xport = xport;
    }

    public void setXForwarding(boolean foo) {
        this.xforwarding = foo;
    }

    public void setLineSpace(int foo) {
        this.line_space = foo;
    }

    public void setAntiAliasing(boolean foo) {
        if (this.graphics == null) {
            return;
        }
        this.antialiasing = foo;
        Object mode = foo ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, mode);
        this.graphics.setRenderingHints(hints);
    }

    public void setCompression(int compression) {
        if (compression < 0 || 9 < compression) {
            return;
        }
        this.compression = compression;
    }

    public int getCompression() {
        return this.compression;
    }

    public void setUserHost(String userhost) {
        try {
            String _user = userhost.substring(0, userhost.indexOf(64));
            String _host = userhost.substring(userhost.indexOf(64) + 1);
            this.user = _user;
            this.host = _host;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void openSession() {
        this.kick();
    }

    public void setPortForwardingL(int port1, String host, int port2) {
        try {
            this.session.setPortForwardingL(port1, host, port2);
        }
        catch (JSchException e) {
            // empty catch block
        }
    }

    public void setPortForwardingR(int port1, String host, int port2) {
        try {
            this.session.setPortForwardingR(port1, host, port2);
        }
        catch (JSchException e) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent e) {
        block41: {
            String action = e.getActionCommand();
            if (action.equals("Open SHELL Session...") || action.equals("Open SFTP Session...")) {
                if (this.thread == null) {
                    if (action.equals("Open SHELL Session...")) {
                        this.mode = 0;
                    } else if (action.equals("Open SFTP Session...")) {
                        this.mode = 1;
                    }
                    this.openSession();
                }
            } else if (action.equals("HTTP...")) {
                String foo = this.getProxyHttpHost();
                int bar = this.getProxyHttpPort();
                String proxy = JOptionPane.showInputDialog(this, "HTTP proxy server (hostname:port)", foo != null && bar != 0 ? foo + ":" + bar : "");
                if (proxy == null) {
                    return;
                }
                if (proxy.length() == 0) {
                    this.setProxyHttp(null, 0);
                    return;
                }
                try {
                    foo = proxy.substring(0, proxy.indexOf(58));
                    bar = Integer.parseInt(proxy.substring(proxy.indexOf(58) + 1));
                    if (foo != null) {
                        this.setProxyHttp(foo, bar);
                    }
                }
                catch (Exception ee) {}
            } else if (action.equals("SOCKS5...")) {
                String foo = this.getProxySOCKS5Host();
                int bar = this.getProxySOCKS5Port();
                String proxy = JOptionPane.showInputDialog(this, "SOCKS5 server (hostname:1080)", foo != null && bar != 0 ? foo + ":" + bar : "");
                if (proxy == null) {
                    return;
                }
                if (proxy.length() == 0) {
                    this.setProxySOCKS5(null, 0);
                    return;
                }
                try {
                    foo = proxy.substring(0, proxy.indexOf(58));
                    bar = Integer.parseInt(proxy.substring(proxy.indexOf(58) + 1));
                    if (foo != null) {
                        this.setProxySOCKS5(foo, bar);
                    }
                }
                catch (Exception ee) {}
            } else if (action.equals("X11 Forwarding...")) {
                String display = JOptionPane.showInputDialog(this, "XDisplay name (hostname:0)", this.xhost == null ? "" : this.xhost + ":" + this.xport);
                try {
                    if (display != null) {
                        this.xhost = display.substring(0, display.indexOf(58));
                        this.xport = Integer.parseInt(display.substring(display.indexOf(58) + 1));
                        this.xforwarding = true;
                    }
                }
                catch (Exception ee) {
                    this.xforwarding = false;
                    this.xhost = null;
                }
            } else if (action.equals("AntiAliasing")) {
                this.setAntiAliasing(!this.antialiasing);
            } else if (action.equals("Compression...")) {
                String foo = JOptionPane.showInputDialog(this, "Compression level(0-9)\n0 means no compression.\n1 means fast.\n9 means slow, but best.", new Integer(this.compression).toString());
                try {
                    if (foo != null) {
                        this.compression = Integer.parseInt(foo);
                    }
                }
                catch (Exception ee) {}
            } else {
                if (action.equals("About...")) {
                    JOptionPane.showMessageDialog(this, COPYRIGHT);
                    return;
                }
                if (action.equals("Local Port...") || action.equals("Remote Port...")) {
                    if (this.session == null) {
                        JOptionPane.showMessageDialog(this, "Establish the connection before this setting.");
                        return;
                    }
                    try {
                        String title = "";
                        title = action.equals("Local Port...") ? title + "Local port forwarding" : title + "remote port forwarding";
                        title = title + "(port:host:hostport)";
                        String foo = JOptionPane.showInputDialog(this, title, "");
                        if (foo == null) {
                            return;
                        }
                        int port1 = Integer.parseInt(foo.substring(0, foo.indexOf(58)));
                        foo = foo.substring(foo.indexOf(58) + 1);
                        String host = foo.substring(0, foo.indexOf(58));
                        int port2 = Integer.parseInt(foo.substring(foo.indexOf(58) + 1));
                        if (action.equals("Local Port...")) {
                            this.setPortForwardingL(port1, host, port2);
                            break block41;
                        }
                        this.setPortForwardingR(port1, host, port2);
                    }
                    catch (Exception exception) {}
                } else if (action.equals("Quit")) {
                    this.quit();
                }
            }
        }
    }

    public JMenuBar getJMenuBar() {
        JMenuBar mb = new JMenuBar();
        JMenu m = new JMenu("File");
        JMenuItem mi = new JMenuItem("Open SHELL Session...");
        mi.addActionListener(this);
        mi.setActionCommand("Open SHELL Session...");
        m.add(mi);
        mi = new JMenuItem("Open SFTP Session...");
        mi.addActionListener(this);
        mi.setActionCommand("Open SFTP Session...");
        m.add(mi);
        mi = new JMenuItem("Quit");
        mi.addActionListener(this);
        mi.setActionCommand("Quit");
        m.add(mi);
        mb.add(m);
        m = new JMenu("Proxy");
        mi = new JMenuItem("HTTP...");
        mi.addActionListener(this);
        mi.setActionCommand("HTTP...");
        m.add(mi);
        mi = new JMenuItem("SOCKS5...");
        mi.addActionListener(this);
        mi.setActionCommand("SOCKS5...");
        m.add(mi);
        mb.add(m);
        m = new JMenu("PortForwarding");
        mi = new JMenuItem("Local Port...");
        mi.addActionListener(this);
        mi.setActionCommand("Local Port...");
        m.add(mi);
        mi = new JMenuItem("Remote Port...");
        mi.addActionListener(this);
        mi.setActionCommand("Remote Port...");
        m.add(mi);
        mi = new JMenuItem("X11 Forwarding...");
        mi.addActionListener(this);
        mi.setActionCommand("X11 Forwarding...");
        m.add(mi);
        mb.add(m);
        m = new JMenu("Etc");
        mi = new JMenuItem("AntiAliasing");
        mi.addActionListener(this);
        mi.setActionCommand("AntiAliasing");
        m.add(mi);
        mi = new JMenuItem("Compression...");
        mi.addActionListener(this);
        mi.setActionCommand("Compression...");
        m.add(mi);
        mb.add(m);
        m = new JMenu("Help");
        mi = new JMenuItem("About...");
        mi.addActionListener(this);
        mi.setActionCommand("About...");
        m.add(mi);
        mb.add(m);
        return mb;
    }

    public static void main(String[] arg) {
        JCTerm term = new JCTerm();
        JFrame frame = new JFrame("JCTerm");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JMenuBar mb = term.getJMenuBar();
        frame.setJMenuBar(mb);
        frame.setSize(term.getTermWidth(), term.getTermHeight());
        frame.getContentPane().add("Center", term);
        frame.pack();
        term.setVisible(true);
        frame.setVisible(true);
        frame.setResizable(true);
        int foo = term.getTermWidth();
        int bar = term.getTermHeight();
        frame.setSize(foo += frame.getWidth() - frame.getContentPane().getWidth(), bar += frame.getHeight() - frame.getContentPane().getHeight());
        frame.setResizable(false);
        term.setFrame(frame.getContentPane());
    }

    public void quit() {
        this.thread = null;
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
    }

    public void setFGround(Object f) {
        if (f instanceof String) {
            this.fground = Color.getColor((String)f);
        }
        if (f instanceof Color) {
            this.fground = (Color)f;
        }
        this.graphics.setColor(this.fground);
    }

    public void setBGround(Object b2) {
        if (b2 instanceof String) {
            this.bground = Color.getColor((String)b2);
        }
        if (b2 instanceof Color) {
            this.bground = (Color)b2;
        }
        Graphics2D foog = (Graphics2D)this.background.getGraphics();
        foog.setColor(this.bground);
        foog.fillRect(0, 0, this.char_width, this.char_height);
        foog.dispose();
    }

    public Object getFGround() {
        return this.fground;
    }

    public Object getBGround() {
        return this.bground;
    }

    public class MyUserInfo
    implements UserInfo {
        String passwd = null;
        String passphrase = null;
        JTextField pword = new JPasswordField(20);

        public boolean promptYesNo(String str) {
            Object[] options = new Object[]{"yes", "no"};
            int foo = JOptionPane.showOptionDialog(null, str, "Warning", -1, 2, null, options, options[0]);
            return foo == 0;
        }

        public String getPassword() {
            return this.passwd;
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public boolean promptPassword(String message) {
            Object[] ob = new Object[]{this.pword};
            int result = JOptionPane.showConfirmDialog(null, ob, message, 2);
            if (result == 0) {
                this.passwd = this.pword.getText();
                return true;
            }
            return false;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public void showMessage(String message) {
            JOptionPane.showMessageDialog(null, message);
        }
    }
}

