/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jcterm;

import com.jcraft.jcterm.Emulator;
import com.jcraft.jcterm.Term;
import java.io.InputStream;

public class EmulatorVT100
extends Emulator {
    private int term_width = 80;
    private int term_height = 24;
    private int x = 0;
    private int y = 0;
    private int char_width;
    private int char_height;
    private Object fground = null;
    private Object bground = null;
    private static byte[] ENTER = new byte[]{13};
    private static byte[] UP = new byte[]{27, 79, 65};
    private static byte[] DOWN = new byte[]{27, 79, 66};
    private static byte[] RIGHT = new byte[]{27, 79, 67};
    private static byte[] LEFT = new byte[]{27, 79, 68};
    private static byte[] F1 = new byte[]{27, 79, 80};
    private static byte[] F2 = new byte[]{27, 79, 81};
    private static byte[] F3 = new byte[]{27, 79, 82};
    private static byte[] F4 = new byte[]{27, 79, 83};
    private static byte[] F5 = new byte[]{27, 79, 116};
    private static byte[] F6 = new byte[]{27, 79, 117};
    private static byte[] F7 = new byte[]{27, 79, 118};
    private static byte[] F8 = new byte[]{27, 79, 73};
    private static byte[] F9 = new byte[]{27, 79, 119};
    private static byte[] F10 = new byte[]{27, 79, 120};

    public EmulatorVT100(Term term, InputStream in) {
        super(term, in);
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setTerm(Term term) {
        this.term = term;
    }

    public void start() {
        this.term_width = this.term.getColumnCount();
        this.term_height = this.term.getRowCount();
        this.char_width = this.term.getCharWidth();
        this.char_height = this.term.getCharHeight();
        int rx = 0;
        int ry = 0;
        int w = 0;
        int h = 0;
        int region_y1 = 1;
        int region_y2 = this.term_height;
        this.x = 0;
        this.y = this.char_height;
        int[] intarg = new int[10];
        int intargi = 0;
        int tab = 8;
        try {
            while (true) {
                byte b2 = this.getChar();
                ry = this.y;
                rx = this.x;
                if (b2 == 0) continue;
                if (b2 == 27) {
                    b2 = this.getChar();
                    if (b2 == 77) {
                        this.term.draw_cursor();
                        this.term.scroll_area(0, (region_y1 - 1) * this.char_height, this.term_width * this.char_width, (region_y2 - region_y1) * this.char_height, 0, this.char_height);
                        this.term.clear_area(this.x, this.y - this.char_height, this.term_width * this.char_width, this.y);
                        this.term.redraw(0, 0, this.term_width * this.char_width, this.term_height * this.char_height - this.char_height);
                        this.term.draw_cursor();
                        continue;
                    }
                    if (b2 == 68) {
                        this.term.draw_cursor();
                        this.term.scroll_area(0, (region_y1 - 1) * this.char_height, this.term_width * this.char_width, (region_y2 - region_y1 + 1) * this.char_height, 0, -this.char_height);
                        this.term.clear_area(0, region_y2 * this.char_height - this.char_height, this.term_width * this.char_width, region_y2 * this.char_height);
                        this.term.redraw(0, (region_y1 - 1) * this.char_height, this.term_width * this.char_width, (region_y2 - region_y1 + 1) * this.char_height);
                        this.term.draw_cursor();
                        continue;
                    }
                    if (b2 != 91) {
                        this.pushChar(b2);
                        continue;
                    }
                    intargi = 0;
                    intarg[intargi] = 0;
                    int digit = 0;
                    while (true) {
                        if ((b2 = this.getChar()) == 59) {
                            if (digit <= 0) continue;
                            intarg[++intargi] = 0;
                            digit = 0;
                            continue;
                        }
                        if (48 > b2 || b2 > 57) break;
                        intarg[intargi] = intarg[intargi] * 10 + (b2 - 48);
                        ++digit;
                    }
                    this.pushChar(b2);
                    b2 = this.getChar();
                    if (b2 == 109) {
                        if (intargi == 0 && digit > 0) {
                            if (intarg[0] == 1) continue;
                            if (intarg[0] == 7) {
                                this.term.setFGround(this.bground);
                                this.term.setBGround(this.fground);
                                continue;
                            }
                        }
                        this.term.setFGround(this.fground);
                        this.term.setBGround(this.bground);
                        continue;
                    }
                    if (b2 == 114) {
                        region_y1 = intarg[0];
                        region_y2 = intarg[1];
                        continue;
                    }
                    if (b2 == 72) {
                        if (intargi == 0) {
                            intarg[1] = 1;
                            intarg[0] = 1;
                        }
                        this.term.draw_cursor();
                        this.x = (intarg[1] - 1) * this.char_width;
                        this.y = intarg[0] * this.char_height;
                        this.term.setCursor(this.x, this.y);
                        this.term.draw_cursor();
                        continue;
                    }
                    if (b2 == 67) {
                        this.term.draw_cursor();
                        if (intargi == 0) {
                            intarg[0] = 1;
                        }
                        this.x += intarg[0] * this.char_width;
                        this.term.setCursor(this.x, this.y);
                        this.term.draw_cursor();
                        continue;
                    }
                    if (b2 == 75) {
                        this.term.draw_cursor();
                        this.term.clear_area(this.x, this.y - this.char_height, this.term_width * this.char_width, this.y);
                        this.term.redraw(this.x, this.y - this.char_height, (this.term_width - this.x / this.char_width) * this.char_width, this.char_height);
                        this.term.draw_cursor();
                        continue;
                    }
                    if (b2 == 74) {
                        this.term.draw_cursor();
                        this.term.clear_area(this.x, this.y - this.char_height, this.term_width * this.char_width, this.term_height * this.char_height);
                        this.term.redraw(this.x, this.y - this.char_height, this.term_width * this.char_width - this.x, this.term_height * this.char_height - this.y + this.char_height);
                        this.term.draw_cursor();
                        continue;
                    }
                    if (b2 == 65) {
                        this.term.draw_cursor();
                        this.x = 0;
                        this.y -= this.char_height;
                        this.term.setCursor(this.x, this.y);
                        this.term.draw_cursor();
                        continue;
                    }
                    if (b2 == 63 && (b2 = this.getChar()) == 49 && ((b2 = this.getChar()) != 108 && b2 != 108 ? b2 == 104 && (b2 = this.getChar()) == 27 && (b2 = this.getChar()) == 61 : (b2 = this.getChar()) == 27 && ((b2 = this.getChar()) == 62 || b2 == 61))) continue;
                    if (b2 != 104) continue;
                    continue;
                }
                if (b2 == 7) {
                    this.term.beep();
                    continue;
                }
                if (b2 == 9) {
                    this.term.draw_cursor();
                    this.x = (this.x / this.char_width / tab + 1) * tab * this.char_width;
                    if (this.x >= this.term_width * this.char_width) {
                        this.x = 0;
                        this.y += this.char_height;
                    }
                    this.term.setCursor(this.x, this.y);
                    this.term.draw_cursor();
                    continue;
                }
                if (b2 == 15) continue;
                if (b2 == 13) {
                    this.term.draw_cursor();
                    this.x = 0;
                    this.term.setCursor(this.x, this.y);
                    this.term.draw_cursor();
                    continue;
                }
                if (b2 == 8) {
                    this.term.draw_cursor();
                    this.x -= this.char_width;
                    if (this.x < 0) {
                        this.y -= this.char_height;
                        this.x = this.term_width * this.char_width - this.char_width;
                    }
                    this.term.setCursor(this.x, this.y);
                    this.term.draw_cursor();
                    continue;
                }
                if (b2 != 10) {
                    if (this.x >= this.term_width * this.char_width) {
                        this.x = 0;
                        this.y += this.char_height;
                        if (this.y > region_y2 * this.char_height) {
                            this.term.draw_cursor();
                            this.y -= this.char_height;
                            this.term.scroll_area(0, region_y1 * this.char_height, this.term_width * this.char_width, (region_y2 - region_y1) * this.char_height, 0, -this.char_height);
                            this.term.clear_area(0, this.y - this.char_height, this.term_width * this.char_width, this.y);
                            this.term.redraw(0, 0, this.term_width * this.char_width, region_y2 * this.char_height);
                            this.term.setCursor(this.x, this.y);
                            this.term.draw_cursor();
                        }
                        rx = this.x;
                        ry = this.y;
                    }
                    this.term.draw_cursor();
                    if ((b2 & 0x80) != 0) {
                        this.term.clear_area(this.x, this.y - this.char_height, this.x + this.char_width * 2, this.y);
                        byte[] foo = new byte[]{b2, this.getChar()};
                        this.term.drawString(new String(foo, 0, 2, "EUC-JP"), this.x, this.y);
                        this.x += this.char_width;
                        this.x += this.char_width;
                        w = this.char_width * 2;
                        h = this.char_height;
                    } else {
                        this.pushChar(b2);
                        int foo = this.getASCII(this.term_width - this.x / this.char_width);
                        if (foo != 0) {
                            this.term.clear_area(this.x, this.y - this.char_height, this.x + foo * this.char_width, this.y);
                            this.term.drawBytes(this.buf, this.bufs - foo, foo, this.x, this.y);
                        } else {
                            foo = 1;
                            this.term.clear_area(this.x, this.y - this.char_height, this.x + foo * this.char_width, this.y);
                            byte[] bar = new byte[]{this.getChar()};
                            this.term.drawBytes(bar, 0, foo, this.x, this.y);
                        }
                        this.x += this.char_width * foo;
                        w = this.char_width * foo;
                        h = this.char_height;
                    }
                    this.term.redraw(rx, ry - this.char_height, w, h);
                    this.term.setCursor(this.x, this.y);
                    this.term.draw_cursor();
                }
                if (b2 == 10) {
                    this.term.draw_cursor();
                    this.y += this.char_height;
                    this.term.setCursor(this.x, this.y);
                    this.term.draw_cursor();
                }
                if (this.y <= region_y2 * this.char_height) continue;
                this.term.draw_cursor();
                this.y -= this.char_height;
                this.term.scroll_area(0, region_y1 * this.char_height, this.term_width * this.char_width, (region_y2 - region_y1) * this.char_height, 0, -this.char_height);
                this.term.clear_area(0, this.y - this.char_height, this.term_width * this.char_width, this.y);
                this.term.redraw(0, 0, this.term_width * this.char_width, region_y2 * this.char_height);
                this.term.setCursor(this.x, this.y);
                this.term.draw_cursor();
            }
        }
        catch (Exception e) {
            return;
        }
    }

    public byte[] getCodeENTER() {
        return ENTER;
    }

    public byte[] getCodeUP() {
        return UP;
    }

    public byte[] getCodeDOWN() {
        return DOWN;
    }

    public byte[] getCodeRIGHT() {
        return RIGHT;
    }

    public byte[] getCodeLEFT() {
        return LEFT;
    }

    public byte[] getCodeF1() {
        return F1;
    }

    public byte[] getCodeF2() {
        return F2;
    }

    public byte[] getCodeF3() {
        return F3;
    }

    public byte[] getCodeF4() {
        return F4;
    }

    public byte[] getCodeF5() {
        return F5;
    }

    public byte[] getCodeF6() {
        return F6;
    }

    public byte[] getCodeF7() {
        return F7;
    }

    public byte[] getCodeF8() {
        return F8;
    }

    public byte[] getCodeF9() {
        return F9;
    }

    public byte[] getCodeF10() {
        return F10;
    }

    public void reset() {
        this.term_width = this.term.getColumnCount();
        this.term_height = this.term.getRowCount();
        this.char_width = this.term.getCharWidth();
        this.char_height = this.term.getCharHeight();
        this.fground = this.term.getFGround();
        this.bground = this.term.getBGround();
    }
}

