/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.inputinterface;

import ciss.phase_viewer.inputinterface.InputInterfaceEntry;
import java.util.HashMap;

public class InputInterfaceUnits
extends InputInterfaceEntry {
    private String[] units;
    public static String LENGTH = "length";
    public static String ENERGY = "energy";
    private static HashMap unitMap;

    public InputInterfaceUnits() {
    }

    public InputInterfaceUnits(String name, String[] units) {
        super(name);
        this.units = units;
    }

    public String[] getUnits() {
        return this.units;
    }

    public void setUnits(String[] units) {
        this.units = units;
    }

    public String[] getUnitTypes() {
        if (this.units == null) {
            return null;
        }
        HashMap map = InputInterfaceUnits.getUnitMap();
        String[] types = new String[this.units.length];
        for (int i = 0; i < this.units.length; ++i) {
            Object obj = map.get(this.units[i].toLowerCase());
            types[i] = obj != null ? obj.toString() : null;
        }
        return types;
    }

    public int getEntryType() {
        return 3;
    }

    public InputInterfaceEntry getCopy() {
        return this;
    }

    public boolean equals(InputInterfaceEntry entry) {
        return entry instanceof InputInterfaceUnits;
    }

    public void saveState() {
    }

    public void undo() {
    }

    public void redo() {
    }

    public static HashMap getUnitMap() {
        if (unitMap == null) {
            unitMap = new HashMap();
            unitMap.put("angstrom", LENGTH);
            unitMap.put("bohr", LENGTH);
            unitMap.put("nm", LENGTH);
            unitMap.put("ev", ENERGY);
            unitMap.put("hartree", ENERGY);
            unitMap.put("rydberg", ENERGY);
        }
        return unitMap;
    }
}

