/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.scenegraphelements;

import ciss.phase_viewer.acviewer.ConfigDataManager;
import ciss.phase_viewer.acviewer.J3DDataManager;
import ciss.phase_viewer.acviewer.scenegraphelements.AxisObject;
import ciss.phase_viewer.acviewer.scenegraphelements.BGObject;
import ciss.phase_viewer.acviewer.scenegraphelements.CellObject;
import ciss.phase_viewer.acviewer.scenegraphelements.LegendObject;
import ciss.phase_viewer.acviewer.scenegraphelements.LightObject;
import ciss.phase_viewer.acviewer.scenegraphelements.MeasureObject;
import ciss.phase_viewer.acviewer.scenegraphelements.SceneGraphElement;
import ciss.phase_viewer.acviewer.scenegraphelements.SceneGraphElementBG;
import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomObject;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomObjectBG;
import ciss.phase_viewer.acviewer.scenegraphelements.bond.BondObject;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import javax.media.j3d.BranchGroup;
import org.apache.log4j.Logger;

public class SceneGraphElementCreator {
    private static Logger logger = Logger.getLogger(SceneGraphElementCreator.class.getName());
    private ConfigDataManager mCD;
    private J3DDataManager mACVD;
    private TGAtom tgatom;
    private GlobalProperties props = PropertiesManager.getGlobalProperties(1);
    private CellObject cellObject;

    public SceneGraphElementCreator(J3DDataManager mACVD, ConfigDataManager mCD) {
        this.mACVD = mACVD;
        this.mCD = mCD;
    }

    public void setTGAtom(TGAtom tgatom) {
        this.tgatom = tgatom;
    }

    public BranchGroup getSceneGraphElement(String ID, int atomicNumber, double[] pos, double[] force, int mobile, int weight) {
        AtomObject element = new AtomObject(ID, atomicNumber, pos, force, mobile, weight);
        element.register(this.mCD, this.mACVD, this.tgatom);
        element.setAttributes();
        element.create();
        AtomObjectBG bg = new AtomObjectBG(element);
        return bg;
    }

    public SceneGraphElementBG getSceneGraphElement(double[] nearestNeighbor) {
        BondObject bond = new BondObject(nearestNeighbor);
        bond.register(this.mCD, this.mACVD, this.tgatom);
        bond.setBondColor(this.mACVD.getBondColor());
        bond.setNumNodes(this.mACVD.getNumNodesBond());
        float scaleatom = this.mCD.getScaleAtom();
        double bondWidth = (double)scaleatom * this.mACVD.getBondWidth();
        bond.setBondWidth(bondWidth);
        bond.create();
        return bond;
    }

    public SceneGraphElementBG getSceneGraphElement(double[] nearestNeighbor, int mode) {
        BondObject bond = new BondObject(nearestNeighbor);
        bond.register(this.mCD, this.mACVD, this.tgatom);
        bond.setBondColor(this.mACVD.getBondColor());
        float scaleatom = this.mCD.getScaleAtom();
        double bondWidth = (double)scaleatom * this.mACVD.getBondWidth();
        bond.setBondWidth(bondWidth);
        bond.setNumNodes(this.mACVD.getNumNodesBond());
        bond.setMode(mode);
        bond.create();
        return bond;
    }

    public SceneGraphElementBG getSceneGraphElement(double[] atom1, double[] atom2, double result, String[] id) {
        MeasureObject measure = new MeasureObject(atom1, atom2, result);
        measure.register(this.mCD, this.mACVD, this.tgatom);
        measure.setIDString(id);
        measure.create();
        return measure;
    }

    public SceneGraphElementBG getSceneGraphElement(double[] atom1, double[] atom2, double[] atom3, double result, String[] id) {
        MeasureObject measure = new MeasureObject(atom1, atom2, atom3, result);
        measure.register(this.mCD, this.mACVD, this.tgatom);
        measure.setIDString(id);
        measure.create();
        return measure;
    }

    public SceneGraphElementBG getSceneGraphElement(double[] atom1, double[] atom2, double[] atom3, double[] atom4, double result, String[] id) {
        MeasureObject measure = new MeasureObject(atom1, atom2, atom3, atom4, result);
        measure.register(this.mCD, this.mACVD, this.tgatom);
        measure.setIDString(id);
        measure.create();
        return measure;
    }

    public SceneGraphElementBG getSceneGraphElementBG(int sceneType) {
        if (sceneType == 2 && this.cellObject == null) {
            this.cellObject = new CellObject();
            this.cellObject.register(this.mCD, this.mACVD, this.tgatom);
            this.mCD.register(this.cellObject);
        }
        if (this.cellObject != null) {
            this.cellObject.create();
        }
        return this.cellObject;
    }

    public SceneGraphElement getSceneGraphElement(int sceneType) {
        SceneGraphElement ret = null;
        if (sceneType == 3) {
            ret = new AxisObject();
        } else if (sceneType == 4) {
            LegendObject lo = new LegendObject();
            lo.setNumAt(this.mCD.getNumAt());
            lo.setElements(this.mCD.getElements());
            lo.setNumEl(this.mACVD.getNumEl());
            lo.setElementAll(this.mACVD.getElement());
            lo.setColor(this.mACVD.getColor());
            lo.setNumNodes(this.mACVD.getNumNodesAtom());
            lo.register(this.mCD, this.mACVD, this.tgatom);
            if (this.mCD != null) {
                this.mCD.register(lo);
            }
            ret = lo;
        } else if (sceneType == 5) {
            BGObject bo = new BGObject();
            bo.register(this.mCD, this.mACVD, this.tgatom);
            bo.setBgColor(this.mACVD.getBgColor());
            if (this.mCD != null) {
                this.mCD.register(bo);
            }
            ret = bo;
        } else if (sceneType == 6) {
            ret = new LightObject();
        }
        if (ret != null) {
            ((SceneGraphElement)ret).create();
        }
        return ret;
    }

    public ConfigDataManager getConfigData() {
        return this.mCD;
    }

    public J3DDataManager getACVData() {
        return this.mACVD;
    }
}

