/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class WeakSet
extends AbstractSet
implements Cloneable,
Serializable {
    private float loadFactor;
    private int size;
    private long modcount;
    private transient ReferenceQueue refq;
    long nullCount;
    private transient Entry[] entries;
    transient Entry iterChain;
    static final long serialVersionUID = 3062376055928236721L;

    public WeakSet() {
        this(101, 0.75f);
    }

    public WeakSet(Collection c) {
        this();
        this.addAll(c);
    }

    public WeakSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public WeakSet(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0 || loadFactor <= 0.0f) {
            throw new IllegalArgumentException();
        }
        this.size = 0;
        this.modcount = 0L;
        this.loadFactor = loadFactor;
        this.nullCount = 0L;
        this.refq = new ReferenceQueue();
        this.entries = new Entry[initialCapacity];
        this.iterChain = null;
    }

    public boolean add(Object o) {
        if (o == null) {
            ++this.size;
            ++this.nullCount;
            ++this.modcount;
            return true;
        }
        Entry e = this.object2Entry(o);
        if (e != null) {
            return false;
        }
        ++this.modcount;
        ++this.size;
        int hash = this.hashIt(o);
        Entry next = this.entries[hash];
        this.iterChain = this.entries[hash] = new Entry(o, this.refq, next, this.iterChain);
        this.rehash();
        return true;
    }

    public void clear() {
        int i = 0;
        while (i < this.entries.length) {
            this.entries[i] = null;
            ++i;
        }
        this.nullCount = 0L;
        ++this.modcount;
        this.size = 0;
        this.iterChain = null;
    }

    public Object clone() {
        WeakSet nws = new WeakSet(1, this.loadFactor);
        nws.size = this.size;
        nws.nullCount = this.nullCount;
        Entry[] cloned = new Entry[this.entries.length];
        nws.entries = cloned;
        int i = 0;
        while (i < cloned.length) {
            Object ref;
            if (this.entries[i] == null || (ref = this.entries[i].get()) == null) {
                cloned[i] = null;
            } else {
                cloned[i] = this.entries[i] == null ? null : this.entries[i].clone(nws.refq);
                ref = null;
            }
            Entry entry = cloned[i];
            while (entry != null) {
                entry.chainIntoIter(nws.iterChain);
                nws.iterChain = entry;
                entry = entry.next;
            }
            ++i;
        }
        return nws;
    }

    public boolean contains(Object o) {
        if (o == null) {
            return this.nullCount > 0L;
        }
        return this.object2Entry(o) != null;
    }

    public boolean isEmpty() {
        return this.nullCount == 0L && this.size() == 0;
    }

    public Iterator iterator() {
        return new WeakSetIterator();
    }

    public boolean remove(Object o) {
        if (o == null) {
            if (this.nullCount > 0L) {
                --this.nullCount;
                ++this.modcount;
                --this.size;
            }
            return true;
        }
        Entry e = this.object2Entry(o);
        if (e != null) {
            ++this.modcount;
            --this.size;
            e.remove();
            this.rehash();
            return true;
        }
        return false;
    }

    public int size() {
        this.checkRefQueue();
        return this.size;
    }

    public Object[] toArray(Object[] array) {
        ArrayList list = new ArrayList(array.length);
        Iterator it = this.iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list.toArray(array);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator e = this.iterator();
        buf.append("[");
        while (e.hasNext()) {
            buf.append(String.valueOf(e.next()));
            if (!e.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    void checkRefQueue() {
        Entry entry;
        while ((entry = (Entry)this.refq.poll()) != null) {
            entry.remove();
            --this.size;
        }
    }

    long modCount() {
        return this.modcount;
    }

    int hashIt(Object o) {
        return (o.hashCode() & Integer.MAX_VALUE) % this.entries.length;
    }

    void rehash() {
    }

    /*
     * Unable to fully structure code
     */
    private Entry object2Entry(Object o) {
        this.checkRefQueue();
        hash = this.hashIt(o);
        e = this.entries[hash];
        if (e != null) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            e = e.next;
lbl7:
            // 2 sources

            ** while (e != null && !e.equals((Object)o))
        }
lbl8:
        // 1 sources

        return e;
    }

    private void writeObject(ObjectOutputStream obtos) throws IOException {
        obtos.defaultWriteObject();
        obtos.writeObject(this.toArray());
    }

    private void readObject(ObjectInputStream obtis) throws IOException, ClassNotFoundException {
        obtis.defaultReadObject();
        Object[] arr = (Object[])obtis.readObject();
        this.entries = new Entry[(int)((double)this.size * 1.5)];
        this.refq = new ReferenceQueue();
        int i = 0;
        while (i < arr.length) {
            this.add(arr[i]);
            ++i;
        }
    }

    class Entry
    extends WeakReference {
        Entry prev;
        Entry next;
        private final int hashcode;
        Entry iterChainNext;
        Entry iterChainPrev;

        Entry(Object referenced, ReferenceQueue q, Entry next, Entry nextInIter) {
            super(referenced, q);
            this.next = next;
            this.prev = null;
            if (next != null) {
                next.prev = this;
            }
            this.hashcode = referenced != null ? WeakSet.this.hashIt(referenced) : 0;
            this.chainIntoIter(nextInIter);
        }

        void chainIntoIter(Entry nextInIter) {
            this.iterChainNext = nextInIter;
            if (nextInIter != null) {
                nextInIter.iterChainPrev = this;
                Object ref = nextInIter.get();
                if (ref == null) {
                    nextInIter.remove();
                }
            }
        }

        void remove() {
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            if (this.iterChainNext != null) {
                this.iterChainNext.iterChainPrev = this.iterChainPrev;
            }
            if (this.iterChainPrev != null) {
                this.iterChainPrev.iterChainNext = this.iterChainNext;
            } else {
                WeakSet.this.iterChain = this.iterChainNext;
            }
            if (WeakSet.this.entries[this.hashcode] == this) {
                ((WeakSet)WeakSet.this).entries[this.hashcode] = this.next;
            }
            this.prev = null;
            this.next = null;
            this.iterChainNext = null;
            this.iterChainPrev = null;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object o) {
            Object oo = this.get();
            if (oo == null) {
                return false;
            }
            return oo.equals(o);
        }

        public Entry clone(ReferenceQueue q) {
            return new Entry(this.get(), q, this.next != null ? this.next.clone(q) : null, null);
        }
    }

    class WeakSetIterator
    implements Iterator {
        Entry current;
        Entry next;
        Object currentObj;
        Object nextObj;
        final long myModcount;
        long myNullCount;

        WeakSetIterator() {
            this.myModcount = WeakSet.this.modCount();
            this.myNullCount = WeakSet.this.nullCount;
            this.current = null;
            this.next = null;
            Entry ee = WeakSet.this.iterChain;
            if (ee == null) {
                return;
            }
            Object o = ee.get();
            while (ee.isEnqueued()) {
                ee = ee.iterChainNext;
                if (ee == null) {
                    return;
                }
                o = ee.get();
            }
            this.nextObj = o;
            this.next = ee;
        }

        public boolean hasNext() {
            this.checkModcount();
            return this.myNullCount > 0L || this.next != null;
        }

        public Object next() {
            this.checkModcount();
            WeakSet.this.checkRefQueue();
            if (this.myNullCount > 0L) {
                --this.myNullCount;
                return null;
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.currentObj = this.nextObj;
            do {
                this.next = this.next.iterChainNext;
                if (this.next == null) break;
                this.nextObj = this.next.get();
            } while (this.next.isEnqueued());
            return this.currentObj;
        }

        public void remove() {
            this.checkModcount();
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.current.remove();
            WeakSet.this.size--;
        }

        void checkModcount() {
            if (this.myModcount != WeakSet.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

