/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.primitiveguis.tableforinputinterface;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jp.advancesoft.chase.atomcoord.AtomCoords;
import jp.advancesoft.chase.common.CheckBoxTableCellRenderer;
import jp.advancesoft.chase.common.Command;
import jp.advancesoft.chase.common.ConstParameters;
import jp.advancesoft.chase.common.ExcelAdapter;
import jp.advancesoft.chase.inputinterface.InputInterface;
import jp.advancesoft.chase.inputinterface.inputinterfacetable.InputInterfaceTableColumns;
import jp.advancesoft.chase.inputinterface.inputinterfacetable.InputInterfaceTableSpec;
import jp.advancesoft.chase.inputinterface.inputinterfacetable.InputInterfaceTableSpecManager;
import jp.advancesoft.chase.inputinterface.inputinterfacetable.RightClickItems;
import jp.advancesoft.chase.primitiveguis.tableforinputinterface.CheckBoxApplyToAll;
import jp.advancesoft.chase.primitiveguis.tableforinputinterface.CheckBoxTable;
import jp.advancesoft.chase.primitiveguis.tableforinputinterface.ColumnHeaderToolTips;
import jp.advancesoft.chase.primitiveguis.tableforinputinterface.ComboBoxApplyToAll;
import jp.advancesoft.chase.primitiveguis.tableforinputinterface.TableHeader;
import jp.advancesoft.chase.primitiveguis.tableforinputinterface.TableModelForInputInterface;
import jp.advancesoft.chase.primitiveguis.tableforinputinterface.TableModelForNonTabularData;
import jp.advancesoft.chase.primitiveguis.tableforinputinterface.TableRightClickListener;
import jp.advancesoft.chase.primitiveguis.tableforinputinterface.TextFieldApplyToAll;
import jp.advancesoft.chase.settings.PropertiesManager;
import org.apache.log4j.Logger;

public class TableForInputInterface
extends JTable
implements ItemListener,
ActionListener,
CaretListener,
PopupMenuListener {
    private static Logger logger = Logger.getLogger(TableForInputInterface.class.getName());
    private String[] idents;
    private Vector tableData;
    private String[] inputSpecifications;
    private InputInterface inputInterface;
    private InputInterfaceTableSpecManager manager;
    private InputInterfaceTableSpec tableSpec;
    private InputInterfaceTableColumns[] tableCols;
    private int[] mapSpecCol;
    private EventListener eventListener;
    private JPanel panel;
    private CheckBoxTable cbtable;
    private DecimalFormat formater = ConstParameters.formater;
    private boolean non_tabular = false;
    private boolean row_oriented = false;
    private String[] row_oriented_columns;
    private int columnIndex = 0;
    private AtomCoords coords;
    TableModelListener[] tlisteners;
    private Vector tableRightClickListeners;

    public TableForInputInterface(String[] inputSpecifications, InputInterface inputInterface, int[] mapSpecCol, EventListener eventListener) {
        this.inputSpecifications = inputSpecifications;
        this.inputInterface = inputInterface;
        this.mapSpecCol = mapSpecCol;
        this.eventListener = eventListener;
        this.columnIndex = 0;
        this.init();
        this.createAll();
    }

    public TableForInputInterface(AtomCoords coords, String[] inputSpecifications, InputInterface inputInterface, int[] mapSpecCol, EventListener eventListener) {
        this.coords = coords;
        this.inputSpecifications = inputSpecifications;
        this.inputInterface = inputInterface;
        this.mapSpecCol = mapSpecCol;
        this.eventListener = eventListener;
        this.columnIndex = 0;
        this.init();
        this.createAll();
    }

    public TableForInputInterface(String[] inputSpecifications, InputInterface inputInterface, EventListener eventListener) {
        this.inputSpecifications = inputSpecifications;
        this.inputInterface = inputInterface;
        this.eventListener = eventListener;
        this.columnIndex = 0;
        this.init();
        this.createAll();
    }

    public TableForInputInterface(String[] inputSpecifications, InputInterface inputInterface, int[] mapSpecCol, EventListener eventListener, int columnIndex) {
        this.inputSpecifications = inputSpecifications;
        this.inputInterface = inputInterface;
        this.mapSpecCol = mapSpecCol;
        this.eventListener = eventListener;
        this.columnIndex = columnIndex;
        this.init();
        this.createAll();
    }

    public TableForInputInterface(String[] inputSpecifications, InputInterface inputInterface, EventListener eventListener, int columnIndex) {
        this.inputSpecifications = inputSpecifications;
        this.inputInterface = inputInterface;
        this.eventListener = eventListener;
        this.columnIndex = columnIndex;
        this.init();
        this.createAll();
    }

    public void itemStateChanged(ItemEvent e) {
        Command command = (Command)e.getSource();
        command.execute(e);
    }

    public void actionPerformed(ActionEvent e) {
        Command command = (Command)e.getSource();
        command.execute(e);
    }

    public void caretUpdate(CaretEvent e) {
        Command command = (Command)e.getSource();
        command.execute(e);
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        Command command = (Command)e.getSource();
        command.execute(e);
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    public void removeListeners() {
        this.tlisteners = ((DefaultTableModel)this.getModel()).getTableModelListeners();
        if (this.tlisteners != null) {
            for (int i = 0; i < this.tlisteners.length; ++i) {
                ((DefaultTableModel)this.getModel()).removeTableModelListener(this.tlisteners[i]);
            }
        }
    }

    public void restoreListeners() {
        if (this.tlisteners != null) {
            for (int i = 0; i < this.tlisteners.length; ++i) {
                ((DefaultTableModel)this.getModel()).addTableModelListener(this.tlisteners[i]);
            }
        }
    }

    public JPanel getPanel() {
        this.createPanel();
        return this.panel;
    }

    public boolean hasData(boolean[] ignore) {
        boolean hasdata = false;
        TableModel model = this.getModel();
        int icol = model.getColumnCount();
        int irow = model.getRowCount();
        for (int i = 0; i < irow; ++i) {
            for (int j2 = 0; j2 < icol; ++j2) {
                String data;
                if (ignore != null && ignore[j2] || (data = (String)model.getValueAt(i, j2)) == null || data.trim().length() == 0) continue;
                hasdata = true;
            }
        }
        return hasdata;
    }

    private void init() {
        logger.debug("at init(): " + this.inputSpecifications[0]);
        ExcelAdapter ea = new ExcelAdapter(this);
        this.manager = this.inputInterface.getInputInterfaceTableSpecManager();
        if (this.manager != null) {
            this.tableSpec = this.manager.getTableSpec(this.inputSpecifications[0], this.columnIndex);
            this.tableCols = this.tableSpec.getTableColumns();
        }
        if (this.mapSpecCol == null) {
            int len = this.tableCols.length;
            this.mapSpecCol = new int[len];
            for (int i = 0; i < len; ++i) {
                this.mapSpecCol[i] = i;
            }
        }
        this.non_tabular = this.tableSpec.nonTabular();
        if (this.non_tabular) {
            this.row_oriented = this.tableSpec.isRowOriented();
            this.row_oriented_columns = this.tableSpec.getColumnNamesForNonTabularData();
        }
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.setModel(this.getTableModel());
        if (this.eventListener instanceof ListSelectionListener) {
            this.getSelectionModel().addListSelectionListener((ListSelectionListener)this.eventListener);
        }
    }

    private boolean isColumnEmpty(int rowIndex) {
        for (int j2 = 1; j2 < ConstParameters.COLNAME_ATOM.length; ++j2) {
            String length = (String)this.getModel().getValueAt(rowIndex, j2);
            if (length != null && length.trim().length() == 0) continue;
            return false;
        }
        return true;
    }

    private void shiftUp(int rowIndex) {
        int MaxAt = Integer.parseInt(PropertiesManager.getGlobalProperties(2).getProperty("NUMAT_MAX_PHASE"));
        for (int i = rowIndex; i < MaxAt - 1; ++i) {
            for (int j2 = 1; j2 < ConstParameters.COLNAME_ATOM.length; ++j2) {
                this.getModel().setValueAt(this.getModel().getValueAt(i + 1, j2), i, j2);
            }
            this.getModel().setValueAt("", i, 0);
        }
    }

    private void createAll() {
        if (this.manager != null && this.inputInterface != null) {
            int[] inds = this.getApplyToAllIndices();
            if (inds != null && inds.length != 0) {
                logger.debug("creating checkbox table...");
                logger.debug("column count... " + this.getColumnCount());
                logger.debug("indices...");
                for (int i = 0; i < inds.length; ++i) {
                    logger.debug(new Integer(inds[i]));
                }
                this.cbtable = new CheckBoxTable(inds, this.getModel().getColumnCount());
            }
            this.createTable();
            this.createPanel();
        }
    }

    private void createPanel() {
        this.panel.removeAll();
        int row = this.getRowCount();
        if (row == 1 && this.getModel() instanceof TableModelForNonTabularData) {
            this.panel.setLayout(new GridLayout(2, 1));
        } else {
            this.panel.setLayout(new BoxLayout(this.panel, 1));
        }
        this.panel.add(this.getTableHeader());
        if (this.cbtable != null) {
            this.panel.add(this.cbtable);
        }
        this.panel.add(this);
        logger.debug("tableheader..." + this.getTableHeader());
        logger.debug("inputspec: " + this.inputSpecifications[0]);
    }

    private int[] getApplyToAllIndices() {
        Vector<Integer> indvec = new Vector<Integer>();
        for (int i = 0; i < this.mapSpecCol.length; ++i) {
            logger.debug("cols: " + this.tableCols[this.mapSpecCol[i]]);
            if (!this.tableCols[this.mapSpecCol[i]].hasApplytoAll()) continue;
            indvec.addElement(new Integer(i));
        }
        if (indvec == null || indvec.size() == 0) {
            return null;
        }
        int[] ret = new int[indvec.size()];
        for (int i = 0; i < indvec.size(); ++i) {
            ret[i] = (Integer)indvec.elementAt(i);
        }
        return ret;
    }

    private void createTable() {
        int numCols = this.getColumnCount();
        ColumnHeaderToolTips toolTips = new ColumnHeaderToolTips();
        for (int i = 0; i < numCols; ++i) {
            TableColumn col = this.getColumnModel().getColumn(i);
            if (!this.non_tabular) {
                this.addCellEditor(col, this.tableCols[this.mapSpecCol[i]], i);
                this.addToolTip(toolTips, col, this.tableCols[this.mapSpecCol[i]]);
                continue;
            }
            this.setEditorsAndRenderes();
        }
        this.addMouseListener(new RowMouseListener());
        this.setTableHeader(new TableHeader(this, this.tableCols, this.mapSpecCol));
        this.getTableHeader().addMouseMotionListener(toolTips);
        logger.debug("done creating table for: " + this.inputSpecifications[0]);
    }

    private void setEditorsAndRenderes() {
        int rowStart;
        DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer();
        dtcr.setHorizontalAlignment(0);
        DefaultTableCellRenderer dtcr2 = new DefaultTableCellRenderer();
        JTextField tf = new JTextField();
        tf.setEditable(false);
        JTextField tf2 = new JTextField();
        tf2.setEditable(true);
        DefaultCellEditor dce = new DefaultCellEditor(tf);
        DefaultCellEditor dce2 = new DefaultCellEditor(tf2);
        int icol = this.getModel().getColumnCount();
        this.columnModel.getColumn(0).setCellRenderer(dtcr);
        this.columnModel.getColumn(0).setCellEditor(dce);
        for (int i = rowStart = 1; i < icol; ++i) {
            this.columnModel.getColumn(i).setCellRenderer(dtcr2);
            this.columnModel.getColumn(i).setCellEditor(dce2);
        }
    }

    private void addToolTip(ColumnHeaderToolTips toolTips, TableColumn col, InputInterfaceTableColumns tableCol) {
        String toolTip = tableCol.getToolTip();
        if (toolTip != null && toolTip.trim().length() != 0) {
            toolTips.setToolTip(col, tableCol.getToolTip());
        }
    }

    private void addCellEditor(TableColumn col, InputInterfaceTableColumns tableCol, int colnum) {
        String type = tableCol.getCellEditor();
        String defaultValue = tableCol.getDefaultValue();
        logger.debug("default value: " + defaultValue);
        boolean editable = tableCol.isEditable();
        if (type.equals(InputInterfaceTableColumns.TEXT_FIELD)) {
            JTextField textField = null;
            textField = tableCol.hasApplytoAll() ? new TextFieldApplyToAll(defaultValue, this.cbtable, this, colnum, this) : new JTextField(defaultValue);
            textField.setEnabled(editable);
            col.setCellEditor(new DefaultCellEditor(textField));
        } else if (type.equals(InputInterfaceTableColumns.COMBO_BOX)) {
            ComboBoxApplyToAll combo = null;
            if (!this.validChoices(tableCol.getChoices())) {
                if (tableCol.hasApplytoAll()) {
                    col.setCellEditor(new DefaultCellEditor(new TextFieldApplyToAll(defaultValue, this.cbtable, this, colnum, this)));
                } else {
                    col.setCellEditor(new DefaultCellEditor(new JTextField()));
                }
                return;
            }
            combo = tableCol.hasApplytoAll() ? new ComboBoxApplyToAll(tableCol.getChoices(), this.cbtable, this, colnum, this) : new JComboBox(tableCol.getChoices());
            combo.setEnabled(editable);
            col.setCellEditor(new DefaultCellEditor(combo));
        } else if (type.equals(InputInterfaceTableColumns.CHECK_BOX)) {
            JCheckBox checkBox = null;
            checkBox = tableCol.hasApplytoAll() ? new CheckBoxApplyToAll(false, this.cbtable, this, colnum, this) : new JCheckBox("", (boolean)new Boolean(defaultValue));
            checkBox.setEnabled(editable);
            checkBox.setHorizontalAlignment(0);
            col.setCellEditor(new DefaultCellEditor(checkBox));
            col.setCellRenderer(new CheckBoxTableCellRenderer());
        }
    }

    private boolean validChoices(String[] test) {
        if (test == null || test.length == 0) {
            return false;
        }
        return test.length != 1 || test[0].trim().length() != 0;
    }

    protected void doApplyToAll(Object selectedItem, int colInd) {
        int numRow = this.getRowCount();
        int numCols = this.getColumnCount();
        DefaultTableModel mod = (DefaultTableModel)this.getModel();
        ((TableModelForInputInterface)mod).batchUpdate(true);
        int swi = numRow - 1;
        if (swi < 0) {
            swi = 0;
        }
        for (int i = 0; i < numRow; ++i) {
            int nullCount = 0;
            for (int j2 = 0; j2 < numCols; ++j2) {
                Object obj = this.getModel().getValueAt(i, j2);
                if (obj == null) {
                    ++nullCount;
                    continue;
                }
                if (!(obj instanceof String) || ((String)obj).length() != 0) continue;
                ++nullCount;
            }
            if (nullCount == numCols) {
                ((TableModelForInputInterface)mod).batchUpdate(false);
                return;
            }
            mod.setValueAt(selectedItem, i, colInd);
        }
    }

    public void updateAll() {
        this.setModel(this.getTableModel());
        this.createAll();
    }

    public void addTableRightClickListener(TableRightClickListener listener) {
        if (this.tableRightClickListeners == null) {
            this.tableRightClickListeners = new Vector();
        }
        this.tableRightClickListeners.addElement(listener);
    }

    protected void deleteColumn(int col) {
        int i;
        int[] tmp = new int[this.mapSpecCol.length - 1];
        int icount = 0;
        for (i = 0; i < this.mapSpecCol.length; ++i) {
            if (i == col) continue;
            tmp[icount] = this.mapSpecCol[i];
            ++icount;
        }
        this.mapSpecCol = new int[tmp.length];
        for (i = 0; i < this.mapSpecCol.length; ++i) {
            this.mapSpecCol[i] = tmp[i];
        }
        this.setModel(this.getTableModel());
        this.createAll();
    }

    protected void addColumn(String name) {
        int i;
        int addInd = -1;
        for (int i2 = 0; i2 < this.tableCols.length; ++i2) {
            if (!this.tableCols[i2].getName().equals(name)) continue;
            addInd = i2;
            break;
        }
        int[] tmp = new int[this.mapSpecCol.length + 1];
        for (i = 0; i < this.mapSpecCol.length; ++i) {
            tmp[i] = this.mapSpecCol[i];
        }
        tmp[this.mapSpecCol.length] = addInd;
        this.mapSpecCol = new int[this.mapSpecCol.length + 1];
        for (i = 0; i < this.mapSpecCol.length; ++i) {
            this.mapSpecCol[i] = tmp[i];
        }
        this.setModel(this.getTableModel());
        this.createAll();
    }

    private TableModelForInputInterface getTableModel() {
        TableModelForInputInterface tmfi = null;
        tmfi = this.coords == null ? TableModelForInputInterface.getInstance(this.inputSpecifications, this.inputInterface, this.mapSpecCol, this.eventListener, this.non_tabular, this.columnIndex) : TableModelForInputInterface.getInstance(this.coords, this.inputSpecifications, this.inputInterface.getInputInterfaceTableSpecManager(), this.mapSpecCol, this.eventListener, this);
        tmfi.setParentTable(this);
        return tmfi;
    }

    class RightClickMenu
    extends JMenuItem {
        private MouseEvent me;
        private String name;

        protected RightClickMenu(MouseEvent me, RightClickItems item) {
            super(item.getText());
            this.setToolTipText(item.getToolTip());
            this.me = me;
            this.name = item.getName();
            this.init();
        }

        private void init() {
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RightClickMenu.this.doRightClickItem(RightClickMenu.this.me, RightClickMenu.this.name);
                }
            });
        }

        private void doRightClickItem(MouseEvent e, String name) {
            logger.debug("clicked item");
            logger.debug("you're at row: " + TableForInputInterface.this.rowAtPoint(e.getPoint()));
            if (TableForInputInterface.this.tableRightClickListeners == null) {
                return;
            }
            for (int i = 0; i < TableForInputInterface.this.tableRightClickListeners.size(); ++i) {
                ((TableRightClickListener)TableForInputInterface.this.tableRightClickListeners.elementAt(i)).tableRightClicked(e.getPoint(), name);
            }
        }
    }

    class RowMouseListener
    extends MouseAdapter {
        JPopupMenu popup;

        protected RowMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (TableForInputInterface.this.inputInterface.getInputInterfaceTableSpecManager().getTableSpec(TableForInputInterface.this.inputSpecifications[0]).getRightClickItems() == null) {
                return;
            }
            this.processClick(e);
        }

        private void processClick(MouseEvent e) {
            if (e.getButton() == 3) {
                this.popup = new JPopupMenu();
                RightClickItems[] items = TableForInputInterface.this.inputInterface.getInputInterfaceTableSpecManager().getTableSpec(TableForInputInterface.this.inputSpecifications[0]).getRightClickItems();
                this.createMenu(e, items);
                if (this.popup.getComponentCount() > 0) {
                    this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }

        private void createMenu(MouseEvent e, RightClickItems[] items) {
            for (int i = 0; i < items.length; ++i) {
                this.popup.add(new RightClickMenu(e, items[i]));
            }
        }
    }
}

