/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import jp.advancesoft.chase.inputinterface.InputInterface;
import jp.advancesoft.chase.inputinterface.InputInterfacePrimitiveEntry;
import jp.advancesoft.chase.phase.ComboBoxPhase;
import jp.advancesoft.chase.phase.PhaseInputPanelInterface;
import org.apache.log4j.Logger;

public class ChoicePanelPhase
extends JPanel
implements PhaseInputPanelInterface {
    private ComboBoxPhase combobox;
    private static Logger logger = Logger.getLogger(ChoicePanelPhase.class.getName());
    private InputInterface inputinterface;
    private InputInterfacePrimitiveEntry entry;
    private String[] inputSpecifications;
    private String[] choices;
    private String[] fullName;
    private String title;
    private Vector dupli = null;

    ChoicePanelPhase(String[] inputSpecifications, InputInterface inputinterface, String title, String[] choices, EventListener parent) {
        this.inputSpecifications = inputSpecifications;
        this.inputinterface = inputinterface;
        this.title = title;
        this.choices = choices;
        this.extractInputFile();
        this.createGUI();
        this.addListeners(parent);
    }

    ChoicePanelPhase(String[] inputSpecifications, InputInterface inputinterface, String title, String[] choices, Vector dupli, EventListener parent) {
        this.inputSpecifications = inputSpecifications;
        this.inputinterface = inputinterface;
        this.title = title;
        this.choices = choices;
        this.dupli = dupli;
        this.extractInputFile();
        this.createGUI();
        this.addListeners(parent);
    }

    ChoicePanelPhase(String[] inputSpecifications, InputInterface inputinterface, String title, String[] choices) {
        this.inputSpecifications = inputSpecifications;
        this.inputinterface = inputinterface;
        this.title = title;
        this.choices = choices;
        this.extractInputFile();
        this.createGUI();
    }

    ChoicePanelPhase(String[] inputSpecifications, InputInterface inputinterface, String title, String[] choices, Vector dupli) {
        this.inputSpecifications = inputSpecifications;
        this.inputinterface = inputinterface;
        this.title = title;
        this.choices = choices;
        this.dupli = dupli;
        this.extractInputFile();
        this.createGUI();
    }

    private void extractInputFile() {
        for (int is = 0; is < this.inputSpecifications.length; ++is) {
            String inp = this.inputSpecifications[is];
            logger.debug("inp: " + inp);
            this.fullName = inp.split("\\.");
            this.inputinterface.selectRoot();
            logger.debug("length of fullName: " + this.fullName.length);
            for (int i = 0; i < this.fullName.length - 1; ++i) {
                String ident = this.fullName[i];
                if (this.inputinterface.selectBlock(ident)) continue;
                logger.debug("couldn't select block: " + ident);
            }
            this.entry = this.inputinterface.getPrimitiveEntry(this.fullName[this.fullName.length - 1]);
            if (this.entry.getName().trim().length() == 0 && is != this.inputSpecifications.length - 1) continue;
            logger.debug("got entry: " + this.entry.getName() + " value: " + this.entry.getValue() + " unit: " + this.entry.getUnit());
            String st = this.inputSpecifications[0];
            this.fullName = st.split("\\.");
            this.entry.setName(this.fullName[this.fullName.length - 1].trim());
            this.inputinterface.selectRoot();
            break;
        }
    }

    private void createGUI() {
        super.setLayout(new BoxLayout(this, 0));
        this.createComboBox();
        super.add(this.combobox);
        if (this.title != null) {
            super.setBorder(new TitledBorder(this.title));
        }
    }

    private void createComboBox() {
        int i;
        this.combobox = new ComboBoxPhase(this.choices, this.inputSpecifications, this.inputinterface);
        String value = this.entry.getValue().trim();
        for (i = 0; i < this.choices.length; ++i) {
            logger.debug("choice at: " + i + " is " + this.choices[i]);
            if (!this.choices[i].equalsIgnoreCase(value)) continue;
            this.combobox.setSelectedIndex(i);
        }
        if (this.dupli != null) {
            for (i = 0; i < this.dupli.size(); ++i) {
                String[] d = (String[])this.dupli.get(i);
                int index = Integer.parseInt(d[0]);
                String newval = d[1];
                if (!newval.equalsIgnoreCase(value)) continue;
                this.combobox.setSelectedIndex(index);
            }
        }
    }

    public void addListeners(EventListener listener) {
        this.combobox.addActionListener((ActionListener)listener);
    }

    public void registerDisabableGUI(int[] index, JComponent jcomponent) {
        this.combobox.setDisabableGUI(index, jcomponent);
        this.combobox.setSelectedIndex(this.combobox.getSelectedIndex());
    }

    public void setEnabled(boolean enabled) {
        this.combobox.setEnabled(enabled);
    }

    public String getValue() {
        return (String)this.combobox.getSelectedItem();
    }

    public String getUnit() {
        return new String();
    }

    public JComboBox getComboBox() {
        return this.combobox;
    }
}

