/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jp.advancesoft.chase.atomcoord.AtomCoords;
import jp.advancesoft.chase.common.Command;
import jp.advancesoft.chase.common.ConstParameters;
import jp.advancesoft.chase.common.ElementInfo;
import jp.advancesoft.chase.common.TaggedString;
import jp.advancesoft.chase.inputinterface.InputInterface;
import jp.advancesoft.chase.inputinterface.inputinterfacetable.InputInterfaceTable;
import jp.advancesoft.chase.phase.CheckBoxTable;
import jp.advancesoft.chase.phase.ComboBoxApplyToAll;
import jp.advancesoft.chase.phase.TableForInputInterface;
import jp.advancesoft.chase.phase.TableModelForAtomPanel;
import jp.advancesoft.chase.settings.PropertiesManager;
import org.apache.log4j.Logger;

public class AtomTableInputInterface
extends TableForInputInterface
implements ItemListener {
    private static Logger logger = Logger.getLogger(TableForInputInterface.class.getName());
    private InputInterface input;
    private InputInterfaceTable table;
    private String[] inputSpecifications;
    private CheckBoxTable tbl_cb;
    private DecimalFormat formater = ConstParameters.formater;
    public static final int ATOMTABLE_COL_WIDTH = 100;
    private AtomCoords coords;
    private Vector ignoreThisRow = new Vector();

    public AtomTableInputInterface(String[] inputSpecifications, InputInterface input) {
        super(inputSpecifications, input);
        this.input = input;
        this.inputSpecifications = inputSpecifications;
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.setAutoResizeMode(0);
        this.tbl_cb = new CheckBoxTable();
    }

    public void init() {
        this.coords = ((TableModelForAtomPanel)this.getModel()).getAtomCoords();
        ElementInfo eI = new ElementInfo();
        int num_elements = eI.num_elements;
        String[] elements_list = new String[num_elements];
        elements_list[0] = "";
        for (int i = 1; i < num_elements; ++i) {
            elements_list[i] = eI.getSymbolFromNumber(i);
        }
        for (int i = 0; i < ConstParameters.COLNAME_ATOM.length; ++i) {
            TableColumn column = this.getColumnModel().getColumn(i);
            column.setPreferredWidth(100);
        }
        TableColumn column = this.getColumnModel().getColumn(1);
        ComboBoxApplyToAll comboAtom = new ComboBoxApplyToAll(elements_list, this.tbl_cb, this, this.coords, 1, this);
        column.setCellEditor(new DefaultCellEditor(comboAtom));
        column = this.getColumnModel().getColumn(5);
        ComboBoxApplyToAll comboMobile = new ComboBoxApplyToAll(ConstParameters.ZERO_OR_ONE, this.tbl_cb, this, this.coords, 5, this);
        column.setCellEditor(new DefaultCellEditor(comboMobile));
        column = this.getColumnModel().getColumn(6);
        ComboBoxApplyToAll comboWeight = new ComboBoxApplyToAll(ConstParameters.ONE_OR_TWO, this.tbl_cb, this, this.coords, 6, this);
        column.setCellEditor(new DefaultCellEditor(comboWeight));
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 8 || e.getKeyCode() == 127) {
                    int[] selectedRows = AtomTableInputInterface.this.getSelectedRows();
                    int numSelectedRows = selectedRows.length;
                    int[] selectedColumns = AtomTableInputInterface.this.getSelectedColumns();
                    int numSelectedColumns = selectedColumns.length;
                    for (int i = 0; i < numSelectedRows; ++i) {
                        for (int j2 = 0; j2 < ConstParameters.COLNAME_ATOM.length; ++j2) {
                            if (!AtomTableInputInterface.this.isCellSelected(selectedRows[i], j2)) continue;
                            AtomTableInputInterface.this.getModel().setValueAt("", selectedRows[i], j2);
                        }
                        if (!AtomTableInputInterface.this.isColumnEmpty(selectedRows[i])) continue;
                        AtomTableInputInterface.this.shiftUp(selectedRows[i]);
                    }
                }
            }
        });
        super.setInputToModel();
    }

    public int getNumAt() {
        TableModel model = this.getModel();
        int numRow = model.getRowCount();
        int numCol = model.getColumnCount();
        int nullCount = 0;
        for (int i = 0; i < numRow; ++i) {
            for (int j2 = 0; j2 < numCol; ++j2) {
                String test = (String)model.getValueAt(i, j2);
                if (test != null && test.trim().length() != 0) continue;
                ++nullCount;
            }
            if (nullCount == numCol) {
                return i;
            }
            nullCount = 0;
        }
        return numRow;
    }

    public double[][] getPos() {
        int numAt = this.getNumAt();
        double[][] Dpos = new double[numAt][3];
        TableModel model = this.getModel();
        String[] elems = this.getElements();
        for (int i = 0; i < numAt; ++i) {
            try {
                for (int j2 = 0; j2 < 3; ++j2) {
                    String pos = (String)model.getValueAt(i, j2 + 2);
                    double p = 0.0;
                    try {
                        Dpos[i][j2] = p = Double.parseDouble(pos);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        logger.warn("failed to convert table data");
                    }
                }
                continue;
            }
            catch (NullPointerException npe) {
                logger.error("failed to get pos data");
            }
        }
        return Dpos;
    }

    public String[] getElements() {
        int numAt = this.getNumAt();
        String[] elements = new String[numAt];
        TableModel model = this.getModel();
        for (int i = 0; i < numAt; ++i) {
            String elem;
            elements[i] = elem = (String)model.getValueAt(i, 1);
        }
        return elements;
    }

    public TaggedString[][] getAuxils() {
        TableModel model = this.getModel();
        int numCols = model.getColumnCount();
        int numAt = this.getNumAt();
        int numauxs = numCols - 5;
        String[] names = this.getColumnNames();
        TaggedString[][] auxils = new TaggedString[numAt][numauxs];
        String[] elems = this.getElements();
        for (int i = 0; i < numAt; ++i) {
            if (elems[i] == null || elems[i].trim().length() == 0) continue;
            for (int j2 = 5; j2 < numCols; ++j2) {
                String au = (String)model.getValueAt(i, j2);
                auxils[i][j2 - 5] = new TaggedString(names[j2], au);
            }
        }
        return auxils;
    }

    public String[] getLabel() {
        int numAt = this.getNumAt();
        String[] retstring = new String[numAt];
        for (int i = 0; i < numAt; ++i) {
            retstring[i] = String.valueOf(i);
        }
        return retstring;
    }

    public void itemStateChanged(ItemEvent e) {
        Command command = (Command)e.getSource();
        command.execute(e);
    }

    private String[] getColumnNames() {
        int numCols = this.getModel().getColumnCount();
        String[] retstring = new String[numCols];
        for (int i = 0; i < numCols; ++i) {
            retstring[i] = this.getColumnName(i);
        }
        return retstring;
    }

    public void setValueAndFormatAt(Object data, int row, int col) {
        Object formatedData;
        if (data instanceof Double) {
            formatedData = this.formater.format((Double)data);
        } else if (data instanceof String) {
            try {
                Double d = Double.valueOf((String)data);
                formatedData = this.formater.format(d);
            }
            catch (NumberFormatException ne) {
                formatedData = data;
            }
        } else {
            formatedData = data;
        }
        super.getModel().setValueAt(formatedData, row, col);
    }

    private boolean isColumnEmpty(int rowIndex) {
        for (int j2 = 1; j2 < ConstParameters.COLNAME_ATOM.length; ++j2) {
            String length = (String)this.getModel().getValueAt(rowIndex, j2);
            if (length != null && length.trim().length() == 0) continue;
            return false;
        }
        return true;
    }

    private void shiftUp(int rowIndex) {
        int MaxAt = Integer.parseInt(PropertiesManager.getGlobalProperties(2).getProperty("NUMAT_MAX_PHASE"));
        for (int i = rowIndex; i < MaxAt - 1; ++i) {
            for (int j2 = 1; j2 < ConstParameters.COLNAME_ATOM.length; ++j2) {
                this.getModel().setValueAt(this.getModel().getValueAt(i + 1, j2), i, j2);
            }
            this.getModel().setValueAt("", i, 0);
        }
    }

    public JPanel getPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.getTableHeader());
        panel.add(this.tbl_cb);
        panel.add(this);
        return panel;
    }

    public void clearAtomConfigTable() {
        TableModel model = this.getModel();
        int numCols = model.getColumnCount();
        int numAt = this.getNumAt();
        for (int i = 0; i < numAt; ++i) {
            for (int j2 = 0; j2 < numCols; ++j2) {
                model.setValueAt("", i, j2);
            }
        }
    }
}

