/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.graph;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import jp.advancesoft.chase.graph.DataTab;
import jp.advancesoft.chase.graph.GraphPanel;
import jp.advancesoft.chase.graph.dataset.DataSet;
import jp.advancesoft.chase.graph.dataset.DataSetManipulator;
import jp.advancesoft.chase.outputinterface.OutputData;
import org.apache.log4j.Logger;

public class DataPanel
extends JPanel {
    private static Logger logger = Logger.getLogger(DataPanel.class.getName());
    private OutputData[] outputData;
    private JTabbedPane tabbedPane;
    private JPanel panel;
    public static final int TABBED = 0;
    public static final int SINGLE = 1;
    private int mode = 0;
    private JComboBox comboplottypes;
    private JToggleButton btntoggle;

    public DataPanel(OutputData[] outputData) {
        this.outputData = outputData;
        this.setLayout(new BoxLayout(this, 1));
        this.init();
    }

    public DataPanel(OutputData[] outputData, int mode) {
        this.outputData = outputData;
        this.mode = mode;
        this.setLayout(new BoxLayout(this, 1));
        this.init();
    }

    public DataPanel(OutputData outputDat) {
        this.outputData = new OutputData[1];
        this.outputData[0] = outputDat;
        this.mode = 1;
        this.setLayout(new BoxLayout(this, 1));
        this.init();
    }

    private void init() {
        if (this.outputData == null || this.outputData.length == 0) {
            return;
        }
        this.create();
        if (this.mode == 0) {
            this.add(this.tabbedPane);
        } else if (this.mode == 1) {
            this.add(this.panel);
        }
        this.add(this.createButtonPanel());
    }

    public void setOutputData(OutputData[] outputData) {
        this.outputData = outputData;
        this.create();
    }

    public void setOutputData(OutputData outData) {
        if (this.outputData == null) {
            this.outputData = new OutputData[1];
        }
        this.outputData[0] = outData;
        this.create();
    }

    private void create() {
        if (this.outputData == null || this.outputData.length == 0) {
            return;
        }
        if (this.mode == 0) {
            if (this.tabbedPane == null) {
                this.tabbedPane = new JTabbedPane();
                this.tabbedPane.setTabLayoutPolicy(1);
            }
            this.tabbedPane.removeAll();
            for (int i = 0; i < this.outputData.length; ++i) {
                DataTab tab = new DataTab(this.outputData[i]);
                this.tabbedPane.addTab(this.outputData[i].getName(), tab);
                this.tabbedPane.setToolTipTextAt(i, this.outputData[i].getDescription());
            }
        } else if (this.mode == 1) {
            if (this.panel == null) {
                this.panel = new JPanel();
                this.panel.setLayout(new GridLayout());
            }
            this.panel.removeAll();
            DataTab tab = new DataTab(this.outputData[0]);
            this.panel.add(tab);
            this.panel.revalidate();
        }
    }

    private JPanel createButtonPanel() {
        String[] plottypes = new String[]{"xy", "pie"};
        JPanel p = new JPanel();
        JButton btnquickplot = new JButton("quick plot");
        JButton btnplot = new JButton("plot");
        this.comboplottypes = new JComboBox<String>(plottypes);
        JButton btnload = new JButton("load data");
        this.btntoggle = new JToggleButton("toggle selection mode");
        JButton btndel = new JButton("delete data");
        JButton btnsavedata = new JButton("save data");
        JButton btnclose = new JButton("close");
        JPanel pbtn = new JPanel();
        pbtn.setLayout(new BoxLayout(pbtn, 1));
        JPanel pplot = new JPanel();
        pplot.setLayout(new BoxLayout(pplot, 0));
        pplot.add(this.btntoggle);
        pplot.add(btnquickplot);
        pplot.add(this.comboplottypes);
        pplot.add(btnplot);
        pbtn.add(pplot);
        p.add(pbtn);
        btnquickplot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!DataPanel.this.plotData()) {
                    logger.error("plot failed.");
                }
            }
        });
        btnplot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataPanel.this.bootDataSetManipulator();
            }
        });
        this.btntoggle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JTable table = ((DataTab)DataPanel.this.tabbedPane.getSelectedComponent()).getTable();
                if (table == null) {
                    return;
                }
                table.setRowSelectionAllowed(DataPanel.this.btntoggle.isSelected());
            }
        });
        return p;
    }

    private void bootDataSetManipulator() {
        DataSet[] dsets = this.createDataSet();
        DataSetManipulator manip = new DataSetManipulator(dsets);
    }

    private DataSet[] createDataSet() {
        DataSet[] ret = null;
        ret = this.mode == 0 ? new DataSet[this.tabbedPane.getTabCount()] : new DataSet[1];
        JTable[] tables = this.getTables();
        String[] names = this.getNames();
        if (tables == null || names == null) {
            return null;
        }
        for (int i = 0; i < tables.length; ++i) {
            int j;
            ret[i] = new DataSet(names[i]);
            int nrow = tables[i].getRowCount();
            int ncol = tables[i].getColumnCount();
            String[] idents = new String[ncol];
            for (j = 0; j < ncol; ++j) {
                idents[j] = tables[i].getColumnName(j);
            }
            for (j = 0; j < ncol; ++j) {
                String[] data = new String[nrow];
                for (int k = 0; k < nrow; ++k) {
                    data[k] = (String)tables[i].getValueAt(k, j);
                }
                ret[i].addData(data, idents[j]);
            }
        }
        return ret;
    }

    private JTable[] getTables() {
        if (this.mode == 0) {
            JTable[] tables = new JTable[this.tabbedPane.getTabCount()];
            for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                tables[i] = ((DataTab)this.tabbedPane.getComponentAt(i)).getTable();
            }
            return tables;
        }
        if (this.mode == 1) {
            JTable[] tables = new JTable[1];
            for (int ii = 0; ii < this.panel.getComponentCount(); ++ii) {
                Component component = this.panel.getComponent(ii);
                if (!(component instanceof DataTab)) continue;
                tables[0] = ((DataTab)component).getTable();
                return tables;
            }
        }
        return null;
    }

    private String[] getNames() {
        String[] names = null;
        if (this.mode == 0) {
            names = new String[this.tabbedPane.getTabCount()];
            for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                names[i] = ((DataTab)this.tabbedPane.getComponentAt(i)).getDataName();
            }
            return names;
        }
        if (this.mode == 1) {
            names = new String[1];
            for (int ii = 0; ii < this.panel.getComponentCount(); ++ii) {
                Component component = this.panel.getComponent(ii);
                if (!(component instanceof DataTab)) continue;
                names[0] = ((DataTab)component).getDataName();
                return names;
            }
        }
        return names;
    }

    private boolean plotData() {
        int i;
        int numSelected_rows;
        int[] index_selected_rows;
        JTable table = null;
        int tabnum = 0;
        int type = this.comboplottypes.getSelectedIndex();
        if (this.mode == 0) {
            tabnum = this.tabbedPane.getSelectedIndex();
            if (tabnum < 0) {
                return false;
            }
            table = ((DataTab)this.tabbedPane.getComponentAt(tabnum)).getTable();
        } else if (this.mode == 1) {
            for (int ii = 0; ii < this.panel.getComponentCount(); ++ii) {
                Component component = this.panel.getComponent(ii);
                if (!(component instanceof DataTab)) continue;
                table = ((DataTab)component).getTable();
                break;
            }
        }
        int numCols = table.getColumnCount();
        int numRows = table.getRowCount();
        int numIdent = numCols;
        int[] index_selected = table.getSelectedColumns();
        int numSelected = index_selected.length;
        if (table.getRowSelectionAllowed()) {
            index_selected_rows = table.getSelectedRows();
            numSelected_rows = index_selected_rows.length;
        } else {
            index_selected_rows = new int[numRows];
            for (i = 0; i < numRows; ++i) {
                index_selected_rows[i] = i;
            }
            numSelected_rows = numRows;
        }
        if (numSelected <= 1) {
            logger.error("select at least two columns!");
            return false;
        }
        if (numSelected_rows <= 0) {
            logger.error("select at least one row!");
            return false;
        }
        String[][] data_out = new String[numSelected][numSelected_rows];
        for (i = 0; i < numSelected; ++i) {
            for (int j = 0; j < numSelected_rows; ++j) {
                data_out[i][j] = (String)table.getModel().getValueAt(index_selected_rows[j], index_selected[i]);
            }
        }
        String xlabel = new String();
        String ylabel = new String();
        String[] idents = this.outputData[tabnum].getIdentifier();
        String[] selected_idents = new String[numSelected];
        if (idents == null || idents.length != numCols) {
            logger.warn("invalid identifiers. defaults are used.");
        }
        String[] legendtext = new String[1];
        if (type == 0) {
            legendtext = new String[numSelected];
            for (i = 0; i < numSelected; ++i) {
                try {
                    legendtext[i] = idents[index_selected[i]];
                    continue;
                }
                catch (Exception e) {
                    legendtext[i] = i == 0 ? "x" : "y" + Integer.toString(i);
                }
            }
            for (i = 0; i < numSelected; ++i) {
                try {
                    if (i == 0) {
                        xlabel = idents[index_selected[i]];
                        continue;
                    }
                    ylabel = ylabel + " " + idents[index_selected[i]];
                    continue;
                }
                catch (Exception e) {
                    xlabel = "x";
                    ylabel = "y";
                }
            }
        } else if (type == 1) {
            legendtext = new String[numSelected_rows];
            for (i = 0; i < numSelected_rows; ++i) {
                legendtext[i] = data_out[0][i];
            }
        }
        GraphPanel graphpanel = new GraphPanel(this.outputData[tabnum].getName());
        graphpanel.setType(type);
        graphpanel.setLegendText(legendtext);
        graphpanel.setData(data_out);
        graphpanel.setPlotTitle(this.outputData[tabnum].getName());
        graphpanel.setXlabel(xlabel);
        graphpanel.setYlabel(ylabel);
        graphpanel.createGraphPanel();
        graphpanel.display();
        return true;
    }
}

