/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import java.util.List;
import org.freehep.math.minuit.FCNBase;
import org.freehep.math.minuit.FunctionMinimum;
import org.freehep.math.minuit.MinuitParameter;
import org.freehep.math.minuit.MnMachinePrecision;
import org.freehep.math.minuit.MnStrategy;
import org.freehep.math.minuit.MnUserCovariance;
import org.freehep.math.minuit.MnUserParameterState;
import org.freehep.math.minuit.MnUserParameters;
import org.freehep.math.minuit.ModularFunctionMinimizer;

public abstract class MnApplication {
    static int DEFAULT_STRATEGY = 1;
    static int DEFAULT_MAXFCN = 0;
    static double DEFAULT_TOLER = 0.1;
    boolean useAnalyticalDerivatives;
    boolean checkAnalyticalDerivatives;
    FCNBase theFCN;
    MnUserParameterState theState;
    MnStrategy theStrategy;
    int theNumCall;
    double theErrorDef = 1.0;

    MnApplication(FCNBase fcn, MnUserParameterState state, MnStrategy stra) {
        this.theFCN = fcn;
        this.theState = state;
        this.theStrategy = stra;
        this.checkAnalyticalDerivatives = true;
        this.useAnalyticalDerivatives = true;
    }

    MnApplication(FCNBase fcn, MnUserParameterState state, MnStrategy stra, int nfcn) {
        this.theFCN = fcn;
        this.theState = state;
        this.theStrategy = stra;
        this.theNumCall = nfcn;
        this.checkAnalyticalDerivatives = true;
        this.useAnalyticalDerivatives = true;
    }

    public FunctionMinimum minimize() {
        return this.minimize(DEFAULT_MAXFCN);
    }

    public FunctionMinimum minimize(int maxfcn) {
        return this.minimize(maxfcn, DEFAULT_TOLER);
    }

    public FunctionMinimum minimize(int maxfcn, double toler) {
        if (!this.theState.isValid()) {
            throw new RuntimeException("Invalid state");
        }
        int npar = this.variableParameters();
        if (maxfcn == 0) {
            maxfcn = 200 + 100 * npar + 5 * npar * npar;
        }
        FunctionMinimum min = this.minimizer().minimize(this.theFCN, this.theState, this.theStrategy, maxfcn, toler, this.theErrorDef, this.useAnalyticalDerivatives, this.checkAnalyticalDerivatives);
        this.theNumCall += min.nfcn();
        this.theState = min.userState();
        return min;
    }

    abstract ModularFunctionMinimizer minimizer();

    public MnMachinePrecision precision() {
        return this.theState.precision();
    }

    public MnUserParameterState state() {
        return this.theState;
    }

    public MnUserParameters parameters() {
        return this.theState.parameters();
    }

    public MnUserCovariance covariance() {
        return this.theState.covariance();
    }

    public FCNBase fcnbase() {
        return this.theFCN;
    }

    public MnStrategy strategy() {
        return this.theStrategy;
    }

    public int numOfCalls() {
        return this.theNumCall;
    }

    List minuitParameters() {
        return this.theState.minuitParameters();
    }

    public double[] params() {
        return this.theState.params();
    }

    public double[] errors() {
        return this.theState.errors();
    }

    MinuitParameter parameter(int i) {
        return this.theState.parameter(i);
    }

    public void add(String name, double val, double err) {
        this.theState.add(name, val, err);
    }

    public void add(String name, double val, double err, double low, double up) {
        this.theState.add(name, val, err, low, up);
    }

    public void add(String name, double val) {
        this.theState.add(name, val);
    }

    public void fix(int index) {
        this.theState.fix(index);
    }

    public void release(int index) {
        this.theState.release(index);
    }

    public void setValue(int index, double val) {
        this.theState.setValue(index, val);
    }

    public void setError(int index, double err) {
        this.theState.setError(index, err);
    }

    public void setLimits(int index, double low, double up) {
        this.theState.setLimits(index, low, up);
    }

    public void removeLimits(int index) {
        this.theState.removeLimits(index);
    }

    public double value(int index) {
        return this.theState.value(index);
    }

    public double error(int index) {
        return this.theState.error(index);
    }

    public void fix(String name) {
        this.theState.fix(name);
    }

    public void release(String name) {
        this.theState.release(name);
    }

    public void setValue(String name, double val) {
        this.theState.setValue(name, val);
    }

    public void setError(String name, double err) {
        this.theState.setError(name, err);
    }

    public void setLimits(String name, double low, double up) {
        this.theState.setLimits(name, low, up);
    }

    public void removeLimits(String name) {
        this.theState.removeLimits(name);
    }

    public void setPrecision(double prec) {
        this.theState.setPrecision(prec);
    }

    public double value(String name) {
        return this.theState.value(name);
    }

    public double error(String name) {
        return this.theState.error(name);
    }

    public int index(String name) {
        return this.theState.index(name);
    }

    public String name(int index) {
        return this.theState.name(index);
    }

    double int2ext(int i, double value) {
        return this.theState.int2ext(i, value);
    }

    double ext2int(int i, double value) {
        return this.theState.ext2int(i, value);
    }

    int intOfExt(int i) {
        return this.theState.intOfExt(i);
    }

    int extOfInt(int i) {
        return this.theState.extOfInt(i);
    }

    public int variableParameters() {
        return this.theState.variableParameters();
    }

    public void setUseAnalyticalDerivatives(boolean use) {
        this.useAnalyticalDerivatives = use;
    }

    public boolean useAnalyticalDerivaties() {
        return this.useAnalyticalDerivatives;
    }

    public void setCheckAnalyticalDerivatives(boolean check) {
        this.checkAnalyticalDerivatives = check;
    }

    public boolean checkAnalyticalDerivatives() {
        return this.checkAnalyticalDerivatives;
    }

    public void setErrorDef(double errorDef) {
        this.theErrorDef = errorDef;
    }

    public double errorDef() {
        return this.theErrorDef;
    }
}

