/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.Handle;
import jas.hist.SliceData;
import jas.hist.SliceParameters;
import jas.plot.DoubleCoordinateTransformation;
import jas.plot.PlotGraphics;
import java.awt.Color;

class ProjectionData
extends SliceData {
    ProjectionData(SliceParameters sliceParameters) {
        super(sliceParameters);
    }

    void paint(PlotGraphics plotGraphics, DoubleCoordinateTransformation doubleCoordinateTransformation, DoubleCoordinateTransformation doubleCoordinateTransformation2) {
        double d;
        double d2;
        double d3 = 1.5707963267948966 + this.parm.getPhi() + Math.PI * 2;
        double d4 = Math.atan2(doubleCoordinateTransformation.getPlotMax() - doubleCoordinateTransformation.getPlotMin(), doubleCoordinateTransformation2.getPlotMax() - doubleCoordinateTransformation2.getPlotMin()) + Math.PI * 2;
        double d5 = (doubleCoordinateTransformation2.getPlotMin() + doubleCoordinateTransformation2.getPlotMax()) / 2.0;
        double d6 = (doubleCoordinateTransformation.getPlotMin() + doubleCoordinateTransformation.getPlotMax()) / 2.0;
        if ((d3 %= Math.PI) < (d4 %= Math.PI) || d3 > Math.PI - d4) {
            d2 = d5 - doubleCoordinateTransformation2.getPlotMin();
            d = -d2 * Math.tan(d3);
        } else {
            d = d6 - doubleCoordinateTransformation.getPlotMin();
            d2 = d * Math.tan(d3 - 1.5707963267948966);
        }
        plotGraphics.setColor(Color.black);
        plotGraphics.drawLine(d6 - d, d5 - d2, d6 + d, d5 + d2);
    }

    public Handle[] getHandles(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7 = (d + d2) / 2.0;
        double d8 = (d3 + d4) / 2.0;
        double d9 = (d2 - d) / 4.0;
        double d10 = (d4 - d3) / 4.0;
        double d11 = Math.atan2(d9, d10) + Math.PI * 2;
        double d12 = 1.5707963267948966 + this.parm.getPhi() + Math.PI * 2;
        if ((d12 %= Math.PI) < (d11 %= Math.PI) || d12 > Math.PI - d11) {
            d6 = d8 + d10;
            d5 = d7 - d10 * Math.tan(d12);
        } else {
            d5 = d7 + d9;
            d6 = d8 + d9 * Math.tan(d12 - 1.5707963267948966);
        }
        Handle[] handleArray = new Handle[]{new ProjectionHandle(d5, d6, d7, d8)};
        return handleArray;
    }

    private class ProjectionHandle
    extends Handle {
        private double x;
        private double y;
        private double xc;
        private double yc;

        ProjectionHandle(double d, double d2, double d3, double d4) {
            this.x = d;
            this.y = d2;
            this.xc = d3;
            this.yc = d4;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void moveTo(double d, double d2) {
            this.x = d;
            this.y = d2;
            double d3 = Math.atan2(d2 - this.yc, d - this.xc);
            ProjectionData.this.parm.setPhi(d3);
        }
    }
}

