/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.FontNodeTraverser;
import jas.hist.JASHistAxis;
import jas.hist.LabelNodeTraverser;
import jas.hist.XMLPrintWriter;
import jas.plot.Axis;
import jas.plot.EditableLabel;
import jas.util.xml.XMLNodeTraverser;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class AxisNodeTraverser
extends XMLNodeTraverser {
    private static LabelNodeTraverser lt = new LabelNodeTraverser();
    private static FontNodeTraverser ft = new FontNodeTraverser();
    private JASHistAxis axis;

    AxisNodeTraverser() {
    }

    void traverse(Node node, JASHistAxis jASHistAxis) throws XMLNodeTraverser.BadXMLException {
        this.axis = jASHistAxis;
        super.traverse(node);
    }

    protected void handleElement(Element element, String string) throws XMLNodeTraverser.BadXMLException {
        if (string.equals("label")) {
            EditableLabel editableLabel = this.axis.getLabelObject();
            if (editableLabel == null) {
                editableLabel = new EditableLabel("", "Axis Label");
                this.axis.setLabelObject(editableLabel);
            }
            lt.traverse((Node)element, editableLabel);
        } else if (string.equals("font")) {
            ft.traverse(element, (Axis)((Object)this.axis));
        } else {
            super.handleElement(element, string);
        }
    }

    protected void handleAttributeNode(Attr attr, String string, String string2) throws XMLNodeTraverser.BadXMLException {
        if (string.equals("logarithmic")) {
            this.axis.setLogarithmic(this.toBoolean(string2));
        } else if (string.equals("allowSuppressedZero")) {
            this.axis.setAllowSuppressedZero(this.toBoolean(string2));
        } else if (string.equals("numberOfBins")) {
            this.axis.setBins(this.toInt(string2));
        } else if (string.equals("type")) {
            this.axis.setAxisType(XMLPrintWriter.convertStringToAxisType(string2));
        } else if (string.equals("min")) {
            this.axis.setMin(this.toDouble(string2));
        } else if (string.equals("max")) {
            this.axis.setMax(this.toDouble(string2));
        } else if (string.equals("showOverflows")) {
            this.axis.setShowOverflows(this.toBoolean(string2));
        } else if (!string.equals("location")) {
            super.handleAttributeNode(attr, string, string2);
        }
    }
}

