/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataManager;
import jas.hist.DefaultDataManager;
import jas.hist.JASHistAxis;
import jas.plot.Axis;
import jas.plot.AxisType;
import jas.plot.DateAxis;
import jas.plot.DoubleAxis;
import jas.plot.EditableLabel;
import jas.plot.StringAxis;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public final class ManagedAxis
extends Axis
implements JASHistAxis,
Externalizable {
    private int bins;
    private boolean rangeAutomatic = true;
    private boolean allowSuppressedZero = true;
    private boolean showOverflows = false;
    private boolean needsAttention = true;
    private boolean fixed = false;
    private boolean binned;
    private int position;
    private DataManager dataManager;

    ManagedAxis(int n) {
        super(n);
        this.dataManager = null;
        this.binned = false;
    }

    ManagedAxis(DataManager dataManager, int n, boolean bl) {
        super(n);
        this.dataManager = dataManager;
        this.binned = bl;
    }

    public ManagedAxis() {
    }

    void setDataManager(DataManager dataManager, boolean bl) {
        this.dataManager = dataManager;
        this.binned = bl;
    }

    void setDataManager(DataManager dataManager, boolean bl, AxisType axisType) {
        this.dataManager = dataManager;
        this.binned = bl;
        this.setType(axisType);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.bins);
        objectOutput.writeBoolean(this.rangeAutomatic);
        if (!this.rangeAutomatic) {
            objectOutput.writeDouble(this.getMin());
            objectOutput.writeDouble(this.getMax());
        }
        objectOutput.writeBoolean(this.allowSuppressedZero);
        objectOutput.writeBoolean(this.fixed);
        objectOutput.writeBoolean(this.binned);
        objectOutput.writeInt(this.position);
        AxisType axisType = this.getType();
        objectOutput.writeInt(this.getAxisOrientation());
        objectOutput.writeBoolean(this.getOnLeftSide());
        objectOutput.writeObject(axisType);
        objectOutput.writeObject(this.dataManager);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.bins = objectInput.readInt();
        this.rangeAutomatic = objectInput.readBoolean();
        if (!this.rangeAutomatic) {
            this.setMin(objectInput.readDouble());
            this.setMax(objectInput.readDouble());
        } else {
            this.attentionNeeded();
        }
        this.allowSuppressedZero = objectInput.readBoolean();
        this.fixed = objectInput.readBoolean();
        this.binned = objectInput.readBoolean();
        this.position = objectInput.readInt();
        this.setAxisOrientation(objectInput.readInt());
        this.setOnLeftSide(objectInput.readBoolean());
        this.setType((AxisType)objectInput.readObject());
        this.dataManager = (DataManager)objectInput.readObject();
    }

    public boolean isVertical() {
        return this.getAxisOrientation() == 1;
    }

    public boolean isLogarithmic() {
        AxisType axisType = this.getType();
        if (axisType instanceof DoubleAxis) {
            return ((DoubleAxis)axisType).isLogarithmic();
        }
        return false;
    }

    public void setLogarithmic(boolean bl) {
        AxisType axisType = this.getType();
        if (axisType instanceof DoubleAxis) {
            ((DoubleAxis)axisType).setLogarithmic(bl);
            this.attentionNeeded();
        }
    }

    public boolean isShowing() {
        return true;
    }

    public void setShowing(boolean bl) {
    }

    public EditableLabel getLabelObject() {
        if (this.dataManager == null) {
            return null;
        }
        EditableLabel editableLabel = this.dataManager.getLabel(this);
        if (editableLabel == null) {
            return null;
        }
        return editableLabel;
    }

    public String getLabel() {
        EditableLabel editableLabel = this.dataManager.getLabel(this);
        return editableLabel == null ? "" : editableLabel.getText();
    }

    public void setLabelObject(EditableLabel editableLabel) {
        this.dataManager.setLabel(this, editableLabel);
    }

    public void setLabel(String string) {
        EditableLabel editableLabel = this.dataManager.getLabel(this);
        if (editableLabel == null) {
            editableLabel = new EditableLabel(string, "Axis Label");
            this.dataManager.setLabel(this, editableLabel);
        } else {
            editableLabel.setText(string);
        }
        this.revalidate();
    }

    public double getMin() {
        AxisType axisType = this.getType();
        if (axisType instanceof DoubleAxis) {
            return ((DoubleAxis)axisType).getPlotMin();
        }
        if (axisType instanceof DateAxis) {
            return (double)((DateAxis)axisType).getAxisMin() / 1000.0;
        }
        throw new RuntimeException("getMin undefined for this axis type");
    }

    public void setMin(double d) {
        AxisType axisType = this.getType();
        if (axisType instanceof DoubleAxis) {
            this.rangeAutomatic = false;
            ((DoubleAxis)axisType).setMin(d);
            this.attentionNeeded();
        } else if (axisType instanceof DateAxis) {
            this.rangeAutomatic = false;
            ((DateAxis)axisType).setMin((long)(d * 1000.0));
            this.attentionNeeded();
        } else {
            throw new RuntimeException("setMin undefined for this axis type");
        }
    }

    public double getMax() {
        AxisType axisType = this.getType();
        if (axisType instanceof DoubleAxis) {
            return ((DoubleAxis)axisType).getPlotMax();
        }
        if (axisType instanceof DateAxis) {
            return (double)((DateAxis)axisType).getAxisMax() / 1000.0;
        }
        throw new RuntimeException("getMax undefined for this axis type");
    }

    public void setMax(double d) {
        AxisType axisType = this.getType();
        if (axisType instanceof DoubleAxis) {
            this.rangeAutomatic = false;
            ((DoubleAxis)axisType).setMax(d);
            this.attentionNeeded();
        } else if (axisType instanceof DateAxis) {
            this.rangeAutomatic = false;
            ((DateAxis)axisType).setMax((long)(d * 1000.0));
            this.invalidate();
            this.attentionNeeded();
        } else {
            throw new RuntimeException("setMax undefined for this axis type");
        }
    }

    public void setRange(double d, double d2) {
        this.setMin(d);
        this.setMax(d2);
    }

    public Object getMinObject() {
        if (this.getAxisType() == 3) {
            return new Date((long)(this.getMin() * 1000.0));
        }
        return new Double(this.getMin());
    }

    public Object getMaxObject() {
        if (this.getAxisType() == 3) {
            return new Date((long)(this.getMax() * 1000.0));
        }
        return new Double(this.getMax());
    }

    public void setMinObject(Object object) {
        try {
            double d = this.getAxisType() == 3 ? (double)(((Date)object).getTime() / 1000L) : (Double)object;
            this.setMin(d);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Argument to setMinObject is of wrong type");
        }
    }

    public void setMaxObject(Object object) {
        try {
            double d = this.getAxisType() == 3 ? (double)(((Date)object).getTime() / 1000L) : (Double)object;
            this.setMax(d);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Argument to setMaxObject is of wrong type");
        }
    }

    public boolean getRangeAutomatic() {
        return this.rangeAutomatic;
    }

    public void setRangeAutomatic(boolean bl) {
        this.rangeAutomatic = bl;
        this.attentionNeeded();
    }

    public boolean getAllowSuppressedZero() {
        return this.allowSuppressedZero;
    }

    public void setAllowSuppressedZero(boolean bl) {
        this.allowSuppressedZero = bl;
        this.attentionNeeded();
    }

    public boolean isBinned() {
        return this.binned;
    }

    public void setBinned(boolean bl) {
        this.binned = bl;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean bl) {
        this.fixed = bl;
    }

    public int getBins() {
        return this.bins;
    }

    public void setBins(int n) {
        this.bins = n;
        this.attentionNeeded();
    }

    public double getBinWidth() {
        if (!this.binned) {
            return 0.0;
        }
        double d = this.getMax() - this.getMin();
        return d / (double)this.bins;
    }

    public void setBinWidth(double d) {
        double d2 = this.getMax() - this.getMin();
        this.bins = (int)Math.max(1.0, d2 / d);
        this.attentionNeeded();
    }

    public boolean getShowOverflows() {
        return this.showOverflows;
    }

    public void setShowOverflows(boolean bl) {
        this.showOverflows = bl;
        this.attentionNeeded();
    }

    public int getLabelPosition() {
        return 0;
    }

    public void setLabelPosition(int n) {
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public int getAxisType() {
        AxisType axisType = this.getType();
        if (axisType instanceof DateAxis) {
            return 3;
        }
        if (axisType instanceof StringAxis) {
            return 2;
        }
        return 1;
    }

    public void setAxisType(int n) {
        if (n != this.getAxisType()) {
            if (n == 3) {
                this.setType(new DateAxis());
            } else if (n == 2) {
                this.setType(new StringAxis());
            } else {
                this.setType(new DoubleAxis());
            }
        }
    }

    private void attentionNeeded() {
        boolean bl = this.needsAttention;
        this.needsAttention = true;
        if (!bl && this.dataManager != null) {
            this.dataManager.invalidate();
        }
    }

    void setAttentionNeeded() {
        this.needsAttention = true;
    }

    void payingAttention() {
        this.needsAttention = false;
    }

    boolean needsAttention() {
        return this.needsAttention;
    }

    public void modifyPopupMenu(JPopupMenu jPopupMenu, Component component) {
        if (this.dataManager != null && !(this.dataManager instanceof DefaultDataManager)) {
            super.modifyPopupMenu(jPopupMenu, component);
            if (this.getAxisType() != 2) {
                if (this.getAxisType() != 3) {
                    jPopupMenu.add(new JCheckBoxMenuItem("Logarithmic", this.isLogarithmic()){

                        protected final void fireActionPerformed(ActionEvent actionEvent) {
                            ManagedAxis.this.setLogarithmic(this.isSelected());
                        }
                    });
                }
                jPopupMenu.add(new JCheckBoxMenuItem("Range Automatic", this.getRangeAutomatic()){

                    protected final void fireActionPerformed(ActionEvent actionEvent) {
                        ManagedAxis.this.setRangeAutomatic(this.isSelected());
                    }
                });
                if (this.getAxisType() != 3) {
                    JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Suppressed Zeros", this.getAllowSuppressedZero()){

                        protected final void fireActionPerformed(ActionEvent actionEvent) {
                            ManagedAxis.this.setAllowSuppressedZero(this.isSelected());
                        }
                    };
                    jPopupMenu.add(jCheckBoxMenuItem);
                    jCheckBoxMenuItem.setEnabled(this.getRangeAutomatic());
                }
            }
            jPopupMenu.add(new JMenuItem("Axis Properties..."){

                protected final void fireActionPerformed(ActionEvent actionEvent) {
                    ManagedAxis.this.dataManager.getPlot().showProperties((byte)(ManagedAxis.this.getAxisOrientation() == 1 ? (ManagedAxis.this.getOnLeftSide() ? 1 : 2) : 3));
                }
            });
        }
    }
}

