/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.projectbrowser.projectcreator;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jp.advancesoft.chase.common.Utils;
import jp.advancesoft.chase.mainpanel.InternalFrameChase;
import jp.advancesoft.chase.projectbrowser.ProjectInfo;
import jp.advancesoft.chase.projectbrowser.projectcreator.ProjectStateChangeEvent;
import jp.advancesoft.chase.projectbrowser.projectcreator.ProjectStateChangeListener;
import jp.advancesoft.chase.projectbrowser.projectcreator.ProjectStateChanger;
import jp.advancesoft.chase.projectbrowser.projectdirbrowser.ProjectDirBrowser;
import jp.advancesoft.chase.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;
import org.apache.log4j.Logger;

public class ProjectRemover
extends InternalFrameChase
implements ProjectStateChanger {
    private Logger logger = Logger.getLogger(ProjectRemover.class.getName());
    private JCheckBox removeFiles;
    private ProjectDirBrowserNode node;
    private Vector listeners = new Vector();
    private ProjectDirBrowser dirBrowser;

    public ProjectRemover(String title, ProjectDirBrowserNode node, ProjectDirBrowser dirBrowser) {
        super(title, false, false, false, false, new Dimension(300, 120));
        this.node = node;
        this.dirBrowser = dirBrowser;
        this.init();
    }

    public void addProjectStateChangeListener(ProjectStateChangeListener listener) {
        this.listeners.addElement(listener);
    }

    private void init() {
        Container cont = this.getContentPane();
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(2, 1));
        p.add(this.removeFilesTooPanel());
        p.add(this.buttonPanel());
        cont.add(p);
    }

    private JPanel removeFilesTooPanel() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        this.removeFiles = new JCheckBox("remove files and directories too");
        p.add(this.removeFiles);
        return p;
    }

    private JPanel buttonPanel() {
        JPanel p = new JPanel();
        JButton ok = new JButton("ok");
        JButton can = new JButton("cancel");
        can.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectRemover.this.dispose();
            }
        });
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectRemover.this.manipulateProjectState();
                ProjectRemover.this.logger.info("removed project.");
                ProjectRemover.this.dispose();
            }
        });
        p.add(ok);
        p.add(can);
        return p;
    }

    public void manipulateProjectState() {
        if (this.removeFiles.isSelected()) {
            ProjectInfo info = this.node.getProjectInfo();
            String dir = info.getProjectDirectory();
            Utils.deleteDir(new File(dir));
        }
        this.dirBrowser.removeCurrentNode();
        if (this.node.getProjectBrowser() != null && this.node.getProjectBrowser().isVisible()) {
            this.node.getProjectBrowser().dispose();
        }
        this.notifyListeners();
    }

    private void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ProjectStateChangeListener listener = (ProjectStateChangeListener)this.listeners.elementAt(i);
            listener.projectStateChanged(new ProjectStateChangeEvent(this));
        }
    }
}

