/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.projectbrowser;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import jp.advancesoft.chase.common.ConstParameters;
import jp.advancesoft.chase.common.MyThread;
import jp.advancesoft.chase.common.Utils;
import jp.advancesoft.chase.settings.PropertiesManager;
import jp.advancesoft.chase.textviewer.HyperLink;
import org.apache.log4j.Logger;

public class ProjectBrowserUtils {
    private static final Logger logger = Logger.getLogger(ProjectBrowserUtils.class.getName());

    public static void setHtmlToEditorPane(JEditorPane pane, URL url) {
        pane.setContentType("text/html; charset=Shift_JIS");
        pane.setEditable(false);
        pane.addHyperlinkListener(new HyperLink(pane, url));
        try {
            pane.setPage(url);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void bootTextViewer(String textfile) {
        File file = new File(textfile);
        if (file.exists()) {
            String editor = PropertiesManager.getGlobalProperties(0).getProperty("editor");
            if (editor == null) {
                logger.error("specify editor");
                return;
            }
            MyThread myThread = new MyThread(Utils.getPathDQ(editor) + " " + Utils.getPathDQ(textfile));
        } else {
            logger.error("file non-existent");
        }
    }

    public static void bootTextViewer(String textfile, String filter, boolean ignoreCase) {
        if (ignoreCase) {
            filter = filter.toLowerCase();
        }
        String compString = "";
        String readString = "";
        String writeString = "";
        try {
            BufferedReader br = new BufferedReader(new FileReader(textfile));
            while ((readString = br.readLine()) != null) {
                compString = ignoreCase ? readString.toLowerCase() : readString;
                if (compString.indexOf(filter) == -1) continue;
                writeString = writeString + readString + System.getProperty("line.separator");
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            System.out.println("failed to read " + textfile);
        }
        File file = new File(textfile + "_" + filter);
        file.deleteOnExit();
        try {
            FileWriter fwriter = new FileWriter(file);
            BufferedWriter bwriter = new BufferedWriter(fwriter);
            bwriter.write(writeString, 0, writeString.length());
            bwriter.flush();
            fwriter.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            System.out.println("failed to write " + file);
        }
        ProjectBrowserUtils.bootTextViewer(file.getAbsolutePath());
    }

    public static void bootBioStationViewer(String input) {
        String bsviewer = System.getProperty("chase.home") + System.getProperty("file.separator") + PropertiesManager.getGlobalProperties(0).getProperty("BioStationViewer");
        if (bsviewer == null) {
            logger.error("could not find BioStationViewer");
            return;
        }
        if (!new File(bsviewer).exists()) {
            logger.error("could not find BioStationViewer");
            return;
        }
        String fileOption = "";
        if (input != null && input.length() != 0) {
            fileOption = " -f " + Utils.getPathDQ(input);
        }
        String bsvexe = Utils.getPathDQ(ConstParameters.getJavaPath()) + " -jar " + Utils.getPathDQ(bsviewer) + fileOption;
        MyThread mt = new MyThread(bsvexe);
    }
}

