/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.atomcoord;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import jp.advancesoft.chase.atomcoord.Atom;
import jp.advancesoft.chase.atomcoord.AtomCoords;
import jp.advancesoft.chase.atomcoord.ExporterBase;
import jp.advancesoft.chase.common.ConstParameters;
import org.apache.log4j.Logger;

class XYZExporter
extends ExporterBase {
    private static Logger logger = Logger.getLogger(XYZExporter.class.getName());
    private DecimalFormat formater = ConstParameters.formater;

    protected XYZExporter(File file, AtomCoords coords) {
        super(file, coords);
    }

    public boolean exportAtomCoords() {
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(this.file)));
            String str = new String();
            logger.info("exporting xyz file... " + this.file.getAbsolutePath());
            int NumAt = this.coords.getNumAt();
            writer.println(NumAt);
            writer.println("XYZ created by CHASE-3PT");
            for (int i = 0; i < NumAt; ++i) {
                Atom atom = this.list.getAtomAt(i);
                String element = atom.getElementName();
                String[] xyz = atom.getPos();
                writer.println(element + " " + xyz[0] + " " + xyz[1] + " " + xyz[2]);
            }
            writer.close();
        }
        catch (Exception exc) {
            logger.warn("failed write to file: " + this.file);
            return false;
        }
        return true;
    }
}

