/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.acviewer.scenegraphelements;

import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import jp.advancesoft.chase.acviewer.CylinderCreator;
import jp.advancesoft.chase.acviewer.scenegraphelements.SceneGraphElement;

class CellObject
extends SceneGraphElement {
    private double[] cellOrigin;
    private double[][] cellVec;
    private double[][] CellTyo;
    private double[] CellHen;
    private float[] cellColor;
    private int numNodes = 30;
    private float cellWidth = 0.005f;

    public CellObject(double[] cellOrigin, double[][] cellVec) {
        this.cellOrigin = cellOrigin;
        this.cellVec = cellVec;
    }

    public int getType() {
        return 2;
    }

    protected void create() {
        int i;
        this.CellTyo = new double[8][3];
        for (i = 0; i < 3; ++i) {
            this.CellTyo[0][i] = this.cellOrigin[i];
        }
        for (i = 0; i < 3; ++i) {
            this.CellTyo[1][i] = this.cellVec[0][i] + this.CellTyo[0][i];
        }
        for (i = 0; i < 3; ++i) {
            this.CellTyo[2][i] = this.cellVec[1][i] + this.CellTyo[0][i];
        }
        for (i = 0; i < 3; ++i) {
            this.CellTyo[3][i] = this.cellVec[0][i] + this.cellVec[1][i] + this.CellTyo[0][i];
        }
        for (i = 0; i < 3; ++i) {
            this.CellTyo[4][i] = this.cellVec[2][i] + this.CellTyo[0][i];
        }
        for (i = 0; i < 3; ++i) {
            this.CellTyo[5][i] = this.cellVec[0][i] + this.cellVec[2][i] + this.CellTyo[0][i];
        }
        for (i = 0; i < 3; ++i) {
            this.CellTyo[6][i] = this.cellVec[1][i] + this.cellVec[2][i] + this.CellTyo[0][i];
        }
        for (i = 0; i < 3; ++i) {
            this.CellTyo[7][i] = this.cellVec[1][i] + this.cellVec[2][i] + this.cellVec[0][i] + this.CellTyo[0][i];
        }
        this.createCell(0, 1);
        this.createCell(0, 2);
        this.createCell(1, 3);
        this.createCell(2, 3);
        this.createCell(4, 6);
        this.createCell(4, 5);
        this.createCell(6, 7);
        this.createCell(5, 7);
        this.createCell(0, 4);
        this.createCell(2, 6);
        this.createCell(1, 5);
        this.createCell(3, 7);
    }

    public void configDataUpdate() {
    }

    public void configDataUpdate(boolean foo) {
    }

    protected void setCellColor(float[] cellColor) {
        this.cellColor = cellColor;
    }

    protected void setNumNodes(int numNodes) {
        this.numNodes = numNodes;
    }

    protected void setCellWidth(float cellWidth) {
        this.cellWidth = cellWidth;
    }

    private void createCell(int i1, int i2) {
        this.CellHen = new double[6];
        for (int i = 0; i < 3; ++i) {
            this.CellHen[i] = this.CellTyo[i1][i];
            this.CellHen[i + 3] = this.CellTyo[i2][i];
        }
        Appearance app = new Appearance();
        Material material = new Material();
        material.setDiffuseColor(new Color3f(this.cellColor));
        material.setShininess(120.0f);
        app.setMaterial(material);
        Point3d Cyl1 = new Point3d(this.CellHen[0], this.CellHen[1], this.CellHen[2]);
        Point3d Cyl2 = new Point3d(this.CellHen[3], this.CellHen[4], this.CellHen[5]);
        CylinderCreator cylindercreate = new CylinderCreator();
        BranchGroup cylinder = new BranchGroup();
        cylindercreate.setResolution(this.numNodes);
        cylinder = cylindercreate.create(Cyl1, Cyl2, this.cellWidth, app);
        this.addChild((Node)cylinder);
    }
}

