/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.Tool.ExampleFileFilter;
import AbinitMp.Tool.ExecCommand;
import AbinitMp.Tool.GridBagLayoutPanel;
import AbinitMp.Tool.MyButton;
import AbinitMp.Tool.MyLabel;
import AbinitMp.Tool.MyResourceBundle;
import AbinitMp.Viewer.AbinitMpViewer;
import AbinitMp.Viewer.ExecAddHydrogen;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.PrintStream;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class AddHydrogenPanel
extends GridBagLayoutPanel {
    private JTextField optionsText;
    private JTextField inputFileText;
    private JTextField outputFileText;
    private AbinitMpViewer viewer;

    public AddHydrogenPanel(AbinitMpViewer abinitMpViewer) {
        this.viewer = abinitMpViewer;
        this.setBorder(new TitledBorder(MyResourceBundle.getResourceString("AddHydrogenPanel.title")));
        this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("AddHydrogenPanel.options")), 0, 0, 5, 1, 1.0, 0.0);
        this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("AddHydrogenPanel.inputFile")), 0, 1, 5, 1, 1.0, 0.0);
        this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("AddHydrogenPanel.outputFile")), 0, 2, 5, 1, 1.0, 0.0);
        this.optionsText = new JTextField();
        this.optionsText.setPreferredSize(new Dimension(300, 28));
        this.layoutObject(this.optionsText, 5, 0, 10, 1, 1.0, 0.0);
        this.inputFileText = new JTextField();
        this.inputFileText.setPreferredSize(new Dimension(300, 28));
        this.layoutObject(this.inputFileText, 5, 1, 10, 1, 1.0, 0.0);
        this.outputFileText = new JTextField();
        this.outputFileText.setPreferredSize(new Dimension(300, 28));
        this.layoutObject(this.outputFileText, 5, 2, 10, 1, 1.0, 0.0);
        MyButton myButton = new MyButton(MyResourceBundle.getResourceString("AddHydrogenPanel.file"));
        MyButton myButton2 = new MyButton(MyResourceBundle.getResourceString("AddHydrogenPanel.file"));
        this.layoutObject(myButton, 15, 1, 10, 1, 1.0, 0.0);
        this.layoutObject(myButton2, 15, 2, 10, 1, 1.0, 0.0);
        final JFileChooser jFileChooser = new JFileChooser(".");
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter(new String[]{"pdb", "ent"}, "PDB file");
        FileFilter fileFilter = jFileChooser.getFileFilter();
        jFileChooser.addChoosableFileFilter(exampleFileFilter);
        jFileChooser.setFileFilter(fileFilter);
        jFileChooser.setPreferredSize(new Dimension(500, 500));
        myButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jFileChooser.showOpenDialog(null) == 0) {
                    AddHydrogenPanel.this.inputFileText.setText(jFileChooser.getSelectedFile().getPath());
                }
            }
        });
        myButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jFileChooser.showOpenDialog(null) == 0) {
                    AddHydrogenPanel.this.outputFileText.setText(jFileChooser.getSelectedFile().getPath());
                }
            }
        });
    }

    public boolean conform() {
        try {
            ExecAddHydrogen execAddHydrogen = new ExecAddHydrogen(this.viewer);
            String string = System.getProperty("os.name");
            if (string.indexOf("Windows") != -1) {
                FileOutputStream fileOutputStream = new FileOutputStream("goAddH.bat");
                PrintStream printStream = new PrintStream(fileOutputStream);
                printStream.print("reduce " + this.getOptions() + " \"" + this.getInputFile() + "\" > \"" + this.getOutputFile() + "\"\n");
                printStream.print("@echo end reduce\n");
                printStream.print("@echo Please input exit\n");
                printStream.close();
                fileOutputStream.close();
            } else {
                FileOutputStream fileOutputStream = new FileOutputStream("goAddH");
                PrintStream printStream = new PrintStream(fileOutputStream);
                printStream.print("reduce " + this.getOptions() + " " + this.getInputFile() + " > " + this.getOutputFile() + "\n");
                printStream.print("echo end reduce\n");
                printStream.print("echo Please hit return key\n");
                printStream.print("read a\n");
                printStream.close();
                fileOutputStream.close();
                ExecCommand.exec(new String[]{"chmod", "755", "goAddH"}, true);
            }
            new Thread(execAddHydrogen).start();
        }
        catch (Exception exception) {
            this.viewer.addMessageln("Exec reduce failed !! \n" + exception.getMessage());
            return false;
        }
        return true;
    }

    public void setFilename(String string, String string2) {
        this.inputFileText.setText(string);
        this.outputFileText.setText(string2);
    }

    public String getOptions() {
        return this.optionsText.getText();
    }

    public String getInputFile() {
        return this.inputFileText.getText();
    }

    public String getOutputFile() {
        return this.outputFileText.getText();
    }
}

