/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.AbinitMpFile.CheckPointFile;
import AbinitMp.AbinitMpFile.CpfAtomData;
import AbinitMp.AbinitMpFile.ElectricFieldFile;
import AbinitMp.AbinitMpFile.GridFile;
import AbinitMp.AbinitMpFile.MoFile;
import AbinitMp.AbinitMpFile.TrajectoryFile;
import AbinitMp.Common.AtomData;
import AbinitMp.Common.AtomInfoTable;
import AbinitMp.Common.BaseDialog;
import AbinitMp.Common.BaseWindow;
import AbinitMp.Common.ChainData;
import AbinitMp.Common.Constants;
import AbinitMp.Common.GaussianCubeFile;
import AbinitMp.Common.MDLFile;
import AbinitMp.Common.MOL2File;
import AbinitMp.Common.PdbFile;
import AbinitMp.Common.ResidueData;
import AbinitMp.Common.ViewText;
import AbinitMp.Common.XyzFile;
import AbinitMp.Display.ColorMap;
import AbinitMp.Display.ElectricFieldAssignValue;
import AbinitMp.Display.ElectricFieldNode;
import AbinitMp.Display.Isosurface;
import AbinitMp.Display.IsosurfaceValue;
import AbinitMp.Display.SectionAssignValue;
import AbinitMp.Structure.CoordInfo;
import AbinitMp.Structure.MolecularStructure;
import AbinitMp.Structure.NodeData;
import AbinitMp.Structure.SceneViewer;
import AbinitMp.Structure.SelectionData;
import AbinitMp.Tool.ExampleFileFilter;
import AbinitMp.Tool.FillSpace;
import AbinitMp.Tool.MyMenu;
import AbinitMp.Tool.MyMenuItem;
import AbinitMp.Tool.MyRadioButtonMenuItem;
import AbinitMp.Tool.MyResourceBundle;
import AbinitMp.Viewer.AddHydrogenPanel;
import AbinitMp.Viewer.AddSideChainPanel;
import AbinitMp.Viewer.AjfFileWindow;
import AbinitMp.Viewer.CalculateChargeWindow;
import AbinitMp.Viewer.Cpf2denInputFileWindow;
import AbinitMp.Viewer.CubeFileTypePanel;
import AbinitMp.Viewer.DeleteFileItemPanel;
import AbinitMp.Viewer.DifferenceFilePanel;
import AbinitMp.Viewer.DisplayAttributePanel;
import AbinitMp.Viewer.DisplayPreference;
import AbinitMp.Viewer.DisplayResiduePanel;
import AbinitMp.Viewer.ElectricFieldAssignWindow;
import AbinitMp.Viewer.FileItem;
import AbinitMp.Viewer.FileListPanel;
import AbinitMp.Viewer.FileListWindow;
import AbinitMp.Viewer.GaussianInputFileWindow;
import AbinitMp.Viewer.InDistanceData;
import AbinitMp.Viewer.InDistancePanel;
import AbinitMp.Viewer.InteractionEnergyManyToManyPanel;
import AbinitMp.Viewer.InteractionEnergyManyToOnePanel;
import AbinitMp.Viewer.InteractionEnergyPanel;
import AbinitMp.Viewer.IsosurfaceValueWindow;
import AbinitMp.Viewer.LabelAttributePanel;
import AbinitMp.Viewer.MoGraphWindow;
import AbinitMp.Viewer.MonitorNode;
import AbinitMp.Viewer.MullikenValuePanel;
import AbinitMp.Viewer.MySwitchValueInterpolator;
import AbinitMp.Viewer.OverlayPanel;
import AbinitMp.Viewer.PeriodicWindow;
import AbinitMp.Viewer.PreferenceWindow;
import AbinitMp.Viewer.ReplaceAddHydrogenPanel;
import AbinitMp.Viewer.ReplaceAddSideChainPanel;
import AbinitMp.Viewer.SimpleKeyBehavior;
import AbinitMp.Viewer.StartEnd;
import AbinitMp.Viewer.Text3DData;
import AbinitMp.Viewer.TextAssignWindow;
import AbinitMp.Viewer.TrajectoryControlWindow;
import AbinitMp.Viewer.TranslateWindow;
import AbinitMp.Viewer.TreePanel;
import AbinitMp.Viewer.UndoData;
import AbinitMp.Viewer.VideoControlPanel;
import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class AbinitMpViewer
extends BaseWindow {
    private JTabbedPane treeTabPanel;
    private SceneViewer sceneViewer;
    private MyRadioButtonMenuItem wireframeModelMenu;
    private MyRadioButtonMenuItem atomColorMenu;
    private MyRadioButtonMenuItem atomSelectionMenu;
    private MyRadioButtonMenuItem residueSelectionMenu;
    private MyMenuItem undoMenu;
    private MyMenuItem redoMenu;
    private MyMenu toolMenu;
    private MyMenu monitorMenu;
    private MyMenuItem distanceMenu;
    private MyMenuItem angleMenu;
    private MyMenuItem dihedralMenu;
    private MyMenuItem interactionMenu;
    private MyMenuItem hBondsAllMenu;
    private MyMenuItem hBondsIntermoleculeMenu;
    private JColorChooser colorChooser = new JColorChooser();
    private Vector fileList = new Vector();
    private AbinitMpViewer me;
    public CoordInfo coordInfo;
    private Switch moRootNode;
    private Switch isoRootNode;
    private int moModel = 1;
    private int moColor = 1;
    private int selectionMode = 3;
    private boolean[] displayResidue = new boolean[Constants.RESIDUE_NAME.length];
    private boolean[] displayResidueColor = new boolean[Constants.RESIDUE_NAME.length];
    private int distanceFlag = 0;
    private int interactionFlag = 0;
    private int angleFlag = 0;
    private int dihedralFlag = 0;
    private AtomData firstAtomData;
    private FileItem firstFileItem;
    private int residueLabel = 0;
    private int atomLabel = 0;
    private Hashtable nodeTable = new Hashtable();
    private Vector selectionList = new Vector();
    private InDistanceData inDistanceData = null;
    private Vector chainTable = new Vector();
    private boolean directionDisplay = false;
    private Vector undoList = new Vector();
    private int undoNo = 0;
    private BaseDialog overlayDialog = null;
    private OverlayPanel overlayPanel = null;
    private BaseDialog interactionEnergyManyToOneDialog = null;
    private InteractionEnergyManyToOnePanel interactionEnergyManyToOnePanel = null;
    private Vector interactionEnergyManyToOneData;
    private BaseDialog interactionEnergyManyToManyDialog = null;
    private InteractionEnergyManyToManyPanel interactionEnergyManyToManyPanel = null;
    Point3f point1;
    Point3f point2;
    Point3f point3;
    Point3f point4;
    private MonitorNode monitorNode;
    private boolean hBondsAllEnable = false;
    private boolean hBondsIntermoleculeEnable = false;
    private AddHydrogenPanel addHydrogenPanel;
    private BaseDialog addHydrogenDialog;
    private AddSideChainPanel addSideChainPanel;
    private BaseDialog addSideChainDialog;
    private AjfFileWindow ajfFileWindow;
    private PreferenceWindow preferenceWindow;
    private MoGraphWindow moGraphWindow;
    private TranslateWindow translateWindow;
    private GaussianInputFileWindow gaussianInputFileWindow;
    private CalculateChargeWindow calculateChargeWindow;
    private PeriodicWindow periodicWindow = null;
    private TextAssignWindow textAssignWindow;
    private TrajectoryControlWindow trajectoryControlWindow;
    private Text3DData trajectoryText3DData;
    private Cpf2denInputFileWindow cpf2denInputFileWindow;
    ExampleFileFilter cpfFileFilter = new ExampleFileFilter("cpf", "Check Point file");
    ExampleFileFilter pdbFileFilter = new ExampleFileFilter(new String[]{"pdb", "ent"}, "PDB file");
    ExampleFileFilter gridFileFilter = new ExampleFileFilter(new String[]{"den", "esp", "map", "mo", "efv"}, "Grid file");
    ExampleFileFilter mol2FileFilter = new ExampleFileFilter("mol2", "MOL2 file");
    ExampleFileFilter mdlFileFilter = new ExampleFileFilter(new String[]{"mdl", "mol"}, "MDL file");
    ExampleFileFilter gjfFileFilter = new ExampleFileFilter("gjf", "Gaussian input file");
    ExampleFileFilter jpgFileFilter = new ExampleFileFilter(new String[]{"jpg", "png"}, "Image file");
    ExampleFileFilter cubeFileFilter = new ExampleFileFilter(new String[]{"cube", "cub"}, "Gaussian Cube file");
    ExampleFileFilter xyzFileFilter = new ExampleFileFilter("xyz", "XYZ file");
    ExampleFileFilter trjFileFilter = new ExampleFileFilter(new String[]{"tr2", "tj2", "trj2", "trj"}, "Trajectory file");

    public AbinitMpViewer() {
        super(MyResourceBundle.getResourceString("AbinitMpViewer.Title") + " Version " + "5.01");
        int n;
        GraphicsConfiguration graphicsConfiguration;
        String string = System.getProperty("user.home");
        String string2 = string + "/.bioViewer";
        File file = new File(string2);
        boolean bl = file.canRead();
        if (!bl) {
            string2 = ".bioViewer";
            file = new File(string2);
            bl = file.canRead();
        }
        if (bl) {
            DisplayPreference.openFile(string2);
        }
        this.me = this;
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        this.getJMenuBar().add(this.addMenuItem("AbinitMpViewer.fileMenuTitle", "AbinitMpViewer.fileMenu", (Action)new fileListener()));
        this.getJMenuBar().add(this.addMenuItem("AbinitMpViewer.viewpointMenuTitle", "AbinitMpViewer.viewpointMenu", (Action)new viewpointListener()));
        MyMenu myMenu = this.addRadioButtonMenuItem("AbinitMpViewer.modelMenuTitle", "AbinitMpViewer.modelMenu", (Action)new modelListener(), 0);
        this.wireframeModelMenu = (MyRadioButtonMenuItem)myMenu.getItem(0);
        this.getJMenuBar().add(myMenu);
        MyMenu myMenu2 = this.addRadioButtonMenuItem("AbinitMpViewer.colorMenuTitle", "AbinitMpViewer.colorMenu", (Action)new colorListener(), 0);
        this.atomColorMenu = (MyRadioButtonMenuItem)myMenu2.getItem(0);
        myMenu2.remove(1);
        MyMenu myMenu3 = new MyMenu("Residue(R)");
        myMenu3.setMnemonic('R');
        myMenu2.add((Component)myMenu3, 1);
        this.addRadioButtonMenuItem(myMenu3, "AbinitMpViewer.residueColorMenu", (Action)new residueColorListener(), 0);
        this.getJMenuBar().add(myMenu2);
        MyMenu myMenu4 = this.addRadioButtonMenuItem("AbinitMpViewer.selectionMenuTitle", "AbinitMpViewer.selectionMenu", (Action)new selectionListener(), 0);
        this.getJMenuBar().add(myMenu4);
        this.atomSelectionMenu = (MyRadioButtonMenuItem)myMenu4.getItem(0);
        this.residueSelectionMenu = (MyRadioButtonMenuItem)myMenu4.getItem(1);
        this.toolMenu = this.addMenuItem("AbinitMpViewer.toolMenuTitle", "AbinitMpViewer.toolMenu", (Action)new toolListener());
        this.getJMenuBar().add(this.toolMenu);
        this.hBondsAllMenu = (MyMenuItem)this.toolMenu.getItem(3);
        this.hBondsIntermoleculeMenu = (MyMenuItem)this.toolMenu.getItem(4);
        this.monitorMenu = this.addMenuItem("AbinitMpViewer.monitorMenuTitle", "AbinitMpViewer.monitorMenu", (Action)new monitorListener());
        this.getJMenuBar().add(this.monitorMenu);
        this.distanceMenu = (MyMenuItem)this.monitorMenu.getItem(0);
        this.angleMenu = (MyMenuItem)this.monitorMenu.getItem(1);
        this.dihedralMenu = (MyMenuItem)this.monitorMenu.getItem(2);
        this.interactionMenu = (MyMenuItem)this.monitorMenu.getItem(3);
        MyMenu myMenu5 = new MyMenu(MyResourceBundle.getResourceString("AbinitMpViewer.chargeListTitle"));
        myMenu5.setMnemonic('C');
        this.monitorMenu.add(myMenu5);
        this.addMenuItem(myMenu5, "AbinitMpViewer.chargeListMenu", (Action)new chargeListListener());
        MyMenu myMenu6 = new MyMenu(MyResourceBundle.getResourceString("AbinitMpViewer.interfragmentInteractionTitle"));
        myMenu6.setMnemonic('I');
        this.monitorMenu.add(myMenu6);
        this.addRadioButtonMenuItem(myMenu6, "AbinitMpViewer.interfragmentInteractionMenu1", (Action)new interfragmentInteractionListener(), 0);
        this.addMenuItem(myMenu6, "AbinitMpViewer.interfragmentInteractionMenu2", (Action)new interfragmentInteractionListener());
        MyMenu myMenu7 = this.addMenuItem("AbinitMpViewer.editMenuTitle", "AbinitMpViewer.editMenu", (Action)new editListener());
        this.getJMenuBar().add(myMenu7);
        this.undoMenu = (MyMenuItem)myMenu7.getItem(2);
        this.redoMenu = (MyMenuItem)myMenu7.getItem(3);
        this.undoMenu.setEnabled(false);
        this.redoMenu.setEnabled(false);
        MyMenu myMenu8 = this.addMenuItem("AbinitMpViewer.preferenceMenuTitle", "AbinitMpViewer.preferenceMenu", (Action)new preferenceListener());
        this.getJMenuBar().add(myMenu8);
        myMenu8.add(this.addRadioButtonMenuItem("AbinitMpViewer.axisMenuTitle", "AbinitMpViewer.axisMenu", (Action)new axisListener(), 0));
        myMenu8.add(this.addRadioButtonMenuItem("AbinitMpViewer.directionMenuTitle", "AbinitMpViewer.directionMenu", (Action)new directionListener(), 1));
        this.addHelpMenu();
        this.setHelpUrl("file:c:/Program files/BioStationViewer/doc/manual.html");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.width > 2000) {
            dimension.width /= 2;
        }
        this.setBounds(0, 0, (int)((double)dimension.width * 0.8), (int)((double)dimension.height * 0.8));
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setOneTouchExpandable(true);
        this.treeTabPanel = new JTabbedPane();
        this.treeTabPanel.addChangeListener(new MyChangeListener());
        if (DisplayPreference.stereo) {
            GraphicsConfigTemplate3D graphicsConfigTemplate3D = new GraphicsConfigTemplate3D();
            graphicsConfigTemplate3D.setStereo(2);
            graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)graphicsConfigTemplate3D);
        } else {
            graphicsConfiguration = SimpleUniverse.getPreferredConfiguration();
        }
        jSplitPane.setLeftComponent(this.treeTabPanel);
        this.sceneViewer = new SceneViewer(this, graphicsConfiguration);
        jSplitPane.setRightComponent((Component)((Object)this.sceneViewer));
        jSplitPane.setDividerLocation(200);
        this.monitorNode = new MonitorNode(this.sceneViewer.getPickedGroup(), this.sceneViewer.getRotateTG());
        this.getContentPane().add((Component)jSplitPane, "Center");
        for (n = 0; n < this.displayResidue.length; ++n) {
            this.displayResidue[n] = true;
        }
        for (n = 0; n < this.displayResidueColor.length; ++n) {
            this.displayResidueColor[n] = false;
        }
        this.setMain();
    }

    private void setDirectionDisplay() {
        int n = this.treeTabPanel.getSelectedIndex();
        if (n == -1) {
            return;
        }
        String string = this.treeTabPanel.getTitleAt(n);
        FileItem fileItem = null;
        for (int i = 0; i < this.fileList.size(); ++i) {
            FileItem fileItem2 = (FileItem)this.fileList.get(i);
            if (fileItem2.filename.equals(string)) {
                fileItem = fileItem2;
                continue;
            }
            if (fileItem2.directionAxisRoot == null) continue;
            fileItem2.directionAxisRoot.setWhichChild(-1);
            fileItem2.keyBehavior.setEnable(false);
        }
        if (fileItem != null && fileItem.keyBehavior != null) {
            fileItem.keyBehavior.setEnable(true);
            if (this.directionDisplay) {
                fileItem.directionAxisRoot.setWhichChild(-2);
            } else {
                fileItem.directionAxisRoot.setWhichChild(-1);
            }
        }
    }

    public void fileListOk(FileListPanel fileListPanel) {
        FileItem[] fileItemArray = fileListPanel.getValue();
        this.fileList.removeAllElements();
        int n = 0;
        int n2 = 0;
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = new BitSet();
        for (int i = 0; i < fileItemArray.length; ++i) {
            boolean bl;
            this.fileList.add(fileItemArray[i]);
            if (fileItemArray[i].type == 4 || fileItemArray[i].type == 5 || fileItemArray[i].type == 6 || fileItemArray[i].type == 7 || fileItemArray[i].type == 13) {
                if (fileItemArray[i].visible) {
                    bitSet.set(n);
                }
                ++n;
                continue;
            }
            if (fileItemArray[i].type == 0 || fileItemArray[i].type == 2 || fileItemArray[i].type == 12 || fileItemArray[i].type == 3) {
                bl = false;
                if (fileItemArray[i].visible) {
                    bitSet2.set(n2);
                    bl = true;
                }
                if (fileItemArray[i].type == 12) {
                    this.setSectionNodeDisplay(fileItemArray[i].electricFieldAssignValue.sectionAssignValueVector, bl);
                } else {
                    this.setSectionNodeDisplay(fileItemArray[i].isosurfaceValue.sectionAssignValueVector, bl);
                }
                ++n2;
                if (fileItemArray[i].visible || fileItemArray[i].type != 3) continue;
                this.moGraphWindow.setVisible(false);
                continue;
            }
            if (fileItemArray[i].type != 8 && fileItemArray[i].type != 9 && fileItemArray[i].type != 10) continue;
            bl = false;
            if (fileItemArray[i].visible) {
                bitSet2.set(n2);
                bitSet.set(n2);
                bl = true;
            }
            this.setSectionNodeDisplay(fileItemArray[i].isosurfaceValue.sectionAssignValueVector, bl);
            ++n2;
            ++n;
            if (fileItemArray[i].visible || fileItemArray[i].type != 10) continue;
            this.moGraphWindow.setVisible(false);
        }
        this.setWaitCursor();
        if (this.moRootNode != null) {
            this.moRootNode.setChildMask(bitSet);
        }
        if (this.isoRootNode != null) {
            this.isoRootNode.setChildMask(bitSet2);
        }
        this.setDefaultCursor();
    }

    private void setSectionNodeDisplay(Vector vector, boolean bl) {
        if (vector != null) {
            BitSet bitSet = new BitSet();
            if (bl) {
                bitSet.set(1);
            }
            for (int i = 0; i < vector.size(); ++i) {
                Switch switch_ = ((SectionAssignValue)vector.get(i)).getSectionRootNode();
                switch_.setChildMask(bitSet);
            }
        }
    }

    public boolean openFile(String string) {
        this.setWaitCursor();
        String string2 = string.substring(string.lastIndexOf(".") + 1);
        FileItem fileItem = new FileItem(null, string, 0, true);
        TreePanel treePanel = null;
        if (string2.equalsIgnoreCase("cpf")) {
            fileItem.file = new CheckPointFile(string);
            if (((CheckPointFile)fileItem.file).filename != null) {
                fileItem.type = 5;
                treePanel = new TreePanel(fileItem, this.me);
            } else {
                fileItem = null;
            }
        } else if (string2.equalsIgnoreCase("pdb") || string2.equalsIgnoreCase("ent")) {
            fileItem.file = new PdbFile(string);
            if (((PdbFile)fileItem.file).filename != null) {
                fileItem.type = 4;
                treePanel = new TreePanel(fileItem, this.me);
            } else {
                fileItem = null;
            }
        } else if (string2.equalsIgnoreCase("mdl") || string2.equalsIgnoreCase("mol")) {
            fileItem.file = new MDLFile(string);
            if (((MDLFile)fileItem.file).filename != null) {
                fileItem.type = 7;
                treePanel = new TreePanel(fileItem, this.me);
            } else {
                fileItem = null;
            }
        } else if (string2.equalsIgnoreCase("mol2")) {
            MOL2File mOL2File = new MOL2File(string);
            fileItem.file = mOL2File;
            if (((MOL2File)fileItem.file).filename != null) {
                fileItem.type = 6;
                if (mOL2File.gridFile == 0) {
                    treePanel = new TreePanel(fileItem, this.me);
                }
            } else {
                fileItem = null;
            }
        } else if (string2.equalsIgnoreCase("den") || string2.equalsIgnoreCase("map") || string2.equalsIgnoreCase("esp")) {
            GridFile gridFile = new GridFile(string);
            fileItem.file = gridFile;
            if (((GridFile)fileItem.file).filename != null) {
                if (string2.equalsIgnoreCase("den")) {
                    fileItem.type = 0;
                    fileItem.isosurfaceValue = new IsosurfaceValue(gridFile.isosurfaceValue, DisplayPreference.densityColor, null, 0);
                } else if (string2.equalsIgnoreCase("esp")) {
                    fileItem.type = 1;
                    fileItem.isosurfaceValue = new IsosurfaceValue(gridFile.isosurfaceValue, null, null, 0);
                    fileItem.isosurfaceValue.minValue = -0.02f;
                    fileItem.isosurfaceValue.maxValue = 0.02f;
                    fileItem.isosurfaceValue.value = 0.02f;
                } else if (string2.equalsIgnoreCase("map")) {
                    fileItem.type = 2;
                    fileItem.isosurfaceValue = new IsosurfaceValue(gridFile.isosurfaceValue, null, null, 0);
                    fileItem.isosurfaceValue.minValue = -0.02f;
                    fileItem.isosurfaceValue.maxValue = 0.02f;
                } else {
                    fileItem.type = 1;
                }
                IsosurfaceValueWindow isosurfaceValueWindow = new IsosurfaceValueWindow(this.me, fileItem);
                isosurfaceValueWindow.setVisible(true);
                fileItem.isosurfaceValueWindow = isosurfaceValueWindow;
                this.setDefaultCursor();
            } else {
                fileItem = null;
            }
        } else if (string2.equalsIgnoreCase("efv")) {
            ElectricFieldFile electricFieldFile = new ElectricFieldFile(string);
            fileItem.file = electricFieldFile;
            fileItem.type = 12;
            fileItem.electricFieldAssignValue = new ElectricFieldAssignValue();
            ElectricFieldAssignWindow electricFieldAssignWindow = new ElectricFieldAssignWindow(this.me, fileItem);
            electricFieldAssignWindow.setVisible(true);
            fileItem.electricFieldAssignWindow = electricFieldAssignWindow;
            this.setDefaultCursor();
        } else if (string2.equalsIgnoreCase("mo")) {
            MoFile moFile = new MoFile(string);
            fileItem.type = 3;
            fileItem.file = moFile;
            fileItem.isosurfaceValue = new IsosurfaceValue(moFile.isosurfaceValue, DisplayPreference.moMinusColor, DisplayPreference.moPlusColor, 0);
            if (this.moGraphWindow != null) {
                this.moGraphWindow.setVisible(false);
            }
            this.moGraphWindow = new MoGraphWindow(this.me, fileItem);
            this.moGraphWindow.setVisible(true);
            this.setDefaultCursor();
        } else if (string2.equalsIgnoreCase("cub") || string2.equalsIgnoreCase("cube")) {
            BaseDialog baseDialog = new BaseDialog(this.me, new CubeFileTypePanel(), MyResourceBundle.getResourceString("CubeFileYypeDialog.Title"));
            baseDialog.setCancelVisible(false);
            baseDialog.setVisible(true);
            CubeFileTypePanel cubeFileTypePanel = (CubeFileTypePanel)baseDialog.getPanel();
            int n = cubeFileTypePanel.getFileType();
            GaussianCubeFile gaussianCubeFile = new GaussianCubeFile(string, n, cubeFileTypePanel.getAtom(), cubeFileTypePanel.getGrid());
            fileItem.type = n;
            fileItem.file = gaussianCubeFile;
            treePanel = new TreePanel(fileItem, this.me);
            if (n == 10) {
                gaussianCubeFile.isosurfaceValue = 0.05f;
                fileItem.isosurfaceValue = new IsosurfaceValue(gaussianCubeFile.isosurfaceValue, DisplayPreference.moMinusColor, DisplayPreference.moPlusColor, 0);
                if (this.moGraphWindow != null) {
                    this.moGraphWindow.setVisible(false);
                }
                this.moGraphWindow = new MoGraphWindow(this.me, fileItem);
                this.moGraphWindow.setVisible(true);
                this.setDefaultCursor();
            } else {
                gaussianCubeFile.isosurfaceValue = 0.001f;
                fileItem.isosurfaceValue = new IsosurfaceValue(gaussianCubeFile.isosurfaceValue, DisplayPreference.densityColor, null, 0);
                IsosurfaceValueWindow isosurfaceValueWindow = new IsosurfaceValueWindow(this.me, fileItem);
                isosurfaceValueWindow.setVisible(true);
                fileItem.isosurfaceValueWindow = isosurfaceValueWindow;
                this.setDefaultCursor();
            }
        } else if (string2.equalsIgnoreCase("xyz")) {
            fileItem.file = new XyzFile(string);
            if (((XyzFile)fileItem.file).filename != null) {
                fileItem.type = 11;
                treePanel = new TreePanel(fileItem, this.me);
            } else {
                fileItem = null;
            }
        } else if (string2.equalsIgnoreCase("trj") || string2.equalsIgnoreCase("tj2") || string2.equalsIgnoreCase("trj2") || string2.equalsIgnoreCase("tr2")) {
            TrajectoryFile trajectoryFile = new TrajectoryFile(string, fileItem);
            fileItem.file = trajectoryFile;
            if (trajectoryFile.filename != null) {
                fileItem.type = 13;
                if (trajectoryFile.type == 0 || trajectoryFile.type == 2 || trajectoryFile.type == 1 || trajectoryFile.type == 3) {
                    treePanel = new TreePanel(fileItem, this.me);
                }
            } else {
                fileItem = null;
            }
        } else {
            this.addMessageln("Unknown file type.(" + string + ")");
            return false;
        }
        if (fileItem == null) {
            this.setDefaultCursor();
            return false;
        }
        this.addMessageln("open file.(" + fileItem.fullname + ")");
        this.fileList.add(fileItem);
        this.calcCoordInfo();
        this.sceneViewer.setScale(this.coordInfo.scale);
        this.sceneViewer.setViewPoint("front");
        if (fileItem.type != 3) {
            this.createNode(fileItem, treePanel);
            if (string2.equalsIgnoreCase("trj") || string2.equalsIgnoreCase("tj2") || string2.equalsIgnoreCase("tr2") || string2.equalsIgnoreCase("trj2")) {
                this.trajectoryControlWindow = new TrajectoryControlWindow(this, fileItem);
                this.trajectoryControlWindow.setVisible(true);
                ((TrajectoryFile)fileItem.file).setTrajectoryControlWindow(this.trajectoryControlWindow);
                this.sceneViewer.createTrajectoryText((TrajectoryFile)fileItem.file);
            }
        }
        return true;
    }

    public void createNode(FileItem fileItem, TreePanel treePanel) {
        this.setWaitCursor();
        this.moRootNode = this.createStructureNode();
        this.sceneViewer.setSceneGraph(this.moRootNode);
        this.isoRootNode = this.createIsosurfaceNode();
        this.sceneViewer.addNode((Node)this.isoRootNode);
        if ((fileItem.type != 6 || ((MOL2File)fileItem.file).gridFile != 1) && treePanel != null) {
            this.treeTabPanel.addTab(fileItem.filename, treePanel);
            this.setDirectionDisplay();
            fileItem.treePanel = treePanel;
        }
        this.setDefaultCursor();
    }

    public void savePdbFile(String string) {
        this.setWaitCursor();
        if (string.lastIndexOf(".") == -1) {
            string = string.concat(".pdb");
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            Date date = new Date();
            int n = 0;
            int n2 = -1;
            int n3 = 0;
            Transform3D transform3D = new Transform3D();
            Matrix4d matrix4d = new Matrix4d();
            Transform3D transform3D2 = new Transform3D();
            Transform3D transform3D3 = new Transform3D();
            DecimalFormat decimalFormat = new DecimalFormat("###0.000");
            DecimalFormat decimalFormat2 = new DecimalFormat("##0.00");
            DecimalFormat decimalFormat3 = new DecimalFormat("#####");
            for (int i = 0; i < this.fileList.size(); ++i) {
                FileItem fileItem = (FileItem)this.fileList.get(i);
                PdbFile pdbFile = fileItem.getPdbFile();
                if (pdbFile == null) continue;
                printStream.print("REMARK Original file : " + fileItem.fullname + "\n");
                fileItem.transformGroup.getTransform(transform3D);
                Vector vector = pdbFile.chains;
                for (int j = 0; j < vector.size(); ++j) {
                    ChainData chainData = (ChainData)vector.get(j);
                    Vector vector2 = null;
                    int n4 = 0;
                    for (int k = 0; k < 2; ++k) {
                        String string2;
                        if (k == 0) {
                            vector2 = chainData.atomTable;
                            string2 = "ATOM  ";
                        } else {
                            vector2 = chainData.hemTable;
                            string2 = "HETATM";
                        }
                        for (int i2 = 0; i2 < vector2.size(); ++i2) {
                            AtomData atomData = (AtomData)vector2.get(i2);
                            if (atomData.cutFlag) continue;
                            ++n4;
                            n = atomData.residueNo;
                            ++n3;
                            transform3D2.setTranslation(new Vector3f(atomData.coordX - fileItem.coordInfo.xcenter + this.coordInfo.xcenter, atomData.coordY - fileItem.coordInfo.ycenter + this.coordInfo.ycenter, atomData.coordZ - fileItem.coordInfo.zcenter + this.coordInfo.zcenter));
                            transform3D3.mul(transform3D, transform3D2);
                            transform3D3.get(matrix4d);
                            float f = (float)matrix4d.m03 + fileItem.coordInfo.xcenter;
                            float f2 = (float)matrix4d.m13 + fileItem.coordInfo.ycenter;
                            float f3 = (float)matrix4d.m23 + fileItem.coordInfo.zcenter;
                            printStream.print(string2);
                            printStream.print(FillSpace.front(decimalFormat3.format(n3), 5) + " ");
                            if (Character.isDigit(atomData.allAtomName.trim().charAt(0))) {
                                printStream.print(FillSpace.back(atomData.allAtomName, 4));
                            } else {
                                printStream.print(" " + FillSpace.back(atomData.allAtomName, 3));
                            }
                            printStream.print(atomData.altLoc);
                            printStream.print(FillSpace.back(atomData.residueName, 3) + " ");
                            if (atomData.chain.equals("CPF")) {
                                printStream.print(" ");
                            } else {
                                printStream.print(atomData.chain);
                            }
                            printStream.print(FillSpace.front(decimalFormat3.format(n), 4));
                            if (atomData.iCode != null) {
                                printStream.print(atomData.iCode + "   ");
                            } else {
                                printStream.print("    ");
                            }
                            printStream.print(FillSpace.front(decimalFormat.format(f), 8));
                            printStream.print(FillSpace.front(decimalFormat.format(f2), 8));
                            printStream.print(FillSpace.front(decimalFormat.format(f3), 8));
                            if (atomData.occupancy == 0.0f) {
                                printStream.print("      ");
                            } else {
                                printStream.print(FillSpace.front(decimalFormat2.format(atomData.occupancy), 6));
                            }
                            if (atomData.tempFactor == 0.0f) {
                                printStream.print("      ");
                            } else {
                                printStream.print(FillSpace.front(decimalFormat2.format(atomData.tempFactor), 6));
                            }
                            printStream.print("      ");
                            printStream.print(FillSpace.front(atomData.segID, 4));
                            printStream.print(atomData.element);
                            printStream.print(atomData.charge);
                            printStream.print("\n");
                        }
                    }
                    if (n4 == 0) continue;
                    printStream.print("TER   \n");
                }
            }
            printStream.close();
        }
        catch (Exception exception) {
            this.addMessageln("Save failed !! \n" + exception.getMessage());
            return;
        }
        this.addMessageln("Save PDB file(" + string + ")");
        this.setDefaultCursor();
    }

    public void saveGaussianFile(String string) {
        this.setWaitCursor();
        if (string.lastIndexOf(".") == -1) {
            string = string.concat(".gjf");
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            Date date = new Date();
            printStream.print("%chk=test.chk\n");
            printStream.print("#HF/6-31G(d,p) POPT=(MaxCycle=100) SCF=TIGHT\n");
            int n = 0;
            int n2 = -1;
            int n3 = 0;
            Transform3D transform3D = new Transform3D();
            Matrix4d matrix4d = new Matrix4d();
            Transform3D transform3D2 = new Transform3D();
            Transform3D transform3D3 = new Transform3D();
            DecimalFormat decimalFormat = new DecimalFormat("###0.000000");
            DecimalFormat decimalFormat2 = new DecimalFormat("000");
            for (int i = 0; i < this.fileList.size(); ++i) {
                int n4;
                int n5;
                Object object;
                PdbFile pdbFile;
                FileItem fileItem = (FileItem)this.fileList.get(i);
                int n6 = 0;
                int n7 = 1;
                if (fileItem.type == 4) {
                    pdbFile = (PdbFile)fileItem.file;
                } else if (fileItem.type == 5) {
                    object = (CheckPointFile)fileItem.file;
                    pdbFile = ((CheckPointFile)object).pdbFile;
                    int n8 = 0;
                    for (n5 = 0; n5 < ((CheckPointFile)object).cpfAtomDatas.size(); ++n5) {
                        CpfAtomData cpfAtomData = (CpfAtomData)((CheckPointFile)object).cpfAtomDatas.get(n5);
                        n8 += AtomInfoTable.getInfo((String)cpfAtomData.atomName).no;
                    }
                    n5 = 0;
                    for (n4 = 0; n4 < ((CheckPointFile)object).numberOfElectronInFragment.length; ++n4) {
                        n5 += ((CheckPointFile)object).numberOfElectronInFragment[n4];
                    }
                    n6 = n8 - n5;
                    if (((CheckPointFile)object).elecState.charAt(0) == 'T') {
                        n7 = 3;
                    } else if (((CheckPointFile)object).elecState.charAt(0) == 'D') {
                        n7 = 2;
                    }
                } else if (fileItem.type == 6) {
                    pdbFile = ((MOL2File)fileItem.file).pdbFile;
                } else {
                    if (fileItem.type != 7) continue;
                    pdbFile = ((MDLFile)fileItem.file).pdbFile;
                }
                printStream.print("\n" + pdbFile.filename + "\n\n");
                printStream.print(" " + n6 + " " + n7 + "\n");
                fileItem.transformGroup.getTransform(transform3D);
                object = pdbFile.chains;
                String string2 = new String();
                n5 = 0;
                for (n4 = 0; n4 < ((Vector)object).size(); ++n4) {
                    ChainData chainData = (ChainData)((Vector)object).get(n4);
                    Vector vector = null;
                    for (int j = 0; j < 2; ++j) {
                        vector = j == 0 ? chainData.atomTable : chainData.hemTable;
                        for (int k = 0; k < vector.size(); ++k) {
                            AtomData atomData = (AtomData)vector.get(k);
                            if (atomData.cutFlag) continue;
                            ++n5;
                            n = atomData.residueNo;
                            ++n3;
                            transform3D2.setTranslation(new Vector3f(atomData.coordX - fileItem.coordInfo.xcenter + this.coordInfo.xcenter, atomData.coordY - fileItem.coordInfo.ycenter + this.coordInfo.ycenter, atomData.coordZ - fileItem.coordInfo.zcenter + this.coordInfo.zcenter));
                            transform3D3.mul(transform3D, transform3D2);
                            transform3D3.get(matrix4d);
                            float f = (float)matrix4d.m03 + fileItem.coordInfo.xcenter;
                            float f2 = (float)matrix4d.m13 + fileItem.coordInfo.ycenter;
                            float f3 = (float)matrix4d.m23 + fileItem.coordInfo.zcenter;
                            String string3 = decimalFormat2.format(n5);
                            printStream.print("  " + FillSpace.back(atomData.atomName, 2) + " 0 ");
                            printStream.print("x" + string3 + " y" + string3 + " z" + string3 + "\n");
                            string2 = string2.concat(" x" + string3 + "=" + FillSpace.front(decimalFormat.format(f), 10) + "\n");
                            string2 = string2.concat(" y" + string3 + "=" + FillSpace.front(decimalFormat.format(f2), 10) + "\n");
                            string2 = string2.concat(" z" + string3 + "=" + FillSpace.front(decimalFormat.format(f3), 10) + "\n");
                        }
                    }
                }
                printStream.print(" Variables:\n");
                printStream.print(string2);
                printStream.print(" Constants:\n");
            }
            printStream.close();
        }
        catch (Exception exception) {
            this.addMessageln("Save failed !! \n" + exception.getMessage());
            return;
        }
        this.addMessageln("Save Gaussian input file(" + string + ")");
        this.setDefaultCursor();
    }

    public void saveXyzFile(String string) {
        this.setWaitCursor();
        if (string.lastIndexOf(".") == -1) {
            string = string.concat(".xyz");
        }
        try {
            Vector vector;
            ChainData chainData;
            int n;
            Object object;
            PdbFile pdbFile;
            boolean bl;
            boolean bl2;
            FileItem fileItem;
            int n2;
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            Transform3D transform3D = new Transform3D();
            Matrix4d matrix4d = new Matrix4d();
            Transform3D transform3D2 = new Transform3D();
            Transform3D transform3D3 = new Transform3D();
            DecimalFormat decimalFormat = new DecimalFormat("###0.000000");
            DecimalFormat decimalFormat2 = new DecimalFormat("000");
            int n3 = 0;
            for (n2 = 0; n2 < this.fileList.size(); ++n2) {
                fileItem = (FileItem)this.fileList.get(n2);
                bl2 = false;
                bl = true;
                if (fileItem.type == 4) {
                    pdbFile = (PdbFile)fileItem.file;
                } else if (fileItem.type == 5) {
                    object = (CheckPointFile)fileItem.file;
                    pdbFile = ((CheckPointFile)object).pdbFile;
                } else if (fileItem.type == 6) {
                    pdbFile = ((MOL2File)fileItem.file).pdbFile;
                } else if (fileItem.type == 7) {
                    pdbFile = ((MDLFile)fileItem.file).pdbFile;
                } else {
                    if (fileItem.type != 11) continue;
                    pdbFile = ((XyzFile)fileItem.file).pdbFile;
                }
                fileItem.transformGroup.getTransform(transform3D);
                object = pdbFile.chains;
                for (n = 0; n < ((Vector)object).size(); ++n) {
                    chainData = (ChainData)((Vector)object).get(n);
                    vector = null;
                    n3 += chainData.atomTable.size() + chainData.hemTable.size();
                }
            }
            for (n2 = 0; n2 < this.fileList.size(); ++n2) {
                fileItem = (FileItem)this.fileList.get(n2);
                bl2 = false;
                bl = true;
                if (fileItem.type == 4) {
                    pdbFile = (PdbFile)fileItem.file;
                } else if (fileItem.type == 5) {
                    object = (CheckPointFile)fileItem.file;
                    pdbFile = ((CheckPointFile)object).pdbFile;
                } else if (fileItem.type == 6) {
                    pdbFile = ((MOL2File)fileItem.file).pdbFile;
                } else if (fileItem.type == 7) {
                    pdbFile = ((MDLFile)fileItem.file).pdbFile;
                } else {
                    if (fileItem.type != 11) continue;
                    pdbFile = ((XyzFile)fileItem.file).pdbFile;
                }
                fileItem.transformGroup.getTransform(transform3D);
                object = pdbFile.chains;
                for (n = 0; n < ((Vector)object).size(); ++n) {
                    chainData = (ChainData)((Vector)object).get(n);
                    vector = null;
                    if (n3 != 0) {
                        printStream.print(n3 + "\n");
                        printStream.print("comment \n");
                        n3 = 0;
                    }
                    for (int i = 0; i < 2; ++i) {
                        vector = i == 0 ? chainData.atomTable : chainData.hemTable;
                        for (int j = 0; j < vector.size(); ++j) {
                            AtomData atomData = (AtomData)vector.get(j);
                            if (atomData.cutFlag) continue;
                            transform3D2.setTranslation(new Vector3f(atomData.coordX - fileItem.coordInfo.xcenter + this.coordInfo.xcenter, atomData.coordY - fileItem.coordInfo.ycenter + this.coordInfo.ycenter, atomData.coordZ - fileItem.coordInfo.zcenter + this.coordInfo.zcenter));
                            transform3D3.mul(transform3D, transform3D2);
                            transform3D3.get(matrix4d);
                            float f = (float)matrix4d.m03 + fileItem.coordInfo.xcenter;
                            float f2 = (float)matrix4d.m13 + fileItem.coordInfo.ycenter;
                            float f3 = (float)matrix4d.m23 + fileItem.coordInfo.zcenter;
                            printStream.print(FillSpace.back(atomData.atomName, 4) + " ");
                            printStream.print(FillSpace.front(decimalFormat.format(f), 12) + " ");
                            printStream.print(FillSpace.front(decimalFormat.format(f2), 12) + " ");
                            printStream.print(FillSpace.front(decimalFormat.format(f3), 12) + "\n");
                        }
                    }
                }
            }
            printStream.close();
        }
        catch (Exception exception) {
            this.addMessageln("Save failed !! \n" + exception.getMessage());
            return;
        }
        this.addMessageln("Save xyz file(" + string + ")");
        this.setDefaultCursor();
    }

    public void saveAjfFile(String string) {
        Object object;
        if (string.lastIndexOf(".") == -1) {
            string = string.concat(".ajf");
        }
        String string2 = null;
        for (int i = 0; i < this.fileList.size(); ++i) {
            object = (FileItem)this.fileList.get(i);
            if (((FileItem)object).type != 4) continue;
            string2 = ((FileItem)object).fullname;
            break;
        }
        if (string2 == null) {
            string2 = string.substring(0, string.length() - 4);
            string2 = string2.concat(".pdb");
            this.addMessageln("No pdb file. so we use " + string2);
        }
        String string3 = string2.substring(0, string2.length() - 4);
        string3 = string3.concat(".cpf");
        String string4 = System.getProperty("os.name");
        object = string4.indexOf("Windows") != -1 ? string2.substring(string2.lastIndexOf("\\") + 1, string2.lastIndexOf(".")) : string2.substring(string2.lastIndexOf("/") + 1, string2.lastIndexOf("."));
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.print("&CMD\n");
            printStream.print("title='" + (String)object + "'\n");
            printStream.print("basis_set='STO-3G' electronic_state='S1'\n");
            printStream.print("maxcycle=-1 maxgrad=0.01\n");
            printStream.print("optimize='BFGS' hopt='OFF' nprint=3\n");
            printStream.print("fmo='ON' auto_frag='ON' fragment_size=2\n");
            printStream.print("apporoximation_level=3 laco=0\n");
            printStream.print("lptc=2 ldimer=2\n");
            printStream.print("np=1\n");
            printStream.print("direct_scf=1\n");
            printStream.print("read_structure='" + string2 + "'\n");
            printStream.print("write_structure='" + string3 + "'\n");
            printStream.print("/\n");
            printStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            this.addMessageln("Save failed !! \n" + exception.getMessage());
            return;
        }
        this.addMessageln("Save ABINIT-MP input file(" + string + ")");
    }

    public Switch createStructureNode() {
        BitSet bitSet = new BitSet();
        Switch switch_ = new Switch(-3);
        int n = 0;
        switch_.setCapability(14);
        switch_.setCapability(18);
        switch_.setCapability(17);
        switch_.setUserData((Object)new String("MolecularStructure"));
        this.chainTable.removeAllElements();
        int n2 = 0;
        for (int i = 0; i < this.fileList.size(); ++i) {
            Object object;
            Object object2;
            ChainData chainData;
            int n3;
            Object object3;
            FileItem fileItem = (FileItem)this.fileList.get(i);
            PdbFile pdbFile = fileItem.getPdbFile();
            if (pdbFile == null) continue;
            if (fileItem.visible) {
                bitSet.set(n);
            }
            ++n;
            Transform3D transform3D = new Transform3D();
            if (fileItem.transformGroup == null) {
                transform3D.setTranslation(new Vector3f(fileItem.coordInfo.xcenter - this.coordInfo.xcenter, fileItem.coordInfo.ycenter - this.coordInfo.ycenter, fileItem.coordInfo.zcenter - this.coordInfo.zcenter));
            } else {
                fileItem.transformGroup.getTransform(transform3D);
            }
            TransformGroup transformGroup = new TransformGroup(transform3D);
            transformGroup.setCapability(13);
            transformGroup.setCapability(14);
            transformGroup.setCapability(17);
            transformGroup.setCapability(18);
            if (fileItem.type == 6 && ((MOL2File)fileItem.file).gridFile == 1) {
                object3 = (MOL2File)fileItem.file;
                n3 = ((MOL2File)object3).connect.length;
                LineArray lineArray = new LineArray(n3 * 2, 5);
                chainData = DisplayPreference.fileColor[n2 % DisplayPreference.fileColor.length].color;
                for (int j = 0; j < n3; ++j) {
                    float f = ((MOL2File)object3).x[((MOL2File)object3).connect[j][0] - 1] - fileItem.coordInfo.xcenter;
                    float f2 = ((MOL2File)object3).y[((MOL2File)object3).connect[j][0] - 1] - fileItem.coordInfo.ycenter;
                    float f3 = ((MOL2File)object3).z[((MOL2File)object3).connect[j][0] - 1] - fileItem.coordInfo.zcenter;
                    lineArray.setCoordinate(j * 2, new Point3f(f, f2, f3));
                    lineArray.setColor(j * 2, (Color3f)chainData);
                    f = ((MOL2File)object3).x[((MOL2File)object3).connect[j][1] - 1] - fileItem.coordInfo.xcenter;
                    f2 = ((MOL2File)object3).y[((MOL2File)object3).connect[j][1] - 1] - fileItem.coordInfo.ycenter;
                    f3 = ((MOL2File)object3).z[((MOL2File)object3).connect[j][1] - 1] - fileItem.coordInfo.zcenter;
                    lineArray.setCoordinate(j * 2 + 1, new Point3f(f, f2, f3));
                    lineArray.setColor(j * 2 + 1, (Color3f)chainData);
                }
                object2 = new Appearance();
                object = new LineAttributes(2.0f, 0, true);
                object2.setLineAttributes((LineAttributes)object);
                Shape3D shape3D = new Shape3D((Geometry)lineArray, (Appearance)object2);
                shape3D.setPickable(false);
                transformGroup.addChild((Node)shape3D);
            } else if (fileItem.type == 13) {
                object3 = (TrajectoryFile)fileItem.file;
                Switch switch_2 = new Switch(0);
                switch_2.setCapability(14);
                switch_2.setCapability(18);
                switch_2.setCapability(17);
                switch_2.setCapability(12);
                for (int j = 0; j < ((TrajectoryFile)object3).stepNum; ++j) {
                    chainData = new TransformGroup();
                    object2 = ((TrajectoryFile)object3).type == 0 || ((TrajectoryFile)object3).type == 2 ? (PdbFile)((TrajectoryFile)object3).files.get(j) : ((XyzFile)((TrajectoryFile)object3).files.get((int)j)).pdbFile;
                    object = ((PdbFile)object2).chains;
                    int n4 = 0;
                    for (int k = 0; k < ((Vector)object).size(); ++k) {
                        ChainData chainData2 = (ChainData)((Vector)object).get(k);
                        MolecularStructure molecularStructure = new MolecularStructure(fileItem, chainData2, this.coordInfo, fileItem.coordInfo, this.moModel, this.moColor, this.residueLabel, this.atomLabel, this.displayResidue, this.displayResidueColor, this.nodeTable, this.inDistanceData, this.selectionList, n4, n2, this.interactionEnergyManyToOneData);
                        molecularStructure.setHBondsEnable(this.hBondsAllEnable, this.hBondsIntermoleculeEnable);
                        chainData.addChild((Node)molecularStructure.getRootNode());
                        ++n4;
                    }
                    switch_2.addChild((Node)chainData);
                }
                BitSet bitSet2 = new BitSet();
                bitSet2.set(0);
                chainData = new Alpha(1, 1000L);
                chainData.setStartTime(System.currentTimeMillis());
                chainData.setIncreasingAlphaDuration(10000L);
                chainData.setDecreasingAlphaDuration(10000L);
                chainData.setLoopCount(1);
                object2 = new MySwitchValueInterpolator((Alpha)chainData, switch_2, this.me);
                object2.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0));
                object2.setFirstChildIndex(0);
                object2.setLastChildIndex(0);
                object2.setEnable(false);
                transformGroup.addChild((Node)switch_2);
                this.sceneViewer.detach();
                this.sceneViewer.getRoot().addChild((Node)object2);
                this.sceneViewer.addBranchGraph();
                ((TrajectoryFile)object3).setTrajectoryRoot(switch_2);
                ((TrajectoryFile)object3).setAlpha((Alpha)chainData);
                ((TrajectoryFile)object3).setInterpolator((MySwitchValueInterpolator)((Object)object2));
                if (((TrajectoryFile)object3).getTrajectoryControlWindow() != null) {
                    object = ((TrajectoryFile)object3).getTrajectoryControlWindow().getVideoControlPanel();
                    ((VideoControlPanel)object).reset((TrajectoryFile)object3);
                    ((MySwitchValueInterpolator)((Object)object2)).setVideoControlPanel((VideoControlPanel)object);
                }
                fileItem.transformGroup = transformGroup;
            } else {
                object3 = pdbFile.chains;
                n3 = 0;
                for (int j = 0; j < ((Vector)object3).size(); ++j) {
                    chainData = (ChainData)((Vector)object3).get(j);
                    object2 = new MolecularStructure(fileItem, chainData, this.coordInfo, fileItem.coordInfo, this.moModel, this.moColor, this.residueLabel, this.atomLabel, this.displayResidue, this.displayResidueColor, this.nodeTable, this.inDistanceData, this.selectionList, n3, n2, this.interactionEnergyManyToOneData);
                    this.chainTable.add(object2);
                    ((MolecularStructure)object2).setHBondsEnable(this.hBondsAllEnable, this.hBondsIntermoleculeEnable);
                    transformGroup.addChild((Node)((MolecularStructure)object2).getRootNode());
                    ++n3;
                }
                if (fileItem.transformGroup == null) {
                    BranchGroup branchGroup = this.createDirectionNode(this.coordInfo, fileItem);
                    chainData = (Switch)branchGroup.getChild(0);
                    object2 = new BoundingSphere(new Point3d(), 100.0);
                    object = new SimpleKeyBehavior(transformGroup, fileItem, this.coordInfo);
                    object.setEnable(true);
                    object.setSchedulingBounds((Bounds)object2);
                    fileItem.setPdbFileInfo(transformGroup, (Switch)chainData, branchGroup, (SimpleKeyBehavior)((Object)object));
                    this.sceneViewer.addNode((Node)object);
                    transformGroup.addChild((Node)branchGroup);
                } else {
                    fileItem.keyBehavior.setTransformGroup(transformGroup);
                    fileItem.directionAxisBrRoot.detach();
                    fileItem.transformGroup = transformGroup;
                    transformGroup.addChild((Node)fileItem.directionAxisBrRoot);
                }
            }
            object3 = new BranchGroup();
            object3.addChild((Node)transformGroup);
            object3.compile();
            switch_.addChild((Node)object3);
            if (fileItem.type != 4 && fileItem.type != 5 && fileItem.type != 6 && fileItem.type != 7 && fileItem.type != 8 && fileItem.type != 9 && fileItem.type != 10 && fileItem.type != 11 && fileItem.type != 13) continue;
            ++n2;
        }
        this.setDirectionDisplay();
        switch_.setChildMask(bitSet);
        return switch_;
    }

    public void clearConnectTable() {
        for (int i = 0; i < this.fileList.size(); ++i) {
            Object object;
            Object object2;
            FileItem fileItem = (FileItem)this.fileList.get(i);
            if (fileItem.type == 13) {
                object2 = (TrajectoryFile)fileItem.file;
                for (int j = 0; j < ((TrajectoryFile)object2).stepNum; ++j) {
                    TransformGroup transformGroup = new TransformGroup();
                    object = ((TrajectoryFile)object2).getPdbFile(j);
                    Vector vector = ((PdbFile)object).chains;
                    for (int k = 0; k < vector.size(); ++k) {
                        ChainData chainData = (ChainData)vector.get(k);
                        chainData.atomConnect = null;
                    }
                }
                continue;
            }
            object2 = fileItem.getPdbFile();
            Vector vector = ((PdbFile)object2).chains;
            for (int j = 0; j < vector.size(); ++j) {
                object = (ChainData)vector.get(j);
                ((ChainData)object).atomConnect = null;
            }
        }
    }

    public Switch createIsosurfaceNode() {
        Switch switch_ = new Switch(-3);
        BitSet bitSet = new BitSet();
        int n = 0;
        switch_.setCapability(14);
        switch_.setCapability(18);
        switch_.setCapability(17);
        switch_.setUserData((Object)new String("Isosurface"));
        for (int i = 0; i < this.fileList.size(); ++i) {
            TransformGroup transformGroup;
            TransformGroup transformGroup2;
            GridFile gridFile;
            FileItem fileItem = (FileItem)this.fileList.get(i);
            if (fileItem.type != 0 && fileItem.type != 1 && fileItem.type != 3 && fileItem.type != 2 && fileItem.type != 8 && fileItem.type != 9 && fileItem.type != 10 && fileItem.type != 12 && fileItem.type != 14) continue;
            BranchGroup branchGroup = new BranchGroup();
            if (fileItem.type == 12) {
                gridFile = (ElectricFieldFile)fileItem.file;
                transformGroup2 = new ElectricFieldNode();
                transformGroup = transformGroup2.createNode((ElectricFieldFile)gridFile, fileItem.electricFieldAssignValue, this.coordInfo);
                branchGroup.addChild((Node)transformGroup);
            } else {
                gridFile = (GridFile)fileItem.file;
                transformGroup2 = new Isosurface(fileItem.type);
                if (fileItem.type == 8 || fileItem.type == 9 || fileItem.type == 10) {
                    transformGroup2.setGaussianCubeFile((GaussianCubeFile)fileItem.file);
                }
                transformGroup = transformGroup2.createNode(gridFile, fileItem.isosurfaceValue, this.coordInfo);
                branchGroup.addChild((Node)transformGroup);
                branchGroup.compile();
            }
            switch_.addChild((Node)branchGroup);
            if (fileItem.visible) {
                bitSet.set(n);
            }
            if (fileItem.isosurfaceValueWindow != null && fileItem.isosurfaceValueWindow.getIsosurfaceValuePanel().getSectionAssignWindow() != null) {
                fileItem.isosurfaceValueWindow.getIsosurfaceValuePanel().getSectionAssignWindow().getSectionAssignPanel().createSectionNode(null);
                fileItem.isosurfaceValueWindow.getIsosurfaceValuePanel().getSectionAssignWindow().getSectionAssignPanel().moveSectionAssignNode();
                if (!fileItem.visible) {
                    fileItem.isosurfaceValueWindow.getIsosurfaceValuePanel().getSectionAssignWindow().getSectionAssignPanel().undisplaySectionPlane();
                }
            }
            ++n;
        }
        switch_.setChildMask(bitSet);
        return switch_;
    }

    private void execEdit(UndoData undoData) {
        block5: {
            Vector vector;
            block4: {
                vector = undoData.data;
                if (undoData.type != 1) break block4;
                for (int i = 0; i < vector.size(); ++i) {
                    Object e = vector.get(i);
                    if (e instanceof ResidueData) {
                        ((ResidueData)e).setCutFlag(this.getAtomTable((ResidueData)e), true);
                        continue;
                    }
                    ((AtomData)e).cutFlag = true;
                }
                break block5;
            }
            if (undoData.type != 2) break block5;
            this.setAllCutFlag(true);
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.get(i);
                if (e instanceof ResidueData) {
                    ((ResidueData)e).setCutFlag(this.getAtomTable((ResidueData)e), false);
                    continue;
                }
                ((AtomData)e).cutFlag = false;
            }
        }
    }

    private void setAllCutFlag(boolean bl) {
        for (int i = 0; i < this.fileList.size(); ++i) {
            FileItem fileItem = (FileItem)this.fileList.get(i);
            PdbFile pdbFile = fileItem.getPdbFile();
            if (pdbFile == null) continue;
            Vector vector = pdbFile.chains;
            for (int j = 0; j < vector.size(); ++j) {
                Object object;
                ChainData chainData = (ChainData)vector.get(j);
                Vector vector2 = chainData.residueTable;
                for (int k = 0; k < vector2.size(); ++k) {
                    object = (ResidueData)vector2.get(k);
                    ((ResidueData)object).cutFlag = bl;
                }
                Vector vector3 = chainData.atomTable;
                for (int k = 0; k < vector3.size(); ++k) {
                    AtomData atomData = (AtomData)vector3.get(k);
                    atomData.cutFlag = bl;
                }
                object = chainData.hemTable;
                for (int k = 0; k < ((Vector)object).size(); ++k) {
                    AtomData atomData = (AtomData)vector3.get(k);
                    atomData.cutFlag = bl;
                }
            }
        }
    }

    private Vector getAtomTable(ResidueData residueData) {
        for (int i = 0; i < this.fileList.size(); ++i) {
            FileItem fileItem = (FileItem)this.fileList.get(i);
            PdbFile pdbFile = fileItem.getPdbFile();
            if (pdbFile == null) continue;
            Vector vector = pdbFile.chains;
            Object var6_6 = null;
            for (int j = 0; j < vector.size(); ++j) {
                ResidueData residueData2;
                int n;
                ChainData chainData = (ChainData)vector.get(j);
                Vector vector2 = chainData.residueTable;
                for (n = 0; n < vector2.size(); ++n) {
                    residueData2 = (ResidueData)vector2.get(n);
                    if (residueData2 != residueData) continue;
                    return chainData.atomTable;
                }
                vector2 = chainData.hemResidueTable;
                for (n = 0; n < vector2.size(); ++n) {
                    residueData2 = (ResidueData)vector2.get(n);
                    if (residueData2 != residueData) continue;
                    return chainData.hemTable;
                }
            }
        }
        return null;
    }

    public void popupAttributeWindow(Node node) {
        if (this.moColor != 13 && node.getUserData() instanceof NodeData) {
            NodeData nodeData = (NodeData)node.getUserData();
            NodeData nodeData2 = null;
            if (this.selectionMode == 3 && nodeData.atomData != null) {
                nodeData2 = (NodeData)this.nodeTable.get(nodeData.atomData);
            } else if (this.selectionMode == 2 && nodeData.residueData != null) {
                nodeData2 = (NodeData)this.nodeTable.get(nodeData.residueData);
            }
            if (nodeData2 == null) {
                nodeData2 = new NodeData();
            }
            BaseDialog baseDialog = new BaseDialog(this.me, new DisplayAttributePanel(nodeData2, this.selectionMode, this), MyResourceBundle.getResourceString("DisplayAttributePanel.title"));
            baseDialog.setModal(false);
            baseDialog.setVisible(true);
        }
    }

    public void popupAttributeWindow(SelectionData selectionData) {
        MolecularStructure molecularStructure;
        Node node = null;
        if (selectionData == null) {
            return;
        }
        for (int i = 0; i < this.chainTable.size() && (node = (molecularStructure = (MolecularStructure)this.chainTable.get(i)).getNodeData(selectionData)) == null; ++i) {
        }
        if (node != null) {
            this.popupAttributeWindow(node);
        }
    }

    public void setDisplayAttribute(NodeData nodeData) {
        for (int i = 0; i < this.selectionList.size(); ++i) {
            SelectionData selectionData = (SelectionData)this.selectionList.get(i);
            if (selectionData.type != nodeData.type) continue;
            if (selectionData.type == 2) {
                this.nodeTable.remove(selectionData.residueData);
                this.nodeTable.put(selectionData.residueData, nodeData);
                continue;
            }
            if (selectionData.type != 3) continue;
            this.nodeTable.remove(selectionData.atomData);
            this.nodeTable.put(selectionData.atomData, nodeData);
        }
        if (this.moColor != 12) {
            this.clearHighlightSelection(false);
        } else {
            this.highlightSelection();
        }
    }

    public void selectNodeFromStructureViewer(AtomData atomData) {
        for (int i = 0; i < this.treeTabPanel.getTabCount(); ++i) {
            TreePanel treePanel = (TreePanel)this.treeTabPanel.getComponentAt(i);
            if (treePanel.selectNodeFromStructureViewer(atomData) == 0) continue;
            this.treeTabPanel.setSelectedIndex(i);
            break;
        }
    }

    public void pickNode(Node node, boolean bl, boolean bl2, int n) {
        if (node != null) {
            Object object = node.getUserData();
            if (object instanceof AtomData) {
                this.highlightBounbaryNode((AtomData)object);
                return;
            }
            if (object instanceof TransformGroup) {
                return;
            }
            NodeData nodeData = (NodeData)object;
            if (nodeData != null) {
                if (nodeData.type == 1) {
                    String string = nodeData.chainData.id;
                } else if (nodeData.type == 2) {
                    String string = nodeData.residueData.name;
                } else if (nodeData.type == 3) {
                    Object object2;
                    Object object3;
                    Object object4;
                    AtomData atomData;
                    Object object5;
                    AtomData atomData2 = nodeData.atomData;
                    ResidueData residueData = nodeData.residueData;
                    ChainData chainData = nodeData.chainData;
                    String string = atomData2.fragmentNo == 0 ? atomData2.allAtomName + "(" + atomData2.no + ") " + residueData.name + residueData.no + " " : new String("Fragment " + atomData2.fragmentNo + " " + atomData2.allAtomName + "(" + atomData2.no + ") " + residueData.name + residueData.no + " charge " + atomData2.mulliken + " ");
                    if (chainData.id != null && !chainData.id.equals("CPF")) {
                        string = string + chainData.id;
                    }
                    this.selectNodeFromStructureViewer(atomData2);
                    this.addMessageln(string);
                    int n2 = this.treeTabPanel.getSelectedIndex();
                    if (n2 == -1) {
                        return;
                    }
                    FileItem fileItem = ((TreePanel)this.treeTabPanel.getComponentAt((int)n2)).fileItem;
                    if (this.ajfFileWindow != null) {
                        this.ajfFileWindow.setAtom(atomData2);
                    }
                    float[] fArray = new float[3];
                    this.getCoordinate(atomData2, fileItem, fArray);
                    if (this.calculateChargeWindow != null) {
                        this.calculateChargeWindow.setNumber(residueData.no, atomData2.fragmentNo, atomData2.no);
                    }
                    if (this.distanceFlag == 1) {
                        this.addMessageln("Click second item");
                        this.distanceFlag = 2;
                        this.firstAtomData = atomData2;
                        this.firstFileItem = fileItem;
                        object5 = new float[3];
                        this.getCoordinate(atomData2, this.firstFileItem, (float[])object5);
                        this.monitorNode.addPickedNode(this.moModel, this.coordInfo, (float)object5[0], (float)object5[1], (float)object5[2], 0.0f, 0);
                    } else if (this.distanceFlag == 2) {
                        object5 = fileItem;
                        atomData = this.firstAtomData;
                        object4 = atomData2;
                        object3 = new float[3];
                        object2 = new float[3];
                        this.getCoordinate(atomData, this.firstFileItem, (float[])object3);
                        this.getCoordinate((AtomData)object4, (FileItem)object5, (float[])object2);
                        float f = (float)Math.sqrt((object3[0] - object2[0]) * (object3[0] - object2[0]) + (object3[1] - object2[1]) * (object3[1] - object2[1]) + (object3[2] - object2[2]) * (object3[2] - object2[2]));
                        this.addMessageln("Distance of " + atomData.allAtomName + " to " + ((AtomData)object4).allAtomName + " : " + f);
                        this.distanceFlag = 1;
                        this.monitorNode.addPickedNode(this.moModel, this.coordInfo, object2[0], object2[1], object2[2], f, 2);
                    }
                    if (this.interactionFlag == 1) {
                        this.firstFileItem = fileItem;
                        if (this.firstFileItem.type != 5) {
                            this.addMessageln("No interaction energy data.");
                            this.interactionFlag = 0;
                            this.setDefaultCursor();
                        } else {
                            this.addMessageln("Click second flagment");
                            this.interactionFlag = 2;
                            this.firstAtomData = atomData2;
                            this.monitorNode.addPickedNode(this.moModel, this.coordInfo, fArray[0], fArray[1], fArray[2], 0.0f, 0);
                        }
                    } else if (this.interactionFlag == 2) {
                        double d = 0.0;
                        if (this.firstFileItem != fileItem) {
                            this.addMessageln("No interaction between different file. ");
                        } else {
                            object4 = (CheckPointFile)this.firstFileItem.file;
                            object3 = new DecimalFormat("0.000000");
                            d = ((CheckPointFile)object4).interactionEnergy[this.firstAtomData.fragmentNo - 1][atomData2.fragmentNo - 1];
                            this.addMessageln("Energy  " + ((NumberFormat)object3).format(d) + " [kcal/mol] between " + this.firstAtomData.fragmentNo + " and " + atomData2.fragmentNo);
                        }
                        this.interactionFlag = 3;
                        this.monitorNode.addPickedNode(this.moModel, this.coordInfo, fArray[0], fArray[1], fArray[2], (float)d, 2);
                    }
                    if (this.angleFlag == 1 || this.angleFlag == 2) {
                        this.addMessageln("Click next Atom");
                        if (this.angleFlag == 1) {
                            this.point1 = new Point3f(fArray);
                            this.monitorNode.addPickedNode(this.moModel, this.coordInfo, fArray[0], fArray[1], fArray[2], 0.0f, 0);
                        } else {
                            this.point2 = new Point3f(fArray);
                            this.monitorNode.addPickedNode(this.moModel, this.coordInfo, fArray[0], fArray[1], fArray[2], 0.0f, 1);
                        }
                        ++this.angleFlag;
                    } else if (this.angleFlag == 3) {
                        this.point3 = new Point3f(fArray);
                        Point3f point3f = new Point3f();
                        point3f.sub((Tuple3f)this.point1, (Tuple3f)this.point2);
                        atomData = new Vector3d((Tuple3f)point3f);
                        point3f.sub((Tuple3f)this.point3, (Tuple3f)this.point2);
                        object4 = new Vector3d((Tuple3f)point3f);
                        double d = atomData.angle((Vector3d)object4) / Math.PI * 180.0;
                        DecimalFormat decimalFormat = new DecimalFormat("0.000");
                        this.addMessageln("angle  = " + decimalFormat.format(d) + "[deg]");
                        this.monitorNode.addPickedNode(this.moModel, this.coordInfo, fArray[0], fArray[1], fArray[2], (float)d, 3);
                        this.angleFlag = 1;
                    }
                    if (1 <= this.dihedralFlag && this.dihedralFlag <= 3) {
                        this.addMessageln("Click next Atom");
                        if (this.dihedralFlag == 1) {
                            this.point1 = new Point3f(fArray);
                            this.monitorNode.addPickedNode(this.moModel, this.coordInfo, fArray[0], fArray[1], fArray[2], 0.0f, 0);
                        } else if (this.dihedralFlag == 2) {
                            this.point2 = new Point3f(fArray);
                            this.monitorNode.addPickedNode(this.moModel, this.coordInfo, fArray[0], fArray[1], fArray[2], 0.0f, 1);
                        } else {
                            this.point3 = new Point3f(fArray);
                            this.monitorNode.addPickedNode(this.moModel, this.coordInfo, fArray[0], fArray[1], fArray[2], 0.0f, 1);
                        }
                        ++this.dihedralFlag;
                    } else if (this.dihedralFlag == 4) {
                        this.point4 = new Point3f(fArray);
                        Point3f point3f = new Point3f(fArray);
                        point3f.sub((Tuple3f)this.point1, (Tuple3f)this.point2);
                        atomData = new Vector3d((Tuple3f)point3f);
                        point3f.sub((Tuple3f)this.point3, (Tuple3f)this.point2);
                        object4 = new Vector3d((Tuple3f)point3f);
                        point3f.sub((Tuple3f)this.point2, (Tuple3f)this.point3);
                        Vector3d vector3d = new Vector3d((Tuple3f)point3f);
                        point3f.sub((Tuple3f)this.point4, (Tuple3f)this.point3);
                        object2 = new Vector3d((Tuple3f)point3f);
                        Vector3d vector3d2 = new Vector3d();
                        Vector3d vector3d3 = new Vector3d();
                        vector3d2.cross((Vector3d)atomData, (Vector3d)object4);
                        vector3d3.cross(vector3d, (Vector3d)object2);
                        double d = Math.acos(vector3d2.dot(vector3d3) / (vector3d2.length() * vector3d3.length())) / Math.PI * 180.0;
                        DecimalFormat decimalFormat = new DecimalFormat("0.000");
                        this.addMessageln("dihedral = " + decimalFormat.format(d) + "[deg]");
                        this.monitorNode.addPickedNode(this.moModel, this.coordInfo, fArray[0], fArray[1], fArray[2], (float)d, 4);
                        this.dihedralFlag = 1;
                    }
                    if (this.interactionFlag == 0 && this.moColor != 13) {
                        this.setWaitCursor();
                        if (!bl && !bl2) {
                            this.clearHighlightSelection(true);
                        } else {
                            this.clearHighlightSelection(false);
                        }
                        int n3 = this.getSelectedTabIndex();
                        int n4 = this.selectionMode == 2 ? residueData.no : atomData2.no;
                        if (!bl2) {
                            boolean bl3 = false;
                            for (int i = 0; i < this.selectionList.size(); ++i) {
                                object2 = (SelectionData)this.selectionList.get(i);
                                if (object2.type == this.selectionMode) {
                                    if (object2.type == 2) {
                                        if (object2.residueData == residueData) {
                                            bl3 = true;
                                        }
                                    } else if (object2.atomData == atomData2) {
                                        bl3 = true;
                                    }
                                }
                                if (!bl3 || n != 1) continue;
                                if (this.selectionList.size() > 1) {
                                    this.selectionList.remove(i);
                                    break;
                                }
                                this.clearHighlightSelection(true);
                                break;
                            }
                            if (!bl3) {
                                this.selectionList.add(new SelectionData(this.selectionMode, residueData, atomData2, nodeData));
                                this.setOverlayInfo(n3, n4);
                                this.setFragmentInfo(atomData2.fragmentNo);
                            }
                        } else {
                            boolean bl4;
                            block72: {
                                bl4 = false;
                                try {
                                    int n5;
                                    int n6;
                                    int n7;
                                    if (this.selectionList.size() <= 0) break block72;
                                    SelectionData selectionData = (SelectionData)this.selectionList.get(0);
                                    if (selectionData.nodeData == null || selectionData.nodeData.chainData != nodeData.chainData || selectionData.type != this.selectionMode) break block72;
                                    if (selectionData.type == 2) {
                                        int n8;
                                        int n9;
                                        int n10;
                                        if (selectionData.residueData.no > residueData.no) {
                                            n10 = residueData.no;
                                            n9 = selectionData.residueData.no;
                                        } else {
                                            n10 = selectionData.residueData.no;
                                            n9 = residueData.no;
                                        }
                                        int n11 = n9 - n10;
                                        this.selectionList.removeAllElements();
                                        Vector vector = nodeData.chainData.residueTable;
                                        Vector vector2 = nodeData.chainData.atomTable;
                                        for (n8 = 0; n8 < vector.size() && ((ResidueData)vector.get((int)n8)).no != n10; ++n8) {
                                        }
                                        if (n8 > vector.size()) {
                                            vector = nodeData.chainData.hemResidueTable;
                                            vector2 = nodeData.chainData.hemTable;
                                            for (n8 = 0; n8 < vector.size() && ((ResidueData)vector.get((int)n8)).no != n10; ++n8) {
                                            }
                                        }
                                        if (n8 >= vector.size()) break block72;
                                        if (n10 == selectionData.residueData.no) {
                                            for (int i = 0; i <= n11; ++i) {
                                                ResidueData residueData2 = (ResidueData)vector.get(n8 + i);
                                                AtomData atomData3 = (AtomData)vector2.get(residueData2.startNo);
                                                this.selectionList.add(new SelectionData(this.selectionMode, residueData2, atomData3, nodeData));
                                                this.setOverlayInfo(n3, residueData2.no);
                                                this.setFragmentInfo(atomData3.fragmentNo);
                                            }
                                        } else {
                                            for (int i = 0; i <= n11; ++i) {
                                                ResidueData residueData3 = (ResidueData)vector.get(n8 + n11 - i);
                                                AtomData atomData4 = (AtomData)vector2.get(residueData3.startNo);
                                                this.selectionList.add(new SelectionData(this.selectionMode, residueData3, atomData4, nodeData));
                                                this.setOverlayInfo(n3, residueData3.no);
                                                this.setFragmentInfo(atomData4.fragmentNo);
                                            }
                                        }
                                        bl4 = true;
                                        break block72;
                                    }
                                    if (selectionData.atomData.no > atomData2.no) {
                                        n7 = atomData2.no;
                                        n6 = selectionData.atomData.no;
                                    } else {
                                        n7 = selectionData.atomData.no;
                                        n6 = atomData2.no;
                                    }
                                    int n12 = n6 - n7;
                                    this.selectionList.removeAllElements();
                                    Vector vector = nodeData.chainData.residueTable;
                                    Vector vector3 = nodeData.chainData.atomTable;
                                    for (n5 = 0; n5 < vector3.size() && ((AtomData)vector3.get((int)n5)).no != n7; ++n5) {
                                    }
                                    if (n5 > vector3.size()) {
                                        vector = nodeData.chainData.hemResidueTable;
                                        vector3 = nodeData.chainData.hemTable;
                                        for (n5 = 0; n5 < vector3.size() && ((AtomData)vector3.get((int)n5)).no != n7; ++n5) {
                                        }
                                    }
                                    if (n5 >= vector3.size()) break block72;
                                    if (n7 == selectionData.atomData.no) {
                                        boolean bl5 = false;
                                        for (int i = 0; i <= n12; ++i) {
                                            AtomData atomData5 = (AtomData)vector3.get(n5 + i);
                                            this.selectionList.add(new SelectionData(this.selectionMode, atomData5.residueData, atomData5, nodeData));
                                            this.setOverlayInfo(n3, atomData5.no);
                                            this.setFragmentInfo(atomData5.fragmentNo);
                                        }
                                    } else {
                                        int n13 = vector.size() - 1;
                                        for (int i = 0; i <= n12; ++i) {
                                            AtomData atomData6 = (AtomData)vector3.get(n5 + n12 - i);
                                            this.selectionList.add(new SelectionData(this.selectionMode, atomData6.residueData, atomData6, nodeData));
                                            this.setOverlayInfo(n3, atomData6.no);
                                            this.setFragmentInfo(atomData6.fragmentNo);
                                        }
                                    }
                                    bl4 = true;
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                    System.out.println("error");
                                }
                            }
                            if (!bl4) {
                                this.selectionList.removeAllElements();
                                this.selectionList.add(new SelectionData(this.selectionMode, residueData, atomData2, nodeData));
                            }
                        }
                        this.highlightSelection();
                        this.setDefaultCursor();
                    }
                    if (this.interactionFlag == 3) {
                        this.interactionFlag = 1;
                    }
                } else {
                    String string = "???";
                }
            }
        }
    }

    private void getCoordinate(AtomData atomData, FileItem fileItem, float[] fArray) {
        Transform3D transform3D = new Transform3D();
        Matrix4d matrix4d = new Matrix4d();
        Transform3D transform3D2 = new Transform3D();
        Transform3D transform3D3 = new Transform3D();
        fileItem.transformGroup.getTransform(transform3D);
        transform3D2.setTranslation(new Vector3f(atomData.coordX - fileItem.coordInfo.xcenter + this.coordInfo.xcenter, atomData.coordY - fileItem.coordInfo.ycenter + this.coordInfo.ycenter, atomData.coordZ - fileItem.coordInfo.zcenter + this.coordInfo.zcenter));
        transform3D3.mul(transform3D, transform3D2);
        transform3D3.get(matrix4d);
        fArray[0] = (float)matrix4d.m03 + fileItem.coordInfo.xcenter;
        fArray[1] = (float)matrix4d.m13 + fileItem.coordInfo.ycenter;
        fArray[2] = (float)matrix4d.m23 + fileItem.coordInfo.zcenter;
    }

    public void highlightSelection() {
        if (this.selectionList.size() > 0) {
            if (this.moColor == 12) {
                this.setWaitCursor();
                this.moRootNode = this.createStructureNode();
                this.sceneViewer.replaceMoNode(this.moRootNode);
                this.setDefaultCursor();
            } else {
                for (int i = 0; i < this.chainTable.size(); ++i) {
                    MolecularStructure molecularStructure = (MolecularStructure)this.chainTable.get(i);
                    molecularStructure.highlightSelection(this.moModel, this.moColor, this.residueLabel, this.atomLabel, this.selectionList, this.nodeTable, this.inDistanceData);
                }
            }
        }
    }

    public void clearHighlightSelection(boolean bl) {
        if (this.selectionList.size() > 0) {
            for (int i = 0; i < this.chainTable.size(); ++i) {
                MolecularStructure molecularStructure = (MolecularStructure)this.chainTable.get(i);
                molecularStructure.clearHighlightSelection(this.moModel, this.moColor, this.residueLabel, this.atomLabel, this.selectionList, this.nodeTable, this.inDistanceData);
            }
            if (bl) {
                this.selectionList.removeAllElements();
            }
        }
    }

    public void clearNodeTable() {
        this.setWaitCursor();
        for (int i = 0; i < this.fileList.size(); ++i) {
            FileItem fileItem = (FileItem)this.fileList.get(i);
            PdbFile pdbFile = fileItem.getPdbFile();
            if (pdbFile == null) continue;
            Vector vector = pdbFile.chains;
            for (int j = 0; j < vector.size(); ++j) {
                ResidueData residueData;
                int n;
                ChainData chainData = (ChainData)vector.get(j);
                for (n = 0; n < chainData.residueTable.size(); ++n) {
                    residueData = (ResidueData)chainData.residueTable.get(n);
                    residueData.inDisplayFlag = true;
                }
                for (n = 0; n < chainData.hemResidueTable.size(); ++n) {
                    residueData = (ResidueData)chainData.hemResidueTable.get(n);
                    residueData.inDisplayFlag = true;
                }
            }
        }
        this.hBondsAllEnable = false;
        this.hBondsIntermoleculeEnable = false;
        this.hBondsAllMenu.setForeground(Color.black);
        this.hBondsIntermoleculeMenu.setForeground(Color.black);
        this.selectionList.removeAllElements();
        this.nodeTable.clear();
        this.inDistanceData = null;
        this.residueLabel = 0;
        this.atomLabel = 0;
        this.moColor = 1;
        this.moRootNode = this.createStructureNode();
        this.monitorNode.clearPickedNode();
        this.sceneViewer.replaceMoNode(this.moRootNode);
        this.setDefaultCursor();
    }

    public Object getNodeData(Object object) {
        return this.nodeTable.get(object);
    }

    public void displayMoNode() {
        if (this.periodicWindow != null && this.periodicWindow.isVisible()) {
            this.periodicWindow.redrawCanvas();
        } else {
            this.setWaitCursor();
            this.moRootNode = this.createStructureNode();
            this.sceneViewer.replaceMoNode(this.moRootNode);
            this.setDefaultCursor();
        }
        if (this.moColor == 7) {
            for (int i = 0; i < this.treeTabPanel.getTabCount(); ++i) {
                this.treeTabPanel.setForegroundAt(i, DisplayPreference.fileColor[i % DisplayPreference.fileColor.length].color.get());
            }
        }
    }

    public void displayIsosurfaceNode() {
        this.isoRootNode = this.createIsosurfaceNode();
        this.sceneViewer.replaceIsoNode(this.isoRootNode);
    }

    public void reCreateNode() {
        this.setWaitCursor();
        this.moRootNode = this.createStructureNode();
        this.sceneViewer.setSceneGraph(this.moRootNode);
        this.isoRootNode = this.createIsosurfaceNode();
        this.sceneViewer.addNode((Node)this.isoRootNode);
        this.sceneViewer.connectSectionControl();
        this.setDefaultCursor();
    }

    public void setBackgroundColor(Color color) {
        this.sceneViewer.setBackgroundColor(color);
        DisplayPreference.backgroundColor = color;
    }

    public void setRotationSpeed() {
        this.sceneViewer.setRotationSpeed();
    }

    public void setSelection(SelectionData selectionData) {
        if (selectionData.type == 2) {
            this.residueSelectionMenu.setSelected(true);
            this.selectionMode = 2;
        } else {
            this.atomSelectionMenu.setSelected(true);
            this.selectionMode = 3;
        }
        this.clearHighlightSelection(true);
        this.selectionList.add(selectionData);
    }

    public void addSelection(SelectionData selectionData) {
        if (selectionData.type == 2) {
            this.residueSelectionMenu.setSelected(true);
            this.selectionMode = 2;
        } else {
            this.atomSelectionMenu.setSelected(true);
            this.selectionMode = 3;
        }
        this.selectionList.add(selectionData);
    }

    public void setSelectionMode(int n) {
        if (n == 2) {
            this.residueSelectionMenu.setSelected(true);
            this.selectionMode = 2;
        } else {
            this.atomSelectionMenu.setSelected(true);
            this.selectionMode = 3;
        }
    }

    private BranchGroup createDirectionNode(CoordInfo coordInfo, FileItem fileItem) {
        CoordInfo coordInfo2 = fileItem.coordInfo;
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        branchGroup.setCapability(14);
        branchGroup.setCapability(12);
        branchGroup.setCapability(13);
        Switch switch_ = new Switch(-1);
        switch_.setCapability(14);
        switch_.setCapability(13);
        switch_.setCapability(18);
        switch_.setCapability(17);
        Transform3D transform3D = new Transform3D();
        TransformGroup transformGroup = new TransformGroup();
        Color3f color3f = new Color3f(Color.orange);
        Color3f color3f2 = new Color3f(Color.magenta);
        Color3f color3f3 = new Color3f(Color.cyan);
        float f = 1.0f;
        LineArray lineArray = new LineArray(6, 5);
        lineArray.setCoordinate(0, new Point3f(-f, 0.0f, 0.0f));
        lineArray.setCoordinate(1, new Point3f(f, 0.0f, 0.0f));
        lineArray.setCoordinate(2, new Point3f(0.0f, -f, 0.0f));
        lineArray.setCoordinate(3, new Point3f(0.0f, f, 0.0f));
        lineArray.setCoordinate(4, new Point3f(0.0f, 0.0f, -f));
        lineArray.setCoordinate(5, new Point3f(0.0f, 0.0f, f));
        lineArray.setColor(0, color3f);
        lineArray.setColor(1, color3f);
        lineArray.setColor(2, color3f2);
        lineArray.setColor(3, color3f2);
        lineArray.setColor(4, color3f3);
        lineArray.setColor(5, color3f3);
        LineAttributes lineAttributes = new LineAttributes(2.0f, 0, true);
        Appearance appearance = new Appearance();
        appearance.setLineAttributes(lineAttributes);
        Shape3D shape3D = new Shape3D((Geometry)lineArray, appearance);
        shape3D.setPickable(false);
        transformGroup.addChild((Node)shape3D);
        Appearance appearance2 = new Appearance();
        appearance2.setMaterial(new Material(color3f, color3f, color3f, color3f, 100.0f));
        Appearance appearance3 = new Appearance();
        appearance3.setMaterial(new Material(color3f2, color3f2, color3f2, color3f2, 100.0f));
        Appearance appearance4 = new Appearance();
        appearance4.setMaterial(new Material(color3f3, color3f3, color3f3, color3f3, 100.0f));
        float f2 = f * 0.1f;
        float f3 = f * 0.4f;
        float f4 = 0.8f * f;
        Transform3D transform3D2 = new Transform3D();
        transform3D2.rotZ(-1.5707963267948966);
        transform3D2.setTranslation(new Vector3f(f4, 0.0f, 0.0f));
        TransformGroup transformGroup2 = new TransformGroup(transform3D2);
        Cone cone = new Cone(f2, f3);
        cone.setAppearance(appearance2);
        cone.setPickable(false);
        transformGroup2.addChild((Node)cone);
        transformGroup.addChild((Node)transformGroup2);
        transform3D2 = new Transform3D();
        transform3D2.rotZ(1.5707963267948966);
        transform3D2.setTranslation(new Vector3f(-f4, 0.0f, 0.0f));
        transformGroup2 = new TransformGroup(transform3D2);
        cone = new Cone(f2, f3);
        cone.setAppearance(appearance2);
        cone.setPickable(false);
        transformGroup2.addChild((Node)cone);
        transformGroup.addChild((Node)transformGroup2);
        Transform3D transform3D3 = new Transform3D();
        transform3D3.setTranslation(new Vector3f(0.0f, f4, 0.0f));
        TransformGroup transformGroup3 = new TransformGroup(transform3D3);
        Cone cone2 = new Cone(f2, f3);
        cone2.setAppearance(appearance3);
        cone2.setPickable(false);
        transformGroup3.addChild((Node)cone2);
        transformGroup.addChild((Node)transformGroup3);
        transform3D3 = new Transform3D();
        transform3D3.rotX(Math.PI);
        transform3D3.setTranslation(new Vector3f(0.0f, -f4, 0.0f));
        transformGroup3 = new TransformGroup(transform3D3);
        cone2 = new Cone(f2, f3);
        cone2.setAppearance(appearance3);
        cone2.setPickable(false);
        transformGroup3.addChild((Node)cone2);
        transformGroup.addChild((Node)transformGroup3);
        Transform3D transform3D4 = new Transform3D();
        transform3D4.rotX(1.5707963267948966);
        transform3D4.setTranslation(new Vector3f(0.0f, 0.0f, f4));
        TransformGroup transformGroup4 = new TransformGroup(transform3D4);
        Cone cone3 = new Cone(f2, f3);
        cone3.setAppearance(appearance4);
        cone3.setPickable(false);
        transformGroup4.addChild((Node)cone3);
        transformGroup.addChild((Node)transformGroup4);
        transform3D4 = new Transform3D();
        transform3D4.rotX(-1.5707963267948966);
        transform3D4.setTranslation(new Vector3f(0.0f, 0.0f, -f4));
        transformGroup4 = new TransformGroup(transform3D4);
        cone3 = new Cone(f2, f3);
        cone3.setAppearance(appearance4);
        cone3.setPickable(false);
        transformGroup4.addChild((Node)cone3);
        transformGroup.addChild((Node)transformGroup4);
        Font3D font3D = new Font3D(new Font("Century Gothic", 0, 1), new FontExtrusion());
        Point3f point3f = new Point3f(3.0f, -0.4f, 0.0f);
        Transform3D transform3D5 = new Transform3D();
        transform3D5.setScale((double)(f *= 0.4f));
        TransformGroup transformGroup5 = new TransformGroup(transform3D5);
        Text3D text3D = new Text3D(font3D, "x", point3f);
        OrientedShape3D orientedShape3D = new OrientedShape3D((Geometry)text3D, appearance2, 1, point3f);
        orientedShape3D.setPickable(false);
        transformGroup5.addChild((Node)orientedShape3D);
        transformGroup.addChild((Node)transformGroup5);
        point3f = new Point3f(-3.0f, -0.4f, 0.0f);
        transform3D5 = new Transform3D();
        transform3D5.setScale((double)f);
        transformGroup5 = new TransformGroup(transform3D5);
        text3D = new Text3D(font3D, "z", point3f);
        orientedShape3D = new OrientedShape3D((Geometry)text3D, appearance2, 1, point3f);
        orientedShape3D.setPickable(false);
        transformGroup5.addChild((Node)orientedShape3D);
        transformGroup.addChild((Node)transformGroup5);
        Point3f point3f2 = new Point3f(0.0f, 3.0f, 0.0f);
        Transform3D transform3D6 = new Transform3D();
        transform3D6.setScale((double)f);
        TransformGroup transformGroup6 = new TransformGroup(transform3D6);
        Text3D text3D2 = new Text3D(font3D, "v", point3f2);
        OrientedShape3D orientedShape3D2 = new OrientedShape3D((Geometry)text3D2, appearance3, 1, point3f2);
        orientedShape3D2.setPickable(false);
        transformGroup6.addChild((Node)orientedShape3D2);
        transformGroup.addChild((Node)transformGroup6);
        point3f2 = new Point3f(0.0f, -3.0f, 0.0f);
        transform3D6 = new Transform3D();
        transform3D6.setScale((double)f);
        transformGroup6 = new TransformGroup(transform3D6);
        text3D2 = new Text3D(font3D, "c", point3f2);
        orientedShape3D2 = new OrientedShape3D((Geometry)text3D2, appearance3, 1, point3f2);
        orientedShape3D2.setPickable(false);
        transformGroup6.addChild((Node)orientedShape3D2);
        transformGroup.addChild((Node)transformGroup6);
        Point3f point3f3 = new Point3f(0.0f, -0.4f, 3.0f);
        Transform3D transform3D7 = new Transform3D();
        transform3D7.setScale((double)f);
        TransformGroup transformGroup7 = new TransformGroup(transform3D7);
        Text3D text3D3 = new Text3D(font3D, "n", point3f3);
        OrientedShape3D orientedShape3D3 = new OrientedShape3D((Geometry)text3D3, appearance4, 1, point3f3);
        orientedShape3D3.setPickable(false);
        transformGroup7.addChild((Node)orientedShape3D3);
        transformGroup.addChild((Node)transformGroup7);
        point3f3 = new Point3f(0.0f, -0.4f, -3.1f);
        transform3D7 = new Transform3D();
        transform3D7.setScale((double)f);
        transformGroup7 = new TransformGroup(transform3D7);
        text3D3 = new Text3D(font3D, "b", point3f3);
        orientedShape3D3 = new OrientedShape3D((Geometry)text3D3, appearance4, 1, point3f3);
        orientedShape3D3.setPickable(false);
        transformGroup7.addChild((Node)orientedShape3D3);
        transformGroup.addChild((Node)transformGroup7);
        switch_.addChild((Node)transformGroup);
        branchGroup.addChild((Node)switch_);
        return branchGroup;
    }

    public void setOverlayDialog(BaseDialog baseDialog, OverlayPanel overlayPanel) {
        if (this.overlayDialog != null && baseDialog == null) {
            this.overlayDialog.setVisible(false);
        }
        this.overlayDialog = baseDialog;
        this.overlayPanel = overlayPanel;
    }

    public void setInteractionManyToManyDialog(BaseDialog baseDialog, InteractionEnergyManyToManyPanel interactionEnergyManyToManyPanel) {
        if (this.interactionEnergyManyToManyDialog != null && baseDialog == null) {
            this.interactionEnergyManyToManyDialog.setVisible(false);
        }
        this.interactionEnergyManyToManyDialog = baseDialog;
        this.interactionEnergyManyToManyPanel = interactionEnergyManyToManyPanel;
    }

    public void setInteractionManyToOneDialog(BaseDialog baseDialog, InteractionEnergyManyToOnePanel interactionEnergyManyToOnePanel) {
        if (this.interactionEnergyManyToOneDialog != null && baseDialog == null) {
            this.interactionEnergyManyToOneDialog.setVisible(false);
        }
        this.interactionEnergyManyToOneDialog = baseDialog;
        this.interactionEnergyManyToOnePanel = interactionEnergyManyToOnePanel;
    }

    public void setInteractionEnergyManyToOneData(Vector vector, float[] fArray) {
        this.interactionEnergyManyToOneData = vector;
        int n = this.treeTabPanel.getSelectedIndex();
        if (n == -1) {
            return;
        }
        FileItem fileItem = ((TreePanel)this.treeTabPanel.getComponentAt((int)n)).fileItem;
        CheckPointFile checkPointFile = (CheckPointFile)fileItem.file;
        checkPointFile.displayInteractionEnergyManyMinValue = fArray[0];
        checkPointFile.displayInteractionEnergyManyMaxValue = fArray[1];
        checkPointFile.displayInteractionEnergyManyThreshold = fArray[2];
        checkPointFile.interactionEnergyColorMap = new ColorMap(fArray[0], fArray[1], 0);
    }

    public int getSelectedTabIndex() {
        return this.treeTabPanel.getSelectedIndex();
    }

    public PdbFile getPdbFileFromTabIndex(int n) {
        Object var2_2 = null;
        FileItem fileItem = this.getFileItem(n);
        return fileItem.getPdbFile();
    }

    public void setOverlayInfo(int n, int n2) {
        if (this.overlayDialog != null) {
            this.overlayPanel.setOverlayInfo(n, n2);
        }
    }

    public void setFragmentInfo(int n) {
        if (this.interactionEnergyManyToManyDialog != null) {
            this.interactionEnergyManyToManyPanel.setFragmentInfo(n);
        }
        if (this.interactionEnergyManyToOneDialog != null) {
            this.interactionEnergyManyToOnePanel.setFragmentInfo(n);
        }
    }

    public FileItem getFileItem(int n) {
        return ((TreePanel)this.treeTabPanel.getComponentAt((int)n)).fileItem;
    }

    public CoordInfo getCoordInfo() {
        return this.coordInfo;
    }

    public void calcCoordInfo() {
        this.coordInfo = new CoordInfo();
        this.coordInfo.setMinMax(this.fileList);
        for (int i = 0; i < this.fileList.size(); ++i) {
            ((FileItem)this.fileList.get((int)i)).transformGroup = null;
        }
    }

    public int getMoColor() {
        return this.moColor;
    }

    public void setDefaultCursor() {
        if (this.distanceFlag != 0 || this.interactionFlag != 0 || this.angleFlag != 0 || this.dihedralFlag != 0) {
            this.setCursor(Cursor.getPredefinedCursor(1));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public CheckPointFile getCurrentTabCpfFile() {
        CheckPointFile checkPointFile = null;
        int n = this.treeTabPanel.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        FileItem fileItem = ((TreePanel)this.treeTabPanel.getComponentAt((int)n)).fileItem;
        if (fileItem.type != 5) {
            this.addMessageln("This file has no Interaction Energy data.");
            return null;
        }
        checkPointFile = (CheckPointFile)fileItem.file;
        if (checkPointFile.interactionEnergy == null) {
            this.addMessageln("This file has no Interaction Energy data.");
            return null;
        }
        return checkPointFile;
    }

    public FileItem getCurrentFileItem() {
        int n = this.treeTabPanel.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        return ((TreePanel)this.treeTabPanel.getComponentAt((int)n)).fileItem;
    }

    private String getAtomChargeList() {
        String string = null;
        CheckPointFile checkPointFile = this.getCurrentTabCpfFile();
        if (checkPointFile == null) {
            return null;
        }
        PdbFile pdbFile = checkPointFile.pdbFile;
        DecimalFormat decimalFormat = new DecimalFormat("0.000000");
        string = "  atom   residue fragment [au]\n";
        Vector vector = pdbFile.chains;
        for (int i = 0; i < vector.size(); ++i) {
            ChainData chainData = (ChainData)vector.get(i);
            Vector vector2 = null;
            for (int j = 0; j < 2; ++j) {
                vector2 = j == 0 ? chainData.atomTable : chainData.hemTable;
                for (int k = 0; k < vector2.size(); ++k) {
                    AtomData atomData = (AtomData)vector2.get(k);
                    string = string.concat(FillSpace.front("" + atomData.no, 4) + " " + FillSpace.back(atomData.allAtomName, 5) + FillSpace.back(atomData.residueName + atomData.residueNo, 6) + FillSpace.front("(" + atomData.fragmentNo + ") ", 6) + FillSpace.front(decimalFormat.format(atomData.mulliken), 11) + "\n");
                }
            }
        }
        return string;
    }

    private String getFragmentChargeList() {
        int n;
        String string = null;
        CheckPointFile checkPointFile = this.getCurrentTabCpfFile();
        if (checkPointFile == null) {
            return null;
        }
        PdbFile pdbFile = checkPointFile.pdbFile;
        float[] fArray = new float[checkPointFile.numberOfFragment];
        DecimalFormat decimalFormat = new DecimalFormat("0.000000");
        Vector vector = pdbFile.chains;
        for (n = 0; n < vector.size(); ++n) {
            ChainData chainData = (ChainData)vector.get(n);
            Vector vector2 = null;
            for (int i = 0; i < 2; ++i) {
                vector2 = i == 0 ? chainData.atomTable : chainData.hemTable;
                for (int j = 0; j < vector2.size(); ++j) {
                    AtomData atomData = (AtomData)vector2.get(j);
                    fArray[atomData.fragmentNo - 1] = fArray[atomData.fragmentNo - 1] + atomData.mulliken;
                }
            }
        }
        string = " fragment  [au]\n";
        for (n = 0; n < checkPointFile.numberOfFragment; ++n) {
            string = string.concat(FillSpace.front(n + 1 + "  ", 8) + FillSpace.front(decimalFormat.format(fArray[n]), 12) + "\n");
        }
        return string;
    }

    private String getResidueChargeList() {
        String string = null;
        CheckPointFile checkPointFile = this.getCurrentTabCpfFile();
        if (checkPointFile == null) {
            return null;
        }
        PdbFile pdbFile = checkPointFile.pdbFile;
        DecimalFormat decimalFormat = new DecimalFormat("0.000000");
        string = " residue fragment  [au]\n";
        Vector vector = pdbFile.chains;
        for (int i = 0; i < vector.size(); ++i) {
            ChainData chainData = (ChainData)vector.get(i);
            Vector vector2 = null;
            Vector vector3 = null;
            for (int j = 0; j < 2; ++j) {
                if (j == 0) {
                    vector2 = chainData.atomTable;
                    vector3 = chainData.residueTable;
                } else {
                    vector2 = chainData.hemTable;
                    vector3 = chainData.hemResidueTable;
                }
                for (int k = 0; k < vector3.size(); ++k) {
                    float f = 0.0f;
                    ResidueData residueData = (ResidueData)vector3.get(k);
                    for (int i2 = residueData.startNo; i2 <= residueData.endNo; ++i2) {
                        AtomData atomData = (AtomData)vector2.get(i2);
                        f += atomData.mulliken;
                    }
                    string = string.concat(" " + FillSpace.back(residueData.name + residueData.no, 8) + FillSpace.front("(" + residueData.atomData.fragmentNo + ") ", 6) + FillSpace.front(decimalFormat.format(f), 11) + "\n");
                }
            }
        }
        return string;
    }

    private String getDNAChargeList() {
        String string = null;
        CheckPointFile checkPointFile = this.getCurrentTabCpfFile();
        if (checkPointFile == null) {
            return null;
        }
        PdbFile pdbFile = checkPointFile.pdbFile;
        DecimalFormat decimalFormat = new DecimalFormat("0.000000");
        string = " residue fragment  [au]\n";
        Vector vector = pdbFile.chains;
        for (int i = 0; i < vector.size(); ++i) {
            ChainData chainData = (ChainData)vector.get(i);
            Vector vector2 = null;
            Vector vector3 = null;
            for (int j = 0; j < 2; ++j) {
                if (j == 0) {
                    vector2 = chainData.atomTable;
                    vector3 = chainData.residueTable;
                } else {
                    vector2 = chainData.hemTable;
                    vector3 = chainData.hemResidueTable;
                }
                for (int k = 0; k < vector3.size(); ++k) {
                    ResidueData residueData = (ResidueData)vector3.get(k);
                    float f = 0.0f;
                    for (int i2 = residueData.startNo; i2 <= residueData.endNo; ++i2) {
                        AtomData atomData = (AtomData)vector2.get(i2);
                        f += atomData.mulliken;
                    }
                    if (residueData.name.equals("A") || residueData.name.equals("G") || residueData.name.equals("C") || residueData.name.equals("T")) {
                        AtomData atomData = null;
                        int n = 0;
                        int n2 = 0;
                        int[] nArray = new int[4];
                        int[] nArray2 = new int[4];
                        int n3 = 0;
                        for (int i3 = residueData.startNo; i3 <= residueData.endNo; ++i3) {
                            atomData = (AtomData)vector2.get(i3);
                            if (atomData.fragmentNo != n) {
                                nArray[n2] = i3;
                                nArray2[n2] = n = atomData.fragmentNo;
                                ++n2;
                            }
                            if (!atomData.allAtomName.equals("C3'")) continue;
                            n3 = atomData.fragmentNo;
                        }
                        float f2 = 0.0f;
                        for (int i4 = nArray[n2 - 2]; i4 < nArray[n2 - 1]; ++i4) {
                            atomData = (AtomData)vector2.get(i4);
                            f2 += atomData.mulliken;
                        }
                        string = string.concat(" " + FillSpace.back(residueData.name + residueData.no + "(B)", 8) + FillSpace.front("(" + nArray2[n2 - 2] + ") ", 6) + FillSpace.front(decimalFormat.format(f2), 11) + "\n");
                        string = string.concat(" " + FillSpace.back(residueData.name + residueData.no, 8) + FillSpace.front("(" + n3 + ") ", 6) + FillSpace.front(decimalFormat.format(f - f2), 11) + "\n");
                        continue;
                    }
                    string = string.concat(" " + FillSpace.back(residueData.name + residueData.no, 8) + FillSpace.front("(" + residueData.atomData.fragmentNo + ") ", 6) + FillSpace.front(decimalFormat.format(f), 11) + "\n");
                }
            }
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String getInteractionEnergyList() {
        int n;
        SelectionData selectionData;
        PdbFile pdbFile;
        CheckPointFile checkPointFile;
        String string;
        block18: {
            int n2;
            string = null;
            checkPointFile = this.getCurrentTabCpfFile();
            if (checkPointFile == null) {
                return null;
            }
            pdbFile = checkPointFile.pdbFile;
            selectionData = null;
            if (this.moColor == 14) {
                if (this.interactionEnergyManyToOneData != null && this.interactionEnergyManyToOneData.size() != 0) {
                    string = " Base fragment ";
                    for (n2 = 0; n2 < this.interactionEnergyManyToOneData.size(); ++n2) {
                        int n3 = ((StartEnd)this.interactionEnergyManyToOneData.get((int)n2)).start;
                        n = ((StartEnd)this.interactionEnergyManyToOneData.get((int)n2)).end;
                        string = string + " " + n3 + "-" + n;
                    }
                    string = string + "\nresidue fragment  [kcal/mol]\n";
                    break block18;
                } else {
                    this.addMessageln("Please select base fragment.");
                    return null;
                }
            }
            if (this.selectionList == null || this.selectionList.size() == 0) {
                this.addMessageln("Please select base fragment.");
                return null;
            }
            selectionData = (SelectionData)this.selectionList.get(0);
            n2 = selectionData.atomData.fragmentNo;
            string = " Base fragment " + selectionData.residueData.name + selectionData.residueData.no + " (" + n2 + ")\n" + "residue fragment  [kcal/mol]\n";
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.000000");
        Vector vector = pdbFile.chains;
        n = 0;
        block1: while (n < vector.size()) {
            ChainData chainData = (ChainData)vector.get(n);
            int n4 = -1;
            int n5 = 0;
            while (true) {
                block20: {
                    Vector vector2;
                    Vector vector3;
                    block21: {
                        block19: {
                            if (n5 >= 2) break block19;
                            if (n5 == 0) {
                                vector3 = chainData.residueTable;
                                vector2 = chainData.atomTable;
                            } else {
                                vector3 = chainData.hemResidueTable;
                                vector2 = chainData.hemTable;
                            }
                            if (vector3.size() == 0) break block20;
                            break block21;
                        }
                        ++n;
                        continue block1;
                    }
                    for (int i = 0; i < vector3.size(); ++i) {
                        ResidueData residueData = (ResidueData)vector3.get(i);
                        AtomData atomData = residueData.atomData;
                        int n6 = atomData.fragmentNo;
                        if (this.moColor == 14 && this.isInBaseFragments(atomData)) continue;
                        if (residueData.name.equals("A") || residueData.name.equals("G") || residueData.name.equals("C") || residueData.name.equals("T")) {
                            int n7;
                            AtomData atomData2 = null;
                            for (n7 = residueData.startNo; n7 <= residueData.endNo; ++n7) {
                                atomData2 = (AtomData)vector2.get(n7);
                                if (atomData2.allAtomName.equals("C3'")) break;
                            }
                            n6 = atomData2.fragmentNo;
                            if (n4 == -1) {
                                n7 = 100000;
                                for (int j = residueData.startNo; j <= residueData.endNo; ++j) {
                                    atomData2 = (AtomData)vector2.get(j);
                                    if (atomData2.fragmentNo >= n7) continue;
                                    n7 = atomData2.fragmentNo;
                                }
                                if (n7 < n6) {
                                    n4 = n6 - 2;
                                }
                            }
                        }
                        if (n4 != -1 && n6 - n4 == 2) {
                            double d = this.moColor == 14 ? this.calcInteractionEnergyManyToOneEnergy(checkPointFile, n6 - 1) : checkPointFile.interactionEnergy[selectionData.atomData.fragmentNo - 1][n6 - 2];
                            string = string.concat(" " + FillSpace.back(residueData.name + residueData.no, 8) + FillSpace.front(" (" + (n6 - 1) + ") ", 6) + FillSpace.front(decimalFormat.format(d), 12) + "\n");
                        }
                        double d = this.moColor == 14 ? this.calcInteractionEnergyManyToOneEnergy(checkPointFile, n6) : checkPointFile.interactionEnergy[selectionData.atomData.fragmentNo - 1][n6 - 1];
                        string = string.concat(" " + FillSpace.back(residueData.name + residueData.no, 8) + FillSpace.front(" (" + n6 + ") ", 6) + FillSpace.front(decimalFormat.format(d), 12) + "\n");
                        n4 = n6;
                    }
                }
                ++n5;
            }
            break;
        }
        return string;
    }

    private boolean isInBaseFragments(AtomData atomData) {
        if (this.interactionEnergyManyToOneData != null && this.interactionEnergyManyToOneData.size() != 0) {
            for (int i = 0; i < this.interactionEnergyManyToOneData.size(); ++i) {
                int n = ((StartEnd)this.interactionEnergyManyToOneData.get((int)i)).start;
                int n2 = ((StartEnd)this.interactionEnergyManyToOneData.get((int)i)).end;
                if (n > atomData.fragmentNo || atomData.fragmentNo > n2) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isInBaseFragments(int n) {
        if (this.interactionEnergyManyToOneData != null && this.interactionEnergyManyToOneData.size() != 0) {
            for (int i = 0; i < this.interactionEnergyManyToOneData.size(); ++i) {
                int n2 = ((StartEnd)this.interactionEnergyManyToOneData.get((int)i)).start;
                int n3 = ((StartEnd)this.interactionEnergyManyToOneData.get((int)i)).end;
                if (n2 > n || n > n3) continue;
                return true;
            }
        }
        return false;
    }

    private double calcInteractionEnergyManyToOneEnergy(CheckPointFile checkPointFile, int n) {
        double d = 0.0;
        if (this.interactionEnergyManyToOneData != null && this.interactionEnergyManyToOneData.size() != 0) {
            for (int i = 0; i < this.interactionEnergyManyToOneData.size(); ++i) {
                int n2 = ((StartEnd)this.interactionEnergyManyToOneData.get((int)i)).start;
                int n3 = ((StartEnd)this.interactionEnergyManyToOneData.get((int)i)).end;
                for (int j = n2; j <= n3; ++j) {
                    d += checkPointFile.interactionEnergy[j - 1][n - 1];
                }
            }
        }
        return d;
    }

    public int getMoModel() {
        return this.moModel;
    }

    private ResidueData isElement(FileItem fileItem, ResidueData residueData) {
        PdbFile pdbFile = fileItem.getPdbFile();
        if (pdbFile == null) {
            return null;
        }
        Vector vector = pdbFile.chains;
        for (int i = 0; i < vector.size(); ++i) {
            ChainData chainData = (ChainData)vector.get(i);
            ResidueData residueData2 = chainData.isElement(residueData);
            if (residueData2 == null) continue;
            return residueData2;
        }
        return null;
    }

    private String getExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n != -1) {
            return string.substring(n + 1);
        }
        return null;
    }

    public void replaceAddHydrogenFile() {
        BaseDialog baseDialog = new BaseDialog(this.me, new ReplaceAddHydrogenPanel(), MyResourceBundle.getResourceString("ReplaceAddHydrogenDialog.Title"));
        baseDialog.setVisible(true);
        ReplaceAddHydrogenPanel replaceAddHydrogenPanel = (ReplaceAddHydrogenPanel)baseDialog.getPanel();
        if (replaceAddHydrogenPanel != null) {
            ResidueData residueData;
            FileItem fileItem = (FileItem)this.fileList.get(0);
            this.treeTabPanel.remove(0);
            this.fileList.remove(0);
            for (int i = this.selectionList.size() - 1; i >= 0; --i) {
                residueData = ((SelectionData)this.selectionList.get((int)i)).residueData;
                if (this.isElement(fileItem, residueData) == null) continue;
                this.selectionList.remove(residueData);
            }
            Enumeration enumeration = this.nodeTable.keys();
            while (enumeration.hasMoreElements()) {
                residueData = enumeration.nextElement();
                NodeData nodeData = (NodeData)this.nodeTable.get(residueData);
                if (nodeData.fileItem != fileItem) continue;
                this.nodeTable.remove(residueData);
            }
            if (this.inDistanceData != null && this.isElement(fileItem, this.inDistanceData.residueData) != null) {
                this.inDistanceData = null;
            }
            this.openFile(this.addHydrogenPanel.getOutputFile());
        }
    }

    public void replaceAddSideChainFile() {
        BaseDialog baseDialog = new BaseDialog(this.me, new ReplaceAddSideChainPanel(), MyResourceBundle.getResourceString("ReplaceAddSideChainDialog.Title"));
        baseDialog.setVisible(true);
        ReplaceAddSideChainPanel replaceAddSideChainPanel = (ReplaceAddSideChainPanel)baseDialog.getPanel();
        if (replaceAddSideChainPanel != null) {
            ResidueData residueData;
            FileItem fileItem = (FileItem)this.fileList.get(0);
            this.treeTabPanel.remove(0);
            this.fileList.remove(0);
            for (int i = this.selectionList.size() - 1; i >= 0; --i) {
                residueData = ((SelectionData)this.selectionList.get((int)i)).residueData;
                if (this.isElement(fileItem, residueData) == null) continue;
                this.selectionList.remove(residueData);
            }
            Enumeration enumeration = this.nodeTable.keys();
            while (enumeration.hasMoreElements()) {
                residueData = enumeration.nextElement();
                NodeData nodeData = (NodeData)this.nodeTable.get(residueData);
                if (nodeData.fileItem != fileItem) continue;
                this.nodeTable.remove(residueData);
            }
            if (this.inDistanceData != null && this.isElement(fileItem, this.inDistanceData.residueData) != null) {
                this.inDistanceData = null;
            }
            this.openFile(this.addSideChainPanel.getOutputFile());
        }
    }

    public void setMoGraphWindow(MoGraphWindow moGraphWindow) {
        if (this.moGraphWindow != null) {
            this.moGraphWindow.setVisible(false);
        }
        this.moGraphWindow = moGraphWindow;
    }

    public FileItem getSelectedFileItem() {
        return (FileItem)this.fileList.get(this.getSelectedTabIndex());
    }

    public void setRotationTranslation(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.sceneViewer.setRotationTranslation(f, f2, f3, f4, f5, f6, f7, f8);
    }

    public void setViewPosition(Matrix4f matrix4f) {
        this.sceneViewer.setViewPosition(matrix4f);
    }

    public Matrix4f getViewPosition() {
        return this.sceneViewer.getViewPosition();
    }

    public void addNode(Node node) {
        this.sceneViewer.addNode(node);
    }

    public void detach() {
        this.sceneViewer.detach();
    }

    public void addBranchGraph() {
        this.sceneViewer.addBranchGraph();
    }

    public void addSectionRootNode(FileItem fileItem, Node node) {
        this.sceneViewer.addSectionRootNode(fileItem, node);
    }

    public void detachSectionControl() {
        this.sceneViewer.detachSectionControl();
    }

    public void addSectionFileRootNode(BranchGroup branchGroup) {
        this.sceneViewer.addSectionFileRootNode(branchGroup);
    }

    public void deleteSectionNode(FileItem fileItem, int n) {
        this.sceneViewer.deleteSectionNode(fileItem, n);
    }

    public void deleteSectionFileRootNode(BranchGroup branchGroup) {
        this.sceneViewer.deleteSectionFileRootNode(branchGroup);
    }

    public void setProjection(int n) {
        this.sceneViewer.setProjection(n);
    }

    public SceneViewer getSceneViewer() {
        return this.sceneViewer;
    }

    public void setNumberCalculateChargeWindow(int n, int n2, int n3) {
        if (this.calculateChargeWindow != null) {
            this.calculateChargeWindow.setNumber(n, n2, n3);
        }
    }

    public void createFragmentBoundaryNode(AtomData atomData, AtomData atomData2) {
        this.sceneViewer.createFragmentBoundaryNode(atomData, atomData2);
    }

    public void removeFragmentBoundaryNode(AtomData atomData) {
        this.sceneViewer.removeFragmentBoundaryNode(atomData);
    }

    public void highlightBounbaryNode(AtomData atomData) {
        this.sceneViewer.highlightBounbaryNode(atomData);
        this.ajfFileWindow.highlightBounbary(atomData);
    }

    public Vector getFileList() {
        return this.fileList;
    }

    public void add3DText(Text3DData text3DData) {
        this.sceneViewer.add3DText(text3DData);
    }

    public void delete3DText(Text3DData text3DData) {
        this.sceneViewer.delete3DText(text3DData);
    }

    public void modify3DText(Text3DData text3DData) {
        this.sceneViewer.modify3DText(text3DData);
    }

    public void setNewTextPosition(float f, float f2, TransformGroup transformGroup) {
        this.textAssignWindow.setNewTextPosition(f, f2, transformGroup);
    }

    public void setTrajectoryTex3DtData(Text3DData text3DData) {
        this.trajectoryText3DData = text3DData;
    }

    public Text3DData getTrajectoryTex3DtData() {
        return this.trajectoryText3DData;
    }

    public void createTrajectoryText(Text3DData text3DData) {
        this.trajectoryText3DData = text3DData;
        for (int i = 0; i < this.fileList.size(); ++i) {
            FileItem fileItem = (FileItem)this.fileList.get(i);
            if (fileItem.type != 13) continue;
            this.setWaitCursor();
            this.sceneViewer.createTrajectoryText((TrajectoryFile)fileItem.file);
            this.setDefaultCursor();
            break;
        }
    }

    public static void main(String[] stringArray) {
        AbinitMpViewer abinitMpViewer = new AbinitMpViewer();
        abinitMpViewer.setMain();
        abinitMpViewer.setVisible(true);
    }

    class directionListener
    extends AbstractAction {
        directionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            String[] stringArray = MyResourceBundle.getResourceStringsWithoutSeparator("AbinitMpViewer.directionMenu");
            char c = string.charAt(0);
            if (AbinitMpViewer.this.getNemonic(stringArray[0]) == c) {
                AbinitMpViewer.this.directionDisplay = true;
                AbinitMpViewer.this.setDirectionDisplay();
            } else if (AbinitMpViewer.this.getNemonic(stringArray[1]) == c) {
                AbinitMpViewer.this.directionDisplay = false;
                AbinitMpViewer.this.setDirectionDisplay();
            }
        }
    }

    class axisListener
    extends AbstractAction {
        axisListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            String[] stringArray = MyResourceBundle.getResourceStringsWithoutSeparator("AbinitMpViewer.axisMenu");
            char c = string.charAt(0);
            if (AbinitMpViewer.this.getNemonic(stringArray[0]) == c) {
                AbinitMpViewer.this.sceneViewer.setAxisEnable(true);
            } else if (AbinitMpViewer.this.getNemonic(stringArray[1]) == c) {
                AbinitMpViewer.this.sceneViewer.setAxisEnable(false);
            }
        }
    }

    class preferenceListener
    extends AbstractAction {
        preferenceListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            String[] stringArray = MyResourceBundle.getResourceStringsWithoutSeparator("AbinitMpViewer.preferenceMenu");
            char c = string.charAt(0);
            if (AbinitMpViewer.this.getNemonic(stringArray[0]) == c) {
                if (AbinitMpViewer.this.preferenceWindow == null) {
                    AbinitMpViewer.this.preferenceWindow = new PreferenceWindow(AbinitMpViewer.this.me);
                }
                AbinitMpViewer.this.preferenceWindow.setVisible(true);
            }
        }
    }

    class editListener
    extends AbstractAction {
        editListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            String[] stringArray = MyResourceBundle.getResourceStringsWithoutSeparator("AbinitMpViewer.editMenu");
            char c = string.charAt(0);
            if (AbinitMpViewer.this.getNemonic(stringArray[0]) == c) {
                int n;
                object = new Vector();
                if (AbinitMpViewer.this.selectionList == null) {
                    return;
                }
                for (n = 0; n < AbinitMpViewer.this.selectionList.size(); ++n) {
                    SelectionData selectionData = (SelectionData)AbinitMpViewer.this.selectionList.get(n);
                    if (selectionData.type == 2) {
                        selectionData.residueData.setCutFlag(AbinitMpViewer.this.getAtomTable(selectionData.residueData), true);
                        ((Vector)object).add(selectionData.residueData);
                        continue;
                    }
                    selectionData.atomData.cutFlag = true;
                    ((Vector)object).add(selectionData.atomData);
                }
                for (n = AbinitMpViewer.this.undoList.size() - 1; n >= AbinitMpViewer.this.undoNo; --n) {
                    AbinitMpViewer.this.undoList.remove(n);
                }
                AbinitMpViewer.this.undoList.add(new UndoData(1, (Vector)object));
                AbinitMpViewer.this.undoNo++;
                AbinitMpViewer.this.undoMenu.setEnabled(true);
            } else if (AbinitMpViewer.this.getNemonic(stringArray[1]) == c) {
                int n;
                object = new Vector();
                if (AbinitMpViewer.this.selectionList == null) {
                    return;
                }
                AbinitMpViewer.this.setAllCutFlag(true);
                for (n = 0; n < AbinitMpViewer.this.selectionList.size(); ++n) {
                    SelectionData selectionData = (SelectionData)AbinitMpViewer.this.selectionList.get(n);
                    if (selectionData.type == 2) {
                        selectionData.residueData.setCutFlag(AbinitMpViewer.this.getAtomTable(selectionData.residueData), false);
                        ((Vector)object).add(selectionData.residueData);
                        continue;
                    }
                    selectionData.residueData.cutFlag = false;
                    selectionData.atomData.cutFlag = false;
                    ((Vector)object).add(selectionData.atomData);
                }
                for (n = AbinitMpViewer.this.undoList.size() - 1; n >= AbinitMpViewer.this.undoNo; --n) {
                    AbinitMpViewer.this.undoList.remove(n);
                }
                AbinitMpViewer.this.undoList.add(new UndoData(2, (Vector)object));
                AbinitMpViewer.this.undoNo++;
                AbinitMpViewer.this.undoMenu.setEnabled(true);
            } else if (AbinitMpViewer.this.getNemonic(stringArray[2]) == c) {
                Object object2;
                int n;
                object = (UndoData)AbinitMpViewer.this.undoList.get(AbinitMpViewer.this.undoNo - 1);
                Vector vector = ((UndoData)object).data;
                if (((UndoData)object).type == 1) {
                    for (n = 0; n < vector.size(); ++n) {
                        object2 = vector.get(n);
                        if (object2 instanceof ResidueData) {
                            ((ResidueData)object2).setCutFlag(AbinitMpViewer.this.getAtomTable((ResidueData)object2), false);
                            continue;
                        }
                        ((AtomData)object2).cutFlag = false;
                    }
                } else if (((UndoData)object).type == 2) {
                    AbinitMpViewer.this.setAllCutFlag(false);
                    for (n = 0; n < AbinitMpViewer.this.undoList.size() - 1; ++n) {
                        object2 = (UndoData)AbinitMpViewer.this.undoList.get(n);
                        AbinitMpViewer.this.execEdit(object2);
                    }
                }
                AbinitMpViewer.this.undoNo--;
                AbinitMpViewer.this.redoMenu.setEnabled(true);
                if (AbinitMpViewer.this.undoNo == 0) {
                    AbinitMpViewer.this.undoMenu.setEnabled(false);
                }
            } else if (AbinitMpViewer.this.getNemonic(stringArray[3]) == c) {
                object = (UndoData)AbinitMpViewer.this.undoList.get(AbinitMpViewer.this.undoNo);
                AbinitMpViewer.this.execEdit((UndoData)object);
                AbinitMpViewer.this.undoNo++;
                AbinitMpViewer.this.undoMenu.setEnabled(true);
                if (AbinitMpViewer.this.undoList.size() == AbinitMpViewer.this.undoNo) {
                    AbinitMpViewer.this.redoMenu.setEnabled(false);
                }
            }
            AbinitMpViewer.this.setWaitCursor();
            AbinitMpViewer.this.moRootNode = AbinitMpViewer.this.createStructureNode();
            AbinitMpViewer.this.sceneViewer.replaceMoNode(AbinitMpViewer.this.moRootNode);
            for (int i = 0; i < AbinitMpViewer.this.fileList.size(); ++i) {
                FileItem fileItem = (FileItem)AbinitMpViewer.this.fileList.get(i);
                if (fileItem.treePanel == null) continue;
                fileItem.treePanel.reCreateTree();
            }
            AbinitMpViewer.this.setDefaultCursor();
        }
    }

    class interfragmentInteractionListener
    extends AbstractAction {
        interfragmentInteractionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string2 = jMenuItem.getActionCommand();
            String[] stringArray = MyResourceBundle.getResourceStringsWithoutSeparator("AbinitMpViewer.interfragmentInteractionMenu1");
            String[] stringArray2 = MyResourceBundle.getResourceStringsWithoutSeparator("AbinitMpViewer.interfragmentInteractionMenu2");
            char c = string2.charAt(0);
            if (AbinitMpViewer.this.getNemonic(stringArray[0]) == c || AbinitMpViewer.this.getNemonic(stringArray[1]) == c || AbinitMpViewer.this.getNemonic(stringArray[2]) == c) {
                if (AbinitMpViewer.this.getNemonic(stringArray[0]) == c || AbinitMpViewer.this.getNemonic(stringArray[1]) == c) {
                    double d;
                    double d2;
                    double d3;
                    if (AbinitMpViewer.this.getNemonic(stringArray[0]) == c) {
                        AbinitMpViewer.this.moColor = 12;
                    } else {
                        AbinitMpViewer.this.moColor = 13;
                    }
                    int n = AbinitMpViewer.this.treeTabPanel.getSelectedIndex();
                    if (n == -1) {
                        return;
                    }
                    FileItem fileItem = ((TreePanel)((AbinitMpViewer)AbinitMpViewer.this).treeTabPanel.getComponentAt((int)n)).fileItem;
                    if (fileItem.type != 5) {
                        AbinitMpViewer.this.addMessageln("This file have no interaction data.");
                        return;
                    }
                    CheckPointFile checkPointFile = (CheckPointFile)fileItem.file;
                    if (checkPointFile.interactionEnergyMinValue == 9.9999997952E10 && checkPointFile.interactionEnergyMaxValue == -9.9999997952E10) {
                        AbinitMpViewer.this.addMessageln("This file have no interaction data.");
                        return;
                    }
                    if (checkPointFile.displayInteractionEnergyMinValue == 0.0 && checkPointFile.displayInteractionEnergyMaxValue == 0.0) {
                        d3 = checkPointFile.interactionEnergyMinValue;
                        d2 = checkPointFile.interactionEnergyMaxValue;
                        d = 0.0;
                    } else {
                        d3 = checkPointFile.displayInteractionEnergyMinValue;
                        d2 = checkPointFile.displayInteractionEnergyMaxValue;
                        d = checkPointFile.displayInteractionEnergyThreshold;
                    }
                    BaseDialog baseDialog = new BaseDialog(AbinitMpViewer.this.me, new InteractionEnergyPanel(d3, d2, d), MyResourceBundle.getResourceString("InteractionEnergyDialog.Title"));
                    baseDialog.setVisible(true);
                    InteractionEnergyPanel interactionEnergyPanel = (InteractionEnergyPanel)baseDialog.getPanel();
                    if (interactionEnergyPanel == null) {
                        return;
                    }
                    float[] fArray = interactionEnergyPanel.getValue();
                    d3 = fArray[0];
                    d2 = fArray[1];
                    d = fArray[2];
                    if (d3 == 0.0 && d2 == 0.0) {
                        d3 = checkPointFile.interactionEnergyMinValue;
                        d2 = checkPointFile.interactionEnergyMaxValue;
                    }
                    AbinitMpViewer.this.addMessageln("Range of Interaction value (" + d3 + " , " + d2 + ") [kcal/mol] Threshold " + d + " [kcal/mol]");
                    checkPointFile.displayInteractionEnergyMinValue = d3;
                    checkPointFile.displayInteractionEnergyMaxValue = d2;
                    checkPointFile.displayInteractionEnergyThreshold = d;
                    checkPointFile.interactionEnergyColorMap = new ColorMap((float)d3, (float)d2, 0);
                    if (AbinitMpViewer.this.selectionList.size() == 0) {
                        AbinitMpViewer.this.addMessageln("Please select atom.");
                        return;
                    }
                } else {
                    AbinitMpViewer.this.moColor = 14;
                    int n = AbinitMpViewer.this.treeTabPanel.getSelectedIndex();
                    if (n == -1) {
                        return;
                    }
                    FileItem fileItem = ((TreePanel)((AbinitMpViewer)AbinitMpViewer.this).treeTabPanel.getComponentAt((int)n)).fileItem;
                    if (fileItem.type != 5) {
                        AbinitMpViewer.this.addMessageln("This file have no interaction data.");
                        return;
                    }
                    CheckPointFile checkPointFile = (CheckPointFile)fileItem.file;
                    if (checkPointFile.interactionEnergyMinValue == 9.9999997952E10 && checkPointFile.interactionEnergyMaxValue == -9.9999997952E10) {
                        AbinitMpViewer.this.addMessageln("This file have no interaction data.");
                        return;
                    }
                    double d = checkPointFile.displayInteractionEnergyManyMinValue;
                    double d4 = checkPointFile.displayInteractionEnergyManyMaxValue;
                    double d5 = checkPointFile.displayInteractionEnergyManyThreshold;
                    if (AbinitMpViewer.this.interactionEnergyManyToOnePanel == null) {
                        AbinitMpViewer.this.interactionEnergyManyToOnePanel = new InteractionEnergyManyToOnePanel(AbinitMpViewer.this.me, d, d4, d5);
                        AbinitMpViewer.this.interactionEnergyManyToOneDialog = new BaseDialog(AbinitMpViewer.this.me, AbinitMpViewer.this.interactionEnergyManyToOnePanel, MyResourceBundle.getResourceString("InteractionEnergyManyToOneDialog.Title"));
                        AbinitMpViewer.this.interactionEnergyManyToOneDialog.setModal(false);
                        AbinitMpViewer.this.interactionEnergyManyToOneDialog.setLocation(700, 5);
                    }
                    AbinitMpViewer.this.interactionEnergyManyToOneDialog.setVisible(true);
                    AbinitMpViewer.this.setSelectionMode(3);
                    return;
                }
                AbinitMpViewer.this.setWaitCursor();
                AbinitMpViewer.this.moRootNode = AbinitMpViewer.this.createStructureNode();
                AbinitMpViewer.this.sceneViewer.replaceMoNode(AbinitMpViewer.this.moRootNode);
                AbinitMpViewer.this.setDefaultCursor();
            } else if (AbinitMpViewer.this.getNemonic(stringArray2[0]) == c) {
                int n = AbinitMpViewer.this.treeTabPanel.getSelectedIndex();
                if (n == -1) {
                    return;
                }
                FileItem fileItem = ((TreePanel)((AbinitMpViewer)AbinitMpViewer.this).treeTabPanel.getComponentAt((int)n)).fileItem;
                if (fileItem.type != 5) {
                    AbinitMpViewer.this.addMessageln("This file have no interaction data.");
                    return;
                }
                CheckPointFile checkPointFile = (CheckPointFile)fileItem.file;
                if (checkPointFile.interactionEnergyMinValue == 9.9999997952E10 && checkPointFile.interactionEnergyMaxValue == -9.9999997952E10) {
                    AbinitMpViewer.this.addMessageln("This file have no interaction data.");
                    return;
                }
                if (AbinitMpViewer.this.interactionEnergyManyToManyPanel == null) {
                    AbinitMpViewer.this.interactionEnergyManyToManyPanel = new InteractionEnergyManyToManyPanel(AbinitMpViewer.this.me);
                    AbinitMpViewer.this.interactionEnergyManyToManyDialog = new BaseDialog(AbinitMpViewer.this.me, AbinitMpViewer.this.interactionEnergyManyToManyPanel, MyResourceBundle.getResourceString("InteractionEnergyManyToManyDialog.Title"));
                    AbinitMpViewer.this.interactionEnergyManyToManyDialog.setModal(false);
                    AbinitMpViewer.this.interactionEnergyManyToManyDialog.setOkButtonLabel(MyResourceBundle.getResourceString("apply"));
                    AbinitMpViewer.this.interactionEnergyManyToManyDialog.setCancelButtonLabel(MyResourceBundle.getResourceString("close"));
                    Dimension dimension = AbinitMpViewer.this.me.getSize();
                    AbinitMpViewer.this.interactionEnergyManyToManyDialog.setLocation(0, dimension.height - 220);
                }
                AbinitMpViewer.this.interactionEnergyManyToManyDialog.setVisible(true);
                AbinitMpViewer.this.setSelectionMode(2);
            } else if (AbinitMpViewer.this.getNemonic(stringArray2[1]) == c && (string = AbinitMpViewer.this.getInteractionEnergyList()) != null) {
                new ViewText("Interaction Energy", string);
            }
        }
    }

    class chargeListListener
    extends AbstractAction {
        chargeListListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            String[] stringArray = MyResourceBundle.getResourceStringsWithoutSeparator("AbinitMpViewer.chargeListMenu");
            char c = string.charAt(0);
            if (AbinitMpViewer.this.getNemonic(stringArray[0]) == c) {
                String string2 = AbinitMpViewer.this.getAtomChargeList();
                if (string2 != null) {
                    ViewText viewText = new ViewText("Charge List of Atom", string2);
                }
            } else if (AbinitMpViewer.this.getNemonic(stringArray[1]) == c) {
                String string3 = AbinitMpViewer.this.getFragmentChargeList();
                if (string3 != null) {
                    new ViewText("Charge List of Fragment", string3);
                }
            } else if (AbinitMpViewer.this.getNemonic(stringArray[2]) == c) {
                String string4 = AbinitMpViewer.this.getResidueChargeList();
                if (string4 != null) {
                    new ViewText("Charge List of Residue", string4);
                }
            } else if (AbinitMpViewer.this.getNemonic(stringArray[3]) == c) {
                String string5 = AbinitMpViewer.this.getDNAChargeList();
                if (string5 != null) {
                    new ViewText("Charge List of Residue(DNA)", string5);
                }
            } else if (AbinitMpViewer.this.getNemonic(stringArray[4]) == c) {
                AbinitMpViewer.this.calculateChargeWindow = new CalculateChargeWindow(AbinitMpViewer.this.me);
                AbinitMpViewer.this.calculateChargeWindow.setVisible(true);
            }
        }
    }

    class monitorListener
    extends AbstractAction {
        monitorListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            String[] stringArray = MyResourceBundle.getResourceStringsWithoutSeparator("AbinitMpViewer.monitorMenu");
            char c = string.charAt(0);
            if (AbinitMpViewer.this.getNemonic(stringArray[0]) == c) {
                AbinitMpViewer.this.angleFlag = 0;
                AbinitMpViewer.this.angleMenu.setForeground(Color.black);
                AbinitMpViewer.this.dihedralFlag = 0;
                AbinitMpViewer.this.dihedralMenu.setForeground(Color.black);
                AbinitMpViewer.this.interactionFlag = 0;
                AbinitMpViewer.this.interactionMenu.setForeground(Color.black);
                if (AbinitMpViewer.this.distanceFlag == 0) {
                    AbinitMpViewer.this.addMessageln("Click first Atom.");
                    AbinitMpViewer.this.distanceFlag = 1;
                    AbinitMpViewer.this.distanceMenu.setForeground(Color.green);
                    AbinitMpViewer.this.monitorMenu.setForeground(Color.green);
                } else {
                    AbinitMpViewer.this.distanceFlag = 0;
                    AbinitMpViewer.this.distanceMenu.setForeground(Color.black);
                    AbinitMpViewer.this.monitorMenu.setForeground(Color.black);
                }
                AbinitMpViewer.this.setDefaultCursor();
            } else if (AbinitMpViewer.this.getNemonic(stringArray[1]) == c) {
                AbinitMpViewer.this.distanceFlag = 0;
                AbinitMpViewer.this.distanceMenu.setForeground(Color.black);
                AbinitMpViewer.this.dihedralFlag = 0;
                AbinitMpViewer.this.dihedralMenu.setForeground(Color.black);
                AbinitMpViewer.this.interactionFlag = 0;
                AbinitMpViewer.this.interactionMenu.setForeground(Color.black);
                if (AbinitMpViewer.this.angleFlag == 0) {
                    AbinitMpViewer.this.addMessageln("Click first Atom.");
                    AbinitMpViewer.this.angleFlag = 1;
                    AbinitMpViewer.this.angleMenu.setForeground(Color.green);
                    AbinitMpViewer.this.monitorMenu.setForeground(Color.green);
                } else {
                    AbinitMpViewer.this.angleFlag = 0;
                    AbinitMpViewer.this.angleMenu.setForeground(Color.black);
                    AbinitMpViewer.this.monitorMenu.setForeground(Color.black);
                }
                AbinitMpViewer.this.setDefaultCursor();
            } else if (AbinitMpViewer.this.getNemonic(stringArray[2]) == c) {
                AbinitMpViewer.this.distanceFlag = 0;
                AbinitMpViewer.this.distanceMenu.setForeground(Color.black);
                AbinitMpViewer.this.angleFlag = 0;
                AbinitMpViewer.this.angleMenu.setForeground(Color.black);
                AbinitMpViewer.this.interactionFlag = 0;
                AbinitMpViewer.this.interactionMenu.setForeground(Color.black);
                if (AbinitMpViewer.this.dihedralFlag == 0) {
                    AbinitMpViewer.this.addMessageln("Click first Atom.");
                    AbinitMpViewer.this.dihedralFlag = 1;
                    AbinitMpViewer.this.dihedralMenu.setForeground(Color.green);
                    AbinitMpViewer.this.monitorMenu.setForeground(Color.green);
                } else {
                    AbinitMpViewer.this.dihedralFlag = 0;
                    AbinitMpViewer.this.dihedralMenu.setForeground(Color.black);
                    AbinitMpViewer.this.monitorMenu.setForeground(Color.black);
                }
                AbinitMpViewer.this.setDefaultCursor();
            } else if (AbinitMpViewer.this.getNemonic(stringArray[3]) == c) {
                FileItem fileItem = ((TreePanel)((AbinitMpViewer)AbinitMpViewer.this).treeTabPanel.getComponentAt((int)((AbinitMpViewer)AbinitMpViewer.this).treeTabPanel.getSelectedIndex())).fileItem;
                if (fileItem.type != 5) {
                    AbinitMpViewer.this.addMessageln("This file has no Interaction Energy data.");
                    return;
                }
                CheckPointFile checkPointFile = (CheckPointFile)fileItem.file;
                if (checkPointFile.interactionEnergy == null) {
                    AbinitMpViewer.this.addMessageln("This file has no Interaction Energy data.");
                    return;
                }
                AbinitMpViewer.this.distanceFlag = 0;
                AbinitMpViewer.this.distanceMenu.setForeground(Color.black);
                AbinitMpViewer.this.angleFlag = 0;
                AbinitMpViewer.this.angleMenu.setForeground(Color.black);
                AbinitMpViewer.this.dihedralFlag = 0;
                AbinitMpViewer.this.dihedralMenu.setForeground(Color.black);
                if (AbinitMpViewer.this.interactionFlag == 0) {
                    AbinitMpViewer.this.addMessageln("Click first flagment.");
                    AbinitMpViewer.this.interactionFlag = 1;
                    AbinitMpViewer.this.interactionMenu.setForeground(Color.green);
                    AbinitMpViewer.this.monitorMenu.setForeground(Color.green);
                } else {
                    AbinitMpViewer.this.interactionFlag = 0;
                    AbinitMpViewer.this.interactionMenu.setForeground(Color.black);
                    AbinitMpViewer.this.monitorMenu.setForeground(Color.black);
                }
                AbinitMpViewer.this.setDefaultCursor();
            } else if (AbinitMpViewer.this.getNemonic(stringArray[4]) == c) {
                AbinitMpViewer.this.monitorNode.clearPickedNode();
            }
        }
    }

    class toolListener
    extends AbstractAction {
        toolListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            String[] stringArray = MyResourceBundle.getResourceStringsWithoutSeparator("AbinitMpViewer.toolMenu");
            char c = string.charAt(0);
            if (AbinitMpViewer.this.getNemonic(stringArray[0]) == c || AbinitMpViewer.this.getNemonic(stringArray[1]) == c) {
                boolean bl;
                Object object;
                String string2 = null;
                ResidueData residueData = null;
                AtomData atomData = null;
                if (AbinitMpViewer.this.selectionList.size() != 0) {
                    object = (SelectionData)AbinitMpViewer.this.selectionList.get(0);
                    residueData = ((SelectionData)object).residueData;
                    atomData = ((SelectionData)object).atomData;
                    string2 = atomData.fragmentNo == 0 ? atomData.allAtomName + "(" + atomData.no + ") " + residueData.name + residueData.no + " " : new String("Fragment " + atomData.fragmentNo + " " + atomData.allAtomName + "(" + atomData.no + ") " + residueData.name + residueData.no + " ");
                }
                if (string2 == null) {
                    AbinitMpViewer.this.addMessageln("Please select residue or atom.");
                    return;
                }
                if (AbinitMpViewer.this.getNemonic(stringArray[0]) == c) {
                    object = MyResourceBundle.getResourceString("InDistanceDialog.TitleAtom");
                    bl = true;
                } else {
                    object = MyResourceBundle.getResourceString("InDistanceDialog.TitleResidue");
                    bl = false;
                }
                BaseDialog baseDialog = new BaseDialog(AbinitMpViewer.this.me, new InDistancePanel(string2), (String)object);
                baseDialog.setVisible(true);
                InDistancePanel inDistancePanel = (InDistancePanel)baseDialog.getPanel();
                if (inDistancePanel != null) {
                    String string3;
                    float f = inDistancePanel.getDistance();
                    boolean bl2 = inDistancePanel.getList();
                    boolean bl3 = inDistancePanel.getFromAtom();
                    Vector vector = null;
                    if (f != 0.0f) {
                        MolecularStructure molecularStructure;
                        for (int i = 0; i < AbinitMpViewer.this.chainTable.size() && (vector = (molecularStructure = (MolecularStructure)AbinitMpViewer.this.chainTable.get(i)).getAtomTable(residueData)) == null; ++i) {
                        }
                        AbinitMpViewer.this.inDistanceData = new InDistanceData(atomData, residueData, vector, bl, bl2, bl3, f);
                        string3 = bl3 ? "atom: " : "residue: ";
                        if (AbinitMpViewer.this.getNemonic(stringArray[0]) == c) {
                            AbinitMpViewer.this.addMessageln("Display Atom from " + string3 + string2 + " distance:" + f);
                        } else {
                            AbinitMpViewer.this.addMessageln("Display residue from " + string3 + string2 + " distance:" + f);
                        }
                    } else {
                        AbinitMpViewer.this.inDistanceData = null;
                    }
                    AbinitMpViewer.this.setWaitCursor();
                    AbinitMpViewer.this.moRootNode = AbinitMpViewer.this.createStructureNode();
                    AbinitMpViewer.this.sceneViewer.replaceMoNode(AbinitMpViewer.this.moRootNode);
                    if (((AbinitMpViewer)AbinitMpViewer.this).inDistanceData.list) {
                        string3 = new String();
                        for (int i = 0; i < AbinitMpViewer.this.chainTable.size(); ++i) {
                            MolecularStructure molecularStructure = (MolecularStructure)AbinitMpViewer.this.chainTable.get(i);
                            for (int j = 0; j < molecularStructure.displayAtomList.size(); ++j) {
                                AtomData atomData2 = (AtomData)molecularStructure.displayAtomList.get(j);
                                String string4 = atomData2.fragmentNo == 0 ? " " + FillSpace.back(atomData2.allAtomName + "(" + atomData2.no + ")", 10) + atomData2.residueName + atomData2.residueNo + "\n" : " Fragment " + FillSpace.back(atomData2.fragmentNo + " ", 4) + FillSpace.back(atomData2.allAtomName + "(" + atomData2.no + ")", 10) + atomData2.residueName + atomData2.residueNo + "\n";
                                string3 = string3.concat(string4);
                            }
                        }
                        new ViewText("Atom List", string3);
                    }
                    AbinitMpViewer.this.setDefaultCursor();
                }
            } else if (AbinitMpViewer.this.getNemonic(stringArray[2]) == c) {
                BaseDialog baseDialog = new BaseDialog(AbinitMpViewer.this.me, new LabelAttributePanel(AbinitMpViewer.this.residueLabel, AbinitMpViewer.this.atomLabel), MyResourceBundle.getResourceString("LabelDialog.Title"));
                baseDialog.setLocation(200, 5);
                baseDialog.setVisible(true);
                LabelAttributePanel labelAttributePanel = (LabelAttributePanel)baseDialog.getPanel();
                if (labelAttributePanel != null) {
                    int[] nArray = labelAttributePanel.getValue();
                    AbinitMpViewer.this.residueLabel = nArray[0];
                    AbinitMpViewer.this.atomLabel = nArray[1];
                    AbinitMpViewer.this.setWaitCursor();
                    AbinitMpViewer.this.moRootNode = AbinitMpViewer.this.createStructureNode();
                    AbinitMpViewer.this.sceneViewer.replaceMoNode(AbinitMpViewer.this.moRootNode);
                    AbinitMpViewer.this.setDefaultCursor();
                }
            } else if (AbinitMpViewer.this.getNemonic(stringArray[3]) == c) {
                AbinitMpViewer.this.hBondsAllEnable = !AbinitMpViewer.this.hBondsAllEnable;
                AbinitMpViewer.this.hBondsIntermoleculeEnable = false;
                AbinitMpViewer.this.hBondsIntermoleculeMenu.setForeground(Color.black);
                if (AbinitMpViewer.this.hBondsAllEnable) {
                    AbinitMpViewer.this.hBondsAllMenu.setForeground(Color.green);
                } else {
                    AbinitMpViewer.this.hBondsAllMenu.setForeground(Color.black);
                }
                for (int i = 0; i < AbinitMpViewer.this.chainTable.size(); ++i) {
                    MolecularStructure molecularStructure = (MolecularStructure)AbinitMpViewer.this.chainTable.get(i);
                    molecularStructure.setHBondsEnable(AbinitMpViewer.this.hBondsAllEnable, AbinitMpViewer.this.hBondsIntermoleculeEnable);
                }
            } else if (AbinitMpViewer.this.getNemonic(stringArray[4]) == c) {
                AbinitMpViewer.this.hBondsIntermoleculeEnable = !AbinitMpViewer.this.hBondsIntermoleculeEnable;
                AbinitMpViewer.this.hBondsAllEnable = false;
                AbinitMpViewer.this.hBondsAllMenu.setForeground(Color.black);
                if (AbinitMpViewer.this.hBondsIntermoleculeEnable) {
                    AbinitMpViewer.this.hBondsIntermoleculeMenu.setForeground(Color.green);
                } else {
                    AbinitMpViewer.this.hBondsIntermoleculeMenu.setForeground(Color.black);
                }
                for (int i = 0; i < AbinitMpViewer.this.chainTable.size(); ++i) {
                    MolecularStructure molecularStructure = (MolecularStructure)AbinitMpViewer.this.chainTable.get(i);
                    molecularStructure.setHBondsEnable(AbinitMpViewer.this.hBondsAllEnable, AbinitMpViewer.this.hBondsIntermoleculeEnable);
                }
            } else if (AbinitMpViewer.this.getNemonic(stringArray[5]) == c) {
                AbinitMpViewer.this.clearNodeTable();
            } else if (AbinitMpViewer.this.getNemonic(stringArray[6]) == c) {
                BaseDialog baseDialog = new BaseDialog(AbinitMpViewer.this.me, new DisplayResiduePanel(AbinitMpViewer.this.displayResidue), MyResourceBundle.getResourceString("DisplayResidueDialog.Title"));
                baseDialog.setVisible(true);
                DisplayResiduePanel displayResiduePanel = (DisplayResiduePanel)baseDialog.getPanel();
                if (displayResiduePanel != null) {
                    boolean[] blArray = displayResiduePanel.getValue();
                    for (int i = 0; i < blArray.length; ++i) {
                        ((AbinitMpViewer)AbinitMpViewer.this).displayResidue[i] = blArray[i];
                    }
                    AbinitMpViewer.this.setWaitCursor();
                    AbinitMpViewer.this.moRootNode = AbinitMpViewer.this.createStructureNode();
                    AbinitMpViewer.this.sceneViewer.replaceMoNode(AbinitMpViewer.this.moRootNode);
                    AbinitMpViewer.this.setDefaultCursor();
                }
            } else if (AbinitMpViewer.this.getNemonic(stringArray[7]) == c) {
                FileItem fileItem;
                if (AbinitMpViewer.this.addHydrogenDialog == null) {
                    AbinitMpViewer.this.addHydrogenPanel = new AddHydrogenPanel(AbinitMpViewer.this.me);
                    AbinitMpViewer.this.addHydrogenDialog = new BaseDialog(AbinitMpViewer.this.me, AbinitMpViewer.this.addHydrogenPanel, MyResourceBundle.getResourceString("AddHydrogenDialog.Title"));
                    AbinitMpViewer.this.addHydrogenDialog.setModal(false);
                }
                if ((fileItem = (FileItem)AbinitMpViewer.this.fileList.get(0)) != null) {
                    String string5 = fileItem.fullname;
                    int n = string5.lastIndexOf(".");
                    String string6 = AbinitMpViewer.this.getExtension(string5);
                    if (!string6.equalsIgnoreCase("pdb") && !string6.equalsIgnoreCase("ent")) {
                        AbinitMpViewer.this.addMessageln("Warnning!! Please assign PDB file.");
                    }
                    AbinitMpViewer.this.addHydrogenPanel.setFilename(string5, string5.substring(0, n) + "_addH." + string6);
                    AbinitMpViewer.this.addHydrogenDialog.setVisible(true);
                }
            } else if (AbinitMpViewer.this.getNemonic(stringArray[8]) == c) {
                int n = AbinitMpViewer.this.treeTabPanel.getTabCount();
                if (n < 1) {
                    AbinitMpViewer.this.addMessageln("Need two files.");
                    return;
                }
                String[] stringArray2 = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray2[i] = AbinitMpViewer.this.treeTabPanel.getTitleAt(i);
                }
                AbinitMpViewer.this.overlayPanel = new OverlayPanel(AbinitMpViewer.this.me, stringArray2);
                AbinitMpViewer.this.overlayDialog = new BaseDialog(AbinitMpViewer.this.me, AbinitMpViewer.this.overlayPanel, MyResourceBundle.getResourceString("OverlayDialog.Title"));
                AbinitMpViewer.this.overlayDialog.setModal(false);
                AbinitMpViewer.this.overlayDialog.setOkButtonLabel(MyResourceBundle.getResourceString("apply"));
                AbinitMpViewer.this.overlayDialog.setCancelButtonLabel(MyResourceBundle.getResourceString("close"));
                AbinitMpViewer.this.overlayDialog.setLocation(200, 5);
                AbinitMpViewer.this.overlayDialog.setVisible(true);
                AbinitMpViewer.this.addMessageln("Click residue or atom.");
            } else if (AbinitMpViewer.this.getNemonic(stringArray[9]) == c) {
                AtomData atomData = null;
                if (AbinitMpViewer.this.selectionList.size() != 0) {
                    SelectionData selectionData = (SelectionData)AbinitMpViewer.this.selectionList.get(0);
                    atomData = selectionData.atomData;
                }
                if (atomData == null) {
                    AbinitMpViewer.this.addMessageln("Please select atom and select this menu.");
                    return;
                }
                int n = AbinitMpViewer.this.treeTabPanel.getSelectedIndex();
                if (n == -1) {
                    return;
                }
                FileItem fileItem = ((TreePanel)((AbinitMpViewer)AbinitMpViewer.this).treeTabPanel.getComponentAt((int)n)).fileItem;
                float[] fArray = new float[3];
                AbinitMpViewer.this.getCoordinate(atomData, fileItem, fArray);
                AbinitMpViewer.this.sceneViewer.setCenter(fArray[0], fArray[1], fArray[2]);
            } else if (AbinitMpViewer.this.getNemonic(stringArray[10]) == c) {
                AbinitMpViewer.this.sceneViewer.resetCenter();
            } else if (AbinitMpViewer.this.getNemonic(stringArray[11]) == c) {
                for (int i = 0; i < AbinitMpViewer.this.fileList.size(); ++i) {
                    FileItem fileItem = (FileItem)AbinitMpViewer.this.fileList.get(i);
                    fileItem.calcNewCoord(AbinitMpViewer.this.me);
                }
                AbinitMpViewer.this.calcCoordInfo();
                if (AbinitMpViewer.this.selectionList != null && AbinitMpViewer.this.selectionList.size() > 0) {
                    Object object;
                    Object object2;
                    int n;
                    float f = 0.0f;
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    int n2 = AbinitMpViewer.this.selectionList.size();
                    for (n = 0; n < n2; ++n) {
                        object2 = (SelectionData)AbinitMpViewer.this.selectionList.get(n);
                        object = ((SelectionData)object2).atomData;
                        f += ((AtomData)object).x;
                        f2 += ((AtomData)object).y;
                        f3 += ((AtomData)object).z;
                    }
                    f /= (float)n2;
                    f2 /= (float)n2;
                    f3 /= (float)n2;
                    n = 0;
                    if (n < AbinitMpViewer.this.treeTabPanel.getTabCount()) {
                        object2 = (TreePanel)AbinitMpViewer.this.treeTabPanel.getComponentAt(n);
                        object = ((TreePanel)((AbinitMpViewer)AbinitMpViewer.this).treeTabPanel.getComponentAt((int)n)).fileItem;
                        ((FileItem)object).coordInfo.setCenter(f, f2, f3);
                    }
                }
                AbinitMpViewer.this.displayMoNode();
            } else if (AbinitMpViewer.this.getNemonic(stringArray[12]) == c) {
                if (AbinitMpViewer.this.textAssignWindow == null) {
                    AbinitMpViewer.this.textAssignWindow = new TextAssignWindow(AbinitMpViewer.this.me);
                }
                AbinitMpViewer.this.textAssignWindow.setVisible(true);
            }
        }
    }

    class selectionListener
    extends AbstractAction {
        selectionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            String[] stringArray = MyResourceBundle.getResourceStringsWithoutSeparator("AbinitMpViewer.selectionMenu");
            char c = string.charAt(0);
            if (AbinitMpViewer.this.getNemonic(stringArray[0]) == c) {
                AbinitMpViewer.this.selectionMode = 3;
            } else if (AbinitMpViewer.this.getNemonic(stringArray[1]) == c) {
                AbinitMpViewer.this.selectionMode = 2;
            }
        }
    }

    class residueColorListener
    extends AbstractAction {
        residueColorListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            String[] stringArray = MyResourceBundle.getResourceStringsWithoutSeparator("AbinitMpViewer.residueColorMenu");
            char c = string.charAt(0);
            if (AbinitMpViewer.this.getNemonic(stringArray[0]) == c) {
                AbinitMpViewer.this.moColor = 2;
            } else if (AbinitMpViewer.this.getNemonic(stringArray[1]) == c) {
                AbinitMpViewer.this.moColor = 8;
            } else if (AbinitMpViewer.this.getNemonic(stringArray[2]) == c) {
                AbinitMpViewer.this.moColor = 9;
            } else if (AbinitMpViewer.this.getNemonic(stringArray[3]) == c) {
                AbinitMpViewer.this.moColor = 10;
            } else if (AbinitMpViewer.this.getNemonic(stringArray[4]) == c) {
                BaseDialog baseDialog = new BaseDialog(AbinitMpViewer.this.me, new DisplayResiduePanel(AbinitMpViewer.this.displayResidueColor), MyResourceBundle.getResourceString("DisplayResidueColorDialog.Title"));
                baseDialog.setVisible(true);
                DisplayResiduePanel displayResiduePanel = (DisplayResiduePanel)baseDialog.getPanel();
                if (displayResiduePanel != null) {
                    AbinitMpViewer.this.moColor = 11;
                    boolean[] blArray = displayResiduePanel.getValue();
                    for (int i = 0; i < blArray.length; ++i) {
                        ((AbinitMpViewer)AbinitMpViewer.this).displayResidueColor[i] = blArray[i];
                    }
                }
            }
            AbinitMpViewer.this.setWaitCursor();
            AbinitMpViewer.this.moRootNode = AbinitMpViewer.this.createStructureNode();
            AbinitMpViewer.this.sceneViewer.replaceMoNode(AbinitMpViewer.this.moRootNode);
            AbinitMpViewer.this.setDefaultCursor();
        }
    }

    class colorListener
    extends AbstractAction {
        colorListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            String[] stringArray = MyResourceBundle.getResourceStringsWithoutSeparator("AbinitMpViewer.colorMenu");
            char c = string.charAt(0);
            if (AbinitMpViewer.this.moColor == 7) {
                for (n = 0; n < AbinitMpViewer.this.treeTabPanel.getTabCount(); ++n) {
                    AbinitMpViewer.this.treeTabPanel.setForegroundAt(n, Color.black);
                }
            }
            if (AbinitMpViewer.this.getNemonic(stringArray[0]) == c) {
                AbinitMpViewer.this.moColor = 1;
            } else if (AbinitMpViewer.this.getNemonic(stringArray[1]) == c) {
                AbinitMpViewer.this.moColor = 2;
            } else if (AbinitMpViewer.this.getNemonic(stringArray[2]) == c) {
                AbinitMpViewer.this.moColor = 3;
            } else if (AbinitMpViewer.this.getNemonic(stringArray[3]) == c) {
                float f;
                float f2;
                AbinitMpViewer.this.moColor = 4;
                n = AbinitMpViewer.this.treeTabPanel.getSelectedIndex();
                if (n == -1) {
                    return;
                }
                FileItem fileItem = ((TreePanel)((AbinitMpViewer)AbinitMpViewer.this).treeTabPanel.getComponentAt((int)n)).fileItem;
                if (fileItem.type != 5) {
                    AbinitMpViewer.this.addMessageln("This file have no charge data.");
                    return;
                }
                CheckPointFile checkPointFile = (CheckPointFile)fileItem.file;
                if (checkPointFile.displayMullikenMinValue == 0.0f && checkPointFile.displayMullikenMaxValue == 0.0f) {
                    f2 = -0.5f;
                    f = 0.5f;
                } else {
                    f2 = checkPointFile.displayMullikenMinValue;
                    f = checkPointFile.displayMullikenMaxValue;
                }
                BaseDialog baseDialog = new BaseDialog(AbinitMpViewer.this.me, new MullikenValuePanel(f2, f), MyResourceBundle.getResourceString("MullikenValueDialog.Title"));
                baseDialog.setVisible(true);
                MullikenValuePanel mullikenValuePanel = (MullikenValuePanel)baseDialog.getPanel();
                if (mullikenValuePanel == null) {
                    return;
                }
                float[] fArray = mullikenValuePanel.getValue();
                f2 = fArray[0];
                f = fArray[1];
                if (f2 == 0.0f && f == 0.0f) {
                    f2 = checkPointFile.mullikenMinValue;
                    f = checkPointFile.mullikenMaxValue;
                }
                checkPointFile.displayMullikenMinValue = f2;
                checkPointFile.displayMullikenMaxValue = f;
                checkPointFile.colorMap = new ColorMap(f2, f, 0);
            } else if (AbinitMpViewer.this.getNemonic(stringArray[4]) == c) {
                AbinitMpViewer.this.moColor = 5;
            } else if (AbinitMpViewer.this.getNemonic(stringArray[5]) == c) {
                AbinitMpViewer.this.moColor = 6;
            } else if (AbinitMpViewer.this.getNemonic(stringArray[6]) == c) {
                AbinitMpViewer.this.moColor = 7;
                for (n = 0; n < AbinitMpViewer.this.treeTabPanel.getTabCount(); ++n) {
                    AbinitMpViewer.this.treeTabPanel.setForegroundAt(n, DisplayPreference.fileColor[n % DisplayPreference.fileColor.length].color.get());
                }
            }
            if (AbinitMpViewer.this.periodicWindow != null && AbinitMpViewer.this.periodicWindow.isVisible()) {
                AbinitMpViewer.this.periodicWindow.redrawCanvas();
            } else {
                AbinitMpViewer.this.setWaitCursor();
                AbinitMpViewer.this.moRootNode = AbinitMpViewer.this.createStructureNode();
                AbinitMpViewer.this.sceneViewer.replaceMoNode(AbinitMpViewer.this.moRootNode);
                AbinitMpViewer.this.setDefaultCursor();
            }
        }
    }

    class modelListener
    extends AbstractAction {
        modelListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            String[] stringArray = MyResourceBundle.getResourceStringsWithoutSeparator("AbinitMpViewer.modelMenu");
            char c = string.charAt(0);
            if (AbinitMpViewer.this.getNemonic(stringArray[0]) == c) {
                AbinitMpViewer.this.moModel = 1;
            } else if (AbinitMpViewer.this.getNemonic(stringArray[1]) == c) {
                AbinitMpViewer.this.moModel = 2;
            } else if (AbinitMpViewer.this.getNemonic(stringArray[2]) == c) {
                AbinitMpViewer.this.moModel = 3;
            } else if (AbinitMpViewer.this.getNemonic(stringArray[3]) == c) {
                AbinitMpViewer.this.moModel = 4;
            } else if (AbinitMpViewer.this.getNemonic(stringArray[4]) == c) {
                AbinitMpViewer.this.moModel = 5;
            } else if (AbinitMpViewer.this.getNemonic(stringArray[5]) == c) {
                AbinitMpViewer.this.moModel = 6;
            } else if (AbinitMpViewer.this.getNemonic(stringArray[6]) == c) {
                AbinitMpViewer.this.moModel = 7;
            } else if (AbinitMpViewer.this.getNemonic(stringArray[7]) == c) {
                AbinitMpViewer.this.moModel = 8;
            } else if (AbinitMpViewer.this.getNemonic(stringArray[8]) == c) {
                AbinitMpViewer.this.moModel = 9;
            } else if (AbinitMpViewer.this.getNemonic(stringArray[9]) == c) {
                AbinitMpViewer.this.moModel = 10;
            }
            if (AbinitMpViewer.this.periodicWindow != null && AbinitMpViewer.this.periodicWindow.isVisible()) {
                AbinitMpViewer.this.periodicWindow.redrawCanvas();
            } else {
                AbinitMpViewer.this.setWaitCursor();
                AbinitMpViewer.this.moRootNode = AbinitMpViewer.this.createStructureNode();
                AbinitMpViewer.this.sceneViewer.replaceMoNode(AbinitMpViewer.this.moRootNode);
                AbinitMpViewer.this.setDefaultCursor();
            }
        }
    }

    class viewpointListener
    extends AbstractAction {
        viewpointListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            String[] stringArray = MyResourceBundle.getResourceStringsWithoutSeparator("AbinitMpViewer.viewpointMenu");
            char c = string.charAt(0);
            if (AbinitMpViewer.this.getNemonic(stringArray[0]) == c) {
                AbinitMpViewer.this.sceneViewer.setViewPoint("front");
            } else if (AbinitMpViewer.this.getNemonic(stringArray[1]) == c) {
                AbinitMpViewer.this.sceneViewer.setViewPoint("back");
            } else if (AbinitMpViewer.this.getNemonic(stringArray[2]) == c) {
                AbinitMpViewer.this.sceneViewer.setViewPoint("left");
            } else if (AbinitMpViewer.this.getNemonic(stringArray[3]) == c) {
                AbinitMpViewer.this.sceneViewer.setViewPoint("right");
            } else if (AbinitMpViewer.this.getNemonic(stringArray[4]) == c) {
                AbinitMpViewer.this.sceneViewer.setViewPoint("top");
            } else if (AbinitMpViewer.this.getNemonic(stringArray[5]) == c) {
                AbinitMpViewer.this.sceneViewer.setViewPoint("bottom");
            } else if (AbinitMpViewer.this.getNemonic(stringArray[6]) == c) {
                AbinitMpViewer.this.sceneViewer.setViewPoint("rotate_x");
            } else if (AbinitMpViewer.this.getNemonic(stringArray[7]) == c) {
                AbinitMpViewer.this.sceneViewer.setViewPoint("rotate_y");
            } else if (AbinitMpViewer.this.getNemonic(stringArray[8]) == c) {
                AbinitMpViewer.this.sceneViewer.setViewPoint("rotate_z");
            } else if (AbinitMpViewer.this.getNemonic(stringArray[9]) == c) {
                if (AbinitMpViewer.this.translateWindow == null) {
                    AbinitMpViewer.this.translateWindow = new TranslateWindow(AbinitMpViewer.this.me);
                }
                AbinitMpViewer.this.translateWindow.setVisible(true);
            } else if (AbinitMpViewer.this.getNemonic(stringArray[10]) == c && AbinitMpViewer.this.fileList.size() > 0) {
                AbinitMpViewer.this.periodicWindow = new PeriodicWindow(AbinitMpViewer.this.me, AbinitMpViewer.this.fileList);
                AbinitMpViewer.this.periodicWindow.setVisible(true);
            }
        }
    }

    class fileListener
    extends AbstractAction {
        JFileChooser openFileChooser;
        JFileChooser saveFileChooser;
        JFileChooser jpegFileChooser;

        fileListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            String[] stringArray = MyResourceBundle.getResourceStringsWithoutSeparator("AbinitMpViewer.fileMenu");
            char c = string.charAt(0);
            if (this.openFileChooser == null) {
                this.openFileChooser = new JFileChooser(".");
                object = this.openFileChooser.getFileFilter();
                this.openFileChooser.addChoosableFileFilter(AbinitMpViewer.this.pdbFileFilter);
                this.openFileChooser.addChoosableFileFilter(AbinitMpViewer.this.cpfFileFilter);
                this.openFileChooser.addChoosableFileFilter(AbinitMpViewer.this.gridFileFilter);
                this.openFileChooser.addChoosableFileFilter(AbinitMpViewer.this.mol2FileFilter);
                this.openFileChooser.addChoosableFileFilter(AbinitMpViewer.this.mdlFileFilter);
                this.openFileChooser.addChoosableFileFilter(AbinitMpViewer.this.cubeFileFilter);
                this.openFileChooser.addChoosableFileFilter(AbinitMpViewer.this.xyzFileFilter);
                this.openFileChooser.addChoosableFileFilter(AbinitMpViewer.this.trjFileFilter);
                this.openFileChooser.setFileFilter((FileFilter)object);
                this.openFileChooser.setMultiSelectionEnabled(true);
                this.openFileChooser.setPreferredSize(new Dimension(500, 500));
            }
            if (this.saveFileChooser == null) {
                this.saveFileChooser = new JFileChooser(".");
                object = this.saveFileChooser.getFileFilter();
                this.saveFileChooser.addChoosableFileFilter(AbinitMpViewer.this.pdbFileFilter);
                this.saveFileChooser.addChoosableFileFilter(AbinitMpViewer.this.gjfFileFilter);
                this.saveFileChooser.addChoosableFileFilter(AbinitMpViewer.this.jpgFileFilter);
                this.saveFileChooser.addChoosableFileFilter(AbinitMpViewer.this.xyzFileFilter);
                this.saveFileChooser.setFileFilter((FileFilter)object);
                this.saveFileChooser.setPreferredSize(new Dimension(500, 500));
            }
            if (AbinitMpViewer.this.getNemonic(stringArray[0]) == c) {
                if (this.openFileChooser.showOpenDialog(null) == 0) {
                    object = this.openFileChooser.getSelectedFiles();
                    for (int i = 0; i < ((File[])object).length; ++i) {
                        String string2 = object[i].getPath();
                        FileFilter fileFilter = this.openFileChooser.getFileFilter();
                        String string3 = AbinitMpViewer.this.getExtension(string2);
                        if ("pdb".equalsIgnoreCase(string3) || "ent".equalsIgnoreCase(string3) || "cpf".equalsIgnoreCase(string3) || "map".equalsIgnoreCase(string3) || "den".equalsIgnoreCase(string3) || "esp".equalsIgnoreCase(string3) || "mo".equalsIgnoreCase(string3) || "efv".equalsIgnoreCase(string3) || "mol2".equalsIgnoreCase(string3) || "mdl".equalsIgnoreCase(string3) || "mol".equalsIgnoreCase(string3) || "cube".equalsIgnoreCase(string3) || "cub".equalsIgnoreCase(string3) || "xyz".equalsIgnoreCase(string3) || "trj".equalsIgnoreCase(string3) || "tr2".equalsIgnoreCase(string3) || "trj2".equalsIgnoreCase(string3) || "tj2".equalsIgnoreCase(string3)) {
                            AbinitMpViewer.this.openFile(string2);
                        } else {
                            AbinitMpViewer.this.addMessageln("This file type dont't implement.");
                        }
                        if (AbinitMpViewer.this.moColor != 7) continue;
                        int n = AbinitMpViewer.this.treeTabPanel.getTabCount() - 1;
                        AbinitMpViewer.this.treeTabPanel.setForegroundAt(n, DisplayPreference.fileColor[n % DisplayPreference.fileColor.length].color.get());
                    }
                }
            } else if (AbinitMpViewer.this.getNemonic(stringArray[1]) == c) {
                object = new BaseDialog(AbinitMpViewer.this.me, new DifferenceFilePanel(), "Files");
                ((Dialog)object).setVisible(true);
                DifferenceFilePanel differenceFilePanel = (DifferenceFilePanel)((BaseDialog)object).getPanel();
                if (differenceFilePanel != null) {
                    int n;
                    String[] stringArray2 = differenceFilePanel.getFilenames();
                    float[] fArray = differenceFilePanel.getCoefficients();
                    for (n = 0; n < stringArray2.length && stringArray2[n].length() != 0; ++n) {
                    }
                    if (n > 1) {
                        int n2;
                        int n3;
                        GridFile[] gridFileArray = new GridFile[n];
                        for (n3 = 0; n3 < n; ++n3) {
                            gridFileArray[n3] = new GridFile(stringArray2[n3]);
                            if (gridFileArray[n3].filename != null) continue;
                            return;
                        }
                        for (n3 = 0; n3 < n; ++n3) {
                            if (gridFileArray[n3].type == 0) continue;
                            JOptionPane.showMessageDialog(AbinitMpViewer.this.me, "It is not density file.", "Error message", 0);
                            return;
                        }
                        for (n3 = 1; n3 < n; ++n3) {
                            if (gridFileArray[0].nx == gridFileArray[n3].nx && gridFileArray[0].ny == gridFileArray[n3].ny && gridFileArray[0].nz == gridFileArray[n3].nz) continue;
                            JOptionPane.showMessageDialog(AbinitMpViewer.this.me, "Different mesh size files.", "Error message", 0);
                            return;
                        }
                        AbinitMpViewer.this.addMessageln("coefficient  File name   ");
                        String string4 = new String();
                        for (int i = 0; i < n; ++i) {
                            String string5 = new String(stringArray2[i]);
                            if ((string5 = string5.replace('\\', '/')).lastIndexOf("/") != -1) {
                                string5 = string5.substring(string5.lastIndexOf("/") + 1);
                            }
                            if (i != 0) {
                                string4.concat("-");
                            }
                            string4 = string4.concat(string5);
                            AbinitMpViewer.this.addMessageln(fArray[i] + " " + stringArray2[i]);
                        }
                        gridFileArray[0].type = 14;
                        gridFileArray[0].filename = string4;
                        FileItem fileItem = new FileItem(gridFileArray[0], gridFileArray[0].filename, 14, true);
                        AbinitMpViewer.this.fileList.add(fileItem);
                        for (n2 = 0; n2 < gridFileArray[0].nxyz; ++n2) {
                            gridFileArray[0].densityValue[n2] = gridFileArray[0].densityValue[n2] * fArray[0];
                        }
                        for (n2 = 1; n2 < n; ++n2) {
                            for (int i = 0; i < gridFileArray[0].nxyz; ++i) {
                                gridFileArray[0].densityValue[i] = gridFileArray[0].densityValue[i] + gridFileArray[n2].densityValue[i] * fArray[n2];
                            }
                        }
                        fileItem.isosurfaceValue = new IsosurfaceValue(gridFileArray[0].isosurfaceValue, DisplayPreference.moMinusColor, DisplayPreference.moPlusColor, 0);
                        IsosurfaceValueWindow isosurfaceValueWindow = new IsosurfaceValueWindow(AbinitMpViewer.this.me, fileItem);
                        isosurfaceValueWindow.setVisible(true);
                        fileItem.isosurfaceValueWindow = isosurfaceValueWindow;
                        AbinitMpViewer.this.calcCoordInfo();
                        AbinitMpViewer.this.sceneViewer.setScale(AbinitMpViewer.this.coordInfo.scale);
                        AbinitMpViewer.this.sceneViewer.setViewPoint("front");
                        AbinitMpViewer.this.createNode(fileItem, null);
                        AbinitMpViewer.this.setDefaultCursor();
                    }
                }
            } else if (AbinitMpViewer.this.getNemonic(stringArray[2]) == c) {
                if (this.saveFileChooser.showSaveDialog(null) == 0) {
                    object = this.saveFileChooser.getSelectedFile().getPath();
                    try {
                        FileFilter fileFilter = this.saveFileChooser.getFileFilter();
                        String string6 = AbinitMpViewer.this.getExtension((String)object);
                        if (fileFilter == AbinitMpViewer.this.pdbFileFilter || "pdb".equalsIgnoreCase(string6) || "ent".equalsIgnoreCase(string6)) {
                            AbinitMpViewer.this.savePdbFile((String)object);
                        } else if (fileFilter == AbinitMpViewer.this.gjfFileFilter || "gjf".equalsIgnoreCase(string6)) {
                            AbinitMpViewer.this.saveGaussianFile((String)object);
                        } else if (fileFilter == AbinitMpViewer.this.jpgFileFilter || "jpg".equalsIgnoreCase(string6) || "jpeg".equalsIgnoreCase(string6) || "png".equalsIgnoreCase(string6)) {
                            if (((String)object).lastIndexOf(".") == -1) {
                                object = ((String)object).concat(".jpg");
                                string6 = "jpg";
                            }
                            AbinitMpViewer.this.sceneViewer.saveImage((String)object, string6);
                            AbinitMpViewer.this.addMessageln("Save " + string6 + " file(" + (String)object + ")");
                        } else if (fileFilter == AbinitMpViewer.this.xyzFileFilter || "xyz".equalsIgnoreCase(string6)) {
                            AbinitMpViewer.this.saveXyzFile((String)object);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.out);
                        System.out.println(exception.getMessage());
                    }
                }
            } else if (AbinitMpViewer.this.getNemonic(stringArray[3]) == c) {
                if (AbinitMpViewer.this.ajfFileWindow == null) {
                    AbinitMpViewer.this.ajfFileWindow = new AjfFileWindow(AbinitMpViewer.this.me);
                }
                if (AbinitMpViewer.this.fileList.size() > 0) {
                    object = (FileItem)AbinitMpViewer.this.fileList.get(0);
                    if (((FileItem)object).type == 4) {
                        AbinitMpViewer.this.ajfFileWindow.setReadGeomFilename(((FileItem)object).filename);
                    }
                }
                AbinitMpViewer.this.ajfFileWindow.setVisible(true);
            } else if (AbinitMpViewer.this.getNemonic(stringArray[4]) == c) {
                if (AbinitMpViewer.this.gaussianInputFileWindow == null) {
                    AbinitMpViewer.this.gaussianInputFileWindow = new GaussianInputFileWindow();
                }
                if (AbinitMpViewer.this.fileList.size() > 0) {
                    object = (FileItem)AbinitMpViewer.this.fileList.get(0);
                    if (((FileItem)object).type == 4) {
                        AbinitMpViewer.this.gaussianInputFileWindow.setMolecule((PdbFile)((FileItem)object).file);
                    } else if (((FileItem)object).type == 5) {
                        AbinitMpViewer.this.gaussianInputFileWindow.setMolecule(((CheckPointFile)((FileItem)object).file).pdbFile);
                    }
                }
                AbinitMpViewer.this.gaussianInputFileWindow.setVisible(true);
            } else if (AbinitMpViewer.this.getNemonic(stringArray[5]) == c) {
                if (AbinitMpViewer.this.cpf2denInputFileWindow == null) {
                    AbinitMpViewer.this.cpf2denInputFileWindow = new Cpf2denInputFileWindow();
                }
                AbinitMpViewer.this.cpf2denInputFileWindow.setVisible(true);
                if (AbinitMpViewer.this.fileList.size() > 0) {
                    object = (FileItem)AbinitMpViewer.this.fileList.get(0);
                    if (((FileItem)object).type == 5) {
                        AbinitMpViewer.this.cpf2denInputFileWindow.setCpfFileDomain((CheckPointFile)((FileItem)object).file);
                    }
                }
            } else if (AbinitMpViewer.this.getNemonic(stringArray[6]) == c) {
                if (AbinitMpViewer.this.fileList.size() > 0) {
                    object = new FileListWindow(AbinitMpViewer.this.me, AbinitMpViewer.this.fileList);
                    ((Window)object).setVisible(true);
                }
            } else if (AbinitMpViewer.this.getNemonic(stringArray[7]) == c) {
                if (AbinitMpViewer.this.fileList.size() > 0) {
                    object = new BaseDialog(AbinitMpViewer.this.me, new DeleteFileItemPanel(AbinitMpViewer.this.fileList), MyResourceBundle.getResourceString("AbinitMpViewer.DeleteFileItemDialog.Title"));
                    ((Dialog)object).setVisible(true);
                    DeleteFileItemPanel deleteFileItemPanel = (DeleteFileItemPanel)((BaseDialog)object).getPanel();
                    if (deleteFileItemPanel != null) {
                        boolean[] blArray = deleteFileItemPanel.getValue();
                        for (int i = blArray.length - 1; i >= 0; --i) {
                            ResidueData residueData;
                            int n;
                            if (!blArray[i]) continue;
                            FileItem fileItem = (FileItem)AbinitMpViewer.this.fileList.get(i);
                            if ((fileItem.type == 3 || fileItem.type == 10) && AbinitMpViewer.this.moGraphWindow != null) {
                                AbinitMpViewer.this.moGraphWindow.setVisible(false);
                                AbinitMpViewer.this.moGraphWindow = null;
                            }
                            if (fileItem.isosurfaceValueWindow != null) {
                                fileItem.isosurfaceValueWindow.setVisible(false);
                            }
                            if (fileItem.electricFieldAssignWindow != null) {
                                fileItem.electricFieldAssignWindow.setVisible(false);
                            }
                            if (fileItem.sectionFileRootNode != null) {
                                AbinitMpViewer.this.deleteSectionFileRootNode(fileItem.sectionFileRootNode);
                            }
                            for (n = AbinitMpViewer.this.treeTabPanel.getTabCount() - 1; n >= 0; --n) {
                                if (!AbinitMpViewer.this.treeTabPanel.getTitleAt(n).equals(fileItem.filename)) continue;
                                AbinitMpViewer.this.treeTabPanel.remove(n);
                                break;
                            }
                            AbinitMpViewer.this.fileList.remove(i);
                            for (n = AbinitMpViewer.this.selectionList.size() - 1; n >= 0; --n) {
                                residueData = ((SelectionData)((AbinitMpViewer)AbinitMpViewer.this).selectionList.get((int)n)).residueData;
                                if (AbinitMpViewer.this.isElement(fileItem, residueData) == null) continue;
                                AbinitMpViewer.this.selectionList.remove(residueData);
                            }
                            Enumeration enumeration = AbinitMpViewer.this.nodeTable.keys();
                            while (enumeration.hasMoreElements()) {
                                residueData = enumeration.nextElement();
                                NodeData nodeData = (NodeData)AbinitMpViewer.this.nodeTable.get(residueData);
                                if (nodeData.fileItem != fileItem) continue;
                                AbinitMpViewer.this.nodeTable.remove(residueData);
                            }
                            if (AbinitMpViewer.this.inDistanceData != null && AbinitMpViewer.this.isElement(fileItem, ((AbinitMpViewer)AbinitMpViewer.this).inDistanceData.residueData) != null) {
                                AbinitMpViewer.this.inDistanceData = null;
                            }
                            if (fileItem.type != 13) continue;
                            AbinitMpViewer.this.sceneViewer.removeTrajectoryText();
                        }
                        AbinitMpViewer.this.setWaitCursor();
                        AbinitMpViewer.this.calcCoordInfo();
                        AbinitMpViewer.this.moRootNode = AbinitMpViewer.this.createStructureNode();
                        AbinitMpViewer.this.sceneViewer.setSceneGraph(AbinitMpViewer.this.moRootNode);
                        AbinitMpViewer.this.isoRootNode = AbinitMpViewer.this.createIsosurfaceNode();
                        AbinitMpViewer.this.sceneViewer.addNode((Node)AbinitMpViewer.this.isoRootNode);
                        AbinitMpViewer.this.sceneViewer.setScale(AbinitMpViewer.this.coordInfo.scale);
                        AbinitMpViewer.this.sceneViewer.setViewPoint("front");
                        AbinitMpViewer.this.setDefaultCursor();
                        if (AbinitMpViewer.this.fileList.size() == 0) {
                            AbinitMpViewer.this.moModel = 1;
                            AbinitMpViewer.this.moColor = 1;
                            AbinitMpViewer.this.wireframeModelMenu.setSelected(true);
                            AbinitMpViewer.this.atomColorMenu.setSelected(true);
                            AbinitMpViewer.this.selectionList.removeAllElements();
                        }
                    }
                }
            } else if (AbinitMpViewer.this.getNemonic(stringArray[8]) == c) {
                System.exit(0);
            }
        }
    }

    class MyChangeListener
    implements ChangeListener {
        MyChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            AbinitMpViewer.this.setDirectionDisplay();
        }
    }
}

