/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram;

import hep.aida.IAnnotation;
import hep.aida.IBaseHistogram;
import hep.aida.ref.AidaUtils;
import hep.aida.ref.Annotation;
import hep.aida.ref.ManagedObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractBaseHistogram
extends ManagedObject
implements IBaseHistogram {
    private int dimension;
    private IAnnotation annotation;
    static String[] styleKeys = new String[]{"xaxislabel", "xaxisscale", "xaxistype", "yaxislabel", "yaxisscale", "yaxistype"};

    public AbstractBaseHistogram(String name, String title, int dimension) {
        this(name, title, dimension, null);
    }

    public AbstractBaseHistogram(String name, String title, int dimension, String options) {
        super(name);
        this.dimension = dimension;
        this.annotation = new Annotation();
        this.annotation.addItem(Annotation.titleKey, title, true);
        this.setOptions(options);
    }

    private void setOptions(String options) {
        String key;
        if (options == null || options.trim().equals("")) {
            return;
        }
        String[] arr = AidaUtils.parseString(options);
        if (arr == null || arr.length == 0) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < arr.length; ++i) {
            String tmp = arr[i];
            if (tmp.length() <= 11 || !tmp.substring(0, 11).equalsIgnoreCase("annotation.")) continue;
            key = tmp.substring(11);
            int index = key.indexOf("=");
            if (index > 0) {
                key = key.substring(0, index);
            }
            list.add(key);
        }
        Map optionMap = AidaUtils.parseOptions(options);
        Iterator it = optionMap.keySet().iterator();
        while (it.hasNext()) {
            key = (String)it.next();
            for (int i = 0; i < list.size(); ++i) {
                String val;
                if (!key.equals((String)list.get(i)) || (val = (String)optionMap.get(key)) == null) continue;
                this.annotation.addItem(key, val, true);
            }
        }
    }

    public String title() {
        String title = this.annotation.value(Annotation.titleKey);
        if (title == null) {
            title = "";
        }
        return title;
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        this.annotation.setValue(Annotation.titleKey, title);
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public IAnnotation annotation() {
        return this.annotation;
    }

    public void setAnnotation(IAnnotation annotation) {
        this.annotation = annotation;
    }

    public int dimension() {
        return this.dimension;
    }

    public void reset() {
        this.annotation.reset();
    }

    public abstract int entries();

    public abstract int nanEntries();
}

