/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataSource;
import jas.hist.JASHist;
import jas.hist.JASHistData;
import jas.hist.ScatterDataManager;
import jas.hist.StatisticsBlock;
import jas.plot.DataArea;
import jas.plot.DateAxis;
import jas.plot.DoubleAxis;
import jas.plot.Legend;
import java.util.TimeZone;

final class DateScatterDataManager
extends ScatterDataManager {
    private DateAxis xAxisType;

    DateScatterDataManager(JASHist jASHist, DataArea dataArea, Legend legend, StatisticsBlock statisticsBlock) {
        super(jASHist, dataArea, legend, statisticsBlock);
        DoubleAxis doubleAxis;
        if (this.xm.getType() instanceof DateAxis) {
            this.xAxisType = (DateAxis)this.xm.getType();
        } else {
            this.xAxisType = new DateAxis();
            this.xm.setType(this.xAxisType);
        }
        if (this.ym[0].getType() instanceof DoubleAxis) {
            doubleAxis = (DoubleAxis)this.ym[0].getType();
        } else {
            doubleAxis = new DoubleAxis();
            this.ym[0].setType(doubleAxis);
        }
        this.xm.setDataManager(this, false, this.xAxisType);
        this.ym[0].setDataManager(this, false, doubleAxis);
    }

    protected final void calcMinMaxXBins(double d, double d2) {
        long l = (long)(d * 1000.0);
        long l2 = (long)(d2 * 1000.0);
        long l3 = this.xAxisType.getAxisMin();
        long l4 = this.xAxisType.getAxisMax();
        if (l < l3 || l2 > l4 || (double)((l2 - l) / (l4 - l3)) < 0.75) {
            this.xAxisType.setMin(l);
            this.xAxisType.setMax(l2);
            this.xm.invalidate();
        }
    }

    JASHistData add(DataSource dataSource) {
        JASHistData jASHistData = super.add(dataSource);
        TimeZone timeZone = jASHistData.getStyle().getTimeZone();
        if (timeZone != null) {
            this.xAxisType.setTimeZone(timeZone);
        }
        return jASHistData;
    }

    void styleUpdate(JASHistData jASHistData) {
        TimeZone timeZone = jASHistData.getStyle().getTimeZone();
        if (timeZone != null) {
            this.xAxisType.setTimeZone(timeZone);
        }
        super.styleUpdate(jASHistData);
    }
}

