/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.ssh;

import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import java.io.File;
import org.apache.log4j.Logger;

public class KnownHosts {
    private static Logger logger = Logger.getLogger(KnownHosts.class.getName());
    private static final String known_hosts_string = System.getProperty("user.home") + System.getProperty("file.separator") + ".chase" + System.getProperty("file.separator") + "known_hosts";

    public static JSch getJSch() {
        JSch jsch = null;
        File known_hosts = new File(known_hosts_string);
        try {
            jsch = new JSch();
            jsch.setKnownHosts(known_hosts.getAbsolutePath());
            HostKeyRepository hkr = jsch.getHostKeyRepository();
            HostKey[] hks = hkr.getHostKey();
            if (hks != null) {
                logger.debug("Host keys in " + hkr.getKnownHostsRepositoryID());
                for (int i = 0; i < hks.length; ++i) {
                    HostKey hk = hks[i];
                    logger.debug(hk.getHost() + " " + hk.getType() + " " + hk.getFingerPrint(jsch));
                }
            }
        }
        catch (Exception exc) {
            logger.error("failed to initialize jsch");
        }
        return jsch;
    }
}

