/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.acviewer.mouselistener;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jp.advancesoft.chase.acviewer.MainPanel;
import jp.advancesoft.chase.acviewer.mouselistener.MouseMotionListenerAction;
import jp.advancesoft.chase.acviewer.mouselistener.MouseMotionListenerManager;
import org.apache.log4j.Logger;

public class ACVMouseMotionListener
implements MouseMotionListener,
MouseListener {
    private Logger logger = Logger.getLogger(ACVMouseMotionListener.class.getName());
    private MainPanel parent;
    private MouseMotionListenerManager manager;

    public ACVMouseMotionListener(MainPanel parent) {
        this.parent = parent;
        this.manager = new MouseMotionListenerManager(parent);
    }

    public void mouseDragged(MouseEvent e) {
        MouseMotionListenerAction action = this.manager.getAction(e);
        if (action == null) {
            this.logger.debug("action for " + MouseEvent.getMouseModifiersText(e.getModifiersEx()) + " not implemented yet.");
            return;
        }
        action.processMouseDrag(e);
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        MouseMotionListenerAction action = this.manager.getAction(e);
        if (action == null) {
            this.logger.debug("action for " + MouseEvent.getMouseModifiersText(e.getModifiersEx()) + " not implemented yet.");
            return;
        }
        action.init(e);
    }

    public void mouseReleased(MouseEvent e) {
        MouseMotionListenerAction action = this.manager.getAction(e);
        if (action == null) {
            this.logger.debug("action for " + MouseEvent.getMouseModifiersText(e.getModifiersEx()) + " not implemented yet.");
            return;
        }
        action.finalize(e);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

