/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.acviewer;

import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import jp.advancesoft.chase.acviewer.ACVAction;
import jp.advancesoft.chase.acviewer.Booter;
import jp.advancesoft.chase.acviewer.MainPanel;
import jp.advancesoft.chase.acviewer.MouseAdapterButton;
import jp.advancesoft.chase.common.MenuTree;
import jp.advancesoft.chase.common.MyJMenu;
import jp.advancesoft.chase.common.MyJMenuItem;
import jp.advancesoft.chase.common.XMLUtils;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;

public class PluginParser {
    private Logger logger = Logger.getLogger(PluginParser.class.getName());
    public static final String PLUGIN_XML_PATH = "/jp/advancesoft/chase/acviewer/plugins.xml";
    private MainPanel parent;
    private Vector buttonVector = new Vector();
    private Vector menuVector = new Vector();
    private long delay = 1000L;
    private MenuTree tree = new MenuTree();

    public PluginParser(MainPanel parent) {
        this.parent = parent;
        this.init();
        this.parse();
    }

    private void init() {
        try {
            this.delay = Long.parseLong(this.parent.getACVProperties().getProperty("viewer_button_tooltip_delay"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JButton[] getButtons() {
        if (this.buttonVector.size() == 0) {
            return null;
        }
        Object[] buttons = new JButton[this.buttonVector.size()];
        this.buttonVector.copyInto(buttons);
        return buttons;
    }

    public JMenu[] getMenus() {
        return this.tree.getMenus();
    }

    private void parse() {
        URL url = PluginParser.class.getResource(PLUGIN_XML_PATH);
        Document doc = XMLUtils.getDocumentFrom(url);
        if (doc == null) {
            this.logger.error("couldn't read plugin specification file...");
            this.logger.error("contact AdvanceSoft.");
            return;
        }
        Element root = doc.getRootElement();
        List topmenus = root.getChildren("menus");
        if (topmenus == null || topmenus.size() == 0) {
            this.logger.warn("no definition for menu found... something is probably wrong.");
            return;
        }
        for (int i = 0; i < topmenus.size(); ++i) {
            this.createMenus((Element)topmenus.get(i));
        }
        List modules = root.getChildren("module");
        if (modules == null || modules.size() == 0) {
            this.logger.warn("no plugins found... something is probably wrong.");
            return;
        }
        for (int i = 0; i < modules.size(); ++i) {
            this.parseEachModule((Element)modules.get(i));
        }
    }

    private void createMenus(Element menus) {
        List children = menus.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Element menu = (Element)children.get(i);
            String[] menuName = menu.getName().split("\\.");
            Attribute attr = menu.getAttribute("shortcut");
            char shortcut = ' ';
            if (attr != null) {
                shortcut = attr.getValue().charAt(0);
            }
            this.createMenu(menuName, shortcut);
        }
    }

    private void createMenu(String[] menuName, char shortcut) {
        this.tree.selectRoot();
        for (int i = 0; i < menuName.length; ++i) {
            this.logger.debug("creating menu: " + menuName[i]);
            MyJMenu men = new MyJMenu(menuName[i]);
            men.setMnemonic(shortcut);
            this.tree.selectBlock(men);
        }
    }

    private void parseEachModule(Element module) {
        String name = module.getChildTextTrim("name");
        if (name == null) {
            name = "";
        }
        String action = module.getChildTextTrim("action");
        List booters = module.getChildren("booter");
        Vector<Booter> bootersVec = new Vector<Booter>();
        for (int i = 0; i < booters.size(); ++i) {
            Booter booter = new Booter((Element)booters.get(i));
            bootersVec.addElement(booter);
        }
        Object[] booterAr = null;
        if (bootersVec.size() != 0) {
            booterAr = new Booter[bootersVec.size()];
            bootersVec.copyInto(booterAr);
        }
        this.createModule(name, action, (Booter[])booterAr);
    }

    private void createModule(String name, String action, Booter[] booterAr) {
        if (booterAr == null || booterAr.length == 0) {
            return;
        }
        for (int i = 0; i < booterAr.length; ++i) {
            ACVAction acvaction;
            int type = booterAr[i].type;
            String text = booterAr[i].tooltiptext;
            String icon = booterAr[i].iconpath;
            String spec = booterAr[i].spec;
            char shortcut = booterAr[i].shortcut;
            boolean hasSep = booterAr[i].hasSep;
            if (type == Booter.BUTTON) {
                JButton btn = this.createButtonFrom(name, text, icon);
                acvaction = ACVAction.getAction(this.parent, action);
                btn.addActionListener(acvaction);
                this.buttonVector.addElement(btn);
                continue;
            }
            if (type != Booter.MENU) continue;
            JMenuItem menuItem = this.createMenuItemFrom(name, spec, text, icon);
            acvaction = ACVAction.getAction(this.parent, action);
            menuItem.addActionListener(acvaction);
            if (shortcut != ' ') {
                menuItem.setMnemonic(shortcut);
            }
            this.addMenuItem(spec, menuItem, hasSep);
        }
    }

    private JButton createButtonFrom(String name, String tooltipText, String iconpath) {
        ImageIcon ico;
        JButton btn = null;
        btn = iconpath.trim().length() == 0 ? new JButton(name) : ((ico = new ImageIcon(this.getClass().getResource(iconpath))) != null ? new JButton(ico) : new JButton(name));
        boolean viewer_button_no_tooltip = new Boolean(this.parent.getACVProperties().getProperty("viewer_button_no_tooltip"));
        if (tooltipText.trim().length() != 0 && !viewer_button_no_tooltip) {
            MouseAdapterButton adap = new MouseAdapterButton(tooltipText, this.delay);
            btn.addMouseListener(adap);
        }
        return btn;
    }

    private JMenuItem createMenuItemFrom(String name, String spec, String tooltipText, String iconpath) {
        ImageIcon ico;
        String[] menuSpec = spec.split("\\.");
        String menuItem = "";
        menuItem = menuSpec.length == 0 ? spec : menuSpec[menuSpec.length - 1];
        MyJMenuItem item = new MyJMenuItem(menuItem);
        if (tooltipText != null && tooltipText.trim().length() != 0) {
            item.setToolTipText(tooltipText);
        }
        if (iconpath != null && iconpath.trim().length() != 0 && (ico = new ImageIcon(this.getClass().getResource(iconpath))) != null) {
            item.setIcon(ico);
        }
        return item;
    }

    private void addMenuItem(String spec, JMenuItem item, boolean hasSep) {
        String[] menuSpec = spec.split("\\.");
        String menuItem = "";
        this.tree.selectRoot();
        for (int i = 0; i < menuSpec.length - 1; ++i) {
            this.tree.selectBlock(menuSpec[i]);
        }
        this.tree.addMenuItem(item, hasSep);
    }
}

