/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import java.net.Socket;
import java.util.Vector;

class ChannelForwardedTCPIP
extends Channel {
    static Vector pool = new Vector();
    private static final int LOCAL_WINDOW_SIZE_MAX = 131072;
    private static final int LOCAL_MAXIMUM_PACKET_SIZE = 16384;
    String host;
    int lport;
    int rport;

    ChannelForwardedTCPIP() {
        this.setLocalWindowSizeMax(131072);
        this.setLocalWindowSize(131072);
        this.setLocalPacketSize(16384);
    }

    void init() {
        try {
            Socket socket = new Socket(this.host, this.lport);
            socket.setTcpNoDelay(true);
            this.io = new IO();
            this.io.setInputStream(socket.getInputStream());
            this.io.setOutputStream(socket.getOutputStream());
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void run() {
        this.thread = Thread.currentThread();
        Buffer buffer = new Buffer(this.rmpsize);
        Packet packet = new Packet(buffer);
        int n = 0;
        try {
            while (this.thread != null && this.io != null && this.io.in != null) {
                n = this.io.in.read(buffer.buffer, 14, buffer.buffer.length - 14 - 16 - 20);
                if (n <= 0) {
                    this.eof();
                } else {
                    packet.reset();
                    if (!this.close) {
                        buffer.putByte((byte)94);
                        buffer.putInt(this.recipient);
                        buffer.putInt(n);
                        buffer.skip(n);
                        this.session.write(packet, this, n);
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.disconnect();
    }

    public void disconnect() {
        this.close();
        this.thread = null;
        try {
            if (this.io != null) {
                if (this.io.in != null) {
                    this.io.in.close();
                }
                if (this.io.out != null) {
                    this.io.out.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.io = null;
        Channel.del(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getData(Buffer buffer) {
        this.setRecipient(buffer.getInt());
        this.setRemoteWindowSize(buffer.getInt());
        this.setRemotePacketSize(buffer.getInt());
        byte[] byArray = buffer.getString();
        int n = buffer.getInt();
        byte[] byArray2 = buffer.getString();
        int n2 = buffer.getInt();
        Vector vector = pool;
        synchronized (vector) {
            int n3 = 0;
            while (n3 < pool.size()) {
                Object[] objectArray = (Object[])pool.elementAt(n3);
                if (objectArray[0] == this.session && (Integer)objectArray[1] == n) {
                    this.rport = n;
                    this.host = (String)objectArray[2];
                    this.lport = (Integer)objectArray[3];
                    break;
                }
                ++n3;
            }
            if (this.host == null) {
                System.out.println("??");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Object[] getPort(Session session, int n) {
        Vector vector = pool;
        synchronized (vector) {
            Object var3_3 = null;
            int n2 = 0;
            while (n2 < pool.size()) {
                Object[] objectArray = (Object[])pool.elementAt(n2);
                if (objectArray[0] == session && (Integer)objectArray[1] == n) {
                    return objectArray;
                }
                ++n2;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getPortForwarding(Session session) {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = pool;
        synchronized (vector2) {
            int n = 0;
            while (n < pool.size()) {
                Object[] objectArray = (Object[])pool.elementAt(n);
                if (objectArray[0] == session) {
                    vector.addElement(objectArray[1] + ":" + objectArray[2] + ":" + objectArray[3]);
                }
                ++n;
            }
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addPort(Session session, int n, String string, int n2) throws JSchException {
        Vector vector = pool;
        synchronized (vector) {
            if (ChannelForwardedTCPIP.getPort(session, n) != null) {
                throw new JSchException("PortForwardingR: remote port " + n + " is already registered.");
            }
            Object[] objectArray = new Object[]{session, new Integer(n), string, new Integer(n2)};
            pool.addElement(objectArray);
        }
    }

    static void delPort(ChannelForwardedTCPIP channelForwardedTCPIP) {
        ChannelForwardedTCPIP.delPort(channelForwardedTCPIP.session, channelForwardedTCPIP.rport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void delPort(Session session, int n) {
        Object[] objectArray;
        Vector vector = pool;
        synchronized (vector) {
            objectArray = null;
            int n2 = 0;
            while (n2 < pool.size()) {
                Object[] objectArray2 = (Object[])pool.elementAt(n2);
                if (objectArray2[0] == session && (Integer)objectArray2[1] == n) {
                    objectArray = objectArray2;
                    break;
                }
                ++n2;
            }
            if (objectArray == null) {
                return;
            }
            pool.removeElement(objectArray);
        }
        objectArray = new Buffer(100);
        Packet packet = new Packet((Buffer)objectArray);
        try {
            packet.reset();
            objectArray.putByte((byte)80);
            objectArray.putString("cancel-tcpip-forward".getBytes());
            objectArray.putByte((byte)0);
            objectArray.putString("0.0.0.0".getBytes());
            objectArray.putInt(n);
            session.write(packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void delPort(Session session) {
        int n;
        int[] nArray = null;
        int n2 = 0;
        Vector vector = pool;
        synchronized (vector) {
            nArray = new int[pool.size()];
            n = 0;
            while (n < pool.size()) {
                Object[] objectArray = (Object[])pool.elementAt(n);
                if (objectArray[0] == session) {
                    nArray[n2++] = (Integer)objectArray[1];
                }
                ++n;
            }
        }
        n = 0;
        while (n < n2) {
            ChannelForwardedTCPIP.delPort(session, nArray[n]);
            ++n;
        }
    }
}

