/*
 * Decompiled with CFR 0.152.
 */
package jas.util.xml.parserwrappers;

import jas.util.xml.JASDOMParser;
import jas.util.xml.parserwrappers.XMLErrorHandler;
import java.io.IOException;
import java.io.Reader;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XercesDOMParser
extends JASDOMParser {
    public Document parse(Reader reader, String string) throws JASDOMParser.JASXMLException {
        return this.parse(reader, string, null);
    }

    public Document parse(Reader reader, String string, EntityResolver entityResolver) throws JASDOMParser.JASXMLException {
        try {
            DOMParser dOMParser = new DOMParser();
            dOMParser.setFeature("http://xml.org/sax/features/validation", true);
            XMLErrorHandler xMLErrorHandler = new XMLErrorHandler(string);
            dOMParser.setErrorHandler((ErrorHandler)xMLErrorHandler);
            if (entityResolver != null) {
                dOMParser.setEntityResolver(entityResolver);
            }
            dOMParser.parse(new InputSource(reader));
            if (xMLErrorHandler.getLevel() > 1) {
                throw new SAXException("Error during XML file parsing");
            }
            return dOMParser.getDocument();
        }
        catch (SAXException sAXException) {
            throw new JASDOMParser.JASXMLException("Syntax error parsing XML file", sAXException);
        }
        catch (IOException iOException) {
            throw new JASDOMParser.JASXMLException("IO error parsing XML file", iOException);
        }
    }
}

