/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.FieldBinding;
import jas.util.UnsupportedType;
import java.lang.reflect.Constructor;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JTextFieldBinding
extends FieldBinding
implements DocumentListener {
    private String m_oldVal = "";
    private JTextField m_field;
    private byte m_flags = 0;
    public static final byte MUST_BE_NUMBER = 1;
    private static final byte MUST_BE_INTEGER_FLAG = 2;
    public static final byte MUST_BE_INTEGER = 3;
    public static final byte MUST_BE_POSITIVE = 4;

    protected JTextFieldBinding(JTextField jTextField, byte by) {
        this(jTextField);
        this.m_flags = by;
    }

    protected JTextFieldBinding(JTextField jTextField) {
        this.m_field = jTextField;
        jTextField.getDocument().addDocumentListener(this);
    }

    void set(Object object) {
        String string = this.setValue(object);
        if (!this.m_oldVal.equals(string)) {
            this.m_field.setText(string);
            this.m_oldVal = string;
        }
    }

    protected String setValue(Object object) {
        String string = object == null ? "" : (object instanceof String ? (String)object : object.toString());
        return string;
    }

    protected Object getValue(String string, Class clazz) throws UnsupportedType {
        if (clazz.isPrimitive()) {
            if (clazz == Double.TYPE) {
                return new Double(string);
            }
            if (clazz == Integer.TYPE) {
                return new Integer(string);
            }
            throw new UnsupportedType(this.m_field, clazz);
        }
        Class[] classArray = new Class[]{string.getClass()};
        try {
            Constructor constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{string};
            return constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new UnsupportedType(this.m_field, clazz);
        }
    }

    Object get(Class clazz) throws UnsupportedType {
        return this.getValue(this.m_field.getText(), clazz);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.update();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.update();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.update();
    }

    private void update() {
        String string = this.m_field.getText();
        if (!string.equals(this.m_oldVal)) {
            this.setChanged();
        }
        this.notifyObservers();
    }

    protected void reset() {
        super.reset();
        this.m_oldVal = this.m_field.getText();
    }

    boolean hasValidInput() {
        String string = this.m_field.getText();
        if ((this.m_flags & 1) != 0) {
            try {
                double d;
                double d2 = d = (this.m_flags & 2) != 0 ? (double)Integer.parseInt(string) : Double.valueOf(string);
                if ((this.m_flags & 4) != 0 && d <= 0.0) {
                    JOptionPane.showMessageDialog(this.m_field, string.concat(" is invalid input; value must be positive."), "Error", 0);
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this.m_field, string + " is invalid input; value must be a" + ((this.m_flags & 3) != 0 ? "n integer." : " number."), "Error", 0);
                return false;
            }
        }
        return true;
    }
}

