/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.FontMenuItem;
import jas.plot.HasPopupItems;
import jas.plot.JASPlotMouseListener;
import jas.plot.LabelTextConverter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

public class EditableLabel
extends JComponent
implements JASPlotMouseListener,
HasPopupItems {
    private Vector listener;
    private boolean showFontMenuItem = true;
    private final LabelTextConverter converter;
    private String sourceText;
    private JLabel label;
    private JTextField textField;
    private String prefix;

    public EditableLabel(String string, String string2, int n) {
        this.sourceText = string;
        this.prefix = string2;
        this.converter = new LabelTextConverter();
        this.setLayout(new BorderLayout());
        this.label = new JLabel(this.converter.convert(string), n);
        this.label.setForeground(this.getForeground());
        this.add((Component)this.label, "Center");
    }

    public EditableLabel(String string, String string2) {
        this(string, string2, 0);
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.listener == null) {
            this.listener = new Vector();
        }
        this.listener.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listener.removeElement(actionListener);
    }

    protected void fireActionPerformed() {
        if (this.listener != null) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, null);
            Enumeration enumeration = this.listener.elements();
            while (enumeration.hasMoreElements()) {
                ((ActionListener)enumeration.nextElement()).actionPerformed(actionEvent);
            }
        }
    }

    void edit() {
        this.textField = new JTextField(this.sourceText);
        this.textField.setFont(this.getFont());
        this.textField.setBorder(null);
        this.textField.setHorizontalAlignment(this.label.getHorizontalAlignment());
        this.textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditableLabel.this.finishTextEdit();
            }
        });
        this.textField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                EditableLabel.this.finishTextEdit();
            }
        });
        this.remove(this.label);
        this.add((Component)this.textField, "Center");
        this.textField.requestFocus();
        this.revalidate();
        this.textField.getCaret().setVisible(true);
    }

    public void mouseEventNotify(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 500 && this.textField == null && mouseEvent.getClickCount() == 2) {
            this.edit();
        }
    }

    private void finishTextEdit() {
        if (this.textField != null) {
            JTextField jTextField = this.textField;
            this.textField = null;
            this.setText(jTextField.getText());
            this.remove(jTextField);
            this.add((Component)this.label, "Center");
            this.fireActionPerformed();
            this.revalidate();
            this.repaint();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.label.setFont(this.getFont());
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.label.setFont(font);
        this.label.revalidate();
    }

    public String getText() {
        return this.label.getText();
    }

    public void setText(String string) {
        this.sourceText = string;
        this.label.setText(this.converter.convert(string));
    }

    public void modifyPopupMenu(JPopupMenu jPopupMenu, Component component) {
        if (jPopupMenu.getComponentCount() > 0) {
            jPopupMenu.addSeparator();
        }
        JMenuItem jMenuItem = new JMenuItem("Edit " + this.prefix + " Text"){

            protected final void fireActionPerformed(ActionEvent actionEvent) {
                EditableLabel.this.edit();
            }
        };
        if (this.showFontMenuItem) {
            jPopupMenu.add(new FontMenuItem(this, this.prefix));
        }
        jPopupMenu.add(jMenuItem);
    }

    public boolean isShowFontMenuItem() {
        return this.showFontMenuItem;
    }

    public void setShowFontMenuItem(boolean bl) {
        this.showFontMenuItem = bl;
    }
}

