/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class URLFile {
    private String mDownloadedFilename;
    private String mURL;

    public URLFile() {
        this.setDownloadedFilename(null);
        this.setURL(null);
    }

    public URLFile(String urlString) {
        this.setDownloadedFilename(null);
        this.setURL(urlString);
    }

    public void finalize() {
        String filename = this.getDownloadedFilename();
        if (filename != null) {
            File file = new File(filename);
            file.delete();
        }
    }

    public void setURL(String url) {
        this.mURL = url;
    }

    public String getURL() {
        return this.mURL;
    }

    public String getHost() {
        String url = this.getURL();
        if (url == null) {
            return null;
        }
        int index = url.lastIndexOf(47);
        if (index <= 0) {
            return null;
        }
        String hostString = new String(url.toCharArray(), 0, index + 1);
        return hostString;
    }

    public void setDownloadedFilename(String filename) {
        this.mDownloadedFilename = filename;
    }

    public String getDownloadedFilename() {
        return this.mDownloadedFilename;
    }

    public boolean download() {
        URL url = null;
        try {
            url = new URL(this.getURL());
        }
        catch (MalformedURLException e) {
            return false;
        }
        DataInputStream inputStream = null;
        try {
            inputStream = new DataInputStream(url.openStream());
        }
        catch (IOException e) {
            return false;
        }
        File outputFile = null;
        FileOutputStream outputStream = null;
        try {
            outputFile = File.createTempFile("tmp", "tmp");
            outputStream = new FileOutputStream(outputFile);
        }
        catch (Exception e) {
            return false;
        }
        try {
            while (true) {
                outputStream.write(inputStream.readUnsignedByte());
            }
        }
        catch (IOException e) {
            try {
                inputStream.close();
                outputStream.close();
            }
            catch (IOException e2) {
                return false;
            }
            this.setDownloadedFilename(outputFile.getAbsolutePath());
            return true;
        }
    }

    public static void main(String[] a2) {
        if (0 < a2.length) {
            URLFile url = new URLFile(a2[0]);
            if (url.download()) {
                System.out.println("Dowload is OK : " + a2[0] + " -> " + url.getDownloadedFilename());
                System.out.println("              : " + url.getHost());
            } else {
                System.out.println("Dowload is failed : " + a2[0]);
                System.out.println("              : " + url.getHost());
            }
        }
    }
}

