/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.parser.autodesk;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.cybergarage.x3d.node.ColorNode;
import org.cybergarage.x3d.node.CoordinateNode;
import org.cybergarage.x3d.node.Geometry3DNode;
import org.cybergarage.x3d.node.IndexedFaceSetNode;
import org.cybergarage.x3d.node.IndexedLineSetNode;
import org.cybergarage.x3d.node.NormalNode;
import org.cybergarage.x3d.node.RootNode;
import org.cybergarage.x3d.node.ShapeNode;
import org.cybergarage.x3d.parser.autodesk.ParserDXFConstants;
import org.cybergarage.x3d.parser.autodesk.ParserDXFException;
import org.cybergarage.x3d.util.Debug;

public class ParserDXF
implements ParserDXFConstants {
    private RootNode mRootNode;
    private ShapeNode mCurrentShapeNode;
    private boolean mHasFaceColor;
    private float[] mPrevFaceColor = new float[3];
    private int mSolidFaceCount;
    private boolean mUseSeparatedShapeNode;
    private BufferedReader mBufferedReader;
    private int mCurrentLine;
    private int mMarkedLine;
    private boolean mThrowable;

    public void initialize() {
        this.mRootNode = new RootNode();
        this.setCurrentShapeNode(null);
        this.setCurrentLine(0);
        this.setMarkedLine(0);
        this.setThrowable(true);
        this.setSeparatedShapeNodeFlag(false);
    }

    public ShapeNode createIdxFaceSetShapeNode() {
        ShapeNode shape = new ShapeNode();
        IndexedFaceSetNode idxFaceSetNode = new IndexedFaceSetNode();
        shape.addChildNode(idxFaceSetNode);
        idxFaceSetNode.addChildNode(new CoordinateNode());
        idxFaceSetNode.addChildNode(new ColorNode());
        idxFaceSetNode.setColorPerVertex(false);
        idxFaceSetNode.setNormalPerVertex(false);
        return shape;
    }

    public ShapeNode createIdxLineSetShapeNode() {
        ShapeNode shape = new ShapeNode();
        IndexedLineSetNode idxLineSetNode = new IndexedLineSetNode();
        shape.addChildNode(idxLineSetNode);
        idxLineSetNode.addChildNode(new CoordinateNode());
        idxLineSetNode.addChildNode(new ColorNode());
        idxLineSetNode.setColorPerVertex(false);
        return shape;
    }

    public int getNShapeNodes() {
        return this.mRootNode.getNChildNodes();
    }

    public ShapeNode getShapeNodes() {
        return this.mRootNode.getShapeNodes();
    }

    public ShapeNode getShapeNode(String name) {
        if (name != null) {
            return this.mRootNode.getShapeNode(name);
        }
        for (ShapeNode shapeNode = this.mRootNode.getShapeNodes(); shapeNode != null; shapeNode = (ShapeNode)shapeNode.nextSameType()) {
            String shapeNodeName = shapeNode.getName();
            if (shapeNodeName != null && shapeNodeName.length() != 0) continue;
            return shapeNode;
        }
        return null;
    }

    public void addShapeNode(ShapeNode node) {
        this.mRootNode.addChildNode(node);
    }

    public void setCurrentShapeNode(ShapeNode node) {
        this.mCurrentShapeNode = node;
    }

    public ShapeNode getCurrentShapeNode() {
        return this.mCurrentShapeNode;
    }

    private Geometry3DNode getCurrentGeometry3DNode() {
        return this.getCurrentShapeNode().getGeometry3DNode();
    }

    private CoordinateNode getCurrentCoordinateNode() {
        return this.getCurrentGeometry3DNode().getCoordinateNodes();
    }

    private ColorNode getCurrentColorNode() {
        return this.getCurrentGeometry3DNode().getColorNodes();
    }

    private NormalNode getCurrentNormalNode() {
        return this.getCurrentGeometry3DNode().getNormalNodes();
    }

    private int getNCurrentCoordinateNodePoints() {
        return this.getCurrentGeometry3DNode().getCoordinateNodes().getNPoints();
    }

    private void addCoordinate(float x, float y, float z) {
        this.getCurrentCoordinateNode().addPoint(x, y, z);
    }

    private void addCoordinate(float[] point) {
        this.getCurrentCoordinateNode().addPoint(point);
    }

    private void addColor(float r, float g, float b2) {
        this.getCurrentColorNode().addColor(r, g, b2);
    }

    private void addColor(float[] color) {
        this.getCurrentColorNode().addColor(color);
    }

    private void addNormal(float x, float y, float z) {
        this.getCurrentNormalNode().addVector(x, y, z);
    }

    private void addCoordIndex(int index) {
        Geometry3DNode geom = this.getCurrentGeometry3DNode();
        if (geom instanceof IndexedFaceSetNode) {
            ((IndexedFaceSetNode)geom).addCoordIndex(index);
        }
        if (geom instanceof IndexedLineSetNode) {
            ((IndexedLineSetNode)geom).addCoordIndex(index);
        }
    }

    public int getNCoordIndices() {
        Geometry3DNode geom = this.getCurrentGeometry3DNode();
        if (geom instanceof IndexedFaceSetNode) {
            return ((IndexedFaceSetNode)geom).getNCoordIndices();
        }
        if (geom instanceof IndexedLineSetNode) {
            return ((IndexedLineSetNode)geom).getNCoordIndices();
        }
        return 0;
    }

    public int getCoordIndex(int n) {
        Geometry3DNode geom = this.getCurrentGeometry3DNode();
        if (geom instanceof IndexedFaceSetNode) {
            return ((IndexedFaceSetNode)geom).getCoordIndex(n);
        }
        if (geom instanceof IndexedLineSetNode) {
            return ((IndexedLineSetNode)geom).getCoordIndex(n);
        }
        return -1;
    }

    private void addNormalIndex(int index) {
        Geometry3DNode geom = this.getCurrentGeometry3DNode();
        if (geom instanceof IndexedFaceSetNode) {
            ((IndexedFaceSetNode)geom).addNormalIndex(index);
        }
    }

    public int getNNormalIndices() {
        Geometry3DNode geom = this.getCurrentGeometry3DNode();
        if (geom instanceof IndexedFaceSetNode) {
            ((IndexedFaceSetNode)geom).getNNormalIndices();
        }
        return 0;
    }

    public int getNormalIndex(int n) {
        Geometry3DNode geom = this.getCurrentGeometry3DNode();
        if (geom instanceof IndexedFaceSetNode) {
            return ((IndexedFaceSetNode)geom).getNormalIndex(n);
        }
        return -1;
    }

    private void addTexCoordIndex(int index) {
        Geometry3DNode geom = this.getCurrentGeometry3DNode();
        if (geom instanceof IndexedFaceSetNode) {
            ((IndexedFaceSetNode)geom).addTexCoordIndex(index);
        }
    }

    public int getNTexCoordIndices() {
        Geometry3DNode geom = this.getCurrentGeometry3DNode();
        if (geom instanceof IndexedFaceSetNode) {
            ((IndexedFaceSetNode)geom).getNTexCoordIndices();
        }
        return 0;
    }

    public int getTexCoordIndex(int n) {
        Geometry3DNode geom = this.getCurrentGeometry3DNode();
        if (geom instanceof IndexedFaceSetNode) {
            ((IndexedFaceSetNode)geom).getTexCoordIndex(n);
        }
        return -1;
    }

    public int getN3DFaceVertices(float[][] point) {
        for (int n = 0; n < 3; ++n) {
            if (point[2][n] == point[3][n]) continue;
            return 4;
        }
        return 3;
    }

    private void setThrowable(boolean isOK) {
        this.mThrowable = isOK;
    }

    private boolean isThrowable() {
        return this.mThrowable;
    }

    private void setSeparatedShapeNodeFlag(boolean flag) {
        this.mUseSeparatedShapeNode = flag;
    }

    private boolean useSeparatedShapeNode() {
        return this.mUseSeparatedShapeNode;
    }

    private void setBufferedReader(BufferedReader buf) {
        this.mBufferedReader = buf;
    }

    private BufferedReader getBufferedReader() {
        return this.mBufferedReader;
    }

    private void setCurrentLine(int line) {
        this.mCurrentLine = line;
    }

    private int getCurrentLine() {
        return this.mCurrentLine;
    }

    private void setMarkedLine(int line) {
        this.mMarkedLine = line;
    }

    private int getMarkedLine() {
        return this.mMarkedLine;
    }

    private String readNextLineString(boolean setMark) throws IOException {
        String data;
        int currentLine = this.getCurrentLine();
        if (setMark) {
            this.setMarkedLine(currentLine);
            this.mBufferedReader.mark(0);
        }
        if ((data = this.mBufferedReader.readLine()) == null) {
            return null;
        }
        this.setCurrentLine(++currentLine);
        StringBuffer str = new StringBuffer();
        for (int n = 0; n < data.length(); ++n) {
            char c2 = data.charAt(n);
            if (' ' >= c2) continue;
            str.append(c2);
        }
        return str.toString();
    }

    private int readNextLineInteger(boolean setMark) throws IOException {
        int value = 0;
        try {
            value = Integer.parseInt(this.readNextLineString(setMark));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    private float readNextLineFloat(boolean setMark) throws IOException {
        float value = 0.0f;
        try {
            Float floatObj = new Float(this.readNextLineString(setMark));
            value = floatObj.floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    private String readNextLineString() throws IOException {
        return this.readNextLineString(true);
    }

    private int readNextLineInteger() throws IOException {
        return this.readNextLineInteger(true);
    }

    private float readNextLineFloat() throws IOException {
        return this.readNextLineFloat(true);
    }

    private void pushCUrrentLine() throws IOException {
        this.mBufferedReader.reset();
        this.setCurrentLine(this.getMarkedLine());
    }

    private void skipNextLine() throws IOException {
        this.readNextLineString(true);
    }

    public int getID(String str) throws ParserDXFException {
        if (str == null) {
            return -1;
        }
        for (int n = 0; n < ID.length; ++n) {
            if (!ID[n].equals(str)) continue;
            return n;
        }
        if (this.isThrowable()) {
            // empty if block
        }
        return -1;
    }

    private int readNextLineStringID() throws IOException, ParserDXFException {
        return this.getID(this.readNextLineString());
    }

    public boolean input(Reader reader) throws ParserDXFException {
        this.setBufferedReader(new BufferedReader(reader));
        try {
            String nextLineString = this.readNextLineString();
            while (nextLineString != null) {
                this.parseGeometries(nextLineString);
                nextLineString = this.readNextLineString();
            }
        }
        catch (IOException iod) {
            return false;
        }
        return true;
    }

    public boolean input(InputStream in) throws ParserDXFException {
        return this.input(new InputStreamReader(in));
    }

    private void getColor(int id, float[] color) {
        switch (id) {
            case 0: {
                color[0] = 0.0f;
                color[1] = 0.0f;
                color[2] = 0.0f;
                return;
            }
            case 1: {
                color[0] = 1.0f;
                color[1] = 0.0f;
                color[2] = 0.0f;
                return;
            }
            case 2: {
                color[0] = 1.0f;
                color[1] = 1.0f;
                color[2] = 0.0f;
                return;
            }
            case 3: {
                color[0] = 0.0f;
                color[1] = 1.0f;
                color[2] = 0.0f;
                return;
            }
            case 4: {
                color[0] = 0.0f;
                color[1] = 1.0f;
                color[2] = 1.0f;
                return;
            }
            case 5: {
                color[0] = 0.0f;
                color[1] = 0.0f;
                color[2] = 1.0f;
                return;
            }
            case 6: {
                color[0] = 1.0f;
                color[1] = 0.0f;
                color[2] = 1.0f;
                return;
            }
            case 7: {
                color[0] = 1.0f;
                color[1] = 1.0f;
                color[2] = 1.0f;
                return;
            }
        }
        if (10 <= id && id < 50) {
            float perHighColor = (float)(40 - (id - 10)) / 40.0f;
            float perLowColor = 1.0f - perHighColor;
            color[0] = 1.0f * perHighColor + 1.0f * perLowColor;
            color[1] = 0.0f * perHighColor + 1.0f * perLowColor;
            color[2] = 0.0f * perHighColor + 0.0f * perLowColor;
            return;
        }
        if (50 <= id && id < 90) {
            float perHighColor = (float)(40 - (id - 50)) / 40.0f;
            float perLowColor = 1.0f - perHighColor;
            color[0] = 1.0f * perHighColor + 0.0f * perLowColor;
            color[1] = 1.0f * perHighColor + 1.0f * perLowColor;
            color[2] = 0.0f * perHighColor + 0.0f * perLowColor;
            return;
        }
        if (90 <= id && id < 130) {
            float perHighColor = (float)(40 - (id - 90)) / 40.0f;
            float perLowColor = 1.0f - perHighColor;
            color[0] = 0.0f * perHighColor + 0.0f * perLowColor;
            color[1] = 1.0f * perHighColor + 1.0f * perLowColor;
            color[2] = 0.0f * perHighColor + 1.0f * perLowColor;
            return;
        }
        if (130 <= id && id < 170) {
            float perHighColor = (float)(40 - (id - 130)) / 40.0f;
            float perLowColor = 1.0f - perHighColor;
            color[0] = 0.0f * perHighColor + 0.0f * perLowColor;
            color[1] = 1.0f * perHighColor + 0.0f * perLowColor;
            color[2] = 1.0f * perHighColor + 1.0f * perLowColor;
            return;
        }
        if (170 <= id && id < 210) {
            float perHighColor = (float)(40 - (id - 170)) / 40.0f;
            float perLowColor = 1.0f - perHighColor;
            color[0] = 0.0f * perHighColor + 1.0f * perLowColor;
            color[1] = 0.0f * perHighColor + 0.0f * perLowColor;
            color[2] = 1.0f * perHighColor + 1.0f * perLowColor;
            return;
        }
        if (210 <= id && id < 250) {
            float perHighColor = (float)(40 - (id - 210)) / 40.0f;
            float perLowColor = 1.0f - perHighColor;
            color[0] = 1.0f * perHighColor + 1.0f * perLowColor;
            color[1] = 0.0f * perHighColor + 0.0f * perLowColor;
            color[2] = 1.0f * perHighColor + 0.0f * perLowColor;
            return;
        }
        color[0] = 1.0f;
        color[1] = 1.0f;
        color[2] = 1.0f;
    }

    private void parseGeometries(String groupCodeString) throws IOException, ParserDXFException {
        if (groupCodeString == null) {
            return;
        }
        int id = this.getID(groupCodeString);
        block0 : switch (id) {
            case 0: {
                int nextID = this.readNextLineStringID();
                switch (nextID) {
                    case 165: {
                        this.parsePolyLine();
                        break block0;
                    }
                    case 8: {
                        this.parse3DFace();
                        break block0;
                    }
                    case 187: {
                        this.parseLine();
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                this.readNextLineString();
            }
        }
        this.parseGeometries(this.readNextLineString());
    }

    private void parseGroupCode(String groupCodeString) throws IOException, ParserDXFException {
        if (groupCodeString == null) {
            return;
        }
        int id = this.getID(groupCodeString);
        Debug.message("TOP GroupCode   = " + groupCodeString + " (" + id + ")");
        block0 : switch (id) {
            case 0: {
                int nextID = this.readNextLineStringID();
                switch (nextID) {
                    case 4: {
                        this.parseSection();
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                this.readNextLineString();
            }
        }
        this.parseGroupCode(this.readNextLineString());
    }

    private void parseSection() throws IOException, ParserDXFException {
        String groupCode = this.readNextLineString();
        String sectionString = this.readNextLineString();
        Debug.message("SECTION GroupCode   = " + groupCode);
        Debug.message("SECTION SectionCode = " + sectionString);
        switch (this.getID(sectionString)) {
            case 178: {
                this.parseBlocksSection();
                break;
            }
            case 6: {
                this.parseEntitiesSection();
                break;
            }
            default: {
                String nextLineString = this.readNextLineString();
                while (nextLineString != null && this.getID(nextLineString) != 5) {
                    nextLineString = this.readNextLineString();
                }
                break block0;
            }
        }
    }

    private void parseHeaderSection() throws IOException, ParserDXFException {
        String groupCode = this.readNextLineString();
        String sectionString = this.readNextLineString();
        while (groupCode != null) {
            switch (this.getID(sectionString)) {
                case 5: {
                    return;
                }
            }
            groupCode = this.readNextLineString();
            sectionString = this.readNextLineString();
        }
    }

    private void parseTablesSection() throws IOException, ParserDXFException {
        String groupCode = this.readNextLineString();
        String sectionString = this.readNextLineString();
        while (groupCode != null) {
            switch (this.getID(sectionString)) {
                case 5: {
                    return;
                }
            }
            groupCode = this.readNextLineString();
            sectionString = this.readNextLineString();
        }
    }

    private void parseBlocksSection() throws IOException, ParserDXFException {
        String groupCode = this.readNextLineString();
        String sectionString = this.readNextLineString();
        while (groupCode != null) {
            switch (this.getID(sectionString)) {
                case 180: {
                    this.parseBlockSection();
                    break;
                }
                case 5: {
                    return;
                }
            }
            groupCode = this.readNextLineString();
            sectionString = this.readNextLineString();
        }
    }

    private void parseBlockSection() throws IOException, ParserDXFException {
        String layerName = null;
        int colorIndex = -1;
        int flag = -1;
        float[] basePoint = new float[3];
        String groupCode = this.readNextLineString();
        block15: while (groupCode != null) {
            int id = this.getID(groupCode);
            block0 : switch (id) {
                case 0: {
                    groupCode = this.readNextLineString(false);
                    id = this.getID(groupCode);
                    switch (id) {
                        case 8: {
                            this.parse3DFace();
                            break block0;
                        }
                        case 159: {
                            this.parseSolid();
                            break block0;
                        }
                        case 165: {
                            this.parsePolyLine();
                            break block0;
                        }
                        case 181: {
                            this.parseAttDef();
                            break block0;
                        }
                        case 187: {
                            this.parseLine();
                            break block0;
                        }
                    }
                    this.pushCUrrentLine();
                    groupCode = null;
                    continue block15;
                }
                case 2: {
                    layerName = this.readNextLineString();
                    break;
                }
                case 10: {
                    colorIndex = this.readNextLineInteger();
                    break;
                }
                case 167: {
                    flag = this.readNextLineInteger();
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    int nPoint = id - 11;
                    basePoint[nPoint] = this.readNextLineFloat();
                    break;
                }
                case 1: {
                    this.skipNextLine();
                    break;
                }
                default: {
                    this.pushCUrrentLine();
                    groupCode = null;
                    continue block15;
                }
            }
            groupCode = this.readNextLineString();
        }
    }

    private void parseEntitiesSection() throws IOException, ParserDXFException {
        String groupCode = this.readNextLineString();
        String sectionString = this.readNextLineString();
        while (groupCode != null) {
            switch (this.getID(sectionString)) {
                case 8: {
                    this.parse3DFace();
                    break;
                }
                case 159: {
                    this.parseSolid();
                    break;
                }
                case 165: {
                    this.parsePolyLine();
                    break;
                }
                case 187: {
                    this.parseLine();
                    break;
                }
                case 181: {
                    this.parseAttDef();
                    break;
                }
                case 5: {
                    return;
                }
            }
            groupCode = this.readNextLineString();
            sectionString = this.readNextLineString();
        }
    }

    private void parseAttDef() throws IOException, ParserDXFException {
        String layerName = null;
        float[][] ocs = new float[2][3];
        int colorIndex = -1;
        String groupCode = this.readNextLineString();
        block7: while (groupCode != null) {
            int id = this.getID(groupCode);
            switch (id) {
                case 2: {
                    layerName = this.readNextLineString();
                    break;
                }
                case 10: {
                    colorIndex = this.readNextLineInteger();
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    int nPoint = id - 11;
                    ocs[0][nPoint] = this.readNextLineFloat();
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    int nPoint = id - 11;
                    ocs[1][nPoint] = this.readNextLineFloat();
                    break;
                }
                case 1: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 167: 
                case 168: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 177: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: {
                    this.skipNextLine();
                    break;
                }
                default: {
                    this.pushCUrrentLine();
                    groupCode = null;
                    continue block7;
                }
            }
            groupCode = this.readNextLineString();
        }
    }

    private void parseSolid() throws IOException, ParserDXFException {
        Object layerName = null;
        float[][] coordPoint = new float[4][3];
        int colorIndex = -1;
        String groupCode = this.readNextLineString();
        block3: while (groupCode != null) {
            int id = this.getID(groupCode);
            switch (id) {
                case 2: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: {
                    this.skipNextLine();
                    break;
                }
                default: {
                    this.pushCUrrentLine();
                    groupCode = null;
                    continue block3;
                }
            }
            groupCode = this.readNextLineString();
        }
    }

    private boolean is4Vertices(float[][] point) {
        for (int n = 0; n < 3; ++n) {
            if (point[2][n] == point[3][n]) continue;
            return true;
        }
        return false;
    }

    private void parse3DFace() throws IOException, ParserDXFException {
        String layerName = null;
        float[][] coordPoint = new float[4][3];
        int colorIndex = -1;
        float[] color = new float[]{1.0f, 1.0f, 1.0f};
        String groupCode = this.readNextLineString();
        block6: while (groupCode != null) {
            int id = this.getID(groupCode);
            switch (id) {
                case 2: {
                    layerName = this.readNextLineString();
                    break;
                }
                case 10: {
                    colorIndex = this.readNextLineInteger();
                    this.getColor(colorIndex, color);
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    int nVertex = (id - 11) / 3;
                    int nPoint = (id - 11) % 3;
                    coordPoint[nVertex][nPoint] = this.readNextLineFloat();
                    break;
                }
                case 164: 
                case 167: {
                    this.skipNextLine();
                    break;
                }
                default: {
                    this.pushCUrrentLine();
                    groupCode = null;
                    continue block6;
                }
            }
            groupCode = this.readNextLineString();
        }
        ShapeNode shapeNode = this.getCurrentShapeNode();
        if ((shapeNode == null || this.useSeparatedShapeNode()) && (shapeNode = this.getShapeNode(layerName)) == null) {
            shapeNode = this.createIdxFaceSetShapeNode();
            shapeNode.setName(layerName);
            this.addShapeNode(shapeNode);
        }
        this.setCurrentShapeNode(shapeNode);
        int n3DFaceVertices = this.is4Vertices(coordPoint) ? 4 : 3;
        for (int n = 0; n < n3DFaceVertices; ++n) {
            this.addCoordinate(coordPoint[n]);
        }
        int nCoordPoints = this.getNCurrentCoordinateNodePoints() - n3DFaceVertices;
        for (int n = 0; n < n3DFaceVertices; ++n) {
            this.addCoordIndex(n + nCoordPoints);
        }
        this.addCoordIndex(-1);
        this.addColor(color);
    }

    private ShapeNode parsePolyLine() throws IOException, ParserDXFException {
        String layerName = null;
        int colorIndex = -1;
        int polyLineFlag = 0;
        float[] color = new float[]{1.0f, 1.0f, 1.0f};
        Debug.message("POLYLINE = " + this.getCurrentLine());
        ShapeNode shapeNode = this.getCurrentShapeNode();
        if (shapeNode == null || this.useSeparatedShapeNode()) {
            shapeNode = this.createIdxFaceSetShapeNode();
            this.addShapeNode(shapeNode);
            this.setCurrentShapeNode(shapeNode);
        }
        String groupCode = this.readNextLineString();
        block12: while (groupCode != null) {
            int id = this.getID(groupCode);
            block0 : switch (id) {
                case 2: {
                    layerName = this.readNextLineString();
                    if (!this.useSeparatedShapeNode()) break;
                    shapeNode.setName(layerName);
                    break;
                }
                case 10: {
                    colorIndex = this.readNextLineInteger();
                    this.getColor(colorIndex, color);
                    break;
                }
                case 167: {
                    polyLineFlag = this.readNextLineInteger();
                    break;
                }
                case 0: {
                    String nextLineString = this.readNextLineString(false);
                    switch (this.getID(nextLineString)) {
                        case 166: {
                            float[] vertexPoint = this.parseVertex();
                            this.addCoordinate(vertexPoint);
                            this.addCoordIndex(this.getNCurrentCoordinateNodePoints() - 1);
                            break block0;
                        }
                        case 176: {
                            break block0;
                        }
                    }
                    this.pushCUrrentLine();
                    groupCode = null;
                    continue block12;
                }
                case 175: 
                case 176: {
                    this.skipNextLine();
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 168: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 182: {
                    this.skipNextLine();
                    break;
                }
                default: {
                    this.pushCUrrentLine();
                    groupCode = null;
                    continue block12;
                }
            }
            groupCode = this.readNextLineString();
        }
        this.addCoordIndex(-1);
        this.addColor(color);
        Debug.message("  SHAPE NODE NAME = " + shapeNode.getName());
        Debug.message("  VERTICES = " + this.getNCurrentCoordinateNodePoints());
        return shapeNode;
    }

    private float[] parseVertex() throws IOException, ParserDXFException {
        float[] vertex = new float[3];
        String groupCode = this.readNextLineString();
        block4: while (groupCode != null) {
            int id = this.getID(groupCode);
            switch (id) {
                case 11: 
                case 12: 
                case 13: {
                    int nVertex = id - 11;
                    vertex[nVertex] = this.readNextLineFloat();
                    break;
                }
                case 2: 
                case 10: 
                case 160: 
                case 164: 
                case 167: 
                case 168: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 177: 
                case 182: {
                    this.skipNextLine();
                    break;
                }
                default: {
                    this.pushCUrrentLine();
                    groupCode = null;
                    continue block4;
                }
            }
            groupCode = this.readNextLineString();
        }
        return vertex;
    }

    private ShapeNode parseLine() throws IOException, ParserDXFException {
        float[][] point = new float[2][3];
        String layerName = null;
        int colorIndex = -1;
        Debug.message("LINE = " + this.getCurrentLine());
        String groupCode = this.readNextLineString();
        block7: while (groupCode != null) {
            int id = this.getID(groupCode);
            switch (id) {
                case 2: {
                    layerName = this.readNextLineString();
                    break;
                }
                case 10: {
                    colorIndex = this.readNextLineInteger();
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    int nPoint = id - 11;
                    point[0][nPoint] = this.readNextLineFloat();
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    int nPoint = id - 14;
                    point[1][nPoint] = this.readNextLineFloat();
                    break;
                }
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: {
                    this.skipNextLine();
                    break;
                }
                default: {
                    this.pushCUrrentLine();
                    groupCode = null;
                    continue block7;
                }
            }
            groupCode = this.readNextLineString();
        }
        return null;
    }
}

