/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.projectbrowser;

import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.SubSelectorButton;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ProjectManipulatorSubSelector
extends JPanel {
    private static Logger logger = Logger.getLogger(ProjectManipulatorSubSelector.class.getName());
    private URL property;
    private ProjectInfo info;
    private JSplitPane splitpane;
    private Dimension defaultPreferredSize = new Dimension(80, 30);
    private boolean setInitialPanel = true;
    private Vector projectManipulators = new Vector();
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    private int layout = 0;

    public ProjectManipulatorSubSelector(URL property, ProjectInfo info, JSplitPane splitpane) {
        this.property = property;
        this.info = info;
        this.splitpane = splitpane;
        this.parseAndAddButtons();
    }

    public ProjectManipulatorSubSelector(URL property, ProjectInfo info, JSplitPane splitpane, boolean setInitialPanel) {
        this.property = property;
        this.info = info;
        this.splitpane = splitpane;
        this.setInitialPanel = setInitialPanel;
        this.parseAndAddButtons();
    }

    private void parseAndAddButtons() {
        Document doc = null;
        SAXBuilder builder = new SAXBuilder();
        try {
            doc = builder.build(this.property);
        }
        catch (JDOMException jde) {
            logger.error("failed to parse " + this.property);
            logger.error("unrecoverable error.");
        }
        catch (IOException ioe) {
            logger.error("failed to parse " + this.property);
            logger.error("unrecoverable error.");
        }
        Element elem = doc.getRootElement();
        if (!elem.getName().equals("root")) {
            logger.error("invalid ProjectSpecification file.");
            return;
        }
        try {
            String strlayout = elem.getChildTextTrim("layout");
            if (strlayout.equalsIgnoreCase("horizontal")) {
                this.layout = 1;
            }
        }
        catch (Exception exc) {
            // empty catch block
        }
        List list = elem.getChild("subselectors").getChildren();
        int nbuttons = list.size();
        if (this.layout == 0) {
            this.setLayout(new GridLayout(nbuttons, 1));
        } else {
            this.setLayout(new GridLayout(1, nbuttons));
        }
        SubSelectorButton btn0 = null;
        for (int i = 0; i < nbuttons; ++i) {
            Element btn = (Element)list.get(i);
            String name = btn.getChildTextTrim("name");
            String iconpath = btn.getChildTextTrim("iconpath");
            String loadClass = btn.getChildTextTrim("loadclass");
            String description = MyElement.decode(btn.getChildTextTrim("description"));
            SubSelectorButton button = new SubSelectorButton(name, iconpath, description, loadClass, this.info, this.splitpane, this);
            String size = btn.getChildTextTrim("size");
            String[] sizes = size.split("x");
            if (sizes == null || sizes.length < 2) {
                button.setPreferredSize(this.defaultPreferredSize);
            } else {
                int width = 0;
                int height = 0;
                try {
                    width = Integer.parseInt(sizes[0]);
                    height = Integer.parseInt(sizes[1]);
                    button.setPreferredSize(new Dimension(width, height));
                    button.setMinimumSize(new Dimension(width, height));
                    button.setMaximumSize(new Dimension(width, height));
                }
                catch (NumberFormatException nfe) {
                    button.setPreferredSize(this.defaultPreferredSize);
                }
            }
            this.add(button);
            if (i != 0 || !this.setInitialPanel) continue;
            btn0 = button;
        }
        if (btn0 != null) {
            btn0.bootProjectManipulatorSub();
        }
    }

    public boolean isLoaded(Class clazz) {
        String cname = clazz.getName();
        for (int i = 0; i < this.projectManipulators.size(); ++i) {
            String regName = this.projectManipulators.elementAt(i).getClass().getName();
            if (!regName.equals(cname)) continue;
            return true;
        }
        return false;
    }

    public ProjectManipulator getProjectManipulator(String cname) {
        for (int i = 0; i < this.projectManipulators.size(); ++i) {
            String regName = this.projectManipulators.elementAt(i).getClass().getName();
            if (!regName.equals(cname)) continue;
            return (ProjectManipulator)this.projectManipulators.elementAt(i);
        }
        return null;
    }

    public Vector getProjectManipulators() {
        return this.projectManipulators;
    }

    public void registerProjectManipulators(ProjectManipulator manip) {
        this.projectManipulators.addElement(manip);
    }

    public int getLayoutPolicy() {
        return this.layout;
    }
}

