/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.inputinterface.filestate;

import ciss.phase_viewer.inputinterface.filestate.FileState;
import ciss.phase_viewer.inputinterface.filestate.FileStateChangeEvent;
import ciss.phase_viewer.inputinterface.filestate.FileStateListener;
import java.io.File;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FileStateObserver {
    private Logger logger = Logger.getLogger(FileStateObserver.class.getName());
    private long period = 20L;
    private String dir;
    private String[] filters;
    private File[] previousFiles;
    private long[] previousLastModified;
    private static String LOCK_FILE = "__LOCK__";
    private Vector listeners = null;

    public static boolean generateLockFile(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        File lock = new File(dir.getAbsolutePath() + System.getProperty("file.separator") + LOCK_FILE);
        try {
            lock.createNewFile();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean removeLockFile(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        File lock = new File(dir.getAbsolutePath() + System.getProperty("file.separator") + LOCK_FILE);
        lock.delete();
        return true;
    }

    public FileStateObserver(String dir, String[] filters) {
        this.dir = dir;
        this.filters = filters;
        this.init();
    }

    public FileStateObserver(String dir, String[] filters, long period) {
        this(dir, filters);
        this.period = period;
    }

    private void init() {
        this.logger.debug("initializing FileStateObserver...");
        File[] list = new File(this.dir).listFiles();
        if (list == null || list.length == 0) {
            return;
        }
        Vector<File> vec = new Vector<File>();
        for (int i = 0; i < list.length; ++i) {
            for (int j = 0; j < this.filters.length; ++j) {
                if (!list[i].getName().matches(this.filters[j])) continue;
                vec.addElement(list[i]);
            }
        }
        if (vec.size() != 0) {
            this.previousFiles = new File[vec.size()];
            vec.copyInto(this.previousFiles);
            this.updatePreviousLastModified();
        }
    }

    private void updatePreviousLastModified() {
        if (this.previousFiles == null || this.previousFiles.length == 0) {
            this.previousLastModified = null;
            return;
        }
        this.previousLastModified = new long[this.previousFiles.length];
        for (int i = 0; i < this.previousFiles.length; ++i) {
            this.previousLastModified[i] = this.previousFiles[i].lastModified();
        }
    }

    public void addFileStateListener(FileStateListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
            this.listeners.addElement(listener);
            Timer timer = new Timer();
            timer.schedule((TimerTask)new FileTimerTask(), 0L, this.period);
        } else {
            this.listeners.addElement(listener);
        }
    }

    public void removeFileStateListener(FileStateListener listener) {
        if (this.listeners == null) {
            this.logger.debug("no listener to remove");
            return;
        }
        this.logger.debug("removing listener: " + listener);
        this.listeners.remove(listener);
    }

    static /* synthetic */ File[] access$302(FileStateObserver x0, File[] x1) {
        x0.previousFiles = x1;
        return x1;
    }

    class FileTimerTask
    extends TimerTask {
        FileTimerTask() {
        }

        public void run() {
            int i;
            if (FileStateObserver.this.listeners == null || FileStateObserver.this.listeners.size() == 0) {
                return;
            }
            File[] files = new File(FileStateObserver.this.dir).listFiles();
            if (files == null) {
                return;
            }
            Vector<File> vec = new Vector<File>();
            for (int j = 0; j < FileStateObserver.this.filters.length; ++j) {
                for (int i2 = 0; i2 < files.length; ++i2) {
                    if (!files[i2].getName().matches(FileStateObserver.this.filters[j])) continue;
                    vec.addElement(files[i2]);
                }
            }
            Object[] filesNow = new File[vec.size()];
            vec.copyInto(filesNow);
            if (filesNow == null || filesNow.length == 0) {
                if (FileStateObserver.this.previousFiles == null || FileStateObserver.this.previousFiles.length == 0) {
                    return;
                }
                FileState[] state = new FileState[FileStateObserver.this.previousFiles.length];
                for (int i3 = 0; i3 < state.length; ++i3) {
                    state[i3] = new FileState(FileStateObserver.this.previousFiles[i3], FileState.FILE_REMOVED);
                }
                FileStateChangeEvent ev = new FileStateChangeEvent(state);
                for (int i4 = 0; i4 < FileStateObserver.this.listeners.size(); ++i4) {
                    ((FileStateListener)FileStateObserver.this.listeners.get(i4)).fileStateChanged(ev);
                }
                FileStateObserver.access$302(FileStateObserver.this, null);
                FileStateObserver.this.updatePreviousLastModified();
                return;
            }
            if (FileStateObserver.this.previousFiles == null || FileStateObserver.this.previousFiles.length == 0) {
                if (filesNow == null || filesNow.length == 0) {
                    return;
                }
                FileState[] state = new FileState[filesNow.length];
                for (int i5 = 0; i5 < state.length; ++i5) {
                    state[i5] = new FileState((File)filesNow[i5], FileState.FILE_CREATED);
                }
                FileStateChangeEvent ev = new FileStateChangeEvent(state);
                for (int i6 = 0; i6 < FileStateObserver.this.listeners.size(); ++i6) {
                    ((FileStateListener)FileStateObserver.this.listeners.get(i6)).fileStateChanged(ev);
                }
                FileStateObserver.access$302(FileStateObserver.this, (File[])filesNow);
                FileStateObserver.this.updatePreviousLastModified();
                FileStateObserver.this.logger.debug("prev null, files were created");
                return;
            }
            Vector<Object> modified = new Vector<Object>();
            Vector<Object> created = new Vector<Object>();
            for (int i7 = 0; i7 < filesNow.length; ++i7) {
                boolean bprev = false;
                for (int j = 0; j < FileStateObserver.this.previousFiles.length; ++j) {
                    if (!((File)filesNow[i7]).equals(FileStateObserver.this.previousFiles[j])) continue;
                    if (((File)filesNow[i7]).lastModified() != FileStateObserver.this.previousLastModified[j]) {
                        modified.addElement(filesNow[i7]);
                    }
                    bprev = true;
                }
                if (bprev) continue;
                created.addElement(filesNow[i7]);
            }
            Vector<File> removed = new Vector<File>();
            for (int i8 = 0; i8 < FileStateObserver.this.previousFiles.length; ++i8) {
                boolean bnow = false;
                for (int j = 0; j < filesNow.length; ++j) {
                    if (!FileStateObserver.this.previousFiles[i8].equals(filesNow[j])) continue;
                    bnow = true;
                }
                if (bnow) continue;
                removed.addElement(FileStateObserver.this.previousFiles[i8]);
            }
            FileStateObserver.access$302(FileStateObserver.this, (File[])filesNow);
            FileStateObserver.this.updatePreviousLastModified();
            if (modified.size() == 0 && created.size() == 0 && removed.size() == 0) {
                FileStateObserver.this.logger.debug("no file has changed");
                return;
            }
            File lfile = new File(FileStateObserver.this.dir + System.getProperty("file.separator") + LOCK_FILE);
            if (lfile.exists()) {
                return;
            }
            Vector<FileState> fileStates = new Vector<FileState>();
            for (i = 0; i < modified.size(); ++i) {
                fileStates.addElement(new FileState((File)modified.get(i), FileState.FILE_MODIFIED));
            }
            for (i = 0; i < created.size(); ++i) {
                fileStates.addElement(new FileState((File)created.get(i), FileState.FILE_CREATED));
            }
            for (i = 0; i < removed.size(); ++i) {
                fileStates.addElement(new FileState((File)removed.get(i), FileState.FILE_REMOVED));
            }
            if (fileStates.size() == 0) {
                return;
            }
            Object[] states = new FileState[fileStates.size()];
            fileStates.copyInto(states);
            FileStateChangeEvent fe = new FileStateChangeEvent((FileState[])states);
            for (int i9 = 0; i9 < FileStateObserver.this.listeners.size(); ++i9) {
                ((FileStateListener)FileStateObserver.this.listeners.elementAt(i9)).fileStateChanged(fe);
            }
        }
    }
}

