/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.common;

import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.common.MyThreadListener;
import java.io.BufferedReader;
import java.io.File;
import org.apache.log4j.Logger;

public class MyThread
extends Thread {
    private static Logger logger = Logger.getLogger(MyThread.class.getName());
    private String exeString;
    private String print = "";
    private File dir;
    private String[] envp = null;
    private MyThreadListener listener;

    public MyThread(String exeString) {
        this.exeString = exeString;
        this.start();
    }

    public MyThread(String exeString, String print) {
        this.exeString = exeString;
        this.print = print;
        this.start();
    }

    public MyThread(String exeString, String print, File dir) {
        this.exeString = exeString;
        this.print = print;
        this.dir = dir;
        this.start();
    }

    public MyThread(String exeString, String print, File dir, String[] envp) {
        this.exeString = exeString;
        this.print = print;
        this.dir = dir;
        this.envp = envp;
        this.start();
    }

    public MyThread(String exeString, MyThreadListener listener, File dir) {
        this.exeString = exeString;
        this.listener = listener;
        this.dir = dir;
        this.start();
    }

    public MyThread(String exeString, MyThreadListener listener, File dir, String[] envp) {
        this.exeString = exeString;
        this.listener = listener;
        this.dir = dir;
        this.envp = envp;
        this.start();
    }

    public void run() {
        try {
            BufferedReader[] reader = null;
            reader = this.dir == null ? ExternalProgramExecuter.executeGetBR(this.exeString) : (this.envp == null ? ExternalProgramExecuter.executeGetBR(this.exeString, this.dir) : ExternalProgramExecuter.executeGetBR(this.exeString, this.dir, this.envp));
            String line = "";
            if (reader[0] != null) {
                while ((line = reader[0].readLine()) != null) {
                    logger.info(line);
                }
            }
            if (reader[1] != null) {
                while ((line = reader[1].readLine()) != null) {
                    logger.error(line);
                    logger.error(this.exeString);
                }
            }
            if (this.print != null && this.print.trim().length() != 0) {
                logger.info(this.print);
            }
            if (this.listener != null) {
                this.listener.done();
            }
            reader[0].close();
            reader[1].close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

