/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord;

import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.AtomStateList;
import ciss.phase_viewer.atomcoord.UndoRedo;
import ciss.phase_viewer.atomcoord.UndoRedoObject;
import ciss.phase_viewer.common.TaggedString;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Element;

public class AtomList
extends LinkedList {
    private static Logger logger = Logger.getLogger(AtomList.class.getName());
    private UndoRedo undoRedo;
    private boolean updateUndoStack = true;
    private AtomCoords parent;
    private AtomStateList atomState;

    public AtomList(AtomCoords parent) {
        this.parent = parent;
        this.undoRedo = new UndoRedo(this);
    }

    void setState(AtomStateList state) {
        this.atomState = state;
    }

    public AtomList(Atom atom, AtomCoords parent) {
        this.parent = parent;
        this.undoRedo = new UndoRedo(this);
        this.addAtom(atom);
    }

    public AtomList getCopy() {
        AtomList newList = new AtomList(this.parent);
        for (int i = 0; i < this.size(); ++i) {
            Atom at = this.getAtomAt(i);
            newList.addAtomAt(i, at.getCopy());
        }
        return newList;
    }

    public void nullify() {
        for (int i = this.getNumAt() - 1; i >= 0; --i) {
            Atom at = this.getAtomAt(i);
            at.nullify();
        }
        if (this.undoRedo != null) {
            this.undoRedo.nullify();
            this.undoRedo = null;
        }
        this.clear();
        this.parent = null;
    }

    public Element getXMLElement() {
        Element element = new Element("atomlist");
        element.setAttribute(new Attribute("numatoms", String.valueOf(this.size())));
        for (int i = 0; i < this.size(); ++i) {
            Atom atom = this.getAtomAt(i);
            element.addContent(atom.getXMLElement());
        }
        return element;
    }

    public void createFrom(Element atomList) {
        List at = atomList.getChildren("atom");
        if (at == null || at.size() == 0) {
            logger.error("invalid atomlist");
            return;
        }
        for (int i = 0; i < at.size(); ++i) {
            Atom atom = Atom.createFrom((Element)at.get(i));
            this.addAtom(atom);
        }
    }

    public AtomCoords getParent() {
        return this.parent;
    }

    protected UndoRedo getUndoRedoObject() {
        return this.undoRedo;
    }

    public void addAtom(Atom atom) {
        this.undoRedo.addEntry(atom, this.size(), UndoRedoObject.ADD);
        this.addLast(atom);
        if (this.atomState != null) {
            this.atomState.atomAdded();
        }
    }

    public void addAtom(Atom atom, boolean updateStack) {
        if (updateStack) {
            this.undoRedo.addEntry(atom, this.size(), UndoRedoObject.ADD);
        }
        this.addLast(atom);
        if (this.atomState != null) {
            this.atomState.atomAdded();
        }
    }

    public void addAtomAt(int index, Atom atom) {
        this.undoRedo.addEntry(atom, index, UndoRedoObject.ADD);
        this.add(index, atom);
        if (this.atomState != null) {
            this.atomState.atomAdded(index);
        }
    }

    public void addAtomAt(int index, Atom atom, boolean updateStack) {
        if (updateStack) {
            this.undoRedo.addEntry(atom, index, UndoRedoObject.ADD);
        }
        this.add(index, atom);
        if (this.atomState != null) {
            this.atomState.atomAdded(index);
        }
    }

    public void addAtom(String elementName, String[] pos) {
        Atom atom = new Atom(elementName, pos);
        this.undoRedo.addEntry(atom, this.size(), UndoRedoObject.ADD);
        this.addLast(atom);
        if (this.atomState != null) {
            this.atomState.atomAdded();
        }
    }

    public void addAtom(String elementName, String[] pos, TaggedString[] auxil) {
        Atom atom = new Atom(elementName, pos, auxil);
        this.undoRedo.addEntry(atom, this.size(), UndoRedoObject.ADD);
        this.addLast(atom);
        if (this.atomState != null) {
            this.atomState.atomAdded();
        }
    }

    public void addAtom(String elementName, String[] pos, Vector auxil) {
        Atom atom = new Atom(elementName, pos, auxil);
        this.undoRedo.addEntry(atom, this.size(), UndoRedoObject.ADD);
        this.addLast(atom);
        if (this.atomState != null) {
            this.atomState.atomAdded();
        }
    }

    public void setUndoCount(int count) {
        this.undoRedo.setUndoCount(count);
    }

    public boolean undoToFirst() {
        boolean ret = this.undoRedo.undoToFirstEntry();
        return ret;
    }

    public void initializeUndoRedo() {
        if (this.undoRedo == null) {
            this.undoRedo = new UndoRedo(this);
        }
        this.undoRedo.init();
    }

    public Atom getAtomAt(int i) {
        Atom atom;
        try {
            atom = (Atom)this.get(i);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("failed to get atom at: " + i);
            return null;
        }
        return atom;
    }

    public void replaceAtomAt(int i, Atom atom) {
        logger.debug("atom now: " + this.getAtomAt(i));
        this.undoRedo.addEntry(this.getAtomAt(i), i, UndoRedoObject.REPLACE);
        this.set(i, atom);
        if (this.atomState != null) {
            this.atomState.atomModified(i);
        }
    }

    public void replaceAtomAt(int i, Atom atom, boolean updateStack) {
        logger.debug("atom now: " + this.getAtomAt(i));
        if (updateStack) {
            this.undoRedo.addEntry(this.getAtomAt(i), i, UndoRedoObject.REPLACE);
        }
        this.set(i, atom);
        if (this.atomState != null) {
            this.atomState.atomModified(i);
        }
    }

    public void removeAtomAt(int i) {
        this.undoRedo.addEntry(this.getAtomAt(i), i, UndoRedoObject.REMOVE);
        this.remove(i);
        if (this.atomState != null) {
            this.atomState.atomRemoved(i);
        }
    }

    public void removeAtomAt(int i, boolean updateStack) {
        if (updateStack) {
            this.undoRedo.addEntry(this.getAtomAt(i), i, UndoRedoObject.REMOVE);
        }
        this.remove(i);
        if (this.atomState != null) {
            this.atomState.atomRemoved(i);
        }
    }

    public boolean removeAtom(Atom atom) {
        return this.removeAtom(atom, true);
    }

    public boolean removeAtom(Atom atom, boolean updateStack) {
        int index = this.indexOf(atom);
        if (index < 0) {
            index = this.size();
        }
        if (updateStack) {
            this.undoRedo.addEntry(atom, index, UndoRedoObject.REMOVE);
        }
        boolean boo = this.remove(atom);
        if (this.atomState != null) {
            this.atomState.atomRemoved(index);
        }
        return boo;
    }

    public boolean undo() {
        boolean ret = this.undoRedo.undo();
        logger.debug(this);
        return ret;
    }

    public boolean redo() {
        boolean ret = this.undoRedo.redo();
        logger.debug(this);
        return ret;
    }

    public int getNumAt() {
        return this.size();
    }

    public int getRealNumAt() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.getAtomAt(i).isVirtualAtom()) continue;
            ++count;
        }
        return count;
    }

    public String toString() {
        String ret = "";
        for (int i = 0; i < this.size(); ++i) {
            ret = ret + " atom no. " + i + " " + this.getAtomAt(i) + System.getProperty("line.separator");
        }
        return ret;
    }
}

