/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.route;

import java.io.PrintWriter;
import org.cybergarage.x3d.Constants;
import org.cybergarage.x3d.Field;
import org.cybergarage.x3d.FieldType;
import org.cybergarage.x3d.SceneGraph;
import org.cybergarage.x3d.field.MFColor;
import org.cybergarage.x3d.field.MFFloat;
import org.cybergarage.x3d.field.MFInt32;
import org.cybergarage.x3d.field.MFNode;
import org.cybergarage.x3d.field.MFRotation;
import org.cybergarage.x3d.field.MFString;
import org.cybergarage.x3d.field.MFTime;
import org.cybergarage.x3d.field.MFVec2f;
import org.cybergarage.x3d.field.MFVec3f;
import org.cybergarage.x3d.field.SFBool;
import org.cybergarage.x3d.field.SFColor;
import org.cybergarage.x3d.field.SFFloat;
import org.cybergarage.x3d.field.SFInt32;
import org.cybergarage.x3d.field.SFRotation;
import org.cybergarage.x3d.field.SFString;
import org.cybergarage.x3d.field.SFTime;
import org.cybergarage.x3d.field.SFVec2f;
import org.cybergarage.x3d.field.SFVec3f;
import org.cybergarage.x3d.node.BindableNode;
import org.cybergarage.x3d.node.Geometry3DNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.util.LinkedListNode;

public class Route
extends LinkedListNode
implements Constants {
    private Node mEventOutNode = null;
    private Node mEventInNode = null;
    private Field mEventOutField = null;
    private Field mEventInField = null;
    private Object mUserData = null;

    public Route(Node eventOutNode, Field eventOutField, Node eventInNode, Field eventInField) {
        this.setHeaderFlag(false);
        this.setEventOutNode(eventOutNode);
        this.setEventInNode(eventInNode);
        this.setEventOutField(eventOutField);
        this.setEventInField(eventInField);
        this.setData(null);
    }

    public void setEventOutNode(Node node) {
        this.mEventOutNode = node;
    }

    public void setEventInNode(Node node) {
        this.mEventInNode = node;
    }

    public Node getEventOutNode() {
        return this.mEventOutNode;
    }

    public Node getEventInNode() {
        return this.mEventInNode;
    }

    public void setEventOutField(Field field) {
        this.mEventOutField = field;
    }

    public Field getEventOutField() {
        return this.mEventOutField;
    }

    public void setEventInField(Field field) {
        this.mEventInField = field;
    }

    public Field getEventInField() {
        return this.mEventInField;
    }

    public void set(Route route) {
        this.setEventOutNode(route.getEventOutNode());
        this.setEventInNode(route.getEventInNode());
        this.setEventOutField(route.getEventOutField());
        this.setEventInField(route.getEventInField());
    }

    public Route next() {
        return (Route)this.getNextNode();
    }

    public void update() {
        SceneGraph sceneGraph;
        Field fieldIn;
        Field fieldOut;
        int value;
        Field eventOutField = this.getEventOutField();
        Field eventInField = this.getEventInField();
        if (eventOutField == null || eventInField == null) {
            return;
        }
        FieldType eventOutFieldType = eventOutField.getType();
        FieldType eventInFieldType = eventInField.getType();
        if (eventOutFieldType.equals(FieldType.SFBOOL)) {
            SFBool boolOut = (SFBool)eventOutField;
            value = boolOut.getValue();
            if (eventInFieldType.equals(FieldType.SFBOOL)) {
                SFBool boolIn = (SFBool)eventInField;
                boolIn.setValue(value != 0);
            }
        }
        if (eventOutFieldType.equals(FieldType.SFFLOAT)) {
            fieldOut = (SFFloat)eventOutField;
            float value2 = ((SFFloat)fieldOut).getValue();
            if (eventInFieldType.equals(FieldType.SFFLOAT)) {
                fieldIn = (SFFloat)eventInField;
                ((SFFloat)fieldIn).setValue(value2);
            }
        }
        if (eventOutFieldType.equals(FieldType.SFINT32)) {
            fieldOut = (SFInt32)eventOutField;
            value = ((SFInt32)fieldOut).getValue();
            if (eventInFieldType.equals(FieldType.SFINT32)) {
                fieldIn = (SFInt32)eventInField;
                ((SFInt32)fieldIn).setValue(value);
            }
        }
        if (eventOutFieldType.equals(FieldType.SFTIME)) {
            fieldOut = (SFTime)eventOutField;
            double value3 = ((SFTime)fieldOut).getValue();
            if (eventInFieldType.equals(FieldType.SFTIME)) {
                SFTime fieldIn2 = (SFTime)eventInField;
                fieldIn2.setValue(value3);
            }
        }
        if (eventOutFieldType.equals(FieldType.SFSTRING)) {
            fieldOut = (SFString)eventOutField;
            String value4 = ((SFString)fieldOut).getValue();
            if (eventInFieldType.equals(FieldType.SFSTRING)) {
                fieldIn = (SFString)eventInField;
                ((SFString)fieldIn).setValue(value4);
            }
        }
        if (eventOutFieldType.equals(FieldType.SFVEC2F)) {
            fieldOut = (SFVec2f)eventOutField;
            float[] value5 = new float[2];
            ((SFVec2f)fieldOut).getValue(value5);
            if (eventInFieldType.equals(FieldType.SFVEC2F)) {
                fieldIn = (SFVec2f)eventInField;
                ((SFVec2f)fieldIn).setValue(value5);
            }
        }
        if (eventOutFieldType.equals(FieldType.SFVEC3F)) {
            fieldOut = (SFVec3f)eventOutField;
            float[] value6 = new float[3];
            ((SFVec3f)fieldOut).getValue(value6);
            if (eventInFieldType.equals(FieldType.SFVEC3F)) {
                fieldIn = (SFVec3f)eventInField;
                ((SFVec3f)fieldIn).setValue(value6);
            }
        }
        if (eventOutFieldType.equals(FieldType.SFCOLOR)) {
            fieldOut = (SFColor)eventOutField;
            float[] value7 = new float[3];
            ((SFColor)fieldOut).getValue(value7);
            if (eventInFieldType.equals(FieldType.SFCOLOR)) {
                fieldIn = (SFColor)eventInField;
                ((SFColor)fieldIn).setValue(value7);
            }
        }
        if (eventOutFieldType.equals(FieldType.SFROTATION)) {
            fieldOut = (SFRotation)eventOutField;
            float[] value8 = new float[4];
            ((SFRotation)fieldOut).getValue(value8);
            if (eventInFieldType.equals(FieldType.SFROTATION)) {
                fieldIn = (SFRotation)eventInField;
                ((SFRotation)fieldIn).setValue(value8);
            }
        }
        if (eventOutFieldType.equals(FieldType.MFNODE)) {
            MFNode outNode = (MFNode)eventOutField;
            if (eventInFieldType.equals(FieldType.MFNODE)) {
                MFNode inNode = (MFNode)eventInField;
                inNode.copy(outNode);
            }
        }
        if (eventOutFieldType.equals(FieldType.MFSTRING)) {
            MFString outString = (MFString)eventOutField;
            if (eventInFieldType.equals(FieldType.MFSTRING)) {
                MFString inString = (MFString)eventInField;
                inString.copy(outString);
            }
        }
        if (eventOutFieldType.equals(FieldType.MFCOLOR)) {
            MFColor outColor = (MFColor)eventOutField;
            if (eventInFieldType.equals(FieldType.MFCOLOR)) {
                MFColor inColor = (MFColor)eventInField;
                inColor.copy(outColor);
            }
        }
        if (eventOutFieldType.equals(FieldType.MFFLOAT)) {
            MFFloat outFloat = (MFFloat)eventOutField;
            if (eventInFieldType.equals(FieldType.MFFLOAT)) {
                MFFloat inFloat = (MFFloat)eventInField;
                inFloat.copy(outFloat);
            }
        }
        if (eventOutFieldType.equals(FieldType.MFINT32)) {
            MFInt32 outInt32 = (MFInt32)eventOutField;
            if (eventInFieldType.equals(FieldType.MFINT32)) {
                MFInt32 inInt32 = (MFInt32)eventInField;
                inInt32.copy(outInt32);
            }
        }
        if (eventOutFieldType.equals(FieldType.MFROTATION)) {
            MFRotation outRotation = (MFRotation)eventOutField;
            if (eventInFieldType.equals(FieldType.MFROTATION)) {
                MFRotation inRotation = (MFRotation)eventInField;
                inRotation.copy(outRotation);
            }
        }
        if (eventOutFieldType.equals(FieldType.MFTIME)) {
            MFTime outTime = (MFTime)eventOutField;
            if (eventInFieldType.equals(FieldType.MFTIME)) {
                MFTime inTime = (MFTime)eventInField;
                inTime.copy(outTime);
            }
        }
        if (eventOutFieldType.equals(FieldType.MFVEC2F)) {
            MFVec2f outVec2f = (MFVec2f)eventOutField;
            if (eventInFieldType.equals(FieldType.MFVEC2F)) {
                MFVec2f inVec2f = (MFVec2f)eventInField;
                inVec2f.copy(outVec2f);
            }
        }
        if (eventOutFieldType.equals(FieldType.MFVEC3F)) {
            MFVec3f outVec3f = (MFVec3f)eventOutField;
            if (eventInFieldType.equals(FieldType.MFVEC3F)) {
                MFVec3f inVec3f = (MFVec3f)eventInField;
                inVec3f.copy(outVec3f);
            }
        }
        Node eventInNode = this.getEventInNode();
        Node eventInParentNode = eventInNode.getParentNode();
        if (eventInNode.isBindableNode() && ((BindableNode)eventInNode).getBindField() == eventInField && (sceneGraph = eventInNode.getSceneGraph()) != null) {
            sceneGraph.setBindableNode((BindableNode)eventInNode, ((SFBool)eventInField).getValue());
        }
        Geometry3DNode geo = null;
        if (eventInNode.isGeometry3DNode()) {
            geo = (Geometry3DNode)eventInNode;
        } else if (eventInParentNode.isGeometry3DNode()) {
            geo = (Geometry3DNode)eventInParentNode;
        }
        if (geo != null) {
            geo.uninitializeObject();
            geo.uninitialize();
            geo.initialize();
            geo.initializeObject();
        }
    }

    public void setData(Object data) {
        this.mUserData = data;
    }

    public Object getData() {
        return this.mUserData;
    }

    public void output(PrintWriter ps) {
        ps.println(this.toString());
    }

    public String toString() {
        StringBuffer routeString = new StringBuffer();
        routeString.append("ROUTE ");
        if (this.getEventOutNode() != null) {
            routeString.append(this.getEventOutNode().getName() + ".");
        } else {
            routeString.append(this.getEventOutNode() + ".");
        }
        if (this.getEventOutField() != null) {
            routeString.append(this.getEventOutField().getName() + " TO ");
        } else {
            routeString.append(this.getEventOutField() + " TO ");
        }
        if (this.getEventInNode() != null) {
            routeString.append(this.getEventInNode().getName() + ".");
        } else {
            routeString.append(this.getEventInNode() + ".");
        }
        if (this.getEventInField() != null) {
            routeString.append(this.getEventInField().getName());
        } else {
            routeString.append(this.getEventInField());
        }
        return routeString.toString();
    }

    public String getIndentLevelString(int nIndentLevel) {
        char[] indentString = new char[nIndentLevel];
        for (int n = 0; n < nIndentLevel; ++n) {
            indentString[n] = 9;
        }
        return new String(indentString);
    }

    public void outputXML(PrintWriter ps, int nIndentLevel) {
        Node fromNode = this.getEventOutNode();
        Node toNode = this.getEventInNode();
        Field fromField = this.getEventOutField();
        Field toField = this.getEventInField();
        if (fromNode == null || toNode == null || fromField == null || toField == null) {
            return;
        }
        String indentString = this.getIndentLevelString(nIndentLevel);
        ps.print(indentString);
        ps.print("<Route ");
        ps.print("fromNode=\"" + fromNode.getName() + "\" fromField=\"" + fromField.getName() + "\" ");
        ps.print("toNode=\"" + toNode.getName() + "\" toField=\"" + toField.getName() + "\"");
        ps.println("/>");
    }

    public void outputXML(PrintWriter ps) {
        this.outputXML(ps, 0);
    }
}

