/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.parser.x3d;

import org.cybergarage.x3d.Field;
import org.cybergarage.x3d.MField;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.parser.Parser;
import org.cybergarage.x3d.parser.x3d.X3DParserTokenizer;
import org.cybergarage.x3d.xml.XMLNode;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class X3DHandler
extends DefaultHandler {
    private Parser parser;

    public X3DHandler(Parser parser) {
        this.parser = parser;
    }

    public Parser getParser() {
        return this.parser;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    private void addXMLElement(XMLNode xmlNode, String attrName, String attrValue) {
        xmlNode.addElement(attrName, attrValue);
    }

    private void addX3DElement(Node x3dNode, String attrName, String attrValue) {
        Field field = x3dNode.findField(attrName);
        if (field == null) {
            return;
        }
        if (field.isSField()) {
            field.setValue(attrValue);
            return;
        }
        MField mfield = (MField)field;
        int mfieldCnt = mfield.getValueCount();
        X3DParserTokenizer attrToken = new X3DParserTokenizer(attrValue);
        int tokenCnt = 0;
        String fieldTokenStr = "";
        while (attrToken.hasMoreTokens()) {
            ++tokenCnt;
            String token = attrToken.nextToken();
            if (0 < fieldTokenStr.length()) {
                fieldTokenStr = fieldTokenStr + " ";
            }
            fieldTokenStr = fieldTokenStr + token;
            if (mfieldCnt > tokenCnt) continue;
            mfield.addValue(fieldTokenStr);
            tokenCnt = 0;
            fieldTokenStr = "";
        }
    }

    public void startElement(String uri, String local, String qname, Attributes attributes) throws SAXException {
        String elemName = qname;
        Node node = NodeType.CreateX3DNode(elemName);
        if (node.isXMLNode()) {
            node.setName(elemName);
        }
        int len = attributes.getLength();
        for (int index = 0; index < len; ++index) {
            String attrName = attributes.getQName(index);
            String attrValue = attributes.getValue(index);
            if (node.isXMLNode()) {
                XMLNode xmlNode = (XMLNode)node;
                this.addXMLElement(xmlNode, attrName, attrValue);
                continue;
            }
            this.addX3DElement(node, attrName, attrValue);
        }
        this.getParser().addNode(node);
        this.getParser().pushNode(node);
    }

    public void endElement(String uri, String local, String qname) throws SAXException {
        this.getParser().popNode();
    }
}

