/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.j3d;

import javax.media.j3d.BadTransformException;
import javax.media.j3d.Group;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.cybergarage.x3d.SceneGraph;
import org.cybergarage.x3d.j3d.SceneGraphJ3dObject;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.NodeObject;
import org.cybergarage.x3d.node.TransformNode;

public class TransformNodeObject
extends TransformGroup
implements NodeObject {
    private float[] translation = new float[3];
    private float[] rotation = new float[4];
    private float[] scale = new float[3];
    private float[] center = new float[3];
    private float[] scaleOrientation = new float[4];
    private Vector3f vector = new Vector3f();
    private Vector3d factor = new Vector3d();
    private AxisAngle4f axisAngle = new AxisAngle4f();
    private Transform3D trans3D = new Transform3D();
    private Transform3D minusCenterTrans3D = new Transform3D();
    private Transform3D minusScaleOriTrans3D = new Transform3D();
    private Transform3D scaleTrans3D = new Transform3D();
    private Transform3D scaleOriTrans3D = new Transform3D();
    private Transform3D rotationTrans3D = new Transform3D();
    private Transform3D centerTrans3D = new Transform3D();
    private Transform3D translationTrans3D = new Transform3D();

    public TransformNodeObject() {
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(17);
        this.setCapability(18);
    }

    public TransformNodeObject(TransformNode node) {
        this();
        this.initialize(node);
    }

    public boolean initialize(Node node) {
        node.setRunnable(true);
        node.setRunnableType(1);
        this.update(node);
        return true;
    }

    public boolean uninitialize(Node node) {
        return true;
    }

    public boolean update(Node node) {
        TransformNode transNode = (TransformNode)node;
        transNode.getTranslation(this.translation);
        transNode.getScale(this.scale);
        transNode.getCenter(this.center);
        transNode.getRotation(this.rotation);
        transNode.getScaleOrientation(this.scaleOrientation);
        this.trans3D.setIdentity();
        this.translationTrans3D.setIdentity();
        this.vector.x = this.translation[0];
        this.vector.y = this.translation[1];
        this.vector.z = this.translation[2];
        this.translationTrans3D.set(this.vector);
        this.trans3D.mul(this.translationTrans3D);
        this.centerTrans3D.setIdentity();
        this.vector.x = this.center[0];
        this.vector.y = this.center[1];
        this.vector.z = this.center[2];
        this.centerTrans3D.set(this.vector);
        this.trans3D.mul(this.centerTrans3D);
        this.rotationTrans3D.setIdentity();
        this.axisAngle.x = this.rotation[0];
        this.axisAngle.y = this.rotation[1];
        this.axisAngle.z = this.rotation[2];
        this.axisAngle.angle = this.rotation[3];
        this.rotationTrans3D.set(this.axisAngle);
        this.trans3D.mul(this.rotationTrans3D);
        this.scaleOriTrans3D.setIdentity();
        this.axisAngle.x = this.scaleOrientation[0];
        this.axisAngle.y = this.scaleOrientation[1];
        this.axisAngle.z = this.scaleOrientation[2];
        this.axisAngle.angle = this.scaleOrientation[3];
        this.scaleOriTrans3D.set(this.axisAngle);
        this.trans3D.mul(this.scaleOriTrans3D);
        this.scaleTrans3D.setIdentity();
        this.factor.x = this.scale[0];
        this.factor.y = this.scale[1];
        this.factor.z = this.scale[2];
        this.scaleTrans3D.setScale(this.factor);
        this.minusScaleOriTrans3D.setIdentity();
        this.axisAngle.x = this.scaleOrientation[0];
        this.axisAngle.y = this.scaleOrientation[1];
        this.axisAngle.z = this.scaleOrientation[2];
        this.axisAngle.angle = -this.scaleOrientation[3];
        this.minusScaleOriTrans3D.set(this.axisAngle);
        this.trans3D.mul(this.minusScaleOriTrans3D);
        this.minusCenterTrans3D.setIdentity();
        this.vector.x = -this.center[0];
        this.vector.y = -this.center[1];
        this.vector.z = -this.center[2];
        this.minusCenterTrans3D.set(this.vector);
        this.trans3D.mul(this.minusCenterTrans3D);
        this.trans3D.mul(this.scaleTrans3D);
        try {
            this.setTransform(this.trans3D);
        }
        catch (BadTransformException badTransformException) {
            // empty catch block
        }
        return true;
    }

    public Group getParentGroup(Node node) {
        Node parentNode = node.getParentNode();
        Object parentGroupNode = null;
        if (parentNode != null) {
            NodeObject parentNodeObject = parentNode.getObject();
            if (parentNodeObject != null) {
                parentGroupNode = (Group)parentNodeObject;
            }
        } else {
            SceneGraphJ3dObject sgObject;
            SceneGraph sg = node.getSceneGraph();
            if (sg != null && (sgObject = (SceneGraphJ3dObject)sg.getObject()) != null) {
                parentGroupNode = sgObject.getRootNode();
            }
        }
        return parentGroupNode;
    }

    public boolean add(Node node) {
        Group parentGroupNode;
        if (this.getParent() == null && (parentGroupNode = this.getParentGroup(node)) != null) {
            parentGroupNode.addChild((javax.media.j3d.Node)this);
        }
        return true;
    }

    public boolean remove(Node node) {
        Group parentGroupNode = this.getParentGroup(node);
        if (parentGroupNode != null) {
            for (int n = 0; n < parentGroupNode.numChildren(); ++n) {
                if (parentGroupNode.getChild(n) != this) continue;
                parentGroupNode.removeChild(n);
                return true;
            }
        }
        return false;
    }
}

