/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.j3d;

import javax.media.j3d.Geometry;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.Shape3D;
import org.cybergarage.x3d.field.MFInt32;
import org.cybergarage.x3d.j3d.NullGeometryObject;
import org.cybergarage.x3d.node.ColorNode;
import org.cybergarage.x3d.node.CoordinateNode;
import org.cybergarage.x3d.node.IndexedFaceSetNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.NodeObject;
import org.cybergarage.x3d.node.NormalNode;
import org.cybergarage.x3d.node.TextureCoordinateNode;
import org.cybergarage.x3d.util.Debug;
import org.cybergarage.x3d.util.Geometry3D;

public class IndexedFaceSetNodeObject
extends IndexedTriangleArray
implements NodeObject {
    public IndexedFaceSetNodeObject(IndexedFaceSetNode node) {
        super(IndexedFaceSetNodeObject.getVertexCount(node), IndexedFaceSetNodeObject.getVertexFormat(node), node.getNTriangleCoordIndices());
        this.setCapability(0);
        this.setCapability(1);
        this.setCapability(2);
        this.setCapability(3);
        this.setCapability(4);
        this.setCapability(5);
        this.setCapability(6);
        this.setCapability(7);
        this.setCapability(8);
        this.setCapability(20);
        this.setCapability(17);
        this.setCapability(11);
        this.setCapability(12);
        this.setCapability(9);
        this.setCapability(10);
        this.setCapability(13);
        this.setCapability(14);
        this.setCapability(15);
        this.setCapability(16);
        this.setCapability(18);
        this.initialize(node);
    }

    public static int getVertexCount(IndexedFaceSetNode node) {
        int colorCount;
        int count = 0;
        if (node.getCoordinateNodes() != null) {
            count = node.getCoordinateNodes().getNPoints();
        }
        if (node.getNormalNodes() != null) {
            int normalCount = node.getNormalNodes().getNVectors();
            if (count < normalCount) {
                count = normalCount;
            }
        } else {
            int nTriangle = node.getNTriangleCoordIndices() / 3;
            if (count < nTriangle) {
                count = nTriangle;
            }
        }
        if (node.getColorNodes() != null && count < (colorCount = node.getColorNodes().getNColors())) {
            count = colorCount;
        }
        Debug.message("\tgetVertexCount() = " + count);
        return count;
    }

    public static int getVertexFormat(IndexedFaceSetNode node) {
        int vertexFormat = 3;
        if (node.getColorNodes() != null) {
            vertexFormat |= 4;
        }
        if (node.getTextureCoordinateNodes() != null) {
            vertexFormat |= 0x20;
        }
        return vertexFormat;
    }

    public boolean initialize(Node node) {
        TextureCoordinateNode texCoordNode;
        int i;
        int indexSize;
        int id;
        int n;
        int i2;
        int id2;
        int n2;
        IndexedFaceSetNode idxFaceSetNode = (IndexedFaceSetNode)node;
        MFInt32 index = new MFInt32();
        int nTriangle = 0;
        int nCoordinatePoints = 0;
        int nCoordIndices = idxFaceSetNode.getNCoordIndices();
        Debug.message("\tnCoordIndices = " + nCoordIndices);
        CoordinateNode coordNode = idxFaceSetNode.getCoordinateNodes();
        if (coordNode != null) {
            int n3;
            nCoordinatePoints = coordNode.getNPoints();
            float[] point = new float[3];
            for (n3 = 0; n3 < nCoordinatePoints; ++n3) {
                coordNode.getPoint(n3, point);
                this.setCoordinate(n3, point);
            }
            index.clear();
            nTriangle = 0;
            for (n3 = 0; n3 < nCoordIndices; ++n3) {
                int id3 = idxFaceSetNode.getCoordIndex(n3);
                if (id3 != -1) {
                    index.addValue(id3);
                }
                if (id3 != -1 && n3 != nCoordIndices - 1) continue;
                int indexSize2 = index.getSize();
                for (int i3 = 0; i3 < indexSize2 - 2; ++i3) {
                    this.setCoordinateIndex(nTriangle * 3, index.get1Value(0));
                    this.setCoordinateIndex(nTriangle * 3 + 1, index.get1Value(i3 + 1));
                    this.setCoordinateIndex(nTriangle * 3 + 2, index.get1Value(i3 + 2));
                    ++nTriangle;
                }
                index.clear();
            }
        }
        ColorNode colorNode = idxFaceSetNode.getColorNodes();
        Debug.message("\tcolorNode = " + colorNode);
        if (colorNode != null) {
            boolean hasColorIndices;
            int nColorIndices;
            float[] color = new float[3];
            int nColors = colorNode.getNColors();
            for (int n4 = 0; n4 < nColors; ++n4) {
                colorNode.getColor(n4, color);
                this.setColor(n4, color);
            }
            index.clear();
            nTriangle = 0;
            boolean isColorPerVertex = idxFaceSetNode.isColorPerVertex();
            Debug.message("\tisColorPerVertex = " + isColorPerVertex);
            if (isColorPerVertex) {
                nColorIndices = idxFaceSetNode.getNColorIndices();
                Debug.message("\tnColorIndices = " + nColorIndices);
                boolean bl = hasColorIndices = nCoordIndices <= nColorIndices;
                if (!hasColorIndices) {
                    nColorIndices = nCoordIndices;
                }
                for (n2 = 0; n2 < nColorIndices; ++n2) {
                    id2 = 0;
                    id2 = hasColorIndices ? idxFaceSetNode.getColorIndex(n2) : idxFaceSetNode.getCoordIndex(n2);
                    if (id2 != -1) {
                        index.addValue(id2);
                    }
                    if (id2 != -1 && n2 != nColorIndices - 1) continue;
                    int indexSize3 = index.getSize();
                    for (i2 = 0; i2 < indexSize3 - 2; ++i2) {
                        this.setColorIndex(nTriangle * 3, index.get1Value(0));
                        this.setColorIndex(nTriangle * 3 + 1, index.get1Value(i2 + 1));
                        this.setColorIndex(nTriangle * 3 + 2, index.get1Value(i2 + 2));
                        ++nTriangle;
                    }
                    index.clear();
                }
            } else {
                nColorIndices = idxFaceSetNode.getNColorIndices();
                hasColorIndices = idxFaceSetNode.getNPolygons() <= nColorIndices;
                int nPolygon = 0;
                for (n = 0; n < nCoordIndices; ++n) {
                    id = idxFaceSetNode.getCoordIndex(n);
                    if (id != -1) {
                        index.addValue(id);
                    }
                    if (id != -1 && n != nCoordIndices - 1) continue;
                    indexSize = index.getSize();
                    for (i = 0; i < indexSize - 2; ++i) {
                        int colorlIndex = 0;
                        colorlIndex = hasColorIndices ? idxFaceSetNode.getColorIndex(nPolygon) : nPolygon;
                        this.setColorIndex(nTriangle * 3, colorlIndex);
                        this.setColorIndex(nTriangle * 3 + 1, colorlIndex);
                        this.setColorIndex(nTriangle * 3 + 2, colorlIndex);
                        ++nTriangle;
                    }
                    index.clear();
                    ++nPolygon;
                }
            }
        }
        NormalNode normalNode = idxFaceSetNode.getNormalNodes();
        Debug.message("\tnormalNode = " + normalNode);
        if (normalNode != null) {
            boolean hasNormalIndices;
            int nNormalIndices;
            float[] vector = new float[3];
            int nVectors = normalNode.getNVectors();
            for (int n5 = 0; n5 < nVectors; ++n5) {
                normalNode.getVector(n5, vector);
                this.setNormal(n5, vector);
            }
            index.clear();
            nTriangle = 0;
            boolean isNormalPerVertex = idxFaceSetNode.isNormalPerVertex();
            Debug.message("\tisNormalPerVertex = " + isNormalPerVertex);
            if (isNormalPerVertex) {
                nNormalIndices = idxFaceSetNode.getNNormalIndices();
                hasNormalIndices = nCoordIndices <= nNormalIndices;
                Debug.message("\thasNormalIndices = " + hasNormalIndices);
                if (!hasNormalIndices) {
                    nNormalIndices = nCoordIndices;
                }
                Debug.message("\tnNormalIndices = " + nNormalIndices);
                for (n = 0; n < nNormalIndices; ++n) {
                    id = 0;
                    id = hasNormalIndices ? idxFaceSetNode.getNormalIndex(n) : idxFaceSetNode.getCoordIndex(n);
                    if (id != -1) {
                        index.addValue(id);
                    }
                    if (id != -1 && n != nNormalIndices - 1) continue;
                    indexSize = index.getSize();
                    for (i = 0; i < indexSize - 2; ++i) {
                        this.setNormalIndex(nTriangle * 3, index.get1Value(0));
                        this.setNormalIndex(nTriangle * 3 + 1, index.get1Value(i + 1));
                        this.setNormalIndex(nTriangle * 3 + 2, index.get1Value(i + 2));
                        ++nTriangle;
                    }
                    index.clear();
                }
            } else {
                nNormalIndices = idxFaceSetNode.getNNormalIndices();
                hasNormalIndices = idxFaceSetNode.getNPolygons() <= nNormalIndices;
                int nPolygon = 0;
                for (int n6 = 0; n6 < nCoordIndices; ++n6) {
                    int id4 = idxFaceSetNode.getCoordIndex(n6);
                    if (id4 != -1) {
                        index.addValue(id4);
                    }
                    if (id4 != -1 && n6 != nCoordIndices - 1) continue;
                    for (i = 0; i < index.getSize() - 2; ++i) {
                        int normalIndex = 0;
                        normalIndex = hasNormalIndices ? idxFaceSetNode.getNormalIndex(nPolygon) : nPolygon;
                        this.setNormalIndex(nTriangle * 3, normalIndex);
                        this.setNormalIndex(nTriangle * 3 + 1, normalIndex);
                        this.setNormalIndex(nTriangle * 3 + 2, normalIndex);
                        ++nTriangle;
                    }
                    index.clear();
                    ++nPolygon;
                }
            }
        } else {
            int nPoly = 0;
            int nPoint = 0;
            float[][] point = new float[3][3];
            float[] vector = new float[3];
            for (n2 = 0; n2 < nCoordIndices; ++n2) {
                id2 = idxFaceSetNode.getCoordIndex(n2);
                if (id2 != -1) {
                    if (nPoint < 3) {
                        coordNode.getPoint(id2, point[nPoint]);
                    }
                    ++nPoint;
                }
                if (id2 != -1 && n2 != nCoordIndices - 1) continue;
                Geometry3D.getNormalVector(point, vector);
                this.setNormal(nPoly, vector);
                nPoint = 0;
                ++nPoly;
            }
            nTriangle = 0;
            nPoly = 0;
            for (n2 = 0; n2 < nCoordIndices; ++n2) {
                id2 = idxFaceSetNode.getCoordIndex(n2);
                if (id2 != -1) {
                    ++nPoint;
                }
                if (id2 != -1 && n2 != nCoordIndices - 1) continue;
                int nTrianglePoly = nPoint - 2;
                for (i2 = 0; i2 < nTrianglePoly; ++i2) {
                    this.setNormalIndex(nTriangle * 3, nPoly);
                    this.setNormalIndex(nTriangle * 3 + 1, nPoly);
                    this.setNormalIndex(nTriangle * 3 + 2, nPoly);
                    ++nTriangle;
                }
                nPoint = 0;
                ++nPoly;
            }
            nTriangle = 0;
        }
        if ((texCoordNode = idxFaceSetNode.getTextureCoordinateNodes()) != null) {
            boolean hasTexCoordIndices;
            float[] point = new float[2];
            int nTexCoordPoints = texCoordNode.getNPoints();
            for (int n7 = 0; n7 < nTexCoordPoints && n7 < nCoordinatePoints; ++n7) {
                texCoordNode.getPoint(n7, point);
                this.setTextureCoordinate(n7, point);
            }
            index.clear();
            nTriangle = 0;
            int nTexCoordIndices = idxFaceSetNode.getNTexCoordIndices();
            boolean bl = hasTexCoordIndices = nCoordIndices <= nTexCoordIndices;
            if (!hasTexCoordIndices) {
                nTexCoordIndices = nCoordIndices;
            }
            for (n = 0; n < nTexCoordIndices; ++n) {
                id = 0;
                id = hasTexCoordIndices ? idxFaceSetNode.getTexCoordIndex(n) : idxFaceSetNode.getCoordIndex(n);
                if (id != -1) {
                    index.addValue(id);
                }
                if (id != -1 && n != nTexCoordIndices - 1) continue;
                indexSize = index.getSize();
                for (i = 0; i < indexSize - 2; ++i) {
                    this.setTextureCoordinateIndex(nTriangle * 3, index.get1Value(0));
                    this.setTextureCoordinateIndex(nTriangle * 3 + 1, index.get1Value(i + 1));
                    this.setTextureCoordinateIndex(nTriangle * 3 + 2, index.get1Value(i + 2));
                    ++nTriangle;
                }
                index.clear();
            }
        }
        return true;
    }

    public boolean uninitialize(Node node) {
        return true;
    }

    public boolean update(Node node) {
        return true;
    }

    public boolean add(Node node) {
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isShapeNode() && (parentNodeObject = parentNode.getObject()) != null) {
            Shape3D parentShape3DNode = (Shape3D)parentNodeObject;
            parentShape3DNode.setGeometry((Geometry)this);
        }
        return true;
    }

    public boolean remove(Node node) {
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isShapeNode() && (parentNodeObject = parentNode.getObject()) != null) {
            Shape3D parentShape3DNode = (Shape3D)parentNodeObject;
            parentShape3DNode.setGeometry((Geometry)new NullGeometryObject());
        }
        return true;
    }
}

