/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.j3d;

import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.ExponentialFog;
import javax.media.j3d.Group;
import javax.vecmath.Point3d;
import org.cybergarage.x3d.SceneGraph;
import org.cybergarage.x3d.j3d.SceneGraphJ3dObject;
import org.cybergarage.x3d.node.FogNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.NodeObject;

public class ExponentialFogNodeObject
extends ExponentialFog
implements NodeObject {
    private static BoundingSphere mInfiniteBounds = new BoundingSphere(new Point3d(), Double.MAX_VALUE);
    private static BoundingSphere mZeroBounds = new BoundingSphere(new Point3d(), -1.0);

    public ExponentialFogNodeObject(FogNode node) {
        this.setCapability(14);
        this.setCapability(15);
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(18);
        this.setCapability(19);
        this.setCapability(16);
        this.setCapability(17);
        this.initialize(node);
    }

    public boolean initialize(Node node) {
        this.update(node);
        return true;
    }

    public boolean uninitialize(Node node) {
        return true;
    }

    public boolean update(Node node) {
        FogNode fogNode = (FogNode)node;
        float[] color = new float[3];
        fogNode.getColor(color);
        this.setColor(color[0], color[1], color[2]);
        float range = fogNode.getVisibilityRange();
        this.setDensity(range);
        if (range <= 0.0f) {
            this.setInfluencingBounds((Bounds)mZeroBounds);
        } else {
            this.setInfluencingBounds((Bounds)mInfiniteBounds);
        }
        return true;
    }

    public Group getParentGroup(Node node) {
        Node parentNode = node.getParentNode();
        Object parentGroupNode = null;
        if (parentNode != null) {
            NodeObject parentNodeObject = parentNode.getObject();
            if (parentNodeObject != null) {
                parentGroupNode = (Group)parentNodeObject;
            }
        } else {
            SceneGraphJ3dObject sgObject;
            SceneGraph sg = node.getSceneGraph();
            if (sg != null && (sgObject = (SceneGraphJ3dObject)sg.getObject()) != null) {
                parentGroupNode = sgObject.getRootNode();
            }
        }
        return parentGroupNode;
    }

    public boolean add(Node node) {
        Group parentGroupNode;
        if (this.getParent() == null && (parentGroupNode = this.getParentGroup(node)) != null) {
            parentGroupNode.addChild((javax.media.j3d.Node)this);
        }
        return true;
    }

    public boolean remove(Node node) {
        Group parentGroupNode = this.getParentGroup(node);
        if (parentGroupNode != null) {
            for (int n = 0; n < parentGroupNode.numChildren(); ++n) {
                if (parentGroupNode.getChild(n) != this) continue;
                parentGroupNode.removeChild(n);
                return true;
            }
        }
        return false;
    }
}

