/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.j3d;

import javax.media.j3d.Geometry;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.cybergarage.x3d.j3d.NullGeometryObject;
import org.cybergarage.x3d.node.BoxNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.NodeObject;

public class BoxNodeObject
extends QuadArray
implements NodeObject {
    public BoxNodeObject(BoxNode node) {
        super(24, 35);
        this.setCapability(0);
        this.setCapability(1);
        this.setCapability(2);
        this.setCapability(3);
        this.setCapability(4);
        this.setCapability(5);
        this.setCapability(6);
        this.setCapability(7);
        this.setCapability(8);
        this.setCapability(20);
        this.setCapability(17);
        this.setCapability(18);
        float xsize = node.getX();
        float ysize = node.getY();
        float zsize = node.getZ();
        float xmin = -xsize / 2.0f;
        float xmax = xsize / 2.0f;
        float ymin = -ysize / 2.0f;
        float ymax = ysize / 2.0f;
        float zmin = -zsize / 2.0f;
        float zmax = zsize / 2.0f;
        this.createBox(xmin, xmax, ymin, ymax, zmin, zmax);
    }

    private void createBox(float x0, float x1, float y0, float y1, float z0, float z1) {
        float[][] n = new float[][]{{0.0f, 0.0f, 1.0f}, {0.0f, -1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}, {0.0f, 1.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {-1.0f, 0.0f, 0.0f}};
        int[][] faces = new int[][]{{3, 2, 1, 0}, {2, 3, 7, 6}, {6, 7, 4, 5}, {0, 1, 5, 4}, {2, 6, 5, 1}, {7, 3, 0, 4}};
        float[][] t = new float[][]{{0.0f, 0.0f}, {1.0f, 0.0f}, {1.0f, 1.0f}, {0.0f, 1.0f}};
        float[][] v = new float[8][3];
        float f = x0;
        v[7][0] = f;
        v[4][0] = f;
        v[3][0] = f;
        v[0][0] = f;
        float f2 = x1;
        v[6][0] = f2;
        v[5][0] = f2;
        v[2][0] = f2;
        v[1][0] = f2;
        float f3 = y0;
        v[7][1] = f3;
        v[6][1] = f3;
        v[3][1] = f3;
        v[2][1] = f3;
        float f4 = y1;
        v[5][1] = f4;
        v[4][1] = f4;
        v[1][1] = f4;
        v[0][1] = f4;
        float f5 = z0;
        v[7][2] = f5;
        v[6][2] = f5;
        v[5][2] = f5;
        v[4][2] = f5;
        float f6 = z1;
        v[3][2] = f6;
        v[2][2] = f6;
        v[1][2] = f6;
        v[0][2] = f6;
        Point3f[] verts = new Point3f[24];
        Vector3f[] norms = new Vector3f[24];
        Point2f[] texCoords = new Point2f[24];
        for (int i = 0; i < 6; ++i) {
            for (int j2 = 0; j2 < 4; ++j2) {
                norms[i * 4 + j2] = new Vector3f(n[i]);
                verts[i * 4 + j2] = new Point3f(v[faces[i][j2]]);
                texCoords[i * 4 + j2] = new Point2f(t[j2]);
            }
        }
        this.setCoordinates(0, verts);
        this.setNormals(0, norms);
        this.setTextureCoordinates(0, texCoords);
    }

    public boolean initialize(Node node) {
        return true;
    }

    public boolean uninitialize(Node node) {
        return true;
    }

    public boolean update(Node node) {
        return true;
    }

    public boolean add(Node node) {
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isShapeNode() && (parentNodeObject = parentNode.getObject()) != null) {
            Shape3D parentShape3DNode = (Shape3D)parentNodeObject;
            parentShape3DNode.setGeometry((Geometry)this);
        }
        return true;
    }

    public boolean remove(Node node) {
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isShapeNode() && (parentNodeObject = parentNode.getObject()) != null) {
            Shape3D parentShape3DNode = (Shape3D)parentNodeObject;
            parentShape3DNode.setGeometry((Geometry)new NullGeometryObject());
        }
        return true;
    }
}

