/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jcterm;

import com.jcraft.jcterm.Term;
import java.io.IOException;
import java.io.InputStream;

public abstract class Emulator {
    Term term = null;
    InputStream in = null;
    byte[] buf = new byte[1024];
    int bufs = 0;
    int buflen = 0;

    public Emulator(Term term, InputStream in) {
        this.term = term;
        this.in = in;
    }

    public abstract void start();

    public abstract byte[] getCodeENTER();

    public abstract byte[] getCodeUP();

    public abstract byte[] getCodeDOWN();

    public abstract byte[] getCodeRIGHT();

    public abstract byte[] getCodeLEFT();

    public abstract byte[] getCodeF1();

    public abstract byte[] getCodeF2();

    public abstract byte[] getCodeF3();

    public abstract byte[] getCodeF4();

    public abstract byte[] getCodeF5();

    public abstract byte[] getCodeF6();

    public abstract byte[] getCodeF7();

    public abstract byte[] getCodeF8();

    public abstract byte[] getCodeF9();

    public abstract byte[] getCodeF10();

    public abstract void reset();

    byte getChar() throws IOException {
        if (this.buflen == 0) {
            this.fillBuf();
        }
        --this.buflen;
        return this.buf[this.bufs++];
    }

    void fillBuf() throws IOException {
        this.bufs = 0;
        this.buflen = 0;
        this.buflen = this.in.read(this.buf, this.bufs, this.buf.length - this.bufs);
        if (this.buflen <= 0) {
            this.buflen = 0;
            throw new IOException("fillBuf");
        }
    }

    void pushChar(byte foo) throws IOException {
        ++this.buflen;
        this.buf[--this.bufs] = foo;
    }

    int getASCII(int len) throws IOException {
        if (this.buflen == 0) {
            this.fillBuf();
        }
        if (len > this.buflen) {
            len = this.buflen;
        }
        int foo = len;
        while (len > 0) {
            byte tmp;
            if (32 <= (tmp = this.buf[this.bufs++]) && tmp <= 127) {
                --this.buflen;
                --len;
                continue;
            }
            --this.bufs;
            break;
        }
        return foo - len;
    }
}

