/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.ssh.hosts;

import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.hosts.HostList;
import ciss.phase_viewer.ssh.hosts.HostSelector;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;

public class HostSelectorTable
extends JTable
implements HostSelector {
    private Logger logger = Logger.getLogger(HostSelectorTable.class.getName());
    private HostList list = HostList.getHostList();
    private static HostSelectorTable ta;

    public HostSelectorTable() {
        this.init();
    }

    private void init() {
        this.setPreferredScrollableViewportSize(new Dimension(250, 10));
        this.setSelectionMode(0);
        TableMod model = new TableMod();
        model.addColumn("hostname");
        model.addColumn("default");
        model.addTableModelListener(new Listener());
        this.setModel(model);
        JCheckBox cb = new JCheckBox();
        DefaultCellEditor dce = new DefaultCellEditor(cb);
        this.getColumn("default").setCellEditor(dce);
        JTextField tf = new JTextField("");
        tf.setEditable(false);
        DefaultCellEditor dcet = new DefaultCellEditor(tf);
        this.getColumn("hostname").setCellEditor(dcet);
        for (int i = 0; i < this.list.size(); ++i) {
            HostInfo info = this.list.getHostInfo(i);
            Object[] obj = new Object[]{info.getName(), new Boolean(info.getBooleanProperty("default"))};
            ((DefaultTableModel)this.getModel()).addRow(obj);
        }
    }

    public HostList getListofHosts() {
        return this.list;
    }

    public HostInfo getSelectedHost() {
        int i = this.getSelectedRow();
        if (i >= 0) {
            return this.list.getHostInfo(i);
        }
        return this.list.getDefaultHost();
    }

    public int getSelectedIndex() {
        return this.getSelectedRow();
    }

    public void recreate() {
        this.removeAll();
        this.init();
    }

    public void addHost(HostInfo hostInfo) {
        ((DefaultTableModel)this.getModel()).addRow(new Object[]{hostInfo.getName(), new Boolean(false)});
        this.list.add(hostInfo);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setSize(200, 100);
        JScrollPane scr = new JScrollPane();
        ta = new HostSelectorTable();
        ta.setPreferredScrollableViewportSize(new Dimension(200, 70));
        scr.getViewport().add(ta);
        JButton btn = new JButton("add");
        JPanel pp = new JPanel();
        pp.add(btn);
        pp.add(scr);
        frame.getContentPane().add(pp);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ta.addHost(new HostInfo("foobar"));
            }
        });
    }

    private int getDefIndex() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object b2 = this.getValueAt(i, 1);
            if (!(b2 instanceof Boolean) || !((Boolean)b2).booleanValue()) continue;
            return i;
        }
        return -1;
    }

    public void deleteSelectedHost() {
        int ind = this.getSelectedRow();
        this.list.remove(ind);
        ((DefaultTableModel)this.getModel()).removeRow(ind);
    }

    class Listener
    implements TableModelListener {
        Listener() {
        }

        public void tableChanged(TableModelEvent e) {
            int i;
            int column = e.getColumn();
            if (column != 1) {
                return;
            }
            int row = e.getFirstRow();
            int larow = e.getLastRow();
            int defind = HostSelectorTable.this.getDefIndex();
            TableModelListener[] lists = ((DefaultTableModel)HostSelectorTable.this.getModel()).getTableModelListeners();
            for (i = 0; i < lists.length; ++i) {
                ((DefaultTableModel)HostSelectorTable.this.getModel()).removeTableModelListener(lists[i]);
            }
            for (i = 0; i < HostSelectorTable.this.getRowCount(); ++i) {
                if (i == row) continue;
                HostSelectorTable.this.setValueAt(new Boolean(false), i, 1);
                HostSelectorTable.this.list.getHostInfo(i).setProperty("default", "false");
            }
            HostSelectorTable.this.setValueAt(new Boolean(true), row, 1);
            HostSelectorTable.this.list.getHostInfo(row).setProperty("default", "true");
            HostSelectorTable.this.repaint();
            HostSelectorTable.this.revalidate();
            for (i = 0; i < lists.length; ++i) {
                ((DefaultTableModel)HostSelectorTable.this.getModel()).addTableModelListener(lists[i]);
            }
        }
    }

    class ListSelectLis
    implements ListSelectionListener {
        ListSelectLis() {
        }

        public void valueChanged(ListSelectionEvent arg0) {
            int i;
            int column = HostSelectorTable.this.getSelectedColumn();
            if (column != 1) {
                return;
            }
            int row = HostSelectorTable.this.getSelectedRow();
            TableModelListener[] lists = ((DefaultTableModel)HostSelectorTable.this.getModel()).getTableModelListeners();
            for (i = 0; i < lists.length; ++i) {
                ((DefaultTableModel)HostSelectorTable.this.getModel()).removeTableModelListener(lists[i]);
            }
            for (i = 0; i < HostSelectorTable.this.getRowCount(); ++i) {
                HostSelectorTable.this.setValueAt(new Boolean(false), i, 1);
            }
            HostSelectorTable.this.repaint();
            HostSelectorTable.this.revalidate();
            HostSelectorTable.this.setValueAt(new Boolean(true), row, 1);
            for (i = 0; i < lists.length; ++i) {
                ((DefaultTableModel)HostSelectorTable.this.getModel()).addTableModelListener(lists[i]);
            }
        }
    }

    class TableMod
    extends DefaultTableModel {
        TableMod() {
        }

        public Class getColumnClass(int c2) {
            return this.getValueAt(0, c2).getClass();
        }
    }
}

