/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.ssh.hosts;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.mainpanel.Desk;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.ssh.SshClient;
import ciss.phase_viewer.ssh.hosts.ButtonListenerHostConfigurator;
import ciss.phase_viewer.ssh.hosts.CaretListenerHostConfigurator;
import ciss.phase_viewer.ssh.hosts.CheckBoxHostConfigurator;
import ciss.phase_viewer.ssh.hosts.HostConfigButtons;
import ciss.phase_viewer.ssh.hosts.HostConfigEditors;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.hosts.HostSelectorList;
import ciss.phase_viewer.ssh.hosts.HostSelectorTable;
import ciss.phase_viewer.ssh.hosts.InputPanelHostConfigurator;
import ciss.phase_viewer.ssh.hosts.JPasswordFieldHostConfigurator;
import ciss.phase_viewer.ssh.hosts.PathSelectorHostConfigurator;
import ciss.phase_viewer.ssh.sftp.SftpClient;
import ciss.phase_viewer.ssh.terminal.Terminal;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.log4j.Logger;

public class HostConfigurator
extends InternalFrameChase
implements ListSelectionListener,
SshClient,
TableModelListener {
    private static Logger logger = Logger.getLogger(HostConfigurator.class.getName());
    private HostSelectorList list;
    private HostSelectorTable table;
    private JPasswordFieldHostConfigurator password;
    private CheckBoxHostConfigurator savepass;
    private CheckBoxHostConfigurator defaultHost;
    private JTabbedPane tab;
    private CaretListenerHostConfigurator caretListener;
    private ButtonListenerHostConfigurator btnlist;
    private HostInfo hostinfo;
    private Vector textfields = new Vector();
    private Vector buttons = new Vector();
    private JButton btndel;
    private JTextField tfbase;
    private JTextField tfbin;
    private JTextField tfmpi;
    private JTextField tfjava;

    public HostConfigurator() {
        super("HostConfigurator", true, true, true, true, new Dimension(600, 360));
        this.init();
    }

    public void connect(HostInfo hostinfo) {
    }

    public void disconnect() {
    }

    public void setHostInfo(HostInfo hostinfo) {
        this.hostinfo = hostinfo;
    }

    public HostInfo getHostInfo() {
        return this.table.getSelectedHost();
    }

    private void init() {
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(2, 1));
        JScrollPane scrollpane = new JScrollPane();
        this.list = new HostSelectorList();
        this.table = new HostSelectorTable();
        this.caretListener = new CaretListenerHostConfigurator(this.table);
        this.btnlist = new ButtonListenerHostConfigurator(this.table);
        scrollpane.getViewport().setView(this.table);
        JPanel ppp = new JPanel();
        ppp.add(scrollpane);
        JSplitPane split = new JSplitPane(1, true, scrollpane, this.createButtons2());
        p.add(split);
        this.tab = new JTabbedPane();
        this.tab.addTab("host", this.createHosts());
        this.tab.addTab("dir", this.createDirs());
        this.tab.addTab("ssh terminal", this.createTerms());
        p.add(this.tab);
        JPanel pp = new JPanel();
        pp.setLayout(new BoxLayout(pp, 1));
        pp.add(p);
        pp.add(this.createButtons());
        this.getContentPane().add(pp);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getSelectionModel().setSelectionInterval(0, 0);
        this.revalidate();
    }

    private JPanel createButtons2() {
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(4, 1));
        p.setBorder(new TitledBorder("create connection to selected host"));
        JButton tem = new JButton("ssh terminal");
        JButton tsf = new JButton("sftp client");
        p.add(tem);
        p.add(tsf);
        tem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Terminal term = new Terminal(HostConfigurator.this.table.getSelectedHost());
            }
        });
        tsf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpClient sfc = new SftpClient(HostConfigurator.this.table.getSelectedHost());
            }
        });
        return p;
    }

    private void adjustSize() {
        int numHost = this.table.getModel().getRowCount();
        int widt = (int)((double)this.getSize().width * 0.45);
        this.table.setPreferredSize(new Dimension(widt, this.table.getPreferredSize().height));
        this.table.revalidate();
    }

    public void valueChanged(ListSelectionEvent e) {
        HostInfo info = this.table.getSelectedHost();
        if (info != null) {
            int i;
            String pas = info.getPasswordString();
            if (pas != null) {
                this.password.setText(pas);
            } else {
                this.password.setText("");
            }
            for (i = 0; i < this.buttons.size(); ++i) {
                HostConfigButtons button = (HostConfigButtons)this.buttons.get(i);
                button.setSelected(info.getBooleanProperty(button.getPropertyType()));
            }
            for (i = 0; i < this.textfields.size(); ++i) {
                HostConfigEditors editor = (HostConfigEditors)this.textfields.get(i);
                editor.setValue(info.getProperty(editor.getPropertyType()));
            }
            this.password.setEditable(this.savepass.isSelected());
            this.btndel.setEnabled(!info.isLocalHost());
        } else {
            logger.debug("host info was null... something is wrong!");
        }
    }

    private JPanel createButtons() {
        JButton btncreate = new JButton("add new host");
        this.btndel = new JButton("delete selected host");
        JButton btnsave = new JButton("save to disk");
        JButton btnclose = new JButton("close");
        JPanel btnpanel = new JPanel();
        btnpanel.setLayout(new BoxLayout(btnpanel, 0));
        btnpanel.add(btncreate);
        btnpanel.add(this.btndel);
        btnpanel.add(btnsave);
        btnpanel.add(btnclose);
        btncreate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HostConfigurator.this.addHost();
            }
        });
        this.btndel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HostConfigurator.this.deleteHost();
            }
        });
        btnsave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HostConfigurator.this.save();
            }
        });
        btnclose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HostConfigurator.this.dispose();
            }
        });
        return btnpanel;
    }

    private void save() {
        this.table.getListofHosts().save();
    }

    private void addHost() {
        String hostName = JOptionPane.showInternalInputDialog(Desk.getDesktop(), "input name of host (must be unique!)", "new host", -1);
        if (hostName == null || hostName.trim().length() == 0) {
            return;
        }
        if (this.isDupli(hostName)) {
            logger.warn("failed to add host ... found duplicate host name!");
            return;
        }
        this.table.addHost(new HostInfo(hostName));
        this.table.addRowSelectionInterval(this.table.getRowCount() - 1, this.table.getRowCount() - 1);
    }

    private void deleteHost() {
        int selected = this.table.getSelectedIndex();
        if (selected == 0) {
            logger.warn("can't delete localhost");
            return;
        }
        this.table.deleteSelectedHost();
        this.table.addRowSelectionInterval(this.table.getRowCount() - 1, this.table.getRowCount() - 1);
    }

    private boolean isDupli(String hostName) {
        boolean ret = false;
        int n = this.table.getListofHosts().size();
        for (int i = 0; i < n; ++i) {
            if (!hostName.trim().equals(this.table.getListofHosts().getHostInfo(i).getName().trim())) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private JPanel createEmail() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        InputPanelHostConfigurator smtp = new InputPanelHostConfigurator("smtp_hostname", 0, 15, "mail_smtphost");
        smtp.getTextField().addCaretListener(this.caretListener);
        this.textfields.add(smtp.getTextField());
        InputPanelHostConfigurator user = new InputPanelHostConfigurator("sender_name", 0, 15, "mail_from_user");
        InputPanelHostConfigurator fromAddres = new InputPanelHostConfigurator("sender_address", 0, 15, "mail_from_address");
        user.getTextField().addCaretListener(this.caretListener);
        fromAddres.getTextField().addCaretListener(this.caretListener);
        this.textfields.add(user.getTextField());
        this.textfields.add(fromAddres.getTextField());
        InputPanelHostConfigurator toAddress = new InputPanelHostConfigurator("recipient_address", 0, 15, "mail_to_address");
        toAddress.getTextField().addCaretListener(this.caretListener);
        this.textfields.add(toAddress.getTextField());
        CheckBoxHostConfigurator defa = new CheckBoxHostConfigurator("effective on default", "mail_default");
        defa.addActionListener(this.btnlist);
        this.buttons.add(defa);
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout(1, 3));
        p1.add(user);
        p1.add(fromAddres);
        p1.add(toAddress);
        JPanel p2 = new JPanel();
        p2.setLayout(new GridLayout(1, 3));
        p2.add(smtp);
        p2.add(new JPanel());
        p2.add(defa);
        panel.add(p1);
        panel.add(p2);
        return panel;
    }

    private JPanel createHosts() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 2));
        InputPanelHostConfigurator address = new InputPanelHostConfigurator("address", 0, 15, "address");
        address.getTextField().addCaretListener(this.caretListener);
        this.textfields.add(address.getTextField());
        InputPanelHostConfigurator username = new InputPanelHostConfigurator("user name", 0, 15, "username");
        username.getTextField().addCaretListener(this.caretListener);
        this.textfields.add(username.getTextField());
        JPanel ppass = new JPanel();
        ppass.setLayout(new BoxLayout(ppass, 0));
        this.password = new JPasswordFieldHostConfigurator(15);
        this.password.addCaretListener(this.caretListener);
        this.savepass = new CheckBoxHostConfigurator("savepass");
        this.savepass.addActionListener(this.btnlist);
        this.buttons.add(this.savepass);
        ppass.add(this.password);
        ppass.add(this.savepass);
        ppass.setBorder(new TitledBorder("password"));
        InputPanelHostConfigurator port = new InputPanelHostConfigurator("port", 0, 15, "port");
        port.getTextField().addCaretListener(this.caretListener);
        this.textfields.add(port.getTextField());
        this.savepass.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HostConfigurator.this.password.setEditable(HostConfigurator.this.savepass.isSelected());
                if (!HostConfigurator.this.savepass.isSelected()) {
                    HostConfigurator.this.password.setText("");
                }
            }
        });
        panel.add(address);
        panel.add(username);
        panel.add(ppass);
        panel.add(port);
        return panel;
    }

    private JPanel createDirs() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 2));
        PathSelectorHostConfigurator basedir = new PathSelectorHostConfigurator("base directory", 12, "basedir", this);
        basedir.getTextField().addCaretListener(this.caretListener);
        JPanel p1 = new JPanel();
        p1.add(basedir);
        this.textfields.add(basedir.getTextField());
        this.tfbase = basedir.getTextField();
        PathSelectorHostConfigurator bindir = new PathSelectorHostConfigurator("bin directory", 12, "bindir", this);
        bindir.getTextField().addCaretListener(this.caretListener);
        JPanel p2 = new JPanel();
        p2.add(bindir);
        this.textfields.add(bindir.getTextField());
        this.tfbin = bindir.getTextField();
        PathSelectorHostConfigurator mpidir = new PathSelectorHostConfigurator("MPI directory", 12, "mpidir", this);
        mpidir.getTextField().addCaretListener(this.caretListener);
        JPanel p3 = new JPanel();
        p3.add(mpidir);
        this.textfields.add(mpidir.getTextField());
        this.tfmpi = mpidir.getTextField();
        PathSelectorHostConfigurator javadir = new PathSelectorHostConfigurator("java directory", 12, "javadir", this);
        javadir.getTextField().addCaretListener(this.caretListener);
        JPanel p4 = new JPanel();
        p4.add(javadir);
        this.textfields.add(javadir.getTextField());
        this.tfjava = javadir.getTextField();
        panel.add(p1);
        panel.add(p2);
        panel.add(p3);
        panel.add(p4);
        JPanel pret = new JPanel();
        pret.setLayout(new BorderLayout());
        pret.add((Component)panel, "Center");
        JButton btndefault = new JButton("enter default");
        JPanel pbtn = new JPanel();
        pbtn.setLayout(new GridLayout(4, 1));
        pbtn.add(new JPanel());
        pbtn.add(new JPanel());
        pbtn.add((Component)btndefault, "North");
        pbtn.add(new JPanel());
        pret.add((Component)pbtn, "East");
        btndefault.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                HostConfigurator.this.doEnterDefault();
            }
        });
        return pret;
    }

    private void doEnterDefault() {
        if (!this.table.getSelectedHost().isLocalHost()) {
            String str = JOptionPane.showInternalInputDialog(this, "enter the installation location of PHASE \n for the remote host (ex: /opt/PHASE)", "", -1);
            if (str != null && str.trim().length() != 0) {
                String basedir = "/home/" + System.getProperty("user.name") + "/phase-viewer-projects";
                String bindir = str + "/bin";
                String mpidir = str + "/mpi";
                String javadir = str + "/_jvm";
                this.tfbase.setText(basedir);
                this.tfbin.setText(bindir);
                this.tfmpi.setText(mpidir);
                this.tfjava.setText(javadir);
            }
        } else {
            String bindir = System.getProperty("pviewer.home") + System.getProperty("file.separator") + "bin";
            String mpidir = "";
            if (!Utils.isWindows()) {
                mpidir = System.getProperty("pviewer.home") + System.getProperty("file.separator") + "mpi";
            }
            String javadir = System.getProperty("pviewer.home") + System.getProperty("file.separator") + "_jvm";
            this.tfbin.setText(bindir);
            this.tfmpi.setText(mpidir);
            this.tfjava.setText(javadir);
        }
    }

    private JPanel createTerms() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        CheckBoxHostConfigurator cbxforward = new CheckBoxHostConfigurator("enable X forwarding", "xforwarding");
        cbxforward.addActionListener(this.btnlist);
        this.buttons.add(cbxforward);
        CheckBoxHostConfigurator cbantialias = new CheckBoxHostConfigurator("enable anti-aliasing", "antialiasing");
        cbantialias.addActionListener(this.btnlist);
        this.buttons.add(cbantialias);
        panel.add(cbxforward);
        panel.add(cbantialias);
        return panel;
    }

    public void tableChanged(TableModelEvent arg0) {
        HostInfo info = this.table.getSelectedHost();
        if (info != null) {
            int i;
            String pas = info.getPasswordString();
            if (pas != null) {
                this.password.setText(pas);
            } else {
                this.password.setText("");
            }
            for (i = 0; i < this.buttons.size(); ++i) {
                HostConfigButtons button = (HostConfigButtons)this.buttons.get(i);
                button.setSelected(info.getBooleanProperty(button.getPropertyType()));
            }
            for (i = 0; i < this.textfields.size(); ++i) {
                HostConfigEditors editor = (HostConfigEditors)this.textfields.get(i);
                editor.setValue(info.getProperty(editor.getPropertyType()));
            }
            this.password.setEditable(this.savepass.isSelected());
            this.btndel.setEnabled(!info.isLocalHost());
        } else {
            logger.debug("host info was null... something is wrong!");
        }
    }
}

